/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.basic;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.luck.picture.lib.basic.PictureSelector;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.entity.LocalMediaFolder;
import com.luck.picture.lib.interfaces.OnQueryAllAlbumListener;
import com.luck.picture.lib.interfaces.OnQueryDataResultListener;
import com.luck.picture.lib.interfaces.OnQueryDataSourceListener;
import com.luck.picture.lib.interfaces.OnQueryFilterListener;
import com.luck.picture.lib.loader.IBridgeMediaLoader;
import com.luck.picture.lib.loader.LocalMediaLoader;
import com.luck.picture.lib.loader.LocalMediaPageLoader;
import java.util.ArrayList;
import java.util.List;

public class PictureSelectionQueryModel {
    private final PictureSelectionConfig selectionConfig;
    private final PictureSelector selector;

    public PictureSelectionQueryModel(PictureSelector selector, int selectMimeType) {
        this.selector = selector;
        this.selectionConfig = PictureSelectionConfig.getCleanInstance();
        this.selectionConfig.chooseMode = selectMimeType;
    }

    public PictureSelectionQueryModel isPageStrategy(boolean isPageStrategy) {
        this.selectionConfig.isPageStrategy = isPageStrategy;
        return this;
    }

    public PictureSelectionQueryModel isPageStrategy(boolean isPageStrategy, int pageSize) {
        this.selectionConfig.isPageStrategy = isPageStrategy;
        this.selectionConfig.pageSize = pageSize < 10 ? 60 : pageSize;
        return this;
    }

    public PictureSelectionQueryModel isPageStrategy(boolean isPageStrategy, int pageSize, boolean isFilterInvalidFile) {
        this.selectionConfig.isPageStrategy = isPageStrategy;
        this.selectionConfig.pageSize = pageSize < 10 ? 60 : pageSize;
        this.selectionConfig.isFilterInvalidFile = isFilterInvalidFile;
        return this;
    }

    public PictureSelectionQueryModel setQueryFilterListener(OnQueryFilterListener listener) {
        PictureSelectionConfig.onQueryFilterListener = listener;
        return this;
    }

    public PictureSelectionQueryModel setQuerySortOrder(String sortOrder) {
        if (!TextUtils.isEmpty((CharSequence)sortOrder)) {
            this.selectionConfig.sortOrder = sortOrder;
        }
        return this;
    }

    public PictureSelectionQueryModel isGif(boolean isGif) {
        this.selectionConfig.isGif = isGif;
        return this;
    }

    public PictureSelectionQueryModel isWebp(boolean isWebp) {
        this.selectionConfig.isWebp = isWebp;
        return this;
    }

    public PictureSelectionQueryModel isBmp(boolean isBmp) {
        this.selectionConfig.isBmp = isBmp;
        return this;
    }

    public PictureSelectionQueryModel setFilterMaxFileSize(long fileKbSize) {
        this.selectionConfig.filterMaxFileSize = fileKbSize >= 0x100000L ? fileKbSize : fileKbSize * 1024L;
        return this;
    }

    public PictureSelectionQueryModel setFilterMinFileSize(long fileKbSize) {
        this.selectionConfig.filterMinFileSize = fileKbSize >= 0x100000L ? fileKbSize : fileKbSize * 1024L;
        return this;
    }

    public PictureSelectionQueryModel setFilterVideoMaxSecond(int videoMaxSecond) {
        this.selectionConfig.filterVideoMaxSecond = videoMaxSecond * 1000;
        return this;
    }

    public PictureSelectionQueryModel setFilterVideoMinSecond(int videoMinSecond) {
        this.selectionConfig.filterVideoMinSecond = videoMinSecond * 1000;
        return this;
    }

    public IBridgeMediaLoader buildMediaLoader() {
        Activity activity = this.selector.getActivity();
        if (activity == null) {
            throw new NullPointerException("Activity cannot be null");
        }
        IBridgeMediaLoader loader = this.selectionConfig.isPageStrategy ? new LocalMediaPageLoader() : new LocalMediaLoader();
        loader.initConfig((Context)activity, this.selectionConfig);
        return loader;
    }

    public void obtainAlbumData(final OnQueryDataSourceListener<LocalMediaFolder> call) {
        Activity activity = this.selector.getActivity();
        if (activity == null) {
            throw new NullPointerException("Activity cannot be null");
        }
        if (call == null) {
            throw new NullPointerException("OnQueryDataSourceListener cannot be null");
        }
        IBridgeMediaLoader loader = this.selectionConfig.isPageStrategy ? new LocalMediaPageLoader() : new LocalMediaLoader();
        loader.initConfig((Context)activity, this.selectionConfig);
        loader.loadAllAlbum(new OnQueryAllAlbumListener<LocalMediaFolder>(){

            @Override
            public void onComplete(List<LocalMediaFolder> result) {
                call.onComplete(result);
            }
        });
    }

    public void obtainMediaData(final OnQueryDataSourceListener<LocalMedia> call) {
        Activity activity = this.selector.getActivity();
        if (activity == null) {
            throw new NullPointerException("Activity cannot be null");
        }
        if (call == null) {
            throw new NullPointerException("OnQueryDataSourceListener cannot be null");
        }
        final IBridgeMediaLoader loader = this.selectionConfig.isPageStrategy ? new LocalMediaPageLoader() : new LocalMediaLoader();
        loader.initConfig((Context)activity, this.selectionConfig);
        loader.loadAllAlbum(new OnQueryAllAlbumListener<LocalMediaFolder>(){

            @Override
            public void onComplete(List<LocalMediaFolder> result) {
                if (result != null && result.size() > 0) {
                    LocalMediaFolder all = result.get(0);
                    if (((PictureSelectionQueryModel)PictureSelectionQueryModel.this).selectionConfig.isPageStrategy) {
                        loader.loadPageMediaData(all.getBucketId(), 1, ((PictureSelectionQueryModel)PictureSelectionQueryModel.this).selectionConfig.pageSize, new OnQueryDataResultListener<LocalMedia>(){

                            @Override
                            public void onComplete(ArrayList<LocalMedia> result, boolean isHasMore) {
                                call.onComplete(result);
                            }
                        });
                    } else {
                        ArrayList<LocalMedia> data = all.getData();
                        call.onComplete(data);
                    }
                }
            }
        });
    }
}

