/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.adapter.holder;

import android.view.View;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import com.luck.picture.lib.adapter.holder.BasePreviewHolder;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.photoview.OnViewTapListener;

public class PreviewImageHolder
extends BasePreviewHolder {
    public PreviewImageHolder(@NonNull View itemView) {
        super(itemView);
    }

    @Override
    protected void findViews(View itemView) {
    }

    @Override
    protected void loadImage(LocalMedia media, int maxWidth, int maxHeight) {
        if (PictureSelectionConfig.imageEngine != null) {
            String availablePath = media.getAvailablePath();
            if (maxWidth == -1 && maxHeight == -1) {
                PictureSelectionConfig.imageEngine.loadImage(this.itemView.getContext(), availablePath, (ImageView)this.coverImageView);
            } else {
                PictureSelectionConfig.imageEngine.loadImage(this.itemView.getContext(), (ImageView)this.coverImageView, availablePath, maxWidth, maxHeight);
            }
        }
    }

    @Override
    protected void onClickBackPressed() {
        this.coverImageView.setOnViewTapListener(new OnViewTapListener(){

            @Override
            public void onViewTap(View view, float x, float y) {
                if (PreviewImageHolder.this.mPreviewEventListener != null) {
                    PreviewImageHolder.this.mPreviewEventListener.onBackPressed();
                }
            }
        });
    }

    @Override
    protected void onLongPressDownload(final LocalMedia media) {
        this.coverImageView.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View view) {
                if (PreviewImageHolder.this.mPreviewEventListener != null) {
                    PreviewImageHolder.this.mPreviewEventListener.onLongPressDownload(media);
                }
                return false;
            }
        });
    }
}

