/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.adapter.holder;

import android.net.Uri;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import androidx.annotation.NonNull;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.PlaybackException;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.ui.StyledPlayerView;
import com.luck.picture.lib.R;
import com.luck.picture.lib.adapter.holder.BasePreviewHolder;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.photoview.OnViewTapListener;
import java.io.File;

public class PreviewVideoHolder
extends BasePreviewHolder {
    public ImageView ivPlayButton;
    public StyledPlayerView mPlayerView;
    public ProgressBar progress;
    private final Player.Listener mPlayerListener = new Player.Listener(){

        public void onPlayerError(@NonNull PlaybackException error) {
            PreviewVideoHolder.this.playerDefaultUI();
        }

        public void onPlaybackStateChanged(int playbackState) {
            if (playbackState == 3) {
                PreviewVideoHolder.this.playerIngUI();
            } else if (playbackState == 2) {
                PreviewVideoHolder.this.progress.setVisibility(0);
            } else if (playbackState == 4) {
                PreviewVideoHolder.this.playerDefaultUI();
            }
        }
    };

    public PreviewVideoHolder(@NonNull View itemView) {
        super(itemView);
        this.ivPlayButton = (ImageView)itemView.findViewById(R.id.iv_play_video);
        this.mPlayerView = (StyledPlayerView)itemView.findViewById(R.id.playerView);
        this.progress = (ProgressBar)itemView.findViewById(R.id.progress);
        this.mPlayerView.setUseController(false);
        PictureSelectionConfig config = PictureSelectionConfig.getInstance();
        this.ivPlayButton.setVisibility(config.isPreviewZoomEffect ? 8 : 0);
    }

    @Override
    protected void findViews(View itemView) {
    }

    @Override
    protected void loadImage(LocalMedia media, int maxWidth, int maxHeight) {
        if (PictureSelectionConfig.imageEngine != null) {
            String availablePath = media.getAvailablePath();
            if (maxWidth == -1 && maxHeight == -1) {
                PictureSelectionConfig.imageEngine.loadImage(this.itemView.getContext(), availablePath, (ImageView)this.coverImageView);
            } else {
                PictureSelectionConfig.imageEngine.loadImage(this.itemView.getContext(), (ImageView)this.coverImageView, availablePath, maxWidth, maxHeight);
            }
        }
    }

    @Override
    protected void onClickBackPressed() {
        this.coverImageView.setOnViewTapListener(new OnViewTapListener(){

            @Override
            public void onViewTap(View view, float x, float y) {
                if (PreviewVideoHolder.this.mPreviewEventListener != null) {
                    PreviewVideoHolder.this.mPreviewEventListener.onBackPressed();
                }
            }
        });
    }

    @Override
    protected void onLongPressDownload(final LocalMedia media) {
        this.coverImageView.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View view) {
                if (PreviewVideoHolder.this.mPreviewEventListener != null) {
                    PreviewVideoHolder.this.mPreviewEventListener.onLongPressDownload(media);
                }
                return false;
            }
        });
    }

    @Override
    public void bindData(LocalMedia media, int position) {
        super.bindData(media, position);
        this.setScaleDisplaySize(media);
        this.ivPlayButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                PreviewVideoHolder.this.startPlay();
            }
        });
        this.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (PreviewVideoHolder.this.mPreviewEventListener != null) {
                    PreviewVideoHolder.this.mPreviewEventListener.onBackPressed();
                }
            }
        });
    }

    public void startPlay() {
        Player player = this.mPlayerView.getPlayer();
        if (player != null) {
            String path = this.media.getAvailablePath();
            this.progress.setVisibility(0);
            this.ivPlayButton.setVisibility(8);
            this.mPreviewEventListener.onPreviewVideoTitle(this.media.getFileName());
            MediaItem mediaItem = PictureMimeType.isContent(path) ? MediaItem.fromUri((Uri)Uri.parse((String)path)) : (PictureMimeType.isHasHttp(path) ? MediaItem.fromUri((String)path) : MediaItem.fromUri((Uri)Uri.fromFile((File)new File(path))));
            player.setRepeatMode(this.config.isLoopAutoPlay ? 2 : 0);
            player.setMediaItem(mediaItem);
            player.prepare();
            player.play();
        }
    }

    @Override
    protected void setScaleDisplaySize(LocalMedia media) {
        super.setScaleDisplaySize(media);
        if (!this.config.isPreviewZoomEffect && this.screenWidth < this.screenHeight) {
            FrameLayout.LayoutParams playerLayoutParams = (FrameLayout.LayoutParams)this.mPlayerView.getLayoutParams();
            playerLayoutParams.width = this.screenWidth;
            playerLayoutParams.height = this.screenAppInHeight;
            playerLayoutParams.gravity = 17;
        }
    }

    private void playerDefaultUI() {
        this.ivPlayButton.setVisibility(0);
        this.progress.setVisibility(8);
        this.coverImageView.setVisibility(0);
        this.mPlayerView.setVisibility(8);
        if (this.mPreviewEventListener != null) {
            this.mPreviewEventListener.onPreviewVideoTitle(null);
        }
    }

    private void playerIngUI() {
        if (this.progress.getVisibility() == 0) {
            this.progress.setVisibility(8);
        }
        if (this.ivPlayButton.getVisibility() == 0) {
            this.ivPlayButton.setVisibility(8);
        }
        if (this.coverImageView.getVisibility() == 0) {
            this.coverImageView.setVisibility(8);
        }
        if (this.mPlayerView.getVisibility() == 8) {
            this.mPlayerView.setVisibility(0);
        }
    }

    @Override
    public void onViewAttachedToWindow() {
        ExoPlayer player = new ExoPlayer.Builder(this.itemView.getContext()).build();
        this.mPlayerView.setPlayer((Player)player);
        player.addListener(this.mPlayerListener);
    }

    @Override
    public void onViewDetachedFromWindow() {
        Player player = this.mPlayerView.getPlayer();
        if (player != null) {
            player.removeListener(this.mPlayerListener);
            player.release();
            this.mPlayerView.setPlayer(null);
            this.playerDefaultUI();
        }
    }

    public void releaseVideo() {
        Player player = this.mPlayerView.getPlayer();
        if (player != null) {
            player.removeListener(this.mPlayerListener);
            player.release();
        }
    }
}

