/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.adapter;

import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.luck.picture.lib.R;
import com.luck.picture.lib.adapter.holder.BasePreviewHolder;
import com.luck.picture.lib.adapter.holder.PreviewAudioHolder;
import com.luck.picture.lib.adapter.holder.PreviewVideoHolder;
import com.luck.picture.lib.config.InjectResourceSource;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.entity.LocalMedia;
import java.util.LinkedHashMap;
import java.util.List;

public class PicturePreviewAdapter
extends RecyclerView.Adapter<BasePreviewHolder> {
    private List<LocalMedia> mData;
    private BasePreviewHolder.OnPreviewEventListener onPreviewEventListener;
    private final LinkedHashMap<Integer, BasePreviewHolder> mHolderCache = new LinkedHashMap();

    public BasePreviewHolder getCurrentHolder(int position) {
        return this.mHolderCache.get(position);
    }

    public void setData(List<LocalMedia> list) {
        this.mData = list;
    }

    public void setOnPreviewEventListener(BasePreviewHolder.OnPreviewEventListener listener) {
        this.onPreviewEventListener = listener;
    }

    @NonNull
    public BasePreviewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (viewType == 2) {
            int layoutResourceId = InjectResourceSource.getLayoutResource(parent.getContext(), 8);
            return BasePreviewHolder.generate(parent, viewType, layoutResourceId != 0 ? layoutResourceId : R.layout.ps_preview_video);
        }
        if (viewType == 3) {
            int layoutResourceId = InjectResourceSource.getLayoutResource(parent.getContext(), 10);
            return BasePreviewHolder.generate(parent, viewType, layoutResourceId != 0 ? layoutResourceId : R.layout.ps_preview_audio);
        }
        int layoutResourceId = InjectResourceSource.getLayoutResource(parent.getContext(), 7);
        return BasePreviewHolder.generate(parent, viewType, layoutResourceId != 0 ? layoutResourceId : R.layout.ps_preview_image);
    }

    public void onBindViewHolder(@NonNull BasePreviewHolder holder, int position) {
        holder.setOnPreviewEventListener(this.onPreviewEventListener);
        LocalMedia media = this.getItem(position);
        this.mHolderCache.put(position, holder);
        holder.bindData(media, position);
    }

    public LocalMedia getItem(int position) {
        if (position > this.mData.size()) {
            return null;
        }
        return this.mData.get(position);
    }

    public int getItemViewType(int position) {
        if (PictureMimeType.isHasVideo(this.mData.get(position).getMimeType())) {
            return 2;
        }
        if (PictureMimeType.isHasAudio(this.mData.get(position).getMimeType())) {
            return 3;
        }
        return 1;
    }

    public int getItemCount() {
        return this.mData != null ? this.mData.size() : 0;
    }

    public void onViewAttachedToWindow(@NonNull BasePreviewHolder holder) {
        super.onViewAttachedToWindow((RecyclerView.ViewHolder)holder);
        holder.onViewAttachedToWindow();
    }

    public void onViewDetachedFromWindow(@NonNull BasePreviewHolder holder) {
        super.onViewDetachedFromWindow((RecyclerView.ViewHolder)holder);
        holder.onViewDetachedFromWindow();
    }

    public void setCoverScaleType(int position) {
        BasePreviewHolder currentHolder = this.getCurrentHolder(position);
        if (currentHolder != null) {
            LocalMedia media = this.getItem(position);
            if (media.getWidth() == 0 && media.getHeight() == 0) {
                currentHolder.coverImageView.setScaleType(ImageView.ScaleType.FIT_CENTER);
            } else {
                currentHolder.coverImageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
            }
        }
    }

    public void setVideoPlayButtonUI(int position) {
        BasePreviewHolder currentHolder = this.getCurrentHolder(position);
        if (currentHolder instanceof PreviewVideoHolder) {
            PreviewVideoHolder videoHolder = (PreviewVideoHolder)currentHolder;
            if (videoHolder.ivPlayButton.getVisibility() == 8) {
                videoHolder.ivPlayButton.setVisibility(0);
            }
        }
    }

    public void startAutoVideoPlay(int position) {
        BasePreviewHolder currentHolder = this.getCurrentHolder(position);
        if (currentHolder instanceof PreviewVideoHolder) {
            PreviewVideoHolder videoHolder = (PreviewVideoHolder)currentHolder;
            videoHolder.startPlay();
        }
    }

    public void destroy() {
        for (Integer key : this.mHolderCache.keySet()) {
            BasePreviewHolder holder = this.mHolderCache.get(key);
            if (holder instanceof PreviewVideoHolder) {
                PreviewVideoHolder videoHolder = (PreviewVideoHolder)holder;
                videoHolder.releaseVideo();
                continue;
            }
            if (!(holder instanceof PreviewAudioHolder)) continue;
            PreviewAudioHolder audioHolder = (PreviewAudioHolder)holder;
            audioHolder.releaseAudio();
        }
    }
}

