/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.basic;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Configuration;
import android.media.SoundPool;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.provider.DocumentsContract;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.luck.picture.lib.R;
import com.luck.picture.lib.app.PictureAppMaster;
import com.luck.picture.lib.basic.IBridgePictureBehavior;
import com.luck.picture.lib.basic.IPictureSelectorCommonEvent;
import com.luck.picture.lib.basic.PictureContentResolver;
import com.luck.picture.lib.basic.PictureMediaScannerConnection;
import com.luck.picture.lib.basic.PictureSelector;
import com.luck.picture.lib.basic.PictureSelectorSupporterActivity;
import com.luck.picture.lib.basic.PictureSelectorTransparentActivity;
import com.luck.picture.lib.config.Crop;
import com.luck.picture.lib.config.PermissionEvent;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.config.SelectMimeType;
import com.luck.picture.lib.dialog.PhotoItemSelectedDialog;
import com.luck.picture.lib.dialog.PictureLoadingDialog;
import com.luck.picture.lib.dialog.RemindDialog;
import com.luck.picture.lib.engine.PictureSelectorEngine;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.entity.MediaExtraInfo;
import com.luck.picture.lib.immersive.ImmersiveManager;
import com.luck.picture.lib.interfaces.OnCallbackIndexListener;
import com.luck.picture.lib.interfaces.OnCallbackListener;
import com.luck.picture.lib.interfaces.OnItemClickListener;
import com.luck.picture.lib.interfaces.OnKeyValueResultCallbackListener;
import com.luck.picture.lib.interfaces.OnRecordAudioInterceptListener;
import com.luck.picture.lib.interfaces.OnRequestPermissionListener;
import com.luck.picture.lib.language.PictureLanguageUtils;
import com.luck.picture.lib.loader.IBridgeMediaLoader;
import com.luck.picture.lib.manager.SelectedManager;
import com.luck.picture.lib.permissions.PermissionChecker;
import com.luck.picture.lib.permissions.PermissionConfig;
import com.luck.picture.lib.permissions.PermissionResultCallback;
import com.luck.picture.lib.permissions.PermissionUtil;
import com.luck.picture.lib.service.ForegroundService;
import com.luck.picture.lib.style.PictureWindowAnimationStyle;
import com.luck.picture.lib.style.SelectMainStyle;
import com.luck.picture.lib.thread.PictureThreadUtils;
import com.luck.picture.lib.utils.ActivityCompatHelper;
import com.luck.picture.lib.utils.BitmapUtils;
import com.luck.picture.lib.utils.DateUtils;
import com.luck.picture.lib.utils.MediaStoreUtils;
import com.luck.picture.lib.utils.MediaUtils;
import com.luck.picture.lib.utils.PictureFileUtils;
import com.luck.picture.lib.utils.SdkVersionUtils;
import com.luck.picture.lib.utils.SpUtils;
import com.luck.picture.lib.utils.ToastUtils;
import com.luck.picture.lib.utils.ValueOf;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class PictureCommonFragment
extends Fragment
implements IPictureSelectorCommonEvent {
    public static final String TAG = PictureCommonFragment.class.getSimpleName();
    private PermissionResultCallback mPermissionResultCallback;
    protected IBridgePictureBehavior iBridgePictureBehavior;
    protected int mPage = 1;
    protected IBridgeMediaLoader mLoader;
    protected PictureSelectionConfig config;
    private PictureLoadingDialog mLoadingDialog;
    private SoundPool soundPool;
    private int soundID;
    private long enterAnimDuration;
    protected Dialog tipsDialog;

    public String getFragmentTag() {
        return TAG;
    }

    @Override
    public int getResourceId() {
        return 0;
    }

    @Override
    public void onFragmentResume() {
    }

    @Override
    public void reStartSavedInstance(Bundle savedInstanceState) {
    }

    @Override
    public void onCheckOriginalChange() {
    }

    @Override
    public void dispatchCameraMediaResult(LocalMedia media) {
    }

    @Override
    public void onSelectedChange(boolean isAddRemove, LocalMedia currentMedia) {
    }

    @Override
    public void onFixedSelectedChange(LocalMedia oldLocalMedia) {
    }

    @Override
    public void sendChangeSubSelectPositionEvent(boolean adapterChange) {
    }

    @Override
    public void handlePermissionSettingResult(String[] permissions) {
    }

    @Override
    public void onEditMedia(Intent intent) {
    }

    @Override
    public void onEnterFragment() {
    }

    @Override
    public void onExitFragment() {
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (this.mPermissionResultCallback != null) {
            PermissionChecker.getInstance().onRequestPermissionsResult(grantResults, this.mPermissionResultCallback);
            this.mPermissionResultCallback = null;
        }
    }

    public void setPermissionsResultAction(PermissionResultCallback callback) {
        this.mPermissionResultCallback = callback;
    }

    @Override
    public void handlePermissionDenied(String[] permissionArray) {
        PermissionConfig.CURRENT_REQUEST_PERMISSION = permissionArray;
        if (permissionArray != null && permissionArray.length > 0) {
            SpUtils.putBoolean(this.getContext(), permissionArray[0], true);
        }
        if (PictureSelectionConfig.onPermissionDeniedListener != null) {
            this.onPermissionExplainEvent(false, null);
            PictureSelectionConfig.onPermissionDeniedListener.onDenied(this, permissionArray, 1102, new OnCallbackListener<Boolean>(){

                @Override
                public void onCall(Boolean isResult) {
                    if (isResult.booleanValue()) {
                        PictureCommonFragment.this.handlePermissionSettingResult(PermissionConfig.CURRENT_REQUEST_PERMISSION);
                        PermissionConfig.CURRENT_REQUEST_PERMISSION = null;
                    }
                }
            });
        } else {
            boolean isReadWrite = false;
            if (permissionArray != null && permissionArray.length > 0) {
                for (String s : permissionArray) {
                    isReadWrite = TextUtils.equals((CharSequence)s, (CharSequence)"android.permission.READ_EXTERNAL_STORAGE") || TextUtils.equals((CharSequence)s, (CharSequence)"android.permission.WRITE_EXTERNAL_STORAGE");
                }
            }
            PermissionUtil.goIntentSetting(this, isReadWrite, 1102);
        }
    }

    protected boolean isNormalDefaultEnter() {
        return this.getActivity() instanceof PictureSelectorSupporterActivity || this.getActivity() instanceof PictureSelectorTransparentActivity;
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        if (this.getResourceId() != 0) {
            return inflater.inflate(this.getResourceId(), container, false);
        }
        return super.onCreateView(inflater, container, savedInstanceState);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.mLoadingDialog = new PictureLoadingDialog(this.getContext());
        if (savedInstanceState != null) {
            this.config = (PictureSelectionConfig)savedInstanceState.getParcelable("com.luck.picture.lib.PictureSelectorConfig");
        }
        if (this.config == null) {
            this.config = PictureSelectionConfig.getInstance();
        }
        this.setRequestedOrientation();
        this.setTranslucentStatusBar();
        this.setRootViewKeyListener(this.requireView());
        if (this.config.isOpenClickSound && !this.config.isOnlyCamera) {
            this.soundPool = new SoundPool(1, 3, 0);
            this.soundID = this.soundPool.load(this.getContext(), R.raw.ps_click_music, 1);
        }
    }

    private void setTranslucentStatusBar() {
        if (this.config.isPreviewFullScreenMode) {
            SelectMainStyle selectMainStyle = PictureSelectionConfig.selectorStyle.getSelectMainStyle();
            ImmersiveManager.translucentStatusBar((Activity)this.getActivity(), selectMainStyle.isDarkStatusBarBlack());
        }
    }

    public void setRootViewKeyListener(View view) {
        view.setFocusableInTouchMode(true);
        view.requestFocus();
        view.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if (keyCode == 4 && event.getAction() == 1) {
                    PictureCommonFragment.this.onKeyBackFragmentFinish();
                    return true;
                }
                return false;
            }
        });
    }

    public void onConfigurationChanged(@NonNull Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.initAppLanguage();
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.config != null) {
            outState.putParcelable("com.luck.picture.lib.PictureSelectorConfig", (Parcelable)this.config);
        }
    }

    @Nullable
    public Animation onCreateAnimation(int transit, boolean enter, int nextAnim) {
        Animation loadAnimation;
        PictureWindowAnimationStyle windowAnimationStyle = PictureSelectionConfig.selectorStyle.getWindowAnimationStyle();
        if (enter) {
            loadAnimation = windowAnimationStyle.activityEnterAnimation != 0 ? AnimationUtils.loadAnimation((Context)this.getContext(), (int)windowAnimationStyle.activityEnterAnimation) : AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.ps_anim_alpha_enter);
            this.setEnterAnimationDuration(loadAnimation.getDuration());
            this.onEnterFragment();
        } else {
            loadAnimation = windowAnimationStyle.activityExitAnimation != 0 ? AnimationUtils.loadAnimation((Context)this.getContext(), (int)windowAnimationStyle.activityExitAnimation) : AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.ps_anim_alpha_exit);
            this.onExitFragment();
        }
        return loadAnimation;
    }

    public void setEnterAnimationDuration(long duration) {
        this.enterAnimDuration = duration;
    }

    public long getEnterAnimationDuration() {
        long DIFFERENCE = 50L;
        long duration = this.enterAnimDuration > 50L ? this.enterAnimDuration - 50L : this.enterAnimDuration;
        return duration >= 0L ? duration : 0L;
    }

    @Override
    public int confirmSelect(LocalMedia currentMedia, boolean isSelected) {
        int resultCode;
        if (PictureSelectionConfig.onSelectFilterListener != null && PictureSelectionConfig.onSelectFilterListener.onSelectFilter(currentMedia)) {
            boolean isSelectLimit = false;
            if (PictureSelectionConfig.onSelectLimitTipsListener != null) {
                isSelectLimit = PictureSelectionConfig.onSelectLimitTipsListener.onSelectLimitTips(this.getContext(), this.config, 13);
            }
            if (!isSelectLimit) {
                ToastUtils.showToast(this.getContext(), this.getString(R.string.ps_select_no_support));
            }
            return -1;
        }
        int checkSelectValidity = this.isCheckSelectValidity(currentMedia, isSelected);
        if (checkSelectValidity != 200) {
            return -1;
        }
        ArrayList<LocalMedia> selectedResult = SelectedManager.getSelectedResult();
        if (isSelected) {
            selectedResult.remove(currentMedia);
            resultCode = 1;
        } else {
            if (this.config.selectionMode == 1 && selectedResult.size() > 0) {
                this.sendFixedSelectedChangeEvent((LocalMedia)selectedResult.get(0));
                selectedResult.clear();
            }
            selectedResult.add(currentMedia);
            currentMedia.setNum(selectedResult.size());
            resultCode = 0;
            this.playClickEffect();
        }
        this.sendSelectedChangeEvent(resultCode == 0, currentMedia);
        return resultCode;
    }

    protected int isCheckSelectValidity(LocalMedia currentMedia, boolean isSelected) {
        String curMimeType = currentMedia.getMimeType();
        long curDuration = currentMedia.getDuration();
        long curFileSize = currentMedia.getSize();
        ArrayList<LocalMedia> selectedResult = SelectedManager.getSelectedResult();
        if (this.config.isWithVideoImage) {
            int selectVideoSize = 0;
            for (int i = 0; i < selectedResult.size(); ++i) {
                String mimeType = ((LocalMedia)selectedResult.get(i)).getMimeType();
                if (!PictureMimeType.isHasVideo(mimeType)) continue;
                ++selectVideoSize;
            }
            if (this.checkWithMimeTypeValidity(isSelected, curMimeType, selectVideoSize, curFileSize, curDuration)) {
                return -1;
            }
        } else if (this.checkOnlyMimeTypeValidity(isSelected, curMimeType, SelectedManager.getTopResultMimeType(), curFileSize, curDuration)) {
            return -1;
        }
        return 200;
    }

    @Override
    @SuppressLint(value={"StringFormatInvalid", "StringFormatMatches"})
    public boolean checkWithMimeTypeValidity(boolean isSelected, String curMimeType, int selectVideoSize, long fileSize, long duration) {
        if (this.config.selectMaxFileSize > 0L && fileSize > this.config.selectMaxFileSize) {
            boolean isSelectLimit;
            if (PictureSelectionConfig.onSelectLimitTipsListener != null && (isSelectLimit = PictureSelectionConfig.onSelectLimitTipsListener.onSelectLimitTips(this.getContext(), this.config, 1))) {
                return true;
            }
            String maxFileSize = PictureFileUtils.formatFileSize(this.config.selectMaxFileSize, 1);
            this.showTipsDialog(this.getString(R.string.ps_select_max_size, new Object[]{maxFileSize}));
            return true;
        }
        if (this.config.selectMinFileSize > 0L && fileSize < this.config.selectMinFileSize) {
            boolean isSelectLimit;
            if (PictureSelectionConfig.onSelectLimitTipsListener != null && (isSelectLimit = PictureSelectionConfig.onSelectLimitTipsListener.onSelectLimitTips(this.getContext(), this.config, 2))) {
                return true;
            }
            String minFileSize = PictureFileUtils.formatFileSize(this.config.selectMinFileSize, 1);
            this.showTipsDialog(this.getString(R.string.ps_select_min_size, new Object[]{minFileSize}));
            return true;
        }
        if (PictureMimeType.isHasVideo(curMimeType)) {
            if (this.config.selectionMode == 2) {
                if (this.config.maxVideoSelectNum <= 0) {
                    boolean isSelectLimit;
                    if (PictureSelectionConfig.onSelectLimitTipsListener != null && (isSelectLimit = PictureSelectionConfig.onSelectLimitTipsListener.onSelectLimitTips(this.getContext(), this.config, 3))) {
                        return true;
                    }
                    this.showTipsDialog(this.getString(R.string.ps_rule));
                    return true;
                }
                if (!isSelected && SelectedManager.getSelectedResult().size() >= this.config.maxSelectNum) {
                    boolean isSelectLimit;
                    if (PictureSelectionConfig.onSelectLimitTipsListener != null && (isSelectLimit = PictureSelectionConfig.onSelectLimitTipsListener.onSelectLimitTips(this.getContext(), this.config, 4))) {
                        return true;
                    }
                    this.showTipsDialog(this.getString(R.string.ps_message_max_num, new Object[]{this.config.maxSelectNum}));
                    return true;
                }
                if (!isSelected && selectVideoSize >= this.config.maxVideoSelectNum) {
                    boolean isSelectLimit;
                    if (PictureSelectionConfig.onSelectLimitTipsListener != null && (isSelectLimit = PictureSelectionConfig.onSelectLimitTipsListener.onSelectLimitTips(this.getContext(), this.config, 6))) {
                        return true;
                    }
                    this.showTipsDialog(PictureCommonFragment.getTipsMsg(this.getContext(), curMimeType, this.config.maxVideoSelectNum));
                    return true;
                }
            }
            if (!isSelected && this.config.selectMinDurationSecond > 0 && DateUtils.millisecondToSecond(duration) < (long)this.config.selectMinDurationSecond) {
                boolean isSelectLimit;
                if (PictureSelectionConfig.onSelectLimitTipsListener != null && (isSelectLimit = PictureSelectionConfig.onSelectLimitTipsListener.onSelectLimitTips(this.getContext(), this.config, 9))) {
                    return true;
                }
                this.showTipsDialog(this.getString(R.string.ps_select_video_min_second, new Object[]{this.config.selectMinDurationSecond / 1000}));
                return true;
            }
            if (!isSelected && this.config.selectMaxDurationSecond > 0 && DateUtils.millisecondToSecond(duration) > (long)this.config.selectMaxDurationSecond) {
                boolean isSelectLimit;
                if (PictureSelectionConfig.onSelectLimitTipsListener != null && (isSelectLimit = PictureSelectionConfig.onSelectLimitTipsListener.onSelectLimitTips(this.getContext(), this.config, 8))) {
                    return true;
                }
                this.showTipsDialog(this.getString(R.string.ps_select_video_max_second, new Object[]{this.config.selectMaxDurationSecond / 1000}));
                return true;
            }
        } else if (this.config.selectionMode == 2 && !isSelected && SelectedManager.getSelectedResult().size() >= this.config.maxSelectNum) {
            boolean isSelectLimit;
            if (PictureSelectionConfig.onSelectLimitTipsListener != null && (isSelectLimit = PictureSelectionConfig.onSelectLimitTipsListener.onSelectLimitTips(this.getContext(), this.config, 4))) {
                return true;
            }
            this.showTipsDialog(this.getString(R.string.ps_message_max_num, new Object[]{this.config.maxSelectNum}));
            return true;
        }
        return false;
    }

    @Override
    @SuppressLint(value={"StringFormatInvalid"})
    public boolean checkOnlyMimeTypeValidity(boolean isSelected, String curMimeType, String existMimeType, long fileSize, long duration) {
        if (!PictureMimeType.isMimeTypeSame(existMimeType, curMimeType)) {
            boolean isSelectLimit;
            if (PictureSelectionConfig.onSelectLimitTipsListener != null && (isSelectLimit = PictureSelectionConfig.onSelectLimitTipsListener.onSelectLimitTips(this.getContext(), this.config, 3))) {
                return true;
            }
            this.showTipsDialog(this.getString(R.string.ps_rule));
            return true;
        }
        if (this.config.selectMaxFileSize > 0L && fileSize > this.config.selectMaxFileSize) {
            boolean isSelectLimit;
            if (PictureSelectionConfig.onSelectLimitTipsListener != null && (isSelectLimit = PictureSelectionConfig.onSelectLimitTipsListener.onSelectLimitTips(this.getContext(), this.config, 1))) {
                return true;
            }
            String maxFileSize = PictureFileUtils.formatFileSize(this.config.selectMaxFileSize, 1);
            this.showTipsDialog(this.getString(R.string.ps_select_max_size, new Object[]{maxFileSize}));
            return true;
        }
        if (this.config.selectMinFileSize > 0L && fileSize < this.config.selectMinFileSize) {
            boolean isSelectLimit;
            if (PictureSelectionConfig.onSelectLimitTipsListener != null && (isSelectLimit = PictureSelectionConfig.onSelectLimitTipsListener.onSelectLimitTips(this.getContext(), this.config, 2))) {
                return true;
            }
            String minFileSize = PictureFileUtils.formatFileSize(this.config.selectMinFileSize, 1);
            this.showTipsDialog(this.getString(R.string.ps_select_min_size, new Object[]{minFileSize}));
            return true;
        }
        if (PictureMimeType.isHasVideo(curMimeType)) {
            if (this.config.selectionMode == 2) {
                int n = this.config.maxVideoSelectNum = this.config.maxVideoSelectNum > 0 ? this.config.maxVideoSelectNum : this.config.maxSelectNum;
                if (!isSelected && SelectedManager.getSelectCount() >= this.config.maxVideoSelectNum) {
                    boolean isSelectLimit;
                    if (PictureSelectionConfig.onSelectLimitTipsListener != null && (isSelectLimit = PictureSelectionConfig.onSelectLimitTipsListener.onSelectLimitTips(this.getContext(), this.config, 6))) {
                        return true;
                    }
                    this.showTipsDialog(PictureCommonFragment.getTipsMsg(this.getContext(), curMimeType, this.config.maxVideoSelectNum));
                    return true;
                }
            }
            if (!isSelected && this.config.selectMinDurationSecond > 0 && DateUtils.millisecondToSecond(duration) < (long)this.config.selectMinDurationSecond) {
                boolean isSelectLimit;
                if (PictureSelectionConfig.onSelectLimitTipsListener != null && (isSelectLimit = PictureSelectionConfig.onSelectLimitTipsListener.onSelectLimitTips(this.getContext(), this.config, 9))) {
                    return true;
                }
                this.showTipsDialog(this.getString(R.string.ps_select_video_min_second, new Object[]{this.config.selectMinDurationSecond / 1000}));
                return true;
            }
            if (!isSelected && this.config.selectMaxDurationSecond > 0 && DateUtils.millisecondToSecond(duration) > (long)this.config.selectMaxDurationSecond) {
                boolean isSelectLimit;
                if (PictureSelectionConfig.onSelectLimitTipsListener != null && (isSelectLimit = PictureSelectionConfig.onSelectLimitTipsListener.onSelectLimitTips(this.getContext(), this.config, 8))) {
                    return true;
                }
                this.showTipsDialog(this.getString(R.string.ps_select_video_max_second, new Object[]{this.config.selectMaxDurationSecond / 1000}));
                return true;
            }
        } else if (PictureMimeType.isHasAudio(curMimeType)) {
            if (this.config.selectionMode == 2 && !isSelected && SelectedManager.getSelectedResult().size() >= this.config.maxSelectNum) {
                boolean isSelectLimit;
                if (PictureSelectionConfig.onSelectLimitTipsListener != null && (isSelectLimit = PictureSelectionConfig.onSelectLimitTipsListener.onSelectLimitTips(this.getContext(), this.config, 4))) {
                    return true;
                }
                this.showTipsDialog(PictureCommonFragment.getTipsMsg(this.getContext(), curMimeType, this.config.maxSelectNum));
                return true;
            }
            if (!isSelected && this.config.selectMinDurationSecond > 0 && DateUtils.millisecondToSecond(duration) < (long)this.config.selectMinDurationSecond) {
                boolean isSelectLimit;
                if (PictureSelectionConfig.onSelectLimitTipsListener != null && (isSelectLimit = PictureSelectionConfig.onSelectLimitTipsListener.onSelectLimitTips(this.getContext(), this.config, 11))) {
                    return true;
                }
                this.showTipsDialog(this.getString(R.string.ps_select_audio_min_second, new Object[]{this.config.selectMinDurationSecond / 1000}));
                return true;
            }
            if (!isSelected && this.config.selectMaxDurationSecond > 0 && DateUtils.millisecondToSecond(duration) > (long)this.config.selectMaxDurationSecond) {
                boolean isSelectLimit;
                if (PictureSelectionConfig.onSelectLimitTipsListener != null && (isSelectLimit = PictureSelectionConfig.onSelectLimitTipsListener.onSelectLimitTips(this.getContext(), this.config, 10))) {
                    return true;
                }
                this.showTipsDialog(this.getString(R.string.ps_select_audio_max_second, new Object[]{this.config.selectMaxDurationSecond / 1000}));
                return true;
            }
        } else if (this.config.selectionMode == 2 && !isSelected && SelectedManager.getSelectedResult().size() >= this.config.maxSelectNum) {
            boolean isSelectLimit;
            if (PictureSelectionConfig.onSelectLimitTipsListener != null && (isSelectLimit = PictureSelectionConfig.onSelectLimitTipsListener.onSelectLimitTips(this.getContext(), this.config, 4))) {
                return true;
            }
            this.showTipsDialog(PictureCommonFragment.getTipsMsg(this.getContext(), curMimeType, this.config.maxSelectNum));
            return true;
        }
        return false;
    }

    private void showTipsDialog(String tips) {
        if (ActivityCompatHelper.isDestroy((Activity)this.getActivity())) {
            return;
        }
        try {
            if (this.tipsDialog != null && this.tipsDialog.isShowing()) {
                return;
            }
            this.tipsDialog = RemindDialog.buildDialog(this.getContext(), tips);
            this.tipsDialog.show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SuppressLint(value={"StringFormatInvalid"})
    private static String getTipsMsg(Context context, String mimeType, int maxSelectNum) {
        if (PictureMimeType.isHasVideo(mimeType)) {
            return context.getString(R.string.ps_message_video_max_num, new Object[]{String.valueOf(maxSelectNum)});
        }
        if (PictureMimeType.isHasAudio(mimeType)) {
            return context.getString(R.string.ps_message_audio_max_num, new Object[]{String.valueOf(maxSelectNum)});
        }
        return context.getString(R.string.ps_message_max_num, new Object[]{String.valueOf(maxSelectNum)});
    }

    @Override
    public void sendSelectedChangeEvent(boolean isAddRemove, LocalMedia currentMedia) {
        if (!ActivityCompatHelper.isDestroy((Activity)this.getActivity())) {
            List fragments = this.getActivity().getSupportFragmentManager().getFragments();
            for (int i = 0; i < fragments.size(); ++i) {
                Fragment fragment = (Fragment)fragments.get(i);
                if (!(fragment instanceof PictureCommonFragment)) continue;
                ((PictureCommonFragment)fragment).onSelectedChange(isAddRemove, currentMedia);
            }
        }
    }

    @Override
    public void sendFixedSelectedChangeEvent(LocalMedia currentMedia) {
        if (!ActivityCompatHelper.isDestroy((Activity)this.getActivity())) {
            List fragments = this.getActivity().getSupportFragmentManager().getFragments();
            for (int i = 0; i < fragments.size(); ++i) {
                Fragment fragment = (Fragment)fragments.get(i);
                if (!(fragment instanceof PictureCommonFragment)) continue;
                ((PictureCommonFragment)fragment).onFixedSelectedChange(currentMedia);
            }
        }
    }

    @Override
    public void sendSelectedOriginalChangeEvent() {
        if (!ActivityCompatHelper.isDestroy((Activity)this.getActivity())) {
            List fragments = this.getActivity().getSupportFragmentManager().getFragments();
            for (int i = 0; i < fragments.size(); ++i) {
                Fragment fragment = (Fragment)fragments.get(i);
                if (!(fragment instanceof PictureCommonFragment)) continue;
                ((PictureCommonFragment)fragment).onCheckOriginalChange();
            }
        }
    }

    @Override
    public void openSelectedCamera() {
        switch (this.config.chooseMode) {
            case 0: {
                if (this.config.ofAllCameraType == SelectMimeType.ofImage()) {
                    this.openImageCamera();
                    break;
                }
                if (this.config.ofAllCameraType == SelectMimeType.ofVideo()) {
                    this.openVideoCamera();
                    break;
                }
                this.onSelectedOnlyCamera();
                break;
            }
            case 1: {
                this.openImageCamera();
                break;
            }
            case 2: {
                this.openVideoCamera();
                break;
            }
            case 3: {
                this.openSoundRecording();
                break;
            }
        }
    }

    @Override
    public void onSelectedOnlyCamera() {
        PhotoItemSelectedDialog selectedDialog = PhotoItemSelectedDialog.newInstance();
        selectedDialog.setOnItemClickListener(new OnItemClickListener(){

            @Override
            public void onItemClick(View v, int position) {
                switch (position) {
                    case 0: {
                        if (PictureSelectionConfig.onCameraInterceptListener != null) {
                            PictureCommonFragment.this.onInterceptCameraEvent(1);
                            break;
                        }
                        PictureCommonFragment.this.openImageCamera();
                        break;
                    }
                    case 1: {
                        if (PictureSelectionConfig.onCameraInterceptListener != null) {
                            PictureCommonFragment.this.onInterceptCameraEvent(2);
                            break;
                        }
                        PictureCommonFragment.this.openVideoCamera();
                        break;
                    }
                }
            }
        });
        selectedDialog.setOnDismissListener(new PhotoItemSelectedDialog.OnDismissListener(){

            @Override
            public void onDismiss(boolean isCancel, DialogInterface dialog) {
                if (PictureCommonFragment.this.config.isOnlyCamera && isCancel) {
                    PictureCommonFragment.this.onKeyBackFragmentFinish();
                }
            }
        });
        selectedDialog.show(this.getChildFragmentManager(), "PhotoItemSelectedDialog");
    }

    @Override
    public void openImageCamera() {
        this.onPermissionExplainEvent(true, PermissionConfig.CAMERA);
        if (PictureSelectionConfig.onPermissionsEventListener != null) {
            this.onApplyPermissionsEvent(PermissionEvent.EVENT_IMAGE_CAMERA, PermissionConfig.CAMERA);
        } else {
            PermissionChecker.getInstance().requestPermissions((Fragment)this, PermissionConfig.CAMERA, new PermissionResultCallback(){

                @Override
                public void onGranted() {
                    PictureCommonFragment.this.startCameraImageCapture();
                }

                @Override
                public void onDenied() {
                    PictureCommonFragment.this.handlePermissionDenied(PermissionConfig.CAMERA);
                }
            });
        }
    }

    protected void startCameraImageCapture() {
        if (!ActivityCompatHelper.isDestroy((Activity)this.getActivity())) {
            this.onPermissionExplainEvent(false, null);
            if (PictureSelectionConfig.onCameraInterceptListener != null) {
                this.onInterceptCameraEvent(1);
            } else {
                Intent cameraIntent = new Intent("android.media.action.IMAGE_CAPTURE");
                if (cameraIntent.resolveActivity(this.getActivity().getPackageManager()) != null) {
                    ForegroundService.startForegroundService(this.getContext());
                    Uri imageUri = MediaStoreUtils.createCameraOutImageUri(this.getContext(), this.config);
                    if (imageUri != null) {
                        if (this.config.isCameraAroundState) {
                            cameraIntent.putExtra("android.intent.extras.CAMERA_FACING", 1);
                        }
                        cameraIntent.putExtra("output", (Parcelable)imageUri);
                        this.startActivityForResult(cameraIntent, 909);
                    }
                }
            }
        }
    }

    @Override
    public void openVideoCamera() {
        this.onPermissionExplainEvent(true, PermissionConfig.CAMERA);
        if (PictureSelectionConfig.onPermissionsEventListener != null) {
            this.onApplyPermissionsEvent(PermissionEvent.EVENT_VIDEO_CAMERA, PermissionConfig.CAMERA);
        } else {
            PermissionChecker.getInstance().requestPermissions((Fragment)this, PermissionConfig.CAMERA, new PermissionResultCallback(){

                @Override
                public void onGranted() {
                    PictureCommonFragment.this.startCameraVideoCapture();
                }

                @Override
                public void onDenied() {
                    PictureCommonFragment.this.handlePermissionDenied(PermissionConfig.CAMERA);
                }
            });
        }
    }

    protected void startCameraVideoCapture() {
        if (!ActivityCompatHelper.isDestroy((Activity)this.getActivity())) {
            this.onPermissionExplainEvent(false, null);
            if (PictureSelectionConfig.onCameraInterceptListener != null) {
                this.onInterceptCameraEvent(2);
            } else {
                Intent cameraIntent = new Intent("android.media.action.VIDEO_CAPTURE");
                if (cameraIntent.resolveActivity(this.getActivity().getPackageManager()) != null) {
                    ForegroundService.startForegroundService(this.getContext());
                    Uri videoUri = MediaStoreUtils.createCameraOutVideoUri(this.getContext(), this.config);
                    if (videoUri != null) {
                        cameraIntent.putExtra("output", (Parcelable)videoUri);
                        if (this.config.isCameraAroundState) {
                            cameraIntent.putExtra("android.intent.extras.CAMERA_FACING", 1);
                        }
                        cameraIntent.putExtra("android.intent.extra.quickCapture", this.config.isQuickCapture);
                        cameraIntent.putExtra("android.intent.extra.durationLimit", this.config.recordVideoMaxSecond);
                        cameraIntent.putExtra("android.intent.extra.videoQuality", this.config.videoQuality);
                        this.startActivityForResult(cameraIntent, 909);
                    }
                }
            }
        }
    }

    @Override
    public void openSoundRecording() {
        if (PictureSelectionConfig.onRecordAudioListener == null) {
            throw new NullPointerException(OnRecordAudioInterceptListener.class.getSimpleName() + " interface needs to be implemented for recording");
        }
        ForegroundService.startForegroundService(this.getContext());
        PictureSelectionConfig.onRecordAudioListener.onRecordAudio(this, 909);
    }

    @Override
    public void onInterceptCameraEvent(int cameraMode) {
        ForegroundService.startForegroundService(this.getContext());
        PictureSelectionConfig.onCameraInterceptListener.openCamera(this, cameraMode, 909);
    }

    @Override
    public void onApplyPermissionsEvent(final int event, String[] permissionArray) {
        PictureSelectionConfig.onPermissionsEventListener.requestPermission(this, permissionArray, new OnRequestPermissionListener(){

            @Override
            public void onCall(String[] permissionArray, boolean isResult) {
                if (isResult) {
                    if (event == PermissionEvent.EVENT_VIDEO_CAMERA) {
                        PictureCommonFragment.this.startCameraVideoCapture();
                    } else {
                        PictureCommonFragment.this.startCameraImageCapture();
                    }
                } else {
                    PictureCommonFragment.this.handlePermissionDenied(permissionArray);
                }
            }
        });
    }

    @Override
    public void onPermissionExplainEvent(boolean isDisplayExplain, String[] permissionArray) {
        if (PictureSelectionConfig.onPermissionDescriptionListener != null) {
            if (isDisplayExplain) {
                if (PermissionChecker.isCheckSelfPermission(this.getContext(), permissionArray)) {
                    SpUtils.putBoolean(this.getContext(), permissionArray[0], false);
                } else if (!SpUtils.getBoolean(this.getContext(), permissionArray[0], false)) {
                    PictureSelectionConfig.onPermissionDescriptionListener.onPermissionDescription(this, permissionArray);
                }
            } else {
                PictureSelectionConfig.onPermissionDescriptionListener.onDismiss(this);
            }
        }
    }

    private void playClickEffect() {
        if (this.soundPool != null && this.config.isOpenClickSound) {
            this.soundPool.play(this.soundID, 0.1f, 0.5f, 0, 1, 1.0f);
        }
    }

    private void releaseSoundPool() {
        try {
            if (this.soundPool != null) {
                this.soundPool.release();
                this.soundPool = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        ForegroundService.stopService(this.getContext());
        if (resultCode == -1) {
            if (requestCode == 909) {
                this.dispatchHandleCamera(data);
            } else if (requestCode == 696) {
                this.onEditMedia(data);
            } else if (requestCode == 69) {
                ArrayList<LocalMedia> selectedResult = SelectedManager.getSelectedResult();
                try {
                    if (selectedResult.size() == 1) {
                        LocalMedia media = (LocalMedia)selectedResult.get(0);
                        Uri output = Crop.getOutput(data);
                        media.setCutPath(output != null ? output.getPath() : "");
                        media.setCut(!TextUtils.isEmpty((CharSequence)media.getCutPath()));
                        media.setCropImageWidth(Crop.getOutputImageWidth(data));
                        media.setCropImageHeight(Crop.getOutputImageHeight(data));
                        media.setCropOffsetX(Crop.getOutputImageOffsetX(data));
                        media.setCropOffsetY(Crop.getOutputImageOffsetY(data));
                        media.setCropResultAspectRatio(Crop.getOutputCropAspectRatio(data));
                        media.setCustomData(Crop.getOutputCustomExtraData(data));
                        media.setSandboxPath(media.getCutPath());
                    } else {
                        String extra = data.getStringExtra("output");
                        JSONArray array = new JSONArray(extra);
                        if (array.length() == selectedResult.size()) {
                            for (int i = 0; i < selectedResult.size(); ++i) {
                                LocalMedia media = (LocalMedia)selectedResult.get(i);
                                JSONObject item = array.optJSONObject(i);
                                media.setCutPath(item.optString("outPutPath"));
                                media.setCut(!TextUtils.isEmpty((CharSequence)media.getCutPath()));
                                media.setCropImageWidth(item.optInt("imageWidth"));
                                media.setCropImageHeight(item.optInt("imageHeight"));
                                media.setCropOffsetX(item.optInt("offsetX"));
                                media.setCropOffsetY(item.optInt("offsetY"));
                                media.setCropResultAspectRatio((float)item.optDouble("aspectRatio"));
                                media.setCustomData(item.optString("customExtraData"));
                                media.setSandboxPath(media.getCutPath());
                            }
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ToastUtils.showToast(this.getContext(), e.getMessage());
                }
                ArrayList<LocalMedia> result = new ArrayList<LocalMedia>(selectedResult);
                if (this.checkCompressValidity()) {
                    this.onCompress(result);
                } else if (this.checkOldCompressValidity()) {
                    this.onOldCompress(result);
                } else {
                    this.onResultEvent(result);
                }
            }
        } else if (resultCode == 96) {
            Throwable throwable;
            Throwable throwable2 = throwable = data != null ? Crop.getError(data) : new Throwable("image crop error");
            if (throwable != null) {
                ToastUtils.showToast(this.getContext(), throwable.getMessage());
            }
        } else if (resultCode == 0) {
            if (requestCode == 909) {
                MediaUtils.deleteUri(this.getContext(), this.config.cameraPath);
            } else if (requestCode == 1102) {
                this.handlePermissionSettingResult(PermissionConfig.CURRENT_REQUEST_PERMISSION);
                PermissionConfig.CURRENT_REQUEST_PERMISSION = null;
            }
        }
    }

    private void dispatchHandleCamera(final Intent intent) {
        PictureThreadUtils.executeByIo(new PictureThreadUtils.SimpleTask<LocalMedia>(){

            @Override
            public LocalMedia doInBackground() {
                String outputPath = PictureCommonFragment.this.getOutputPath(intent);
                if (!TextUtils.isEmpty((CharSequence)outputPath)) {
                    PictureCommonFragment.this.config.cameraPath = outputPath;
                }
                if (TextUtils.isEmpty((CharSequence)PictureCommonFragment.this.config.cameraPath)) {
                    return null;
                }
                if (PictureCommonFragment.this.config.chooseMode == SelectMimeType.ofAudio()) {
                    PictureCommonFragment.this.copyOutputAudioToDir();
                }
                return PictureCommonFragment.this.buildLocalMedia(PictureCommonFragment.this.config.cameraPath);
            }

            @Override
            public void onSuccess(LocalMedia result) {
                PictureThreadUtils.cancel((PictureThreadUtils.Task)this);
                if (result != null) {
                    PictureCommonFragment.this.onScannerScanFile(result);
                    PictureCommonFragment.this.dispatchCameraMediaResult(result);
                }
            }
        });
    }

    private void copyOutputAudioToDir() {
        try {
            if (!TextUtils.isEmpty((CharSequence)this.config.outPutAudioDir) && PictureMimeType.isContent(this.config.cameraPath)) {
                InputStream inputStream = PictureContentResolver.getContentResolverOpenInputStream(this.getContext(), Uri.parse((String)this.config.cameraPath));
                String audioFileName = TextUtils.isEmpty((CharSequence)this.config.outPutAudioFileName) ? "" : (this.config.isOnlyCamera ? this.config.outPutAudioFileName : System.currentTimeMillis() + "_" + this.config.outPutAudioFileName);
                File outputFile = PictureFileUtils.createCameraFile(this.getContext(), this.config.chooseMode, audioFileName, "", this.config.outPutAudioDir);
                FileOutputStream outputStream = new FileOutputStream(outputFile.getAbsolutePath());
                boolean isCopyStatus = PictureFileUtils.writeFileFromIS(inputStream, outputStream);
                if (isCopyStatus) {
                    MediaUtils.deleteUri(this.getContext(), this.config.cameraPath);
                    this.config.cameraPath = outputFile.getAbsolutePath();
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    protected String getOutputPath(Intent data) {
        Uri outPutUri;
        String outputPath = null;
        if (data != null && (outPutUri = this.config.chooseMode == SelectMimeType.ofAudio() ? (data.getData() != null ? data.getData() : (Uri)data.getParcelableExtra("output")) : (Uri)data.getParcelableExtra("output")) != null) {
            outputPath = PictureMimeType.isContent(outPutUri.toString()) ? outPutUri.toString() : outPutUri.getPath();
        }
        return outputPath;
    }

    private void onScannerScanFile(LocalMedia media) {
        if (ActivityCompatHelper.isDestroy((Activity)this.getActivity())) {
            return;
        }
        if (SdkVersionUtils.isQ()) {
            if (PictureMimeType.isHasVideo(media.getMimeType()) && PictureMimeType.isContent(this.config.cameraPath)) {
                new PictureMediaScannerConnection((Context)this.getActivity(), media.getRealPath());
            }
        } else {
            String path = PictureMimeType.isContent(this.config.cameraPath) ? media.getRealPath() : this.config.cameraPath;
            new PictureMediaScannerConnection((Context)this.getActivity(), path);
            if (PictureMimeType.isHasImage(media.getMimeType())) {
                File dirFile = new File(path);
                int lastImageId = MediaUtils.getDCIMLastImageId(this.getContext(), dirFile.getParent());
                if (lastImageId != -1) {
                    MediaUtils.removeMedia(this.getContext(), lastImageId);
                }
            }
        }
    }

    protected LocalMedia buildLocalMedia(String generatePath) {
        long bucketId;
        String mimeType;
        File cameraFile;
        if (ActivityCompatHelper.isDestroy((Activity)this.getActivity())) {
            return null;
        }
        long id2 = 0L;
        if (PictureMimeType.isContent(generatePath)) {
            Uri cameraUri = Uri.parse((String)generatePath);
            String path = PictureFileUtils.getPath((Context)this.getActivity(), cameraUri);
            cameraFile = new File(path);
            mimeType = MediaUtils.getMimeTypeFromMediaUrl(cameraFile.getAbsolutePath());
            if (PictureFileUtils.isMediaDocument(cameraUri)) {
                String[] split;
                String documentId = DocumentsContract.getDocumentId((Uri)cameraUri);
                if (!TextUtils.isEmpty((CharSequence)documentId) && (split = documentId.split(":")).length > 1) {
                    id2 = ValueOf.toLong(split[1]);
                }
            } else if (PictureFileUtils.isDownloadsDocument(cameraUri)) {
                id2 = ValueOf.toLong(DocumentsContract.getDocumentId((Uri)cameraUri));
            } else {
                int lastIndexOf = generatePath.lastIndexOf("/") + 1;
                long l = id2 = lastIndexOf > 0 ? ValueOf.toLong(generatePath.substring(lastIndexOf)) : System.currentTimeMillis();
            }
            bucketId = PictureMimeType.isHasAudio(mimeType) ? MediaUtils.generateSoundsBucketId(this.getContext(), cameraFile, "") : MediaUtils.generateCameraBucketId(this.getContext(), cameraFile, "");
        } else {
            cameraFile = new File(generatePath);
            mimeType = MediaUtils.getMimeTypeFromMediaUrl(cameraFile.getAbsolutePath());
            id2 = System.currentTimeMillis();
            bucketId = PictureMimeType.isHasAudio(mimeType) ? MediaUtils.generateSoundsBucketId(this.getContext(), cameraFile, this.config.outPutCameraDir) : MediaUtils.generateCameraBucketId(this.getContext(), cameraFile, this.config.outPutCameraDir);
        }
        if (PictureMimeType.isHasImage(mimeType) && this.config.isCameraRotateImage) {
            BitmapUtils.rotateImage(this.getContext(), generatePath);
        }
        MediaExtraInfo mediaExtraInfo = PictureMimeType.isHasVideo(mimeType) ? MediaUtils.getVideoSize(this.getContext(), generatePath) : (PictureMimeType.isHasAudio(mimeType) ? MediaUtils.getAudioSize(this.getContext(), generatePath) : MediaUtils.getImageSize(this.getContext(), generatePath));
        String folderName = MediaUtils.generateCameraFolderName(cameraFile.getAbsolutePath());
        LocalMedia media = LocalMedia.parseLocalMedia(id2, generatePath, cameraFile.getAbsolutePath(), cameraFile.getName(), folderName, mediaExtraInfo.getDuration(), this.config.chooseMode, mimeType, mediaExtraInfo.getWidth(), mediaExtraInfo.getHeight(), cameraFile.length(), bucketId, cameraFile.lastModified() / 1000L);
        if (SdkVersionUtils.isQ()) {
            media.setSandboxPath(PictureMimeType.isContent(generatePath) ? null : generatePath);
        }
        return media;
    }

    private boolean checkCompleteSelectLimit() {
        if (this.config.selectionMode != 2 || this.config.isOnlyCamera) {
            return false;
        }
        if (this.config.isWithVideoImage) {
            boolean isSelectLimit;
            ArrayList<LocalMedia> selectedResult = SelectedManager.getSelectedResult();
            int selectImageSize = 0;
            int selectVideoSize = 0;
            for (int i = 0; i < selectedResult.size(); ++i) {
                String mimeType = selectedResult.get(i).getMimeType();
                if (PictureMimeType.isHasVideo(mimeType)) {
                    ++selectVideoSize;
                    continue;
                }
                ++selectImageSize;
            }
            if (this.config.minSelectNum > 0 && selectImageSize < this.config.minSelectNum) {
                isSelectLimit = PictureSelectionConfig.onSelectLimitTipsListener.onSelectLimitTips(this.getContext(), this.config, 5);
                if (isSelectLimit) {
                    return true;
                }
                this.showTipsDialog(this.getString(R.string.ps_min_img_num, new Object[]{String.valueOf(this.config.minSelectNum)}));
                return true;
            }
            if (this.config.minVideoSelectNum > 0 && selectVideoSize < this.config.minVideoSelectNum) {
                isSelectLimit = PictureSelectionConfig.onSelectLimitTipsListener.onSelectLimitTips(this.getContext(), this.config, 7);
                if (isSelectLimit) {
                    return true;
                }
                this.showTipsDialog(this.getString(R.string.ps_min_video_num, new Object[]{String.valueOf(this.config.minVideoSelectNum)}));
                return true;
            }
        } else {
            String mimeType = SelectedManager.getTopResultMimeType();
            if (PictureMimeType.isHasImage(mimeType) && this.config.minSelectNum > 0 && SelectedManager.getSelectCount() < this.config.minSelectNum) {
                boolean isSelectLimit;
                if (PictureSelectionConfig.onSelectLimitTipsListener != null && (isSelectLimit = PictureSelectionConfig.onSelectLimitTipsListener.onSelectLimitTips(this.getContext(), this.config, 5))) {
                    return true;
                }
                this.showTipsDialog(this.getString(R.string.ps_min_img_num, new Object[]{String.valueOf(this.config.minSelectNum)}));
                return true;
            }
            if (PictureMimeType.isHasVideo(mimeType) && this.config.minVideoSelectNum > 0 && SelectedManager.getSelectCount() < this.config.minVideoSelectNum) {
                boolean isSelectLimit;
                if (PictureSelectionConfig.onSelectLimitTipsListener != null && (isSelectLimit = PictureSelectionConfig.onSelectLimitTipsListener.onSelectLimitTips(this.getContext(), this.config, 7))) {
                    return true;
                }
                this.showTipsDialog(this.getString(R.string.ps_min_video_num, new Object[]{String.valueOf(this.config.minVideoSelectNum)}));
                return true;
            }
            if (PictureMimeType.isHasAudio(mimeType) && this.config.minAudioSelectNum > 0 && SelectedManager.getSelectCount() < this.config.minAudioSelectNum) {
                boolean isSelectLimit;
                if (PictureSelectionConfig.onSelectLimitTipsListener != null && (isSelectLimit = PictureSelectionConfig.onSelectLimitTipsListener.onSelectLimitTips(this.getContext(), this.config, 12))) {
                    return true;
                }
                this.showTipsDialog(this.getString(R.string.ps_min_audio_num, new Object[]{String.valueOf(this.config.minAudioSelectNum)}));
                return true;
            }
        }
        return false;
    }

    protected void dispatchTransformResult() {
        if (this.checkCompleteSelectLimit()) {
            return;
        }
        ArrayList<LocalMedia> selectedResult = SelectedManager.getSelectedResult();
        ArrayList<LocalMedia> result = new ArrayList<LocalMedia>(selectedResult);
        if (this.checkCropValidity()) {
            this.onCrop(result);
        } else if (this.checkOldCropValidity()) {
            this.onOldCrop(result);
        } else if (this.checkCompressValidity()) {
            this.onCompress(result);
        } else if (this.checkOldCompressValidity()) {
            this.onOldCompress(result);
        } else {
            this.onResultEvent(result);
        }
    }

    @Override
    public void onCrop(ArrayList<LocalMedia> result) {
        Uri srcUri = null;
        Uri destinationUri = null;
        ArrayList<String> dataCropSource = new ArrayList<String>();
        for (int i = 0; i < result.size(); ++i) {
            LocalMedia media = result.get(i);
            dataCropSource.add(media.getAvailablePath());
            if (srcUri != null || !PictureMimeType.isHasImage(media.getMimeType())) continue;
            String currentCropPath = media.getAvailablePath();
            srcUri = PictureMimeType.isContent(currentCropPath) || PictureMimeType.isHasHttp(currentCropPath) ? Uri.parse((String)currentCropPath) : Uri.fromFile((File)new File(currentCropPath));
            String fileName = DateUtils.getCreateFileName("CROP_") + ".jpg";
            File externalFilesDir = this.requireContext().getExternalFilesDir(Environment.DIRECTORY_PICTURES);
            File outputFile = new File(externalFilesDir.getAbsolutePath(), fileName);
            destinationUri = Uri.fromFile((File)outputFile);
        }
        PictureSelectionConfig.cropFileEngine.onStartCrop(this, srcUri, destinationUri, dataCropSource, 69);
    }

    @Override
    public void onOldCrop(ArrayList<LocalMedia> result) {
        LocalMedia currentLocalMedia = null;
        for (int i = 0; i < result.size(); ++i) {
            LocalMedia item = result.get(i);
            if (!PictureMimeType.isHasImage(result.get(i).getMimeType())) continue;
            currentLocalMedia = item;
            break;
        }
        PictureSelectionConfig.cropEngine.onStartCrop(this, currentLocalMedia, result, 69);
    }

    @Override
    public void onCompress(final ArrayList<LocalMedia> result) {
        this.showLoading();
        final ConcurrentHashMap<String, LocalMedia> queue = new ConcurrentHashMap<String, LocalMedia>();
        ArrayList<Uri> source = new ArrayList<Uri>();
        for (int i = 0; i < result.size(); ++i) {
            LocalMedia media = result.get(i);
            if (!PictureMimeType.isHasImage(media.getMimeType())) continue;
            String availablePath = media.getAvailablePath();
            Uri uri = PictureMimeType.isContent(availablePath) ? Uri.parse((String)availablePath) : Uri.fromFile((File)new File(availablePath));
            source.add(uri);
            queue.put(availablePath, media);
        }
        if (queue.size() == 0) {
            this.onResultEvent(result);
        } else {
            PictureSelectionConfig.compressFileEngine.onStartCompress(this.getContext(), source, new OnKeyValueResultCallbackListener(){

                @Override
                public void onCallback(String srcPath, String compressPath) {
                    if (TextUtils.isEmpty((CharSequence)srcPath)) {
                        PictureCommonFragment.this.onResultEvent(result);
                    } else {
                        LocalMedia media = (LocalMedia)queue.get(srcPath);
                        if (media != null) {
                            media.setCompressPath(compressPath);
                            media.setCompressed(!TextUtils.isEmpty((CharSequence)compressPath));
                            media.setSandboxPath(SdkVersionUtils.isQ() ? media.getCompressPath() : null);
                            queue.remove(srcPath);
                        }
                        if (queue.size() == 0) {
                            PictureCommonFragment.this.onResultEvent(result);
                        }
                    }
                }
            });
        }
    }

    @Override
    public void onOldCompress(ArrayList<LocalMedia> result) {
        this.showLoading();
        PictureSelectionConfig.compressEngine.onStartCompress(this.getContext(), result, new OnCallbackListener<ArrayList<LocalMedia>>(){

            @Override
            public void onCall(ArrayList<LocalMedia> result) {
                PictureCommonFragment.this.onResultEvent(result);
            }
        });
    }

    @Override
    public boolean checkCropValidity() {
        if (PictureSelectionConfig.cropFileEngine != null) {
            HashSet<String> filterSet = new HashSet<String>();
            List<String> filters = this.config.skipCropList;
            if (filters != null && filters.size() > 0) {
                filterSet.addAll(filters);
            }
            if (SelectedManager.getSelectCount() == 1) {
                String mimeType = SelectedManager.getTopResultMimeType();
                boolean isHasImage = PictureMimeType.isHasImage(mimeType);
                if (isHasImage && filterSet.contains(mimeType)) {
                    return false;
                }
                return isHasImage;
            }
            int notSupportCropCount = 0;
            for (int i = 0; i < SelectedManager.getSelectCount(); ++i) {
                LocalMedia media = SelectedManager.getSelectedResult().get(i);
                if (!PictureMimeType.isHasImage(media.getMimeType()) || !filterSet.contains(media.getMimeType())) continue;
                ++notSupportCropCount;
            }
            return notSupportCropCount != SelectedManager.getSelectCount();
        }
        return false;
    }

    @Override
    public boolean checkOldCropValidity() {
        if (PictureSelectionConfig.cropEngine != null) {
            HashSet<String> filterSet = new HashSet<String>();
            List<String> filters = this.config.skipCropList;
            if (filters != null && filters.size() > 0) {
                filterSet.addAll(filters);
            }
            if (SelectedManager.getSelectCount() == 1) {
                String mimeType = SelectedManager.getTopResultMimeType();
                boolean isHasImage = PictureMimeType.isHasImage(mimeType);
                if (isHasImage && filterSet.contains(mimeType)) {
                    return false;
                }
                return isHasImage;
            }
            int notSupportCropCount = 0;
            for (int i = 0; i < SelectedManager.getSelectCount(); ++i) {
                LocalMedia media = SelectedManager.getSelectedResult().get(i);
                if (!PictureMimeType.isHasImage(media.getMimeType()) || !filterSet.contains(media.getMimeType())) continue;
                ++notSupportCropCount;
            }
            return notSupportCropCount != SelectedManager.getSelectCount();
        }
        return false;
    }

    @Override
    public boolean checkCompressValidity() {
        if (PictureSelectionConfig.compressFileEngine != null) {
            for (int i = 0; i < SelectedManager.getSelectCount(); ++i) {
                LocalMedia media = SelectedManager.getSelectedResult().get(i);
                if (!PictureMimeType.isHasImage(media.getMimeType())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean checkOldCompressValidity() {
        if (PictureSelectionConfig.compressEngine != null) {
            for (int i = 0; i < SelectedManager.getSelectCount(); ++i) {
                LocalMedia media = SelectedManager.getSelectedResult().get(i);
                if (!PictureMimeType.isHasImage(media.getMimeType())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean checkTransformSandboxFile() {
        return SdkVersionUtils.isQ() && PictureSelectionConfig.uriToFileTransformEngine != null;
    }

    @Override
    public boolean checkOldTransformSandboxFile() {
        return SdkVersionUtils.isQ() && PictureSelectionConfig.sandboxFileEngine != null;
    }

    @Override
    public boolean checkAddBitmapWatermark() {
        return PictureSelectionConfig.onBitmapWatermarkListener != null;
    }

    @Override
    public boolean checkVideoThumbnail() {
        return PictureSelectionConfig.onVideoThumbnailEventListener != null;
    }

    private void videoThumbnail(final ArrayList<LocalMedia> result) {
        final ConcurrentHashMap<String, LocalMedia> queue = new ConcurrentHashMap<String, LocalMedia>();
        for (int i = 0; i < result.size(); ++i) {
            LocalMedia media = result.get(i);
            String availablePath = media.getAvailablePath();
            if (!PictureMimeType.isHasVideo(media.getMimeType()) && !PictureMimeType.isUrlHasVideo(availablePath)) continue;
            queue.put(availablePath, media);
        }
        if (queue.size() == 0) {
            this.onCallBackResult(result);
        } else {
            for (Map.Entry entry : queue.entrySet()) {
                PictureSelectionConfig.onVideoThumbnailEventListener.onVideoThumbnail(this.getContext(), (String)entry.getKey(), new OnKeyValueResultCallbackListener(){

                    @Override
                    public void onCallback(String srcPath, String resultPath) {
                        LocalMedia media = (LocalMedia)queue.get(srcPath);
                        if (media != null) {
                            media.setVideoThumbnailPath(resultPath);
                            queue.remove(srcPath);
                        }
                        if (queue.size() == 0) {
                            PictureCommonFragment.this.onCallBackResult(result);
                        }
                    }
                });
            }
        }
    }

    private void addBitmapWatermark(final ArrayList<LocalMedia> result) {
        final ConcurrentHashMap<String, LocalMedia> queue = new ConcurrentHashMap<String, LocalMedia>();
        for (int i = 0; i < result.size(); ++i) {
            LocalMedia media = result.get(i);
            if (PictureMimeType.isHasAudio(media.getMimeType())) continue;
            String availablePath = media.getAvailablePath();
            queue.put(availablePath, media);
        }
        if (queue.size() == 0) {
            this.dispatchWatermarkResult(result);
        } else {
            for (Map.Entry entry : queue.entrySet()) {
                String srcPath = (String)entry.getKey();
                LocalMedia media = (LocalMedia)entry.getValue();
                PictureSelectionConfig.onBitmapWatermarkListener.onAddBitmapWatermark(this.getContext(), srcPath, media.getMimeType(), new OnKeyValueResultCallbackListener(){

                    @Override
                    public void onCallback(String srcPath, String resultPath) {
                        if (TextUtils.isEmpty((CharSequence)srcPath)) {
                            PictureCommonFragment.this.dispatchWatermarkResult(result);
                        } else {
                            LocalMedia media = (LocalMedia)queue.get(srcPath);
                            if (media != null) {
                                media.setWatermarkPath(resultPath);
                                queue.remove(srcPath);
                            }
                            if (queue.size() == 0) {
                                PictureCommonFragment.this.dispatchWatermarkResult(result);
                            }
                        }
                    }
                });
            }
        }
    }

    private void dispatchUriToFileTransformResult(ArrayList<LocalMedia> result) {
        this.showLoading();
        if (this.checkAddBitmapWatermark()) {
            this.addBitmapWatermark(result);
        } else if (this.checkVideoThumbnail()) {
            this.videoThumbnail(result);
        } else {
            this.onCallBackResult(result);
        }
    }

    private void dispatchWatermarkResult(ArrayList<LocalMedia> result) {
        if (this.checkVideoThumbnail()) {
            this.videoThumbnail(result);
        } else {
            this.onCallBackResult(result);
        }
    }

    private void uriToFileTransform29(final ArrayList<LocalMedia> result) {
        this.showLoading();
        final ConcurrentHashMap<String, LocalMedia> queue = new ConcurrentHashMap<String, LocalMedia>();
        for (int i = 0; i < result.size(); ++i) {
            LocalMedia media = result.get(i);
            queue.put(media.getPath(), media);
        }
        if (queue.size() == 0) {
            this.dispatchUriToFileTransformResult(result);
        } else {
            PictureThreadUtils.executeByIo(new PictureThreadUtils.SimpleTask<ArrayList<LocalMedia>>(){

                @Override
                public ArrayList<LocalMedia> doInBackground() {
                    for (Map.Entry entry : queue.entrySet()) {
                        LocalMedia media = (LocalMedia)entry.getValue();
                        if (!PictureCommonFragment.this.config.isCheckOriginalImage && !TextUtils.isEmpty((CharSequence)media.getSandboxPath())) continue;
                        PictureSelectionConfig.uriToFileTransformEngine.onUriToFileAsyncTransform(PictureCommonFragment.this.getContext(), (String)entry.getKey(), media.getMimeType(), new OnKeyValueResultCallbackListener(){

                            @Override
                            public void onCallback(String srcPath, String resultPath) {
                                if (TextUtils.isEmpty((CharSequence)srcPath)) {
                                    return;
                                }
                                LocalMedia media = (LocalMedia)queue.get(srcPath);
                                if (media != null) {
                                    if (TextUtils.isEmpty((CharSequence)media.getSandboxPath())) {
                                        media.setSandboxPath(resultPath);
                                    }
                                    if (PictureCommonFragment.this.config.isCheckOriginalImage) {
                                        media.setOriginalPath(resultPath);
                                        media.setOriginal(!TextUtils.isEmpty((CharSequence)resultPath));
                                    }
                                    queue.remove(srcPath);
                                }
                            }
                        });
                    }
                    return result;
                }

                @Override
                public void onSuccess(ArrayList<LocalMedia> result2) {
                    PictureThreadUtils.cancel((PictureThreadUtils.Task)this);
                    PictureCommonFragment.this.dispatchUriToFileTransformResult(result2);
                }
            });
        }
    }

    @Deprecated
    private void copyExternalPathToAppInDirFor29(final ArrayList<LocalMedia> result) {
        this.showLoading();
        PictureThreadUtils.executeByIo(new PictureThreadUtils.SimpleTask<ArrayList<LocalMedia>>(){

            @Override
            public ArrayList<LocalMedia> doInBackground() {
                for (int i = 0; i < result.size(); ++i) {
                    LocalMedia media = (LocalMedia)result.get(i);
                    PictureSelectionConfig.sandboxFileEngine.onStartSandboxFileTransform(PictureCommonFragment.this.getContext(), PictureCommonFragment.this.config.isCheckOriginalImage, i, media, new OnCallbackIndexListener<LocalMedia>(){

                        @Override
                        public void onCall(LocalMedia data, int index) {
                            LocalMedia media = (LocalMedia)result.get(index);
                            media.setSandboxPath(data.getSandboxPath());
                            if (PictureCommonFragment.this.config.isCheckOriginalImage) {
                                media.setOriginalPath(data.getOriginalPath());
                                media.setOriginal(!TextUtils.isEmpty((CharSequence)data.getOriginalPath()));
                            }
                        }
                    });
                }
                return result;
            }

            @Override
            public void onSuccess(ArrayList<LocalMedia> result2) {
                PictureThreadUtils.cancel((PictureThreadUtils.Task)this);
                PictureCommonFragment.this.dispatchUriToFileTransformResult(result2);
            }
        });
    }

    private void mergeOriginalImage(ArrayList<LocalMedia> result) {
        if (this.config.isCheckOriginalImage) {
            for (int i = 0; i < result.size(); ++i) {
                LocalMedia media = result.get(i);
                media.setOriginal(true);
                media.setOriginalPath(media.getPath());
            }
        }
    }

    @Override
    public void onResultEvent(ArrayList<LocalMedia> result) {
        if (this.checkTransformSandboxFile()) {
            this.uriToFileTransform29(result);
        } else if (this.checkOldTransformSandboxFile()) {
            this.copyExternalPathToAppInDirFor29(result);
        } else {
            this.mergeOriginalImage(result);
            this.dispatchUriToFileTransformResult(result);
        }
    }

    private void onCallBackResult(ArrayList<LocalMedia> result) {
        if (!ActivityCompatHelper.isDestroy((Activity)this.getActivity())) {
            this.dismissLoading();
            if (this.config.isActivityResultBack) {
                this.getActivity().setResult(-1, PictureSelector.putIntentResult(result));
                this.onSelectFinish(-1, result);
            } else if (PictureSelectionConfig.onResultCallListener != null) {
                PictureSelectionConfig.onResultCallListener.onResult(result);
            }
            this.onExitPictureSelector();
        }
    }

    @Override
    public void initAppLanguage() {
        PictureSelectionConfig config = PictureSelectionConfig.getInstance();
        if (config.language != -2) {
            PictureLanguageUtils.setAppLanguage((Context)this.getActivity(), config.language);
        }
    }

    @Override
    public void onRecreateEngine() {
        this.createImageLoaderEngine();
        this.createCompressEngine();
        this.createSandboxFileEngine();
        this.createLoaderDataEngine();
        this.createResultCallbackListener();
        this.createLayoutResourceListener();
    }

    @Override
    public void onKeyBackFragmentFinish() {
        if (!ActivityCompatHelper.isDestroy((Activity)this.getActivity())) {
            if (this.config.isActivityResultBack) {
                this.getActivity().setResult(0);
                this.onSelectFinish(0, null);
            } else if (PictureSelectionConfig.onResultCallListener != null) {
                PictureSelectionConfig.onResultCallListener.onCancel();
            }
            this.onExitPictureSelector();
        }
    }

    public void onDestroy() {
        this.releaseSoundPool();
        super.onDestroy();
    }

    @Override
    public void showLoading() {
        try {
            if (ActivityCompatHelper.isDestroy((Activity)this.getActivity())) {
                return;
            }
            if (!this.mLoadingDialog.isShowing()) {
                this.mLoadingDialog.show();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void dismissLoading() {
        try {
            if (ActivityCompatHelper.isDestroy((Activity)this.getActivity())) {
                return;
            }
            if (this.mLoadingDialog.isShowing()) {
                this.mLoadingDialog.dismiss();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onAttach(@NonNull Context context) {
        this.initAppLanguage();
        this.onRecreateEngine();
        super.onAttach(context);
        if (this.getParentFragment() instanceof IBridgePictureBehavior) {
            this.iBridgePictureBehavior = (IBridgePictureBehavior)this.getParentFragment();
        } else if (context instanceof IBridgePictureBehavior) {
            this.iBridgePictureBehavior = (IBridgePictureBehavior)context;
        }
    }

    protected void setRequestedOrientation() {
        if (ActivityCompatHelper.isDestroy((Activity)this.getActivity())) {
            return;
        }
        this.getActivity().setRequestedOrientation(this.config.requestedOrientation);
    }

    protected void onBackCurrentFragment() {
        if (!ActivityCompatHelper.isDestroy((Activity)this.getActivity())) {
            this.getActivity().getSupportFragmentManager().popBackStack();
        }
        List fragments = this.getActivity().getSupportFragmentManager().getFragments();
        for (int i = 0; i < fragments.size(); ++i) {
            Fragment fragment = (Fragment)fragments.get(i);
            if (!(fragment instanceof PictureCommonFragment)) continue;
            ((PictureCommonFragment)fragment).onFragmentResume();
        }
    }

    protected void onSelectFinish(int resultCode, ArrayList<LocalMedia> result) {
        if (null != this.iBridgePictureBehavior) {
            SelectorResult selectorResult = this.getResult(resultCode, result);
            this.iBridgePictureBehavior.onSelectFinish(selectorResult);
        }
    }

    protected void onExitPictureSelector() {
        if (!ActivityCompatHelper.isDestroy((Activity)this.getActivity())) {
            if (this.isNormalDefaultEnter()) {
                this.getActivity().finish();
            } else {
                List fragments = this.getActivity().getSupportFragmentManager().getFragments();
                for (int i = 0; i < fragments.size(); ++i) {
                    Fragment fragment = (Fragment)fragments.get(i);
                    if (!(fragment instanceof PictureCommonFragment)) continue;
                    this.onBackCurrentFragment();
                }
            }
        }
        PictureSelectionConfig.destroy();
    }

    private void createImageLoaderEngine() {
        PictureSelectorEngine baseEngine;
        if (PictureSelectionConfig.imageEngine == null && (baseEngine = PictureAppMaster.getInstance().getPictureSelectorEngine()) != null) {
            PictureSelectionConfig.imageEngine = baseEngine.createImageLoaderEngine();
        }
    }

    private void createLoaderDataEngine() {
        PictureSelectorEngine baseEngine;
        if (PictureSelectionConfig.getInstance().isLoaderDataEngine && PictureSelectionConfig.loaderDataEngine == null && (baseEngine = PictureAppMaster.getInstance().getPictureSelectorEngine()) != null) {
            PictureSelectionConfig.loaderDataEngine = baseEngine.createLoaderDataEngine();
        }
    }

    private void createCompressEngine() {
        if (PictureSelectionConfig.getInstance().isCompressEngine) {
            PictureSelectorEngine baseEngine;
            if (PictureSelectionConfig.compressFileEngine == null && (baseEngine = PictureAppMaster.getInstance().getPictureSelectorEngine()) != null) {
                PictureSelectionConfig.compressFileEngine = baseEngine.createCompressFileEngine();
            }
            if (PictureSelectionConfig.compressEngine == null && (baseEngine = PictureAppMaster.getInstance().getPictureSelectorEngine()) != null) {
                PictureSelectionConfig.compressEngine = baseEngine.createCompressEngine();
            }
        }
    }

    private void createSandboxFileEngine() {
        if (PictureSelectionConfig.getInstance().isSandboxFileEngine) {
            PictureSelectorEngine baseEngine;
            if (PictureSelectionConfig.uriToFileTransformEngine == null && (baseEngine = PictureAppMaster.getInstance().getPictureSelectorEngine()) != null) {
                PictureSelectionConfig.uriToFileTransformEngine = baseEngine.createUriToFileTransformEngine();
            }
            if (PictureSelectionConfig.sandboxFileEngine == null && (baseEngine = PictureAppMaster.getInstance().getPictureSelectorEngine()) != null) {
                PictureSelectionConfig.sandboxFileEngine = baseEngine.createSandboxFileEngine();
            }
        }
    }

    private void createResultCallbackListener() {
        PictureSelectorEngine baseEngine;
        if (PictureSelectionConfig.getInstance().isResultListenerBack && PictureSelectionConfig.onResultCallListener == null && (baseEngine = PictureAppMaster.getInstance().getPictureSelectorEngine()) != null) {
            PictureSelectionConfig.onResultCallListener = baseEngine.getResultCallbackListener();
        }
    }

    private void createLayoutResourceListener() {
        PictureSelectorEngine baseEngine;
        if (PictureSelectionConfig.getInstance().isInjectLayoutResource && PictureSelectionConfig.onLayoutResourceListener == null && (baseEngine = PictureAppMaster.getInstance().getPictureSelectorEngine()) != null) {
            PictureSelectionConfig.onLayoutResourceListener = baseEngine.createLayoutResourceListener();
        }
    }

    protected SelectorResult getResult(int resultCode, ArrayList<LocalMedia> data) {
        return new SelectorResult(resultCode, data != null ? PictureSelector.putIntentResult(data) : null);
    }

    public static class SelectorResult {
        public int mResultCode;
        public Intent mResultData;

        public SelectorResult(int resultCode, Intent data) {
            this.mResultCode = resultCode;
            this.mResultData = data;
        }
    }
}

