/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import com.luck.picture.lib.R;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.style.PictureSelectorStyle;
import com.luck.picture.lib.style.TitleBarStyle;
import com.luck.picture.lib.utils.DensityUtil;
import com.luck.picture.lib.utils.StyleUtils;
import com.luck.picture.lib.widget.MarqueeTextView;

public class TitleBar
extends RelativeLayout
implements View.OnClickListener {
    protected RelativeLayout rlAlbumBg;
    protected ImageView ivLeftBack;
    protected ImageView ivArrow;
    protected ImageView ivDelete;
    protected MarqueeTextView tvTitle;
    protected TextView tvCancel;
    protected View titleBarLine;
    protected View viewAlbumClickArea;
    protected PictureSelectionConfig config;
    protected View viewTopStatusBar;
    protected RelativeLayout titleBarLayout;
    protected OnTitleBarListener titleBarListener;

    public TextView getTitleCancelView() {
        return this.tvCancel;
    }

    public TitleBar(Context context) {
        super(context);
        this.init();
    }

    public TitleBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public TitleBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    protected void init() {
        this.inflateLayout();
        this.setClickable(true);
        this.setFocusable(true);
        this.viewTopStatusBar = this.findViewById(R.id.top_status_bar);
        this.titleBarLayout = (RelativeLayout)this.findViewById(R.id.rl_title_bar);
        this.ivLeftBack = (ImageView)this.findViewById(R.id.ps_iv_left_back);
        this.rlAlbumBg = (RelativeLayout)this.findViewById(R.id.ps_rl_album_bg);
        this.ivDelete = (ImageView)this.findViewById(R.id.ps_iv_delete);
        this.viewAlbumClickArea = this.findViewById(R.id.ps_rl_album_click);
        this.tvTitle = (MarqueeTextView)this.findViewById(R.id.ps_tv_title);
        this.ivArrow = (ImageView)this.findViewById(R.id.ps_iv_arrow);
        this.tvCancel = (TextView)this.findViewById(R.id.ps_tv_cancel);
        this.titleBarLine = this.findViewById(R.id.title_bar_line);
        this.ivLeftBack.setOnClickListener((View.OnClickListener)this);
        this.tvCancel.setOnClickListener((View.OnClickListener)this);
        this.rlAlbumBg.setOnClickListener((View.OnClickListener)this);
        this.titleBarLayout.setOnClickListener((View.OnClickListener)this);
        this.viewAlbumClickArea.setOnClickListener((View.OnClickListener)this);
        this.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.ps_color_grey));
        this.config = PictureSelectionConfig.getInstance();
        this.handleLayoutUI();
    }

    protected void inflateLayout() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.ps_title_bar, (ViewGroup)this);
    }

    protected void handleLayoutUI() {
    }

    public ImageView getImageArrow() {
        return this.ivArrow;
    }

    public ImageView getImageDelete() {
        return this.ivDelete;
    }

    public View getTitleBarLine() {
        return this.titleBarLine;
    }

    public void setTitle(String title) {
        this.tvTitle.setText(title);
    }

    public String getTitleText() {
        return this.tvTitle.getText().toString();
    }

    public void setTitleBarStyle() {
        int titleTextColor;
        int titleTextSize;
        String titleDefaultText;
        int backResId;
        int backgroundColor;
        PictureSelectorStyle selectorStyle;
        TitleBarStyle titleBarStyle;
        int titleBarHeight;
        if (this.config.isPreviewFullScreenMode) {
            ViewGroup.LayoutParams layoutParams = this.viewTopStatusBar.getLayoutParams();
            layoutParams.height = DensityUtil.getStatusBarHeight(this.getContext());
        }
        this.titleBarLayout.getLayoutParams().height = StyleUtils.checkSizeValidity(titleBarHeight = (titleBarStyle = (selectorStyle = PictureSelectionConfig.selectorStyle).getTitleBarStyle()).getTitleBarHeight()) ? titleBarHeight : DensityUtil.dip2px(this.getContext(), 48.0f);
        if (this.titleBarLine != null) {
            if (titleBarStyle.isDisplayTitleBarLine()) {
                this.titleBarLine.setVisibility(0);
                if (StyleUtils.checkStyleValidity(titleBarStyle.getTitleBarLineColor())) {
                    this.titleBarLine.setBackgroundColor(titleBarStyle.getTitleBarLineColor());
                }
            } else {
                this.titleBarLine.setVisibility(8);
            }
        }
        if (StyleUtils.checkStyleValidity(backgroundColor = titleBarStyle.getTitleBackgroundColor())) {
            this.setBackgroundColor(backgroundColor);
        }
        if (StyleUtils.checkStyleValidity(backResId = titleBarStyle.getTitleLeftBackResource())) {
            this.ivLeftBack.setImageResource(backResId);
        }
        if (StyleUtils.checkTextValidity(titleDefaultText = titleBarStyle.getTitleDefaultText())) {
            this.tvTitle.setText(titleDefaultText);
        }
        if (StyleUtils.checkSizeValidity(titleTextSize = titleBarStyle.getTitleTextSize())) {
            this.tvTitle.setTextSize(titleTextSize);
        }
        if (StyleUtils.checkStyleValidity(titleTextColor = titleBarStyle.getTitleTextColor())) {
            this.tvTitle.setTextColor(titleTextColor);
        }
        if (this.config.isOnlySandboxDir) {
            this.ivArrow.setImageResource(R.drawable.ps_ic_trans_1px);
        } else {
            int arrowResId = titleBarStyle.getTitleDrawableRightResource();
            if (StyleUtils.checkStyleValidity(arrowResId)) {
                this.ivArrow.setImageResource(arrowResId);
            }
        }
        int albumBackgroundRes = titleBarStyle.getTitleAlbumBackgroundResource();
        if (StyleUtils.checkStyleValidity(albumBackgroundRes)) {
            this.rlAlbumBg.setBackgroundResource(albumBackgroundRes);
        }
        if (titleBarStyle.isHideCancelButton()) {
            this.tvCancel.setVisibility(8);
        } else {
            int titleCancelTextSize;
            int titleCancelTextColor;
            String titleCancelText;
            this.tvCancel.setVisibility(0);
            int titleCancelBackgroundResource = titleBarStyle.getTitleCancelBackgroundResource();
            if (StyleUtils.checkStyleValidity(titleCancelBackgroundResource)) {
                this.tvCancel.setBackgroundResource(titleCancelBackgroundResource);
            }
            if (StyleUtils.checkTextValidity(titleCancelText = titleBarStyle.getTitleCancelText())) {
                this.tvCancel.setText((CharSequence)titleCancelText);
            }
            if (StyleUtils.checkStyleValidity(titleCancelTextColor = titleBarStyle.getTitleCancelTextColor())) {
                this.tvCancel.setTextColor(titleCancelTextColor);
            }
            if (StyleUtils.checkSizeValidity(titleCancelTextSize = titleBarStyle.getTitleCancelTextSize())) {
                this.tvCancel.setTextSize((float)titleCancelTextSize);
            }
        }
        int deleteBackgroundResource = titleBarStyle.getPreviewDeleteBackgroundResource();
        if (StyleUtils.checkStyleValidity(deleteBackgroundResource)) {
            this.ivDelete.setBackgroundResource(deleteBackgroundResource);
        } else {
            this.ivDelete.setBackgroundResource(R.drawable.ps_ic_delete);
        }
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.ps_iv_left_back || id2 == R.id.ps_tv_cancel) {
            if (this.titleBarListener != null) {
                this.titleBarListener.onBackPressed();
            }
        } else if (id2 == R.id.ps_rl_album_bg || id2 == R.id.ps_rl_album_click) {
            if (this.titleBarListener != null) {
                this.titleBarListener.onShowAlbumPopWindow((View)this);
            }
        } else if (id2 == R.id.rl_title_bar && this.titleBarListener != null) {
            this.titleBarListener.onTitleDoubleClick();
        }
    }

    public void setOnTitleBarListener(OnTitleBarListener listener) {
        this.titleBarListener = listener;
    }

    public static class OnTitleBarListener {
        public void onTitleDoubleClick() {
        }

        public void onBackPressed() {
        }

        public void onShowAlbumPopWindow(View anchor) {
        }
    }
}

