/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.permissions;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Environment;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.luck.picture.lib.basic.PictureCommonFragment;
import com.luck.picture.lib.permissions.PermissionResultCallback;
import com.luck.picture.lib.permissions.PermissionUtil;
import com.luck.picture.lib.utils.ActivityCompatHelper;
import com.luck.picture.lib.utils.SdkVersionUtils;
import java.util.ArrayList;
import java.util.List;

public class PermissionChecker {
    private static final int REQUEST_CODE = 10086;
    private static PermissionChecker mInstance;

    private PermissionChecker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PermissionChecker getInstance() {
        if (mInstance != null) return mInstance;
        Class<PermissionChecker> clazz = PermissionChecker.class;
        synchronized (PermissionChecker.class) {
            if (mInstance != null) return mInstance;
            mInstance = new PermissionChecker();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public void requestPermissions(Fragment fragment, String[] permissionArray, PermissionResultCallback callback) {
        ArrayList<String[]> groupList = new ArrayList<String[]>();
        groupList.add(permissionArray);
        this.requestPermissions(fragment, groupList, 10086, callback);
    }

    public void requestPermissions(Fragment fragment, List<String[]> permissionGroupList, PermissionResultCallback callback) {
        this.requestPermissions(fragment, permissionGroupList, 10086, callback);
    }

    private void requestPermissions(Fragment fragment, List<String[]> permissionGroupList, int requestCode, PermissionResultCallback permissionResultCallback) {
        if (ActivityCompatHelper.isDestroy((Activity)fragment.getActivity())) {
            return;
        }
        if (fragment instanceof PictureCommonFragment) {
            if (Build.VERSION.SDK_INT < 23) {
                if (permissionResultCallback != null) {
                    permissionResultCallback.onGranted();
                }
                return;
            }
            FragmentActivity activity = fragment.getActivity();
            ArrayList<String> permissionList = new ArrayList<String>();
            for (String[] permissionArray : permissionGroupList) {
                for (String permission2 : permissionArray) {
                    if (ContextCompat.checkSelfPermission((Context)activity, (String)permission2) == 0) continue;
                    permissionList.add(permission2);
                }
            }
            if (permissionList.size() > 0) {
                ((PictureCommonFragment)fragment).setPermissionsResultAction(permissionResultCallback);
                String[] requestArray = new String[permissionList.size()];
                permissionList.toArray(requestArray);
                fragment.requestPermissions(requestArray, requestCode);
                ActivityCompat.requestPermissions((Activity)activity, (String[])requestArray, (int)requestCode);
            } else if (permissionResultCallback != null) {
                permissionResultCallback.onGranted();
            }
        }
    }

    public void onRequestPermissionsResult(int[] grantResults, PermissionResultCallback action) {
        if (PermissionUtil.isAllGranted(grantResults)) {
            action.onGranted();
        } else {
            action.onDenied();
        }
    }

    public static boolean checkSelfPermission(Context ctx, String[] permissions) {
        boolean isAllGranted = true;
        if (permissions != null) {
            for (String permission2 : permissions) {
                if (ContextCompat.checkSelfPermission((Context)ctx.getApplicationContext(), (String)permission2) == 0) continue;
                isAllGranted = false;
                break;
            }
        }
        return isAllGranted;
    }

    public static boolean isCheckReadStorage(Context context) {
        boolean isPermissionState = SdkVersionUtils.isR() ? Environment.isExternalStorageManager() : PermissionChecker.checkSelfPermission(context, new String[]{"android.permission.READ_EXTERNAL_STORAGE"});
        return isPermissionState;
    }

    public static boolean isCheckWriteStorage(Context context) {
        boolean isPermissionState = SdkVersionUtils.isR() ? Environment.isExternalStorageManager() : PermissionChecker.checkSelfPermission(context, new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"});
        return isPermissionState;
    }

    public static boolean isCheckCamera(Context context) {
        return PermissionChecker.checkSelfPermission(context, new String[]{"android.permission.CAMERA"});
    }

    public static boolean isCheckSelfPermission(Context context, String[] permissions) {
        return PermissionChecker.checkSelfPermission(context, permissions);
    }
}

