/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.widget;

import android.content.Context;
import android.content.res.Resources;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.widget.OverScroller;
import androidx.annotation.NonNull;
import androidx.core.view.ViewCompat;
import androidx.recyclerview.widget.RecyclerView;

public class SlideSelectTouchListener
implements RecyclerView.OnItemTouchListener {
    private boolean isActive;
    private int mStart;
    private int mEnd;
    private boolean mInTopSpot;
    private boolean mInBottomSpot;
    private int mScrollDistance;
    private float mLastX;
    private float mLastY;
    private int mLastStart;
    private int mLastEnd;
    private OnSlideSelectListener mSelectListener;
    private RecyclerView mRecyclerView;
    private OverScroller mScroller;
    private final Runnable mScrollRunnable = new Runnable(){

        @Override
        public void run() {
            if (SlideSelectTouchListener.this.mScroller != null && SlideSelectTouchListener.this.mScroller.computeScrollOffset()) {
                SlideSelectTouchListener.this.scrollBy(SlideSelectTouchListener.this.mScrollDistance);
                ViewCompat.postOnAnimation((View)SlideSelectTouchListener.this.mRecyclerView, (Runnable)SlideSelectTouchListener.this.mScrollRunnable);
            }
        }
    };
    private int mTopBoundFrom;
    private int mTopBoundTo;
    private int mBottomBoundFrom;
    private int mBottomBoundTo;
    private int mMaxScrollDistance = 16;
    private int mAutoScrollDistance;
    private int mTouchRegionTopOffset;
    private int mTouchRegionBottomOffset;
    private boolean mScrollAboveTopRegion;
    private boolean mScrollBelowTopRegion;
    private int mHeaderViewCount;

    public SlideSelectTouchListener() {
        this.mAutoScrollDistance = (int)(Resources.getSystem().getDisplayMetrics().density * 56.0f);
        this.mTouchRegionTopOffset = 0;
        this.mTouchRegionBottomOffset = 0;
        this.mScrollAboveTopRegion = true;
        this.mScrollBelowTopRegion = true;
        this.reset();
    }

    public SlideSelectTouchListener setRecyclerViewHeaderCount(int count) {
        this.mHeaderViewCount = count;
        return this;
    }

    public SlideSelectTouchListener withSelectListener(OnSlideSelectListener selectListener) {
        this.mSelectListener = selectListener;
        return this;
    }

    public SlideSelectTouchListener withMaxScrollDistance(int distance) {
        this.mMaxScrollDistance = distance;
        return this;
    }

    public SlideSelectTouchListener withTouchRegion(int size) {
        this.mAutoScrollDistance = size;
        return this;
    }

    public SlideSelectTouchListener withTopOffset(int distance) {
        this.mTouchRegionTopOffset = distance;
        return this;
    }

    public SlideSelectTouchListener withBottomOffset(int distance) {
        this.mTouchRegionBottomOffset = distance;
        return this;
    }

    public SlideSelectTouchListener withScrollAboveTopRegion(boolean enabled) {
        this.mScrollAboveTopRegion = enabled;
        return this;
    }

    public SlideSelectTouchListener withScrollBelowTopRegion(boolean enabled) {
        this.mScrollBelowTopRegion = enabled;
        return this;
    }

    public void startSlideSelection(int position) {
        this.setActive(true);
        this.mStart = position;
        this.mEnd = position;
        this.mLastStart = position;
        this.mLastEnd = position;
        if (this.mSelectListener != null && this.mSelectListener instanceof OnAdvancedSlideSelectListener) {
            ((OnAdvancedSlideSelectListener)this.mSelectListener).onSelectionStarted(position);
        }
    }

    public boolean onInterceptTouchEvent(@NonNull RecyclerView rv, @NonNull MotionEvent e) {
        if (!this.isActive || rv.getAdapter() == null || rv.getAdapter().getItemCount() == 0) {
            return false;
        }
        int action = e.getAction();
        switch (action) {
            case 0: 
            case 5: {
                this.reset();
            }
        }
        this.mRecyclerView = rv;
        int height = rv.getHeight();
        this.mTopBoundFrom = this.mTouchRegionTopOffset;
        this.mTopBoundTo = this.mTouchRegionTopOffset + this.mAutoScrollDistance;
        this.mBottomBoundFrom = height + this.mTouchRegionBottomOffset - this.mAutoScrollDistance;
        this.mBottomBoundTo = height + this.mTouchRegionBottomOffset;
        return true;
    }

    public void startAutoScroll() {
        if (this.mRecyclerView == null) {
            return;
        }
        this.initScroller(this.mRecyclerView.getContext());
        if (this.mScroller.isFinished()) {
            this.mRecyclerView.removeCallbacks(this.mScrollRunnable);
            this.mScroller.startScroll(0, this.mScroller.getCurrY(), 0, 5000, 100000);
            ViewCompat.postOnAnimation((View)this.mRecyclerView, (Runnable)this.mScrollRunnable);
        }
    }

    private void initScroller(Context context) {
        if (this.mScroller == null) {
            this.mScroller = new OverScroller(context, (Interpolator)new LinearInterpolator());
        }
    }

    public void stopAutoScroll() {
        try {
            if (this.mScroller != null && !this.mScroller.isFinished()) {
                this.mRecyclerView.removeCallbacks(this.mScrollRunnable);
                this.mScroller.abortAnimation();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onTouchEvent(@NonNull RecyclerView rv, @NonNull MotionEvent e) {
        if (!this.isActive) {
            this.reset();
            return;
        }
        int action = e.getAction();
        switch (action) {
            case 2: {
                if (!this.mInTopSpot && !this.mInBottomSpot) {
                    this.changeSelectedRange(rv, e);
                }
                this.processAutoScroll(e);
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                this.reset();
            }
        }
    }

    private void changeSelectedRange(RecyclerView rv, MotionEvent e) {
        this.changeSelectedRange(rv, e.getX(), e.getY());
    }

    private void changeSelectedRange(RecyclerView rv, float x, float y) {
        int position;
        View child = rv.findChildViewUnder(x, y);
        if (child != null && (position = rv.getChildAdapterPosition(child) - this.mHeaderViewCount) != -1 && this.mEnd != position) {
            this.mEnd = position;
            this.notifySelectRangeChange();
        }
    }

    private void processAutoScroll(MotionEvent event) {
        int y = (int)event.getY();
        if (y >= this.mTopBoundFrom && y <= this.mTopBoundTo) {
            this.mLastX = event.getX();
            this.mLastY = event.getY();
            float mScrollSpeedFactor = ((float)this.mTopBoundTo - (float)this.mTopBoundFrom - ((float)y - (float)this.mTopBoundFrom)) / ((float)this.mTopBoundTo - (float)this.mTopBoundFrom);
            this.mScrollDistance = (int)((float)this.mMaxScrollDistance * mScrollSpeedFactor * -1.0f);
            if (!this.mInTopSpot) {
                this.mInTopSpot = true;
                this.startAutoScroll();
            }
        } else if (this.mScrollAboveTopRegion && y < this.mTopBoundFrom) {
            this.mLastX = event.getX();
            this.mLastY = event.getY();
            this.mScrollDistance = this.mMaxScrollDistance * -1;
            if (!this.mInTopSpot) {
                this.mInTopSpot = true;
                this.startAutoScroll();
            }
        } else if (y >= this.mBottomBoundFrom && y <= this.mBottomBoundTo) {
            this.mLastX = event.getX();
            this.mLastY = event.getY();
            float mScrollSpeedFactor = ((float)y - (float)this.mBottomBoundFrom) / ((float)this.mBottomBoundTo - (float)this.mBottomBoundFrom);
            this.mScrollDistance = (int)((float)this.mMaxScrollDistance * mScrollSpeedFactor);
            if (!this.mInBottomSpot) {
                this.mInBottomSpot = true;
                this.startAutoScroll();
            }
        } else if (this.mScrollBelowTopRegion && y > this.mBottomBoundTo) {
            this.mLastX = event.getX();
            this.mLastY = event.getY();
            this.mScrollDistance = this.mMaxScrollDistance;
            if (!this.mInTopSpot) {
                this.mInTopSpot = true;
                this.startAutoScroll();
            }
        } else {
            this.mInBottomSpot = false;
            this.mInTopSpot = false;
            this.mLastX = Float.MIN_VALUE;
            this.mLastY = Float.MIN_VALUE;
            this.stopAutoScroll();
        }
    }

    private void notifySelectRangeChange() {
        if (this.mSelectListener == null) {
            return;
        }
        if (this.mStart == -1 || this.mEnd == -1) {
            return;
        }
        int newStart = Math.min(this.mStart, this.mEnd);
        int newEnd = Math.max(this.mStart, this.mEnd);
        if (newStart < 0) {
            return;
        }
        if (this.mLastStart == -1 || this.mLastEnd == -1) {
            if (newEnd - newStart == 1) {
                this.mSelectListener.onSelectChange(newStart, newStart, true);
            } else {
                this.mSelectListener.onSelectChange(newStart, newEnd, true);
            }
        } else {
            if (newStart > this.mLastStart) {
                this.mSelectListener.onSelectChange(this.mLastStart, newStart - 1, false);
            } else if (newStart < this.mLastStart) {
                this.mSelectListener.onSelectChange(newStart, this.mLastStart - 1, true);
            }
            if (newEnd > this.mLastEnd) {
                this.mSelectListener.onSelectChange(this.mLastEnd + 1, newEnd, true);
            } else if (newEnd < this.mLastEnd) {
                this.mSelectListener.onSelectChange(newEnd + 1, this.mLastEnd, false);
            }
        }
        this.mLastStart = newStart;
        this.mLastEnd = newEnd;
    }

    private void reset() {
        this.setActive(false);
        if (this.mSelectListener != null && this.mSelectListener instanceof OnAdvancedSlideSelectListener) {
            ((OnAdvancedSlideSelectListener)this.mSelectListener).onSelectionFinished(this.mEnd);
        }
        this.mStart = -1;
        this.mEnd = -1;
        this.mLastStart = -1;
        this.mLastEnd = -1;
        this.mInTopSpot = false;
        this.mInBottomSpot = false;
        this.mLastX = Float.MIN_VALUE;
        this.mLastY = Float.MIN_VALUE;
        this.stopAutoScroll();
    }

    public void onRequestDisallowInterceptTouchEvent(boolean disallowIntercept) {
    }

    private void scrollBy(int distance) {
        int scrollDistance = distance > 0 ? Math.min(distance, this.mMaxScrollDistance) : Math.max(distance, -this.mMaxScrollDistance);
        this.mRecyclerView.scrollBy(0, scrollDistance);
        if (this.mLastX != Float.MIN_VALUE && this.mLastY != Float.MIN_VALUE) {
            this.changeSelectedRange(this.mRecyclerView, this.mLastX, this.mLastY);
        }
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    public static interface OnSlideSelectListener {
        public void onSelectChange(int var1, int var2, boolean var3);
    }

    public static interface OnAdvancedSlideSelectListener
    extends OnSlideSelectListener {
        public void onSelectionStarted(int var1);

        public void onSelectionFinished(int var1);
    }
}

