/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.loader;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.luck.picture.lib.R;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.config.SelectMimeType;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.entity.LocalMediaFolder;
import com.luck.picture.lib.entity.MediaData;
import com.luck.picture.lib.interfaces.OnQueryAlbumListener;
import com.luck.picture.lib.interfaces.OnQueryAllAlbumListener;
import com.luck.picture.lib.interfaces.OnQueryDataResultListener;
import com.luck.picture.lib.loader.IBridgeMediaLoader;
import com.luck.picture.lib.loader.SandboxFileLoader;
import com.luck.picture.lib.thread.PictureThreadUtils;
import com.luck.picture.lib.utils.MediaUtils;
import com.luck.picture.lib.utils.PictureFileUtils;
import com.luck.picture.lib.utils.SdkVersionUtils;
import com.luck.picture.lib.utils.SortUtils;
import com.luck.picture.lib.utils.ValueOf;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public final class LocalMediaPageLoader
extends IBridgeMediaLoader {
    private static final String[] PROJECTION_29 = new String[]{"_id", "bucket_id", "bucket_display_name", "mime_type"};
    private static final String[] ALL_PROJECTION = new String[]{"_id", "_data", "bucket_id", "bucket_display_name", "mime_type", "COUNT(*) AS count"};

    public LocalMediaPageLoader(Context context, PictureSelectionConfig config) {
        this.mContext = context;
        this.config = config;
    }

    private static String getSelectionArgsForAllMediaCondition(String timeCondition, String sizeCondition, String queryMimeTypeOptions) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(").append("media_type").append("=?").append(queryMimeTypeOptions).append(" OR ").append("media_type").append("=? AND ").append(timeCondition).append(") AND ").append(sizeCondition);
        if (SdkVersionUtils.isQ()) {
            return stringBuilder.toString();
        }
        return stringBuilder.append(")").append(" GROUP BY (bucket_id").toString();
    }

    private static String getSelectionArgsForImageMediaCondition(String queryMimeTypeOptions, String fileSizeCondition) {
        StringBuilder stringBuilder = new StringBuilder();
        if (SdkVersionUtils.isQ()) {
            return stringBuilder.append("media_type").append("=?").append(queryMimeTypeOptions).append(" AND ").append(fileSizeCondition).toString();
        }
        return stringBuilder.append("(").append("media_type").append("=?").append(queryMimeTypeOptions).append(") AND ").append(fileSizeCondition).append(")").append(" GROUP BY (bucket_id").toString();
    }

    private static String getSelectionArgsForVideoOrAudioMediaCondition(String queryMimeTypeOptions, String fileSizeCondition) {
        StringBuilder stringBuilder = new StringBuilder();
        if (SdkVersionUtils.isQ()) {
            return stringBuilder.append("media_type").append("=?").append(queryMimeTypeOptions).append(" AND ").append(fileSizeCondition).toString();
        }
        return stringBuilder.append("(").append("media_type").append("=?").append(queryMimeTypeOptions).append(") AND ").append(fileSizeCondition).append(")").append(" GROUP BY (bucket_id").toString();
    }

    private static String[] getSelectionArgsForPageSingleMediaType(int mediaType, long bucketId) {
        String[] stringArray;
        if (bucketId == -1L) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = String.valueOf(mediaType);
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = String.valueOf(mediaType);
            stringArray = stringArray3;
            stringArray3[1] = ValueOf.toString(bucketId);
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getFirstCover(long bucketId) {
        Cursor data = null;
        try {
            if (SdkVersionUtils.isR()) {
                Bundle queryArgs = MediaUtils.createQueryArgsBundle(this.getPageSelection(bucketId), this.getPageSelectionArgs(bucketId), 1, 0);
                data = this.mContext.getContentResolver().query(QUERY_URI, new String[]{"_id", "mime_type", "_data"}, queryArgs, null);
            } else {
                String orderBy = this.getSortOrder() + " limit 1 offset 0";
                data = this.mContext.getContentResolver().query(QUERY_URI, new String[]{"_id", "mime_type", "_data"}, this.getPageSelection(bucketId), this.getPageSelectionArgs(bucketId), orderBy);
            }
            if (data != null && data.getCount() > 0) {
                if (data.moveToFirst()) {
                    long id2 = data.getLong(data.getColumnIndexOrThrow("_id"));
                    String mimeType = data.getString(data.getColumnIndexOrThrow("mime_type"));
                    String string2 = SdkVersionUtils.isQ() ? MediaUtils.getRealPathUri(id2, mimeType) : data.getString(data.getColumnIndexOrThrow("_data"));
                    return string2;
                }
                String id2 = null;
                return id2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (data != null && !data.isClosed()) {
                data.close();
            }
        }
        return null;
    }

    @Override
    public void loadFirstPageMedia(long bucketId, int pageSize, OnQueryDataResultListener<LocalMedia> listener) {
        this.loadPageMediaData(bucketId, 1, pageSize, pageSize, listener);
    }

    @Override
    public void loadPageMediaData(long bucketId, int page, int pageSize, OnQueryDataResultListener<LocalMedia> listener) {
        this.loadPageMediaData(bucketId, page, pageSize, pageSize, listener);
    }

    @Override
    public void loadPageMediaData(final long bucketId, final int page, final int limit, final int pageSize, final OnQueryDataResultListener<LocalMedia> listener) {
        PictureThreadUtils.executeByIo(new PictureThreadUtils.SimpleTask<MediaData>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public MediaData doInBackground() {
                Cursor data = null;
                try {
                    if (SdkVersionUtils.isR()) {
                        Bundle queryArgs = MediaUtils.createQueryArgsBundle(LocalMediaPageLoader.this.getPageSelection(bucketId), LocalMediaPageLoader.this.getPageSelectionArgs(bucketId), limit, (page - 1) * pageSize);
                        data = LocalMediaPageLoader.this.mContext.getContentResolver().query(IBridgeMediaLoader.QUERY_URI, IBridgeMediaLoader.PROJECTION, queryArgs, null);
                    } else {
                        String orderBy = page == -1 ? LocalMediaPageLoader.this.getSortOrder() : LocalMediaPageLoader.this.getSortOrder() + " limit " + limit + " offset " + (page - 1) * pageSize;
                        data = LocalMediaPageLoader.this.mContext.getContentResolver().query(IBridgeMediaLoader.QUERY_URI, IBridgeMediaLoader.PROJECTION, LocalMediaPageLoader.this.getPageSelection(bucketId), LocalMediaPageLoader.this.getPageSelectionArgs(bucketId), orderBy);
                    }
                    if (data != null) {
                        ArrayList<LocalMedia> list;
                        ArrayList<LocalMedia> result = new ArrayList<LocalMedia>();
                        if (data.getCount() > 0) {
                            int idColumn = data.getColumnIndexOrThrow(IBridgeMediaLoader.PROJECTION[0]);
                            int dataColumn = data.getColumnIndexOrThrow(IBridgeMediaLoader.PROJECTION[1]);
                            int mimeTypeColumn = data.getColumnIndexOrThrow(IBridgeMediaLoader.PROJECTION[2]);
                            int widthColumn = data.getColumnIndexOrThrow(IBridgeMediaLoader.PROJECTION[3]);
                            int heightColumn = data.getColumnIndexOrThrow(IBridgeMediaLoader.PROJECTION[4]);
                            int durationColumn = data.getColumnIndexOrThrow(IBridgeMediaLoader.PROJECTION[5]);
                            int sizeColumn = data.getColumnIndexOrThrow(IBridgeMediaLoader.PROJECTION[6]);
                            int folderNameColumn = data.getColumnIndexOrThrow(IBridgeMediaLoader.PROJECTION[7]);
                            int fileNameColumn = data.getColumnIndexOrThrow(IBridgeMediaLoader.PROJECTION[8]);
                            int bucketIdColumn = data.getColumnIndexOrThrow(IBridgeMediaLoader.PROJECTION[9]);
                            int dateAddedColumn = data.getColumnIndexOrThrow(IBridgeMediaLoader.PROJECTION[10]);
                            data.moveToFirst();
                            do {
                                String url;
                                long id2 = data.getLong(idColumn);
                                String mimeType = data.getString(mimeTypeColumn);
                                mimeType = TextUtils.isEmpty((CharSequence)mimeType) ? PictureMimeType.ofJPEG() : mimeType;
                                String absolutePath = data.getString(dataColumn);
                                String string2 = url = SdkVersionUtils.isQ() ? MediaUtils.getRealPathUri(id2, mimeType) : absolutePath;
                                if (LocalMediaPageLoader.this.config.isFilterInvalidFile && !PictureFileUtils.isFileExists(absolutePath)) continue;
                                if (mimeType.endsWith("image/*")) {
                                    mimeType = MediaUtils.getMimeTypeFromMediaUrl(absolutePath);
                                    if (!LocalMediaPageLoader.this.config.isGif && PictureMimeType.isHasGif(mimeType)) continue;
                                }
                                if (mimeType.endsWith("image/*") || !LocalMediaPageLoader.this.config.isWebp && mimeType.startsWith(PictureMimeType.ofWEBP()) || !LocalMediaPageLoader.this.config.isBmp && mimeType.startsWith(PictureMimeType.ofBMP())) continue;
                                int width = data.getInt(widthColumn);
                                int height = data.getInt(heightColumn);
                                long duration = data.getLong(durationColumn);
                                long size = data.getLong(sizeColumn);
                                String folderName = data.getString(folderNameColumn);
                                String fileName = data.getString(fileNameColumn);
                                long bucket_id = data.getLong(bucketIdColumn);
                                if ((PictureMimeType.isHasVideo(mimeType) || PictureMimeType.isHasAudio(mimeType)) && (LocalMediaPageLoader.this.config.filterVideoMinSecond > 0 && duration < (long)LocalMediaPageLoader.this.config.filterVideoMinSecond || LocalMediaPageLoader.this.config.filterVideoMaxSecond > 0 && duration > (long)LocalMediaPageLoader.this.config.filterVideoMaxSecond || duration == 0L || size <= 0L)) continue;
                                LocalMedia image = LocalMedia.parseLocalMedia(id2, url, absolutePath, fileName, folderName, duration, LocalMediaPageLoader.this.config.chooseMode, mimeType, width, height, size, bucket_id, data.getLong(dateAddedColumn));
                                result.add(image);
                            } while (data.moveToNext());
                        }
                        if (bucketId == -1L && page == 1 && (list = SandboxFileLoader.loadInAppSandboxFile(LocalMediaPageLoader.this.mContext, LocalMediaPageLoader.this.config.sandboxDir)) != null) {
                            result.addAll(list);
                            SortUtils.sortLocalMediaAddedTime(result);
                        }
                        MediaData mediaData = new MediaData(data.getCount() > 0, result);
                        return mediaData;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Log.i((String)IBridgeMediaLoader.TAG, (String)("loadMedia Page Data Error: " + e.getMessage()));
                    MediaData mediaData = new MediaData();
                    return mediaData;
                }
                finally {
                    if (data != null && !data.isClosed()) {
                        data.close();
                    }
                }
                return new MediaData();
            }

            @Override
            public void onSuccess(MediaData result) {
                PictureThreadUtils.cancel((PictureThreadUtils.Task)this);
                if (listener != null) {
                    listener.onComplete(result.data != null ? result.data : new ArrayList(), result.isHasNextMore);
                }
            }
        });
    }

    @Override
    public void loadOnlyInAppDirAllMedia(final OnQueryAlbumListener<LocalMediaFolder> query) {
        PictureThreadUtils.executeByIo(new PictureThreadUtils.SimpleTask<LocalMediaFolder>(){

            @Override
            public LocalMediaFolder doInBackground() {
                return SandboxFileLoader.loadInAppSandboxFolderFile(LocalMediaPageLoader.this.mContext, LocalMediaPageLoader.this.config.sandboxDir);
            }

            @Override
            public void onSuccess(LocalMediaFolder result) {
                PictureThreadUtils.cancel((PictureThreadUtils.Task)this);
                if (query != null) {
                    query.onComplete(result);
                }
            }
        });
    }

    @Override
    public void loadAllAlbum(final OnQueryAllAlbumListener<LocalMediaFolder> query) {
        PictureThreadUtils.executeByIo(new PictureThreadUtils.SimpleTask<List<LocalMediaFolder>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<LocalMediaFolder> doInBackground() {
                Cursor data = LocalMediaPageLoader.this.mContext.getContentResolver().query(IBridgeMediaLoader.QUERY_URI, SdkVersionUtils.isQ() ? PROJECTION_29 : ALL_PROJECTION, LocalMediaPageLoader.this.getSelection(), LocalMediaPageLoader.this.getSelectionArgs(), LocalMediaPageLoader.this.getSortOrder());
                try {
                    if (data != null) {
                        int count = data.getCount();
                        int totalCount = 0;
                        ArrayList<LocalMediaFolder> mediaFolders = new ArrayList<LocalMediaFolder>();
                        if (count > 0) {
                            if (SdkVersionUtils.isQ()) {
                                HashMap<Long, Long> countMap = new HashMap<Long, Long>();
                                while (data.moveToNext()) {
                                    long bucketId = data.getLong(data.getColumnIndexOrThrow("bucket_id"));
                                    Long newCount = (Long)countMap.get(bucketId);
                                    if (newCount == null) {
                                        newCount = 1L;
                                    } else {
                                        Long l = newCount;
                                        Long l2 = newCount = Long.valueOf(newCount + 1L);
                                    }
                                    countMap.put(bucketId, newCount);
                                }
                                if (data.moveToFirst()) {
                                    HashSet<Long> hashSet = new HashSet<Long>();
                                    do {
                                        long bucketId;
                                        if (hashSet.contains(bucketId = data.getLong(data.getColumnIndexOrThrow("bucket_id")))) continue;
                                        LocalMediaFolder mediaFolder = new LocalMediaFolder();
                                        mediaFolder.setBucketId(bucketId);
                                        String bucketDisplayName = data.getString(data.getColumnIndexOrThrow("bucket_display_name"));
                                        String mimeType = data.getString(data.getColumnIndexOrThrow("mime_type"));
                                        long size = (Long)countMap.get(bucketId);
                                        long id2 = data.getLong(data.getColumnIndexOrThrow("_id"));
                                        mediaFolder.setFolderName(bucketDisplayName);
                                        mediaFolder.setFolderTotalNum(ValueOf.toInt(size));
                                        mediaFolder.setFirstImagePath(MediaUtils.getRealPathUri(id2, mimeType));
                                        mediaFolder.setFirstMimeType(mimeType);
                                        mediaFolders.add(mediaFolder);
                                        hashSet.add(bucketId);
                                        totalCount = (int)((long)totalCount + size);
                                    } while (data.moveToNext());
                                }
                            } else {
                                data.moveToFirst();
                                do {
                                    LocalMediaFolder mediaFolder = new LocalMediaFolder();
                                    long bucketId = data.getLong(data.getColumnIndexOrThrow("bucket_id"));
                                    String bucketDisplayName = data.getString(data.getColumnIndexOrThrow("bucket_display_name"));
                                    String mimeType = data.getString(data.getColumnIndexOrThrow("mime_type"));
                                    int size = data.getInt(data.getColumnIndexOrThrow("count"));
                                    mediaFolder.setBucketId(bucketId);
                                    String url = data.getString(data.getColumnIndexOrThrow("_data"));
                                    mediaFolder.setFirstImagePath(url);
                                    mediaFolder.setFolderName(bucketDisplayName);
                                    mediaFolder.setFirstMimeType(mimeType);
                                    mediaFolder.setFolderTotalNum(size);
                                    mediaFolders.add(mediaFolder);
                                    totalCount += size;
                                } while (data.moveToNext());
                            }
                            LocalMediaFolder allMediaFolder = new LocalMediaFolder();
                            LocalMediaFolder selfFolder = SandboxFileLoader.loadInAppSandboxFolderFile(LocalMediaPageLoader.this.mContext, LocalMediaPageLoader.this.config.sandboxDir);
                            if (selfFolder != null) {
                                mediaFolders.add(selfFolder);
                                String firstImagePath = selfFolder.getFirstImagePath();
                                File file = new File(firstImagePath);
                                long lastModified = file.lastModified();
                                totalCount += selfFolder.getFolderTotalNum();
                                allMediaFolder.setData(new ArrayList<LocalMedia>());
                                if (data.moveToFirst()) {
                                    long lastModified2;
                                    allMediaFolder.setFirstImagePath(SdkVersionUtils.isQ() ? LocalMediaPageLoader.getFirstUri(data) : LocalMediaPageLoader.getFirstUrl(data));
                                    allMediaFolder.setFirstMimeType(LocalMediaPageLoader.getFirstCoverMimeType(data));
                                    if (PictureMimeType.isContent(allMediaFolder.getFirstImagePath())) {
                                        String path = PictureFileUtils.getPath(LocalMediaPageLoader.this.mContext, Uri.parse((String)allMediaFolder.getFirstImagePath()));
                                        lastModified2 = new File(path).lastModified();
                                    } else {
                                        lastModified2 = new File(allMediaFolder.getFirstImagePath()).lastModified();
                                    }
                                    if (lastModified > lastModified2) {
                                        allMediaFolder.setFirstImagePath(selfFolder.getFirstImagePath());
                                        allMediaFolder.setFirstMimeType(selfFolder.getFirstMimeType());
                                    }
                                }
                            } else if (data.moveToFirst()) {
                                allMediaFolder.setFirstImagePath(SdkVersionUtils.isQ() ? LocalMediaPageLoader.getFirstUri(data) : LocalMediaPageLoader.getFirstUrl(data));
                                allMediaFolder.setFirstMimeType(LocalMediaPageLoader.getFirstCoverMimeType(data));
                            }
                            SortUtils.sortFolder(mediaFolders);
                            allMediaFolder.setFolderTotalNum(totalCount);
                            allMediaFolder.setBucketId(-1L);
                            String bucketDisplayName = LocalMediaPageLoader.this.config.chooseMode == SelectMimeType.ofAudio() ? LocalMediaPageLoader.this.mContext.getString(R.string.ps_all_audio) : LocalMediaPageLoader.this.mContext.getString(R.string.ps_camera_roll);
                            allMediaFolder.setFolderName(bucketDisplayName);
                            mediaFolders.add(0, allMediaFolder);
                            if (LocalMediaPageLoader.this.config.isSyncCover && LocalMediaPageLoader.this.config.chooseMode == SelectMimeType.ofAll()) {
                                LocalMediaPageLoader.this.synchronousFirstCover(mediaFolders);
                            }
                            ArrayList<LocalMediaFolder> arrayList = mediaFolders;
                            return arrayList;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Log.i((String)IBridgeMediaLoader.TAG, (String)("loadAllMedia Data Error: " + e.getMessage()));
                }
                finally {
                    if (data != null && !data.isClosed()) {
                        data.close();
                    }
                }
                return new ArrayList<LocalMediaFolder>();
            }

            @Override
            public void onSuccess(List<LocalMediaFolder> result) {
                PictureThreadUtils.cancel((PictureThreadUtils.Task)this);
                if (query != null) {
                    query.onComplete(result);
                }
            }
        });
    }

    private void synchronousFirstCover(List<LocalMediaFolder> mediaFolders) {
        for (int i = 0; i < mediaFolders.size(); ++i) {
            String firstCover;
            LocalMediaFolder mediaFolder = mediaFolders.get(i);
            if (mediaFolder == null || TextUtils.isEmpty((CharSequence)(firstCover = this.getFirstCover(mediaFolder.getBucketId())))) continue;
            mediaFolder.setFirstImagePath(firstCover);
        }
    }

    private static String getFirstUri(Cursor cursor) {
        long id2 = cursor.getLong(cursor.getColumnIndexOrThrow("_id"));
        String mimeType = cursor.getString(cursor.getColumnIndexOrThrow("mime_type"));
        return MediaUtils.getRealPathUri(id2, mimeType);
    }

    private static String getFirstCoverMimeType(Cursor cursor) {
        return cursor.getString(cursor.getColumnIndexOrThrow("mime_type"));
    }

    private static String getFirstUrl(Cursor cursor) {
        return cursor.getString(cursor.getColumnIndexOrThrow("_data"));
    }

    private String getPageSelection(long bucketId) {
        String durationCondition = this.getDurationCondition();
        String sizeCondition = this.getFileSizeCondition();
        String queryMimeCondition = this.getQueryMimeCondition();
        switch (this.config.chooseMode) {
            case 0: {
                return LocalMediaPageLoader.getPageSelectionArgsForAllMediaCondition(bucketId, queryMimeCondition, durationCondition, sizeCondition);
            }
            case 1: {
                return LocalMediaPageLoader.getPageSelectionArgsForImageMediaCondition(bucketId, queryMimeCondition, sizeCondition);
            }
            case 2: 
            case 3: {
                return LocalMediaPageLoader.getPageSelectionArgsForVideoOrAudioMediaCondition(bucketId, queryMimeCondition, durationCondition, sizeCondition);
            }
        }
        return null;
    }

    private static String getPageSelectionArgsForAllMediaCondition(long bucketId, String queryMimeCondition, String durationCondition, String sizeCondition) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(").append("media_type").append("=?").append(queryMimeCondition).append(" OR ").append("media_type").append("=? AND ").append(durationCondition).append(") AND ");
        if (bucketId == -1L) {
            return stringBuilder.append(sizeCondition).toString();
        }
        return stringBuilder.append("bucket_id").append("=? AND ").append(sizeCondition).toString();
    }

    private static String getPageSelectionArgsForImageMediaCondition(long bucketId, String queryMimeCondition, String sizeCondition) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(").append("media_type").append("=?");
        if (bucketId == -1L) {
            return stringBuilder.append(queryMimeCondition).append(") AND ").append(sizeCondition).toString();
        }
        return stringBuilder.append(queryMimeCondition).append(") AND ").append("bucket_id").append("=? AND ").append(sizeCondition).toString();
    }

    private static String getPageSelectionArgsForVideoOrAudioMediaCondition(long bucketId, String queryMimeCondition, String durationCondition, String sizeCondition) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(").append("media_type").append("=?").append(queryMimeCondition).append(" AND ").append(durationCondition).append(") AND ");
        if (bucketId == -1L) {
            return stringBuilder.append(sizeCondition).toString();
        }
        return stringBuilder.append("bucket_id").append("=? AND ").append(sizeCondition).toString();
    }

    private String[] getPageSelectionArgs(long bucketId) {
        switch (this.config.chooseMode) {
            case 0: {
                if (bucketId == -1L) {
                    return new String[]{String.valueOf(1), String.valueOf(3)};
                }
                return new String[]{String.valueOf(1), String.valueOf(3), ValueOf.toString(bucketId)};
            }
            case 1: {
                return LocalMediaPageLoader.getSelectionArgsForPageSingleMediaType(1, bucketId);
            }
            case 2: {
                return LocalMediaPageLoader.getSelectionArgsForPageSingleMediaType(3, bucketId);
            }
            case 3: {
                return LocalMediaPageLoader.getSelectionArgsForPageSingleMediaType(2, bucketId);
            }
        }
        return null;
    }

    private String getSelection() {
        String fileSizeCondition = this.getFileSizeCondition();
        String queryMimeCondition = this.getQueryMimeCondition();
        switch (this.config.chooseMode) {
            case 0: {
                return LocalMediaPageLoader.getSelectionArgsForAllMediaCondition(this.getDurationCondition(), fileSizeCondition, queryMimeCondition);
            }
            case 1: {
                return LocalMediaPageLoader.getSelectionArgsForImageMediaCondition(queryMimeCondition, fileSizeCondition);
            }
            case 2: 
            case 3: {
                return LocalMediaPageLoader.getSelectionArgsForVideoOrAudioMediaCondition(queryMimeCondition, fileSizeCondition);
            }
        }
        return null;
    }

    private String[] getSelectionArgs() {
        switch (this.config.chooseMode) {
            case 0: {
                return LocalMediaPageLoader.getSelectionArgsForAllMediaType();
            }
            case 1: {
                return LocalMediaPageLoader.getSelectionArgsForSingleMediaType(1);
            }
            case 2: {
                return LocalMediaPageLoader.getSelectionArgsForSingleMediaType(3);
            }
            case 3: {
                return LocalMediaPageLoader.getSelectionArgsForSingleMediaType(2);
            }
        }
        return null;
    }
}

