/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.config;

import android.text.TextUtils;

public final class PictureMimeType {
    public static final String MIME_TYPE_IMAGE = "image/jpeg";
    public static final String MIME_TYPE_VIDEO = "video/mp4";
    public static final String MIME_TYPE_AUDIO = "audio/mpeg";
    public static final String MIME_TYPE_AUDIO_AMR = "audio/amr";
    public static final String MIME_TYPE_PREFIX_IMAGE = "image";
    public static final String MIME_TYPE_PREFIX_VIDEO = "video";
    public static final String MIME_TYPE_PREFIX_AUDIO = "audio";
    private static final String MIME_TYPE_PNG = "image/png";
    public static final String MIME_TYPE_JPEG = "image/jpeg";
    private static final String MIME_TYPE_JPG = "image/jpg";
    private static final String MIME_TYPE_BMP = "image/bmp";
    private static final String MIME_TYPE_GIF = "image/gif";
    private static final String MIME_TYPE_WEBP = "image/webp";
    private static final String MIME_TYPE_3GP = "video/3gp";
    private static final String MIME_TYPE_MP4 = "video/mp4";
    private static final String MIME_TYPE_MPEG = "video/mpeg";
    private static final String MIME_TYPE_AVI = "video/avi";
    public static final String JPEG = ".jpeg";
    public static final String JPG = ".jpg";
    public static final String PNG = ".png";
    public static final String WEBP = ".webp";
    public static final String GIF = ".gif";
    public static final String BMP = ".bmp";
    public static final String AMR = ".amr";
    public static final String WAV = ".wav";
    public static final String MP3 = ".mp3";
    public static final String MP4 = ".mp4";
    public static final String AVI = ".avi";
    public static final String JPEG_Q = "image/jpeg";
    public static final String PNG_Q = "image/png";
    public static final String MP4_Q = "video/mp4";
    public static final String AVI_Q = "video/avi";
    public static final String AMR_Q = "audio/amr";
    public static final String WAV_Q = "audio/x-wav";
    public static final String MP3_Q = "audio/mpeg";
    public static final String DCIM = "DCIM/Camera";
    public static final String CAMERA = "Camera";

    public static boolean isHasGif(String mimeType) {
        return mimeType != null && (mimeType.equals(MIME_TYPE_GIF) || mimeType.equals("image/GIF"));
    }

    public static boolean isUrlHasGif(String url) {
        return url.toLowerCase().endsWith(GIF);
    }

    public static boolean isUrlHasImage(String url) {
        return url.toLowerCase().endsWith(JPG) || url.toLowerCase().endsWith(JPEG) || url.toLowerCase().endsWith(PNG);
    }

    public static boolean isHasWebp(String mimeType) {
        return mimeType != null && mimeType.equalsIgnoreCase(MIME_TYPE_WEBP);
    }

    public static boolean isUrlHasWebp(String url) {
        return url.toLowerCase().endsWith(WEBP);
    }

    public static boolean isHasVideo(String mimeType) {
        return mimeType != null && mimeType.startsWith(MIME_TYPE_PREFIX_VIDEO);
    }

    public static boolean isUrlHasVideo(String url) {
        return url.toLowerCase().endsWith(MP4);
    }

    public static boolean isHasAudio(String mimeType) {
        return mimeType != null && mimeType.startsWith(MIME_TYPE_PREFIX_AUDIO);
    }

    public static boolean isUrlHasAudio(String url) {
        return url.toLowerCase().endsWith(AMR) || url.toLowerCase().endsWith(MP3);
    }

    public static boolean isHasImage(String mimeType) {
        return mimeType != null && mimeType.startsWith(MIME_TYPE_PREFIX_IMAGE);
    }

    public static boolean isJPEG(String mimeType) {
        if (TextUtils.isEmpty((CharSequence)mimeType)) {
            return false;
        }
        return mimeType.startsWith("image/jpeg") || mimeType.startsWith(MIME_TYPE_JPG);
    }

    public static boolean isJPG(String mimeType) {
        if (TextUtils.isEmpty((CharSequence)mimeType)) {
            return false;
        }
        return mimeType.startsWith(MIME_TYPE_JPG);
    }

    public static boolean isHasHttp(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return false;
        }
        return path.startsWith("http") || path.startsWith("https");
    }

    public static boolean isMimeTypeSame(String oldMimeType, String newMimeType) {
        if (TextUtils.isEmpty((CharSequence)oldMimeType)) {
            return true;
        }
        return PictureMimeType.getMimeType(oldMimeType) == PictureMimeType.getMimeType(newMimeType);
    }

    public static int getMimeType(String mimeType) {
        if (TextUtils.isEmpty((CharSequence)mimeType)) {
            return 1;
        }
        if (mimeType.startsWith(MIME_TYPE_PREFIX_VIDEO)) {
            return 2;
        }
        if (mimeType.startsWith(MIME_TYPE_PREFIX_AUDIO)) {
            return 3;
        }
        return 1;
    }

    public static String getLastImgSuffix(String mineType) {
        try {
            return mineType.substring(mineType.lastIndexOf("/")).replace("/", ".");
        }
        catch (Exception e) {
            e.printStackTrace();
            return JPG;
        }
    }

    public static boolean isContent(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return false;
        }
        return url.startsWith("content://");
    }

    public static String ofPNG() {
        return "image/png";
    }

    public static String ofJPEG() {
        return "image/jpeg";
    }

    public static String ofBMP() {
        return MIME_TYPE_BMP;
    }

    public static String ofGIF() {
        return MIME_TYPE_GIF;
    }

    public static String ofWEBP() {
        return MIME_TYPE_WEBP;
    }

    public static String of3GP() {
        return MIME_TYPE_3GP;
    }

    public static String ofMP4() {
        return "video/mp4";
    }

    public static String ofMPEG() {
        return MIME_TYPE_MPEG;
    }

    public static String ofAVI() {
        return "video/avi";
    }
}

