/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.adapter.holder;

import android.net.Uri;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import androidx.annotation.NonNull;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.PlaybackException;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.ui.PlayerView;
import com.luck.picture.lib.R;
import com.luck.picture.lib.adapter.holder.BasePreviewHolder;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.entity.LocalMedia;
import java.io.File;

public class PreviewVideoHolder
extends BasePreviewHolder {
    public ImageView ivPlayButton;
    public PlayerView mPlayerView;
    public ProgressBar progress;
    private final Player.Listener mPlayerListener = new Player.Listener(){

        public void onPlayerError(@NonNull PlaybackException error) {
            PreviewVideoHolder.this.playerDefaultUI();
        }

        public void onPlaybackStateChanged(int playbackState) {
            if (playbackState == 3) {
                PreviewVideoHolder.this.playerIngUI();
            } else if (playbackState == 4) {
                PreviewVideoHolder.this.playerDefaultUI();
            }
        }
    };

    public PreviewVideoHolder(@NonNull View itemView) {
        super(itemView);
        this.ivPlayButton = (ImageView)itemView.findViewById(R.id.iv_play_video);
        this.mPlayerView = (PlayerView)itemView.findViewById(R.id.playerView);
        this.progress = (ProgressBar)itemView.findViewById(R.id.progress);
        this.mPlayerView.setUseController(false);
        PictureSelectionConfig config = PictureSelectionConfig.getInstance();
        this.ivPlayButton.setVisibility(config.isPreviewZoomEffect ? 8 : 0);
    }

    @Override
    public void bindData(final LocalMedia media, int position) {
        super.bindData(media, position);
        final String path = media.getAvailablePath();
        this.setScaleDisplaySize(media);
        this.ivPlayButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Player player = PreviewVideoHolder.this.mPlayerView.getPlayer();
                if (player != null) {
                    PreviewVideoHolder.this.progress.setVisibility(0);
                    PreviewVideoHolder.this.ivPlayButton.setVisibility(8);
                    PreviewVideoHolder.this.mPreviewEventListener.onPreviewVideoTitle(media.getFileName());
                    MediaItem mediaItem = PictureMimeType.isContent(path) ? MediaItem.fromUri((Uri)Uri.parse((String)path)) : MediaItem.fromUri((Uri)Uri.fromFile((File)new File(path)));
                    player.setMediaItem(mediaItem);
                    player.prepare();
                    player.play();
                }
            }
        });
        this.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (PreviewVideoHolder.this.mPreviewEventListener != null) {
                    PreviewVideoHolder.this.mPreviewEventListener.onBackPressed();
                }
            }
        });
    }

    @Override
    protected void setScaleDisplaySize(LocalMedia media) {
        if (!this.config.isPreviewZoomEffect && this.screenWidth < this.screenHeight) {
            float ratio = media.getWidth() > media.getHeight() ? (float)media.getHeight() / (float)media.getWidth() : (float)media.getWidth() / (float)media.getHeight();
            int displayHeight = (int)((float)this.screenWidth / ratio);
            FrameLayout.LayoutParams playerLayoutParams = (FrameLayout.LayoutParams)this.mPlayerView.getLayoutParams();
            playerLayoutParams.width = this.screenWidth;
            playerLayoutParams.height = displayHeight > this.screenHeight ? this.screenAppInHeight : this.screenHeight;
            playerLayoutParams.gravity = 17;
            FrameLayout.LayoutParams coverLayoutParams = (FrameLayout.LayoutParams)this.coverImageView.getLayoutParams();
            coverLayoutParams.width = this.screenWidth;
            coverLayoutParams.height = displayHeight > this.screenHeight ? this.screenAppInHeight : this.screenHeight;
            coverLayoutParams.gravity = 17;
        }
    }

    private void playerDefaultUI() {
        this.ivPlayButton.setVisibility(0);
        this.progress.setVisibility(8);
        this.coverImageView.setVisibility(0);
        this.mPlayerView.setVisibility(8);
        if (this.mPreviewEventListener != null) {
            this.mPreviewEventListener.onPreviewVideoTitle(null);
        }
    }

    private void playerIngUI() {
        if (this.progress.getVisibility() == 0) {
            this.progress.setVisibility(8);
        }
        if (this.ivPlayButton.getVisibility() == 0) {
            this.ivPlayButton.setVisibility(8);
        }
        if (this.coverImageView.getVisibility() == 0) {
            this.coverImageView.setVisibility(8);
        }
        if (this.mPlayerView.getVisibility() == 8) {
            this.mPlayerView.setVisibility(0);
        }
    }

    @Override
    public void onViewAttachedToWindow() {
        ExoPlayer player = new ExoPlayer.Builder(this.itemView.getContext()).build();
        this.mPlayerView.setPlayer((Player)player);
        player.addListener(this.mPlayerListener);
    }

    @Override
    public void onViewDetachedFromWindow() {
        Player player = this.mPlayerView.getPlayer();
        if (player != null) {
            player.removeListener(this.mPlayerListener);
            player.release();
            this.mPlayerView.setPlayer(null);
            this.playerDefaultUI();
        }
    }

    public void releaseVideo() {
        Player player = this.mPlayerView.getPlayer();
        if (player != null) {
            player.removeListener(this.mPlayerListener);
            player.release();
        }
    }
}

