/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.SystemClock;
import android.os.Vibrator;
import android.text.TextUtils;
import android.view.View;
import android.view.animation.AnimationUtils;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.SimpleItemAnimator;
import com.luck.picture.lib.PictureSelectorPreviewFragment;
import com.luck.picture.lib.R;
import com.luck.picture.lib.adapter.PictureImageGridAdapter;
import com.luck.picture.lib.animators.AlphaInAnimationAdapter;
import com.luck.picture.lib.animators.SlideInBottomAnimationAdapter;
import com.luck.picture.lib.basic.FragmentInjectManager;
import com.luck.picture.lib.basic.IPictureSelectorEvent;
import com.luck.picture.lib.basic.PictureCommonFragment;
import com.luck.picture.lib.config.InjectResourceSource;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.config.SelectMimeType;
import com.luck.picture.lib.decoration.GridSpacingItemDecoration;
import com.luck.picture.lib.dialog.AlbumListPopWindow;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.entity.LocalMediaFolder;
import com.luck.picture.lib.interfaces.OnAlbumItemClickListener;
import com.luck.picture.lib.interfaces.OnQueryAlbumListener;
import com.luck.picture.lib.interfaces.OnQueryAllAlbumListener;
import com.luck.picture.lib.interfaces.OnQueryDataResultListener;
import com.luck.picture.lib.interfaces.OnRecyclerViewPreloadMoreListener;
import com.luck.picture.lib.interfaces.OnRecyclerViewScrollListener;
import com.luck.picture.lib.interfaces.OnRecyclerViewScrollStateListener;
import com.luck.picture.lib.interfaces.OnRequestPermissionListener;
import com.luck.picture.lib.loader.LocalMediaLoader;
import com.luck.picture.lib.loader.LocalMediaPageLoader;
import com.luck.picture.lib.magical.BuildRecycleItemViewParams;
import com.luck.picture.lib.manager.SelectedManager;
import com.luck.picture.lib.permissions.PermissionChecker;
import com.luck.picture.lib.permissions.PermissionConfig;
import com.luck.picture.lib.permissions.PermissionResultCallback;
import com.luck.picture.lib.style.PictureSelectorStyle;
import com.luck.picture.lib.style.SelectMainStyle;
import com.luck.picture.lib.utils.ActivityCompatHelper;
import com.luck.picture.lib.utils.AnimUtils;
import com.luck.picture.lib.utils.DateUtils;
import com.luck.picture.lib.utils.DensityUtil;
import com.luck.picture.lib.utils.DoubleUtils;
import com.luck.picture.lib.utils.StyleUtils;
import com.luck.picture.lib.utils.ToastUtils;
import com.luck.picture.lib.utils.ValueOf;
import com.luck.picture.lib.widget.BottomNavBar;
import com.luck.picture.lib.widget.CompleteSelectView;
import com.luck.picture.lib.widget.RecyclerPreloadView;
import com.luck.picture.lib.widget.SlideSelectTouchListener;
import com.luck.picture.lib.widget.SlideSelectionHandler;
import com.luck.picture.lib.widget.TitleBar;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class PictureSelectorFragment
extends PictureCommonFragment
implements OnRecyclerViewPreloadMoreListener,
IPictureSelectorEvent {
    public static final String TAG = PictureSelectorFragment.class.getSimpleName();
    private static final int SELECT_ANIM_DURATION = 135;
    private RecyclerPreloadView mRecycler;
    private TextView tvDataEmpty;
    private TitleBar titleBar;
    private BottomNavBar bottomNarBar;
    private CompleteSelectView completeSelectView;
    private TextView tvCurrentDataTime;
    private long intervalClickTime = 0L;
    private int openCameraNumber;
    private int allFolderSize;
    private int currentPosition = -1;
    private boolean isDisplayCamera;
    private PictureImageGridAdapter mAdapter;
    private AlbumListPopWindow albumListPopWindow;
    private boolean isCameraMemoryRecycling;
    private SlideSelectTouchListener mDragSelectTouchListener;

    public static PictureSelectorFragment newInstance() {
        PictureSelectorFragment fragment = new PictureSelectorFragment();
        fragment.setArguments(new Bundle());
        return fragment;
    }

    @Override
    public String getFragmentTag() {
        return TAG;
    }

    @Override
    public int getResourceId() {
        int layoutResourceId = InjectResourceSource.getLayoutResource(this.getContext(), 1);
        if (layoutResourceId != 0) {
            return layoutResourceId;
        }
        return R.layout.ps_fragment_selector;
    }

    @Override
    @SuppressLint(value={"NotifyDataSetChanged"})
    public void onSelectedChange(boolean isAddRemove, LocalMedia currentMedia) {
        this.bottomNarBar.setSelectedChange();
        this.completeSelectView.setSelectedChange(false);
        if (this.checkNotifyStrategy(isAddRemove)) {
            this.mAdapter.notifyItemPositionChanged(currentMedia.position);
            this.mRecycler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    PictureSelectorFragment.this.mAdapter.notifyDataSetChanged();
                }
            }, 135L);
        } else {
            this.mAdapter.notifyItemPositionChanged(currentMedia.position);
        }
        if (!isAddRemove) {
            this.sendChangeSubSelectPositionEvent(true);
        }
    }

    @Override
    public void onFixedSelectedChange(LocalMedia oldLocalMedia) {
        this.mAdapter.notifyItemPositionChanged(oldLocalMedia.position);
    }

    @Override
    public void sendChangeSubSelectPositionEvent(boolean adapterChange) {
        if (PictureSelectionConfig.selectorStyle.getSelectMainStyle().isSelectNumberStyle()) {
            for (int index = 0; index < SelectedManager.getSelectCount(); ++index) {
                LocalMedia media = SelectedManager.getSelectedResult().get(index);
                media.setNum(index + 1);
                if (!adapterChange) continue;
                this.mAdapter.notifyItemPositionChanged(media.position);
            }
        }
    }

    @Override
    public void onCheckOriginalChange() {
        this.bottomNarBar.setOriginalCheck();
    }

    private boolean checkNotifyStrategy(boolean isAddRemove) {
        boolean isNotifyAll = false;
        if (this.config.isMaxSelectEnabledMask) {
            if (this.config.isWithVideoImage) {
                if (this.config.selectionMode != 1) {
                    isNotifyAll = SelectedManager.getSelectCount() == this.config.maxSelectNum || !isAddRemove && SelectedManager.getSelectCount() == this.config.maxSelectNum - 1;
                }
            } else if (SelectedManager.getSelectCount() == 0 || isAddRemove && SelectedManager.getSelectCount() == 1) {
                isNotifyAll = true;
            } else if (PictureMimeType.isHasVideo(SelectedManager.getTopResultMimeType())) {
                int maxSelectNum = this.config.maxVideoSelectNum > 0 ? this.config.maxVideoSelectNum : this.config.maxSelectNum;
                isNotifyAll = SelectedManager.getSelectCount() == maxSelectNum || !isAddRemove && SelectedManager.getSelectCount() == maxSelectNum - 1;
            } else {
                isNotifyAll = SelectedManager.getSelectCount() == this.config.maxSelectNum || !isAddRemove && SelectedManager.getSelectCount() == this.config.maxSelectNum - 1;
            }
        }
        return isNotifyAll;
    }

    @Override
    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt("com.luck.picture.lib.all_folder_size", this.allFolderSize);
        outState.putInt("com.luck.picture.lib.current_page", this.mPage);
        outState.putInt("com.luck.picture.lib.current_preview_position", this.mRecycler.getLastVisiblePosition());
        outState.putBoolean("com.luck.picture.lib.display_camera", this.mAdapter.isDisplayCamera());
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.reStartSavedInstance(savedInstanceState);
        this.isCameraMemoryRecycling = savedInstanceState != null;
        this.tvDataEmpty = (TextView)view.findViewById(R.id.tv_data_empty);
        this.completeSelectView = (CompleteSelectView)view.findViewById(R.id.ps_complete_select);
        this.titleBar = (TitleBar)view.findViewById(R.id.title_bar);
        this.bottomNarBar = (BottomNavBar)view.findViewById(R.id.bottom_nar_bar);
        this.tvCurrentDataTime = (TextView)view.findViewById(R.id.tv_current_data_time);
        this.initLoader();
        this.initAlbumListPopWindow();
        this.initTitleBar();
        this.initComplete();
        this.initRecycler(view);
        this.initBottomNavBar();
        this.requestLoadData();
    }

    @Override
    public void onFragmentResume() {
        this.setRootViewKeyListener(this.requireView());
    }

    @Override
    public void reStartSavedInstance(Bundle savedInstanceState) {
        super.reStartSavedInstance(savedInstanceState);
        if (savedInstanceState != null) {
            this.allFolderSize = savedInstanceState.getInt("com.luck.picture.lib.all_folder_size");
            this.mPage = savedInstanceState.getInt("com.luck.picture.lib.current_page", this.mPage);
            this.currentPosition = savedInstanceState.getInt("com.luck.picture.lib.current_preview_position", this.currentPosition);
            this.isDisplayCamera = savedInstanceState.getBoolean("com.luck.picture.lib.display_camera", this.config.isDisplayCamera);
        } else {
            this.isDisplayCamera = this.config.isDisplayCamera;
        }
    }

    private void initComplete() {
        if (this.config.selectionMode == 1 && this.config.isDirectReturnSingle) {
            PictureSelectionConfig.selectorStyle.getTitleBarStyle().setHideCancelButton(false);
            this.titleBar.getTitleCancelView().setVisibility(0);
            this.completeSelectView.setVisibility(8);
        } else {
            this.completeSelectView.setCompleteSelectViewStyle();
            this.completeSelectView.setSelectedChange(false);
            SelectMainStyle selectMainStyle = PictureSelectionConfig.selectorStyle.getSelectMainStyle();
            if (selectMainStyle.isCompleteSelectRelativeTop()) {
                if (this.completeSelectView.getLayoutParams() instanceof ConstraintLayout.LayoutParams) {
                    ((ConstraintLayout.LayoutParams)this.completeSelectView.getLayoutParams()).topToTop = R.id.title_bar;
                    ((ConstraintLayout.LayoutParams)this.completeSelectView.getLayoutParams()).bottomToBottom = R.id.title_bar;
                    if (this.config.isPreviewFullScreenMode) {
                        ((ConstraintLayout.LayoutParams)this.completeSelectView.getLayoutParams()).topMargin = DensityUtil.getStatusBarHeight(this.getContext());
                    }
                } else if (this.completeSelectView.getLayoutParams() instanceof RelativeLayout.LayoutParams && this.config.isPreviewFullScreenMode) {
                    ((RelativeLayout.LayoutParams)this.completeSelectView.getLayoutParams()).topMargin = DensityUtil.getStatusBarHeight(this.getContext());
                }
            }
            this.completeSelectView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    PictureSelectorFragment.this.dispatchTransformResult();
                }
            });
        }
    }

    protected void initLoader() {
        this.mLoader = this.config.isPageStrategy ? new LocalMediaPageLoader(this.getContext(), this.config) : new LocalMediaLoader(this.getContext(), this.config);
    }

    private void initTitleBar() {
        if (PictureSelectionConfig.selectorStyle.getTitleBarStyle().isHideTitleBar()) {
            this.titleBar.setVisibility(8);
        }
        this.titleBar.setTitleBarStyle();
        this.titleBar.setOnTitleBarListener(new TitleBar.OnTitleBarListener(){

            @Override
            public void onTitleDoubleClick() {
                if (((PictureSelectorFragment)PictureSelectorFragment.this).config.isAutomaticTitleRecyclerTop) {
                    int intervalTime = 500;
                    if (SystemClock.uptimeMillis() - PictureSelectorFragment.this.intervalClickTime < (long)intervalTime && PictureSelectorFragment.this.mAdapter.getItemCount() > 0) {
                        PictureSelectorFragment.this.mRecycler.scrollToPosition(0);
                    } else {
                        PictureSelectorFragment.this.intervalClickTime = SystemClock.uptimeMillis();
                    }
                }
            }

            @Override
            public void onBackPressed() {
                if (PictureSelectorFragment.this.albumListPopWindow.isShowing()) {
                    PictureSelectorFragment.this.albumListPopWindow.dismiss();
                } else {
                    PictureSelectorFragment.this.onKeyBackFragmentFinish();
                }
            }

            @Override
            public void onShowAlbumPopWindow(View anchor) {
                PictureSelectorFragment.this.albumListPopWindow.showAsDropDown(anchor);
            }
        });
    }

    private void initAlbumListPopWindow() {
        this.albumListPopWindow = AlbumListPopWindow.buildPopWindow(this.getContext());
        this.albumListPopWindow.setOnPopupWindowStatusListener(new AlbumListPopWindow.OnPopupWindowStatusListener(){

            @Override
            public void onShowPopupWindow() {
                if (!((PictureSelectorFragment)PictureSelectorFragment.this).config.isOnlySandboxDir) {
                    AnimUtils.rotateArrow(PictureSelectorFragment.this.titleBar.getImageArrow(), true);
                }
            }

            @Override
            public void onDismissPopupWindow() {
                if (!((PictureSelectorFragment)PictureSelectorFragment.this).config.isOnlySandboxDir) {
                    AnimUtils.rotateArrow(PictureSelectorFragment.this.titleBar.getImageArrow(), false);
                }
            }
        });
        this.addAlbumPopWindowAction();
    }

    private void requestLoadData() {
        this.mAdapter.setDisplayCamera(this.isDisplayCamera);
        if (PermissionChecker.isCheckReadStorage(this.getContext())) {
            this.beginLoadData();
        } else if (PictureSelectionConfig.onPermissionsEventListener != null) {
            PictureSelectionConfig.onPermissionsEventListener.requestPermission(this, PermissionConfig.READ_WRITE_EXTERNAL_STORAGE, new OnRequestPermissionListener(){

                @Override
                public void onCall(String[] permissionArray, boolean isResult) {
                    if (isResult) {
                        PictureSelectorFragment.this.beginLoadData();
                    } else {
                        PictureSelectorFragment.this.handlePermissionDenied(permissionArray);
                    }
                }
            });
        } else {
            PermissionChecker.getInstance().requestPermissions((Fragment)this, PermissionConfig.READ_WRITE_EXTERNAL_STORAGE, new PermissionResultCallback(){

                @Override
                public void onGranted() {
                    PictureSelectorFragment.this.beginLoadData();
                }

                @Override
                public void onDenied() {
                    PictureSelectorFragment.this.handlePermissionDenied(PermissionConfig.READ_WRITE_EXTERNAL_STORAGE);
                }
            });
        }
    }

    private void beginLoadData() {
        if (this.config.isOnlySandboxDir) {
            this.loadOnlyInAppDirectoryAllMediaData();
        } else {
            this.loadAllAlbumData();
        }
    }

    @Override
    public void handlePermissionSettingResult(String[] permissions) {
        boolean isHasPermissions = PictureSelectionConfig.onPermissionsEventListener != null ? PictureSelectionConfig.onPermissionsEventListener.hasPermissions(this, permissions) : PermissionChecker.isCheckReadStorage(this.getContext());
        if (isHasPermissions) {
            this.beginLoadData();
        } else {
            ToastUtils.showToast(this.getContext(), this.getString(R.string.ps_jurisdiction));
            this.onKeyBackFragmentFinish();
        }
    }

    private void addAlbumPopWindowAction() {
        this.albumListPopWindow.setOnIBridgeAlbumWidget(new OnAlbumItemClickListener(){

            @Override
            public void onItemClick(int position, LocalMediaFolder curFolder) {
                PictureSelectorFragment.this.isDisplayCamera = ((PictureSelectorFragment)PictureSelectorFragment.this).config.isDisplayCamera && curFolder.getBucketId() == -1L;
                PictureSelectorFragment.this.mAdapter.setDisplayCamera(PictureSelectorFragment.this.isDisplayCamera);
                PictureSelectorFragment.this.titleBar.setTitle(curFolder.getFolderName());
                LocalMediaFolder lastFolder = SelectedManager.getCurrentLocalMediaFolder();
                long lastBucketId = lastFolder.getBucketId();
                if (((PictureSelectorFragment)PictureSelectorFragment.this).config.isPageStrategy) {
                    if (curFolder.getBucketId() != lastBucketId) {
                        lastFolder.setData(PictureSelectorFragment.this.mAdapter.getData());
                        lastFolder.setCurrentDataPage(PictureSelectorFragment.this.mPage);
                        lastFolder.setHasMore(PictureSelectorFragment.this.mRecycler.isEnabledLoadMore());
                        if (curFolder.getData().size() > 0) {
                            PictureSelectorFragment.this.setAdapterData(curFolder.getData());
                            PictureSelectorFragment.this.mPage = curFolder.getCurrentDataPage();
                            PictureSelectorFragment.this.mRecycler.setEnabledLoadMore(curFolder.isHasMore());
                            PictureSelectorFragment.this.mRecycler.smoothScrollToPosition(0);
                        } else {
                            PictureSelectorFragment.this.mPage = 1;
                            if (PictureSelectionConfig.loaderDataEngine != null) {
                                PictureSelectionConfig.loaderDataEngine.loadFirstPageMediaData(PictureSelectorFragment.this.getContext(), curFolder.getBucketId(), PictureSelectorFragment.this.mPage, ((PictureSelectorFragment)PictureSelectorFragment.this).config.pageSize, new OnQueryDataResultListener<LocalMedia>(){

                                    @Override
                                    public void onComplete(ArrayList<LocalMedia> result, boolean isHasMore) {
                                        PictureSelectorFragment.this.handleSwitchAlbum(result, isHasMore);
                                    }
                                });
                            } else {
                                PictureSelectorFragment.this.mLoader.loadPageMediaData(curFolder.getBucketId(), PictureSelectorFragment.this.mPage, ((PictureSelectorFragment)PictureSelectorFragment.this).config.pageSize, new OnQueryDataResultListener<LocalMedia>(){

                                    @Override
                                    public void onComplete(ArrayList<LocalMedia> result, boolean isHasMore) {
                                        PictureSelectorFragment.this.handleSwitchAlbum(result, isHasMore);
                                    }
                                });
                            }
                        }
                    }
                } else if (curFolder.getBucketId() != lastBucketId) {
                    PictureSelectorFragment.this.setAdapterData(curFolder.getData());
                    PictureSelectorFragment.this.mRecycler.smoothScrollToPosition(0);
                }
                SelectedManager.setCurrentLocalMediaFolder(curFolder);
                PictureSelectorFragment.this.albumListPopWindow.dismiss();
                if (PictureSelectorFragment.this.mDragSelectTouchListener != null && ((PictureSelectorFragment)PictureSelectorFragment.this).config.isFastSlidingSelect) {
                    PictureSelectorFragment.this.mDragSelectTouchListener.setRecyclerViewHeaderCount(PictureSelectorFragment.this.mAdapter.isDisplayCamera() ? 1 : 0);
                }
            }
        });
    }

    private void handleSwitchAlbum(ArrayList<LocalMedia> result, boolean isHasMore) {
        if (ActivityCompatHelper.isDestroy((Activity)this.getActivity())) {
            return;
        }
        this.mRecycler.setEnabledLoadMore(isHasMore);
        if (result.size() == 0) {
            this.mAdapter.getData().clear();
        }
        this.setAdapterData(result);
        this.mRecycler.onScrolled(0, 0);
        this.mRecycler.smoothScrollToPosition(0);
    }

    private void initBottomNavBar() {
        this.bottomNarBar.setBottomNavBarStyle();
        this.bottomNarBar.setOnBottomNavBarListener(new BottomNavBar.OnBottomNavBarListener(){

            @Override
            public void onPreview() {
                PictureSelectorFragment.this.onStartPreview(0, true);
            }

            @Override
            public void onCheckOriginalChange() {
                PictureSelectorFragment.this.sendSelectedOriginalChangeEvent();
            }
        });
        this.bottomNarBar.setSelectedChange();
    }

    @Override
    public void loadAllAlbumData() {
        if (PictureSelectionConfig.loaderDataEngine != null) {
            PictureSelectionConfig.loaderDataEngine.loadAllAlbumData(this.getContext(), new OnQueryAllAlbumListener<LocalMediaFolder>(){

                @Override
                public void onComplete(List<LocalMediaFolder> result) {
                    PictureSelectorFragment.this.handleAllAlbumData(result);
                }
            });
        } else {
            this.mLoader.loadAllAlbum(new OnQueryAllAlbumListener<LocalMediaFolder>(){

                @Override
                public void onComplete(List<LocalMediaFolder> result) {
                    PictureSelectorFragment.this.handleAllAlbumData(result);
                }
            });
        }
    }

    private void handleAllAlbumData(List<LocalMediaFolder> result) {
        if (ActivityCompatHelper.isDestroy((Activity)this.getActivity())) {
            return;
        }
        if (result.size() > 0) {
            LocalMediaFolder firstFolder;
            if (SelectedManager.getCurrentLocalMediaFolder() != null) {
                firstFolder = SelectedManager.getCurrentLocalMediaFolder();
            } else {
                firstFolder = result.get(0);
                SelectedManager.setCurrentLocalMediaFolder(firstFolder);
            }
            this.titleBar.setTitle(firstFolder.getFolderName());
            this.albumListPopWindow.bindAlbumData(result);
            if (this.config.isPageStrategy) {
                this.loadFirstPageMediaData(firstFolder.getBucketId());
            } else {
                this.setAdapterData(firstFolder.getData());
            }
        } else {
            this.showDataNull();
        }
    }

    @Override
    public void loadFirstPageMediaData(long firstBucketId) {
        this.mRecycler.setEnabledLoadMore(true);
        if (PictureSelectionConfig.loaderDataEngine != null) {
            PictureSelectionConfig.loaderDataEngine.loadFirstPageMediaData(this.getContext(), firstBucketId, this.mPage, this.mPage * this.config.pageSize, new OnQueryDataResultListener<LocalMedia>(){

                @Override
                public void onComplete(ArrayList<LocalMedia> result, boolean isHasMore) {
                    PictureSelectorFragment.this.handleFirstPageMedia(result, isHasMore);
                }
            });
        } else {
            this.mLoader.loadFirstPageMedia(firstBucketId, this.mPage * this.config.pageSize, new OnQueryDataResultListener<LocalMedia>(){

                @Override
                public void onComplete(ArrayList<LocalMedia> result, boolean isHasMore) {
                    PictureSelectorFragment.this.handleFirstPageMedia(result, isHasMore);
                }
            });
        }
    }

    private void handleFirstPageMedia(ArrayList<LocalMedia> result, boolean isHasMore) {
        if (ActivityCompatHelper.isDestroy((Activity)this.getActivity())) {
            return;
        }
        this.mRecycler.setEnabledLoadMore(isHasMore);
        if (this.mRecycler.isEnabledLoadMore() && result.size() == 0) {
            this.onRecyclerViewPreloadMore();
        } else {
            this.setAdapterData(result);
        }
        this.recoveryRecyclerPosition();
    }

    @Override
    public void loadOnlyInAppDirectoryAllMediaData() {
        if (PictureSelectionConfig.loaderDataEngine != null) {
            PictureSelectionConfig.loaderDataEngine.loadOnlyInAppDirAllMediaData(this.getContext(), new OnQueryAlbumListener<LocalMediaFolder>(){

                @Override
                public void onComplete(LocalMediaFolder folder) {
                    PictureSelectorFragment.this.handleInAppDirAllMedia(folder);
                }
            });
        } else {
            this.mLoader.loadOnlyInAppDirAllMedia(new OnQueryAlbumListener<LocalMediaFolder>(){

                @Override
                public void onComplete(LocalMediaFolder folder) {
                    PictureSelectorFragment.this.handleInAppDirAllMedia(folder);
                }
            });
        }
    }

    private void handleInAppDirAllMedia(LocalMediaFolder folder) {
        if (!ActivityCompatHelper.isDestroy((Activity)this.getActivity())) {
            String sandboxDir = this.config.sandboxDir;
            boolean isNonNull = folder != null;
            String folderName = isNonNull ? folder.getFolderName() : new File(sandboxDir).getName();
            this.titleBar.setTitle(folderName);
            if (isNonNull) {
                SelectedManager.setCurrentLocalMediaFolder(folder);
                this.setAdapterData(folder.getData());
                this.recoveryRecyclerPosition();
            } else {
                this.showDataNull();
            }
        }
    }

    private void recoveryRecyclerPosition() {
        if (this.currentPosition > 0) {
            this.mRecycler.post(new Runnable(){

                @Override
                public void run() {
                    PictureSelectorFragment.this.mRecycler.scrollToPosition(PictureSelectorFragment.this.currentPosition);
                    PictureSelectorFragment.this.mRecycler.setLastVisiblePosition(PictureSelectorFragment.this.currentPosition);
                }
            });
        }
    }

    private void initRecycler(View view) {
        int imageSpanCount;
        this.mRecycler = (RecyclerPreloadView)view.findViewById(R.id.recycler);
        PictureSelectorStyle selectorStyle = PictureSelectionConfig.selectorStyle;
        SelectMainStyle selectMainStyle = selectorStyle.getSelectMainStyle();
        int listBackgroundColor = selectMainStyle.getMainListBackgroundColor();
        if (StyleUtils.checkStyleValidity(listBackgroundColor)) {
            this.mRecycler.setBackgroundColor(listBackgroundColor);
        } else {
            this.mRecycler.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.ps_color_black));
        }
        int n = imageSpanCount = this.config.imageSpanCount <= 0 ? 4 : this.config.imageSpanCount;
        if (this.mRecycler.getItemDecorationCount() == 0) {
            if (StyleUtils.checkSizeValidity(selectMainStyle.getAdapterItemSpacingSize())) {
                this.mRecycler.addItemDecoration(new GridSpacingItemDecoration(imageSpanCount, selectMainStyle.getAdapterItemSpacingSize(), selectMainStyle.isAdapterItemIncludeEdge()));
            } else {
                this.mRecycler.addItemDecoration(new GridSpacingItemDecoration(imageSpanCount, DensityUtil.dip2px(view.getContext(), 1.0f), selectMainStyle.isAdapterItemIncludeEdge()));
            }
        }
        this.mRecycler.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager(this.getContext(), imageSpanCount));
        RecyclerView.ItemAnimator itemAnimator = this.mRecycler.getItemAnimator();
        if (itemAnimator != null) {
            ((SimpleItemAnimator)itemAnimator).setSupportsChangeAnimations(false);
            this.mRecycler.setItemAnimator(null);
        }
        if (this.config.isPageStrategy) {
            this.mRecycler.setReachBottomRow(2);
            this.mRecycler.setOnRecyclerViewPreloadListener(this);
        } else {
            this.mRecycler.setHasFixedSize(true);
        }
        this.mAdapter = new PictureImageGridAdapter(this.getContext(), this.config);
        this.mAdapter.setDisplayCamera(this.isDisplayCamera);
        switch (this.config.animationMode) {
            case 1: {
                this.mRecycler.setAdapter(new AlphaInAnimationAdapter(this.mAdapter));
                break;
            }
            case 2: {
                this.mRecycler.setAdapter(new SlideInBottomAnimationAdapter(this.mAdapter));
                break;
            }
            default: {
                this.mRecycler.setAdapter(this.mAdapter);
            }
        }
        this.addRecyclerAction();
    }

    private void addRecyclerAction() {
        this.mAdapter.setOnItemClickListener(new PictureImageGridAdapter.OnItemClickListener(){

            @Override
            public void openCameraClick() {
                if (DoubleUtils.isFastDoubleClick()) {
                    return;
                }
                PictureSelectorFragment.this.openSelectedCamera();
            }

            @Override
            public int onSelected(View selectedView, int position, LocalMedia media) {
                int selectResultCode = PictureSelectorFragment.this.confirmSelect(media, selectedView.isSelected());
                if (selectResultCode == 0) {
                    selectedView.startAnimation(AnimationUtils.loadAnimation((Context)PictureSelectorFragment.this.getContext(), (int)R.anim.ps_anim_modal_in));
                }
                return selectResultCode;
            }

            @Override
            public void onItemClick(View selectedView, int position, LocalMedia media) {
                if (((PictureSelectorFragment)PictureSelectorFragment.this).config.selectionMode == 1 && ((PictureSelectorFragment)PictureSelectorFragment.this).config.isDirectReturnSingle) {
                    SelectedManager.clearSelectResult();
                    int selectResultCode = PictureSelectorFragment.this.confirmSelect(media, false);
                    if (selectResultCode == 0) {
                        PictureSelectorFragment.this.dispatchTransformResult();
                    }
                } else {
                    if (DoubleUtils.isFastDoubleClick()) {
                        return;
                    }
                    if (PictureMimeType.isHasAudio(media.getMimeType()) && PictureSelectionConfig.onPreviewInterceptListener != null) {
                        PictureSelectionConfig.onPreviewInterceptListener.onPreviewAudio(PictureSelectorFragment.this.getContext(), media);
                    } else {
                        PictureSelectorFragment.this.onStartPreview(position, false);
                    }
                }
            }

            @Override
            public void onItemLongClick(View itemView, int position) {
                if (PictureSelectorFragment.this.mDragSelectTouchListener != null && ((PictureSelectorFragment)PictureSelectorFragment.this).config.isFastSlidingSelect) {
                    Vibrator vibrator = (Vibrator)PictureSelectorFragment.this.getActivity().getSystemService("vibrator");
                    vibrator.vibrate(50L);
                    PictureSelectorFragment.this.mDragSelectTouchListener.startSlideSelection(position);
                }
            }
        });
        this.mRecycler.setOnRecyclerViewScrollStateListener(new OnRecyclerViewScrollStateListener(){

            @Override
            public void onScrollFast() {
                if (PictureSelectionConfig.imageEngine != null) {
                    PictureSelectionConfig.imageEngine.pauseRequests(PictureSelectorFragment.this.getContext());
                }
            }

            @Override
            public void onScrollSlow() {
                if (PictureSelectionConfig.imageEngine != null) {
                    PictureSelectionConfig.imageEngine.resumeRequests(PictureSelectorFragment.this.getContext());
                }
            }
        });
        this.mRecycler.setOnRecyclerViewScrollListener(new OnRecyclerViewScrollListener(){

            @Override
            public void onScrolled(int dx, int dy) {
                PictureSelectorFragment.this.setCurrentMediaCreateTimeText();
            }

            @Override
            public void onScrollStateChanged(int state) {
                if (state == 1) {
                    PictureSelectorFragment.this.showCurrentMediaCreateTimeUI();
                } else if (state == 0) {
                    PictureSelectorFragment.this.hideCurrentMediaCreateTimeUI();
                }
            }
        });
        if (this.config.isFastSlidingSelect) {
            final HashSet selectedPosition = new HashSet();
            SlideSelectionHandler slideSelectionHandler = new SlideSelectionHandler(new SlideSelectionHandler.ISelectionHandler(){

                public HashSet<Integer> getSelection() {
                    for (int i = 0; i < SelectedManager.getSelectCount(); ++i) {
                        LocalMedia media = SelectedManager.getSelectedResult().get(i);
                        selectedPosition.add(media.position);
                    }
                    return selectedPosition;
                }

                @Override
                public void changeSelection(int start, int end, boolean isSelected, boolean calledFromOnStart) {
                    ArrayList<LocalMedia> adapterData = PictureSelectorFragment.this.mAdapter.getData();
                    if (adapterData.size() == 0 || start > adapterData.size()) {
                        return;
                    }
                    LocalMedia media = adapterData.get(start);
                    int selectResultCode = PictureSelectorFragment.this.confirmSelect(media, SelectedManager.getSelectedResult().contains(media));
                    PictureSelectorFragment.this.mDragSelectTouchListener.setActive(selectResultCode != -1);
                }
            });
            this.mDragSelectTouchListener = new SlideSelectTouchListener().setRecyclerViewHeaderCount(this.mAdapter.isDisplayCamera() ? 1 : 0).withSelectListener(slideSelectionHandler);
            this.mRecycler.addOnItemTouchListener(this.mDragSelectTouchListener);
        }
    }

    private void setCurrentMediaCreateTimeText() {
        ArrayList<LocalMedia> data;
        int position;
        if (this.config.isDisplayTimeAxis && (position = this.mRecycler.getFirstVisiblePosition()) != -1 && (data = this.mAdapter.getData()).size() > position && data.get(position).getDateAddedTime() > 0L) {
            this.tvCurrentDataTime.setText((CharSequence)DateUtils.getDataFormat(this.getContext(), data.get(position).getDateAddedTime()));
        }
    }

    private void showCurrentMediaCreateTimeUI() {
        if (this.config.isDisplayTimeAxis && this.mAdapter.getData().size() > 0 && this.tvCurrentDataTime.getAlpha() == 0.0f) {
            this.tvCurrentDataTime.animate().setDuration(150L).alphaBy(1.0f).start();
        }
    }

    private void hideCurrentMediaCreateTimeUI() {
        if (this.config.isDisplayTimeAxis && this.mAdapter.getData().size() > 0) {
            this.tvCurrentDataTime.animate().setDuration(250L).alpha(0.0f).start();
        }
    }

    private void onStartPreview(int position, boolean isBottomPreview) {
        if (ActivityCompatHelper.checkFragmentNonExits(this.getActivity(), PictureSelectorPreviewFragment.TAG)) {
            int totalNum;
            ArrayList<LocalMedia> data;
            long currentBucketId = 0L;
            if (isBottomPreview) {
                data = new ArrayList<LocalMedia>(SelectedManager.getSelectedResult());
                totalNum = data.size();
            } else {
                data = this.mAdapter.getData();
                totalNum = SelectedManager.getCurrentLocalMediaFolder().getFolderTotalNum();
                currentBucketId = SelectedManager.getCurrentLocalMediaFolder().getBucketId();
            }
            if (!isBottomPreview && this.config.isPreviewZoomEffect) {
                BuildRecycleItemViewParams.generateViewParams(this.mRecycler, this.config.isPreviewFullScreenMode ? 0 : DensityUtil.getStatusBarHeight(this.getContext()));
            }
            if (PictureSelectionConfig.onPreviewInterceptListener != null) {
                PictureSelectionConfig.onPreviewInterceptListener.onPreview(this.getContext(), position, totalNum, this.mPage, currentBucketId, this.titleBar.getTitleText(), this.mAdapter.isDisplayCamera(), data, isBottomPreview);
            } else if (ActivityCompatHelper.checkFragmentNonExits(this.getActivity(), PictureSelectorPreviewFragment.TAG)) {
                PictureSelectorPreviewFragment previewFragment = PictureSelectorPreviewFragment.newInstance();
                previewFragment.setInternalPreviewData(isBottomPreview, this.titleBar.getTitleText(), this.mAdapter.isDisplayCamera(), position, totalNum, this.mPage, currentBucketId, data);
                FragmentInjectManager.injectFragment(this.getActivity(), PictureSelectorPreviewFragment.TAG, previewFragment);
            }
        }
    }

    @SuppressLint(value={"NotifyDataSetChanged"})
    private void setAdapterData(final ArrayList<LocalMedia> result) {
        this.requireView().postDelayed(new Runnable(){

            @Override
            public void run() {
                PictureSelectorFragment.this.setEnterAnimationDuration(0L);
                PictureSelectorFragment.this.sendChangeSubSelectPositionEvent(false);
                PictureSelectorFragment.this.mAdapter.setDataAndDataSetChanged(result);
                if (PictureSelectorFragment.this.mAdapter.isDataEmpty()) {
                    PictureSelectorFragment.this.showDataNull();
                } else {
                    PictureSelectorFragment.this.hideDataNull();
                }
            }
        }, this.getEnterAnimationDuration());
    }

    @Override
    public void onRecyclerViewPreloadMore() {
        this.loadMoreMediaData();
    }

    @Override
    public void loadMoreMediaData() {
        if (this.mRecycler.isEnabledLoadMore()) {
            long bucketId;
            ++this.mPage;
            LocalMediaFolder localMediaFolder = SelectedManager.getCurrentLocalMediaFolder();
            long l = bucketId = localMediaFolder != null ? localMediaFolder.getBucketId() : 0L;
            if (PictureSelectionConfig.loaderDataEngine != null) {
                PictureSelectionConfig.loaderDataEngine.loadMoreMediaData(this.getContext(), bucketId, this.mPage, this.getPageLimit(bucketId), this.config.pageSize, new OnQueryDataResultListener<LocalMedia>(){

                    @Override
                    public void onComplete(ArrayList<LocalMedia> result, boolean isHasMore) {
                        PictureSelectorFragment.this.handleMoreMediaData(result, isHasMore);
                    }
                });
            } else {
                this.mLoader.loadPageMediaData(bucketId, this.mPage, this.getPageLimit(bucketId), this.config.pageSize, new OnQueryDataResultListener<LocalMedia>(){

                    @Override
                    public void onComplete(ArrayList<LocalMedia> result, boolean isHasMore) {
                        PictureSelectorFragment.this.handleMoreMediaData(result, isHasMore);
                    }
                });
            }
        }
    }

    private void handleMoreMediaData(List<LocalMedia> result, boolean isHasMore) {
        if (ActivityCompatHelper.isDestroy((Activity)this.getActivity())) {
            return;
        }
        this.mRecycler.setEnabledLoadMore(isHasMore);
        if (this.mRecycler.isEnabledLoadMore()) {
            if (result.size() > 0) {
                int positionStart = this.mAdapter.getData().size();
                this.mAdapter.getData().addAll(result);
                this.mAdapter.notifyItemRangeChanged(positionStart, this.mAdapter.getItemCount());
            } else {
                this.onRecyclerViewPreloadMore();
            }
            if (result.size() < 10) {
                this.mRecycler.onScrolled(this.mRecycler.getScrollX(), this.mRecycler.getScrollY());
            }
        }
    }

    @Override
    public void dispatchCameraMediaResult(LocalMedia media) {
        if (this.isCameraMemoryRecycling) {
            this.isCameraMemoryRecycling = false;
            SelectedManager.addSelectResult(media);
            this.mAdapter.notifyItemPositionChanged(this.config.isDisplayCamera ? 1 : 0);
            if (this.config.isDirectReturnSingle) {
                this.dispatchTransformResult();
            }
            return;
        }
        int exitsTotalNum = this.albumListPopWindow.getFirstAlbumImageCount();
        if (!this.isAddSameImp(exitsTotalNum)) {
            this.mAdapter.getData().add(0, media);
            ++this.openCameraNumber;
        }
        if (this.config.selectionMode == 1 && this.config.isDirectReturnSingle) {
            SelectedManager.clearSelectResult();
            int selectResultCode = this.confirmSelect(media, false);
            if (selectResultCode == 0) {
                this.dispatchTransformResult();
            }
        } else {
            this.confirmSelect(media, false);
        }
        this.mAdapter.notifyItemInserted(this.config.isDisplayCamera ? 1 : 0);
        this.mAdapter.notifyItemRangeChanged(this.config.isDisplayCamera ? 1 : 0, this.mAdapter.getData().size());
        if (this.config.isOnlySandboxDir) {
            LocalMediaFolder currentLocalMediaFolder = SelectedManager.getCurrentLocalMediaFolder();
            if (currentLocalMediaFolder == null) {
                currentLocalMediaFolder = new LocalMediaFolder();
                long bucketId = ValueOf.toLong(media.getParentFolderName().hashCode());
                currentLocalMediaFolder.setBucketId(bucketId);
                currentLocalMediaFolder.setFolderName(media.getParentFolderName());
                currentLocalMediaFolder.setFirstMimeType(media.getMimeType());
                currentLocalMediaFolder.setFirstImagePath(media.getPath());
                currentLocalMediaFolder.setFolderTotalNum(this.mAdapter.getData().size());
                currentLocalMediaFolder.setCurrentDataPage(this.mPage);
                currentLocalMediaFolder.setHasMore(false);
                this.mRecycler.setEnabledLoadMore(false);
                SelectedManager.setCurrentLocalMediaFolder(currentLocalMediaFolder);
            }
        } else {
            this.mergeFolder(media);
        }
        this.allFolderSize = 0;
        if (this.mAdapter.getData().size() > 0 || this.config.isDirectReturnSingle) {
            this.hideDataNull();
        } else {
            this.showDataNull();
        }
    }

    private void mergeFolder(LocalMedia media) {
        LocalMediaFolder allFolder;
        if (this.albumListPopWindow.getFolderCount() == 0) {
            allFolder = new LocalMediaFolder();
            String folderName = this.config.chooseMode == SelectMimeType.ofAudio() ? this.getString(R.string.ps_all_audio) : this.getString(R.string.ps_camera_roll);
            allFolder.setFolderName(folderName);
            allFolder.setFirstImagePath("");
            allFolder.setBucketId(-1L);
            this.albumListPopWindow.getAlbumList().add(0, allFolder);
        } else {
            allFolder = this.albumListPopWindow.getFolder(0);
        }
        allFolder.setFirstImagePath(media.getPath());
        allFolder.setFirstMimeType(media.getMimeType());
        allFolder.setData(this.mAdapter.getData());
        allFolder.setBucketId(-1L);
        allFolder.setFolderTotalNum(this.isAddSameImp(allFolder.getFolderTotalNum()) ? allFolder.getFolderTotalNum() : allFolder.getFolderTotalNum() + 1);
        if (SelectedManager.getCurrentLocalMediaFolder() == null) {
            SelectedManager.setCurrentLocalMediaFolder(allFolder);
        }
        LocalMediaFolder cameraFolder = null;
        List<LocalMediaFolder> albumList = this.albumListPopWindow.getAlbumList();
        for (int i = 0; i < albumList.size(); ++i) {
            LocalMediaFolder exitsFolder = albumList.get(i);
            if (!TextUtils.equals((CharSequence)exitsFolder.getFolderName(), (CharSequence)media.getParentFolderName())) continue;
            cameraFolder = exitsFolder;
            break;
        }
        if (cameraFolder == null) {
            cameraFolder = new LocalMediaFolder();
            cameraFolder.setFolderName(media.getParentFolderName());
            cameraFolder.setBucketId(media.getBucketId());
            if (!TextUtils.isEmpty((CharSequence)this.config.outPutCameraDir) || !TextUtils.isEmpty((CharSequence)this.config.outPutAudioDir)) {
                cameraFolder.getData().add(0, media);
            }
            albumList.add(cameraFolder);
        } else {
            if (!this.config.isPageStrategy && !this.isAddSameImp(allFolder.getFolderTotalNum()) || !TextUtils.isEmpty((CharSequence)this.config.outPutCameraDir) || !TextUtils.isEmpty((CharSequence)this.config.outPutAudioDir)) {
                cameraFolder.getData().add(0, media);
            }
            if (cameraFolder.getBucketId() == -1L || cameraFolder.getBucketId() == 0L) {
                cameraFolder.setBucketId(media.getBucketId());
            }
        }
        cameraFolder.setFolderTotalNum(this.isAddSameImp(allFolder.getFolderTotalNum()) ? cameraFolder.getFolderTotalNum() : cameraFolder.getFolderTotalNum() + 1);
        cameraFolder.setFirstImagePath(this.config.cameraPath);
        cameraFolder.setFirstMimeType(media.getMimeType());
        this.albumListPopWindow.bindAlbumData(albumList);
    }

    private boolean isAddSameImp(int totalNum) {
        if (totalNum == 0) {
            return false;
        }
        return this.allFolderSize > 0 && this.allFolderSize < totalNum;
    }

    private int getPageLimit(long bucketId) {
        if (bucketId == -1L) {
            int limit = this.openCameraNumber > 0 ? this.config.pageSize - this.openCameraNumber : this.config.pageSize;
            this.openCameraNumber = 0;
            return limit;
        }
        return this.config.pageSize;
    }

    public void onDestroyView() {
        super.onDestroyView();
        if (this.mDragSelectTouchListener != null) {
            this.mDragSelectTouchListener.stopAutoScroll();
        }
    }

    private void showDataNull() {
        if (this.tvDataEmpty.getVisibility() == 8) {
            this.tvDataEmpty.setVisibility(0);
        }
        this.tvDataEmpty.setCompoundDrawablesRelativeWithIntrinsicBounds(0, R.drawable.ps_ic_no_data, 0, 0);
        int chooseMode = this.config.chooseMode;
        String tips = chooseMode == SelectMimeType.ofAudio() ? this.getString(R.string.ps_audio_empty) : this.getString(R.string.ps_empty);
        this.tvDataEmpty.setText((CharSequence)tips);
    }

    private void hideDataNull() {
        if (this.tvDataEmpty.getVisibility() == 0) {
            this.tvDataEmpty.setVisibility(8);
        }
    }
}

