/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.luck.picture.lib.R;
import com.luck.picture.lib.basic.PictureCommonFragment;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.permissions.PermissionChecker;
import com.luck.picture.lib.permissions.PermissionConfig;
import com.luck.picture.lib.permissions.PermissionResultCallback;
import com.luck.picture.lib.utils.SdkVersionUtils;
import com.luck.picture.lib.utils.ToastUtils;

public class PictureOnlyCameraFragment
extends PictureCommonFragment {
    public static final String TAG = PictureOnlyCameraFragment.class.getSimpleName();

    public static PictureOnlyCameraFragment newInstance() {
        return new PictureOnlyCameraFragment();
    }

    @Override
    public String getFragmentTag() {
        return TAG;
    }

    @Override
    public int getResourceId() {
        return R.layout.ps_empty;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (SdkVersionUtils.isQ()) {
            this.openSelectedCamera();
        } else {
            PermissionChecker.getInstance().requestPermissions((Fragment)this, PermissionConfig.WRITE_EXTERNAL_STORAGE, new PermissionResultCallback(){

                @Override
                public void onGranted() {
                    PictureOnlyCameraFragment.this.openSelectedCamera();
                }

                @Override
                public void onDenied() {
                    PictureOnlyCameraFragment.this.handlePermissionDenied(PermissionConfig.WRITE_EXTERNAL_STORAGE);
                }
            });
        }
    }

    @Override
    public void dispatchCameraMediaResult(LocalMedia media) {
        int selectResultCode = this.confirmSelect(media, false);
        if (selectResultCode == 0) {
            this.dispatchTransformResult();
        } else {
            this.onKeyBackFragmentFinish();
        }
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == 0) {
            this.onKeyBackFragmentFinish();
        }
    }

    @Override
    public void handlePermissionSettingResult(String[] permissions) {
        boolean isHasPermissions;
        if (PictureSelectionConfig.onPermissionsEventListener != null) {
            isHasPermissions = PictureSelectionConfig.onPermissionsEventListener.hasPermissions(this, permissions);
        } else {
            isHasPermissions = PermissionChecker.isCheckCamera(this.getContext());
            if (!SdkVersionUtils.isQ()) {
                isHasPermissions = PermissionChecker.isCheckWriteStorage(this.getContext());
            }
        }
        if (isHasPermissions) {
            this.openSelectedCamera();
        } else {
            if (!PermissionChecker.isCheckCamera(this.getContext())) {
                ToastUtils.showToast(this.getContext(), this.getString(R.string.ps_camera));
            } else if (!PermissionChecker.isCheckWriteStorage(this.getContext())) {
                ToastUtils.showToast(this.getContext(), this.getString(R.string.ps_jurisdiction));
            }
            this.onKeyBackFragmentFinish();
        }
    }
}

