/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.adapter.holder;

import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.ForegroundColorSpan;
import android.view.View;
import android.widget.ImageView;
import android.widget.SeekBar;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.luck.picture.lib.R;
import com.luck.picture.lib.adapter.holder.BasePreviewHolder;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.utils.DateUtils;
import com.luck.picture.lib.utils.DensityUtil;
import com.luck.picture.lib.utils.DoubleUtils;
import com.luck.picture.lib.utils.PictureFileUtils;
import java.io.IOException;

public class PreviewAudioHolder
extends BasePreviewHolder {
    private static final long MAX_BACK_FAST_MS = 3000L;
    private static final long MAX_UPDATE_INTERVAL_MS = 1000L;
    private static final long MIN_CURRENT_POSITION = 1000L;
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    public ImageView ivPlayButton;
    public TextView tvAudioName;
    public TextView tvTotalDuration;
    public TextView tvCurrentTime;
    public SeekBar seekBar;
    public ImageView ivPlayBack;
    public ImageView ivPlayFast;
    private MediaPlayer mPlayer = new MediaPlayer();
    private boolean isPausePlayer = false;
    public Runnable mTickerRunnable = new Runnable(){

        @Override
        public void run() {
            long currentPosition = PreviewAudioHolder.this.mPlayer.getCurrentPosition();
            String time = DateUtils.formatDurationTime(currentPosition);
            if (!TextUtils.equals((CharSequence)time, (CharSequence)PreviewAudioHolder.this.tvCurrentTime.getText())) {
                PreviewAudioHolder.this.tvCurrentTime.setText((CharSequence)time);
                if ((long)PreviewAudioHolder.this.mPlayer.getDuration() - currentPosition > 1000L) {
                    PreviewAudioHolder.this.seekBar.setProgress((int)currentPosition);
                } else {
                    PreviewAudioHolder.this.seekBar.setProgress(PreviewAudioHolder.this.mPlayer.getDuration());
                }
            }
            long nextSecondMs = 1000L - currentPosition % 1000L;
            PreviewAudioHolder.this.mHandler.postDelayed((Runnable)this, nextSecondMs);
        }
    };
    private final MediaPlayer.OnCompletionListener mPlayCompletionListener = new MediaPlayer.OnCompletionListener(){

        public void onCompletion(MediaPlayer mp) {
            PreviewAudioHolder.this.stopUpdateProgress();
            PreviewAudioHolder.this.resetMediaPlayer();
            PreviewAudioHolder.this.playerDefaultUI(true);
        }
    };
    private final MediaPlayer.OnErrorListener mPlayErrorListener = new MediaPlayer.OnErrorListener(){

        public boolean onError(MediaPlayer mp, int what, int extra) {
            PreviewAudioHolder.this.resetMediaPlayer();
            PreviewAudioHolder.this.playerDefaultUI(true);
            return false;
        }
    };
    private final MediaPlayer.OnPreparedListener mPlayPreparedListener = new MediaPlayer.OnPreparedListener(){

        public void onPrepared(MediaPlayer mp) {
            if (mp.isPlaying()) {
                PreviewAudioHolder.this.seekBar.setMax(mp.getDuration());
                PreviewAudioHolder.this.startUpdateProgress();
                PreviewAudioHolder.this.playerIngUI();
            } else {
                PreviewAudioHolder.this.stopUpdateProgress();
                PreviewAudioHolder.this.resetMediaPlayer();
                PreviewAudioHolder.this.playerDefaultUI(true);
            }
        }
    };

    public PreviewAudioHolder(@NonNull View itemView) {
        super(itemView);
        this.ivPlayButton = (ImageView)itemView.findViewById(R.id.iv_play_video);
        this.tvAudioName = (TextView)itemView.findViewById(R.id.tv_audio_name);
        this.tvCurrentTime = (TextView)itemView.findViewById(R.id.tv_current_time);
        this.tvTotalDuration = (TextView)itemView.findViewById(R.id.tv_total_duration);
        this.seekBar = (SeekBar)itemView.findViewById(R.id.music_seek_bar);
        this.ivPlayBack = (ImageView)itemView.findViewById(R.id.iv_play_back);
        this.ivPlayFast = (ImageView)itemView.findViewById(R.id.iv_play_fast);
    }

    @Override
    public void bindData(final LocalMedia media, int position) {
        final String path = media.getAvailablePath();
        String dataFormat = DateUtils.getYearDataFormat(media.getDateAddedTime());
        String fileSize = PictureFileUtils.formatFileSize(media.getSize(), 2);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(media.getFileName()).append("\n").append(dataFormat).append(" - ").append(fileSize);
        SpannableStringBuilder builder = new SpannableStringBuilder((CharSequence)stringBuilder.toString());
        String indexOfStr = dataFormat + " - " + fileSize;
        int startIndex = stringBuilder.indexOf(indexOfStr);
        int endOf = startIndex + indexOfStr.length();
        builder.setSpan((Object)new AbsoluteSizeSpan(DensityUtil.dip2px(this.itemView.getContext(), 12.0f)), startIndex, endOf, 17);
        builder.setSpan((Object)new ForegroundColorSpan(-10132123), startIndex, endOf, 17);
        this.tvAudioName.setText((CharSequence)builder);
        this.tvTotalDuration.setText((CharSequence)DateUtils.formatDurationTime(media.getDuration()));
        this.seekBar.setMax((int)media.getDuration());
        this.setBackFastUI(false);
        this.ivPlayBack.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PreviewAudioHolder.this.slowAudioPlay();
            }
        });
        this.ivPlayFast.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PreviewAudioHolder.this.fastAudioPlay();
            }
        });
        this.seekBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                if (fromUser) {
                    seekBar.setProgress(progress);
                    PreviewAudioHolder.this.setCurrentPlayTime(progress);
                    if (PreviewAudioHolder.this.mPlayer.isPlaying()) {
                        PreviewAudioHolder.this.mPlayer.seekTo(seekBar.getProgress());
                    }
                }
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
            }
        });
        this.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (PreviewAudioHolder.this.mPreviewEventListener != null) {
                    PreviewAudioHolder.this.mPreviewEventListener.onBackPressed();
                }
            }
        });
        this.ivPlayButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                try {
                    if (DoubleUtils.isFastDoubleClick()) {
                        return;
                    }
                    PreviewAudioHolder.this.mPreviewEventListener.onPreviewVideoTitle(media.getFileName());
                    if (PreviewAudioHolder.this.mPlayer.isPlaying()) {
                        PreviewAudioHolder.this.pausePlayer();
                    } else if (PreviewAudioHolder.this.isPausePlayer) {
                        PreviewAudioHolder.this.resumePlayer();
                    } else {
                        PreviewAudioHolder.this.startPlayer(path);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.coverImageView.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View view) {
                if (PreviewAudioHolder.this.mPreviewEventListener != null) {
                    PreviewAudioHolder.this.mPreviewEventListener.onLongPressDownload(media);
                }
                return false;
            }
        });
    }

    private void startPlayer(String path) {
        try {
            if (PictureMimeType.isContent(path)) {
                this.mPlayer.setDataSource(this.itemView.getContext(), Uri.parse((String)path));
            } else {
                this.mPlayer.setDataSource(path);
            }
            this.mPlayer.prepare();
            this.mPlayer.seekTo(this.seekBar.getProgress());
            this.mPlayer.start();
            this.isPausePlayer = false;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void pausePlayer() {
        this.mPlayer.pause();
        this.isPausePlayer = true;
        this.playerDefaultUI(false);
        this.stopUpdateProgress();
    }

    private void resumePlayer() {
        this.mPlayer.seekTo(this.seekBar.getProgress());
        this.mPlayer.start();
        this.startUpdateProgress();
        this.playerIngUI();
    }

    private void resetMediaPlayer() {
        this.isPausePlayer = false;
        this.mPlayer.stop();
        this.mPlayer.reset();
    }

    private void setCurrentPlayTime(int progress) {
        String time = DateUtils.formatDurationTime(progress);
        this.tvCurrentTime.setText((CharSequence)time);
    }

    private void fastAudioPlay() {
        if ((long)this.seekBar.getProgress() > 3000L) {
            this.seekBar.setProgress(this.seekBar.getMax());
        } else {
            this.seekBar.setProgress((int)((long)this.seekBar.getProgress() + 3000L));
        }
        this.setCurrentPlayTime(this.seekBar.getProgress());
        this.mPlayer.seekTo(this.seekBar.getProgress());
    }

    private void slowAudioPlay() {
        if ((long)this.seekBar.getProgress() < 3000L) {
            this.seekBar.setProgress(0);
        } else {
            this.seekBar.setProgress((int)((long)this.seekBar.getProgress() - 3000L));
        }
        this.setCurrentPlayTime(this.seekBar.getProgress());
        this.mPlayer.seekTo(this.seekBar.getProgress());
    }

    private void startUpdateProgress() {
        this.mHandler.post(this.mTickerRunnable);
    }

    private void stopUpdateProgress() {
        this.mHandler.removeCallbacks(this.mTickerRunnable);
    }

    private void playerDefaultUI(boolean isResetProgress) {
        this.stopUpdateProgress();
        if (isResetProgress) {
            this.seekBar.setProgress(0);
            this.tvCurrentTime.setText((CharSequence)"00:00");
        }
        this.setBackFastUI(false);
        this.ivPlayButton.setImageResource(R.drawable.ps_ic_audio_play);
        if (this.mPreviewEventListener != null) {
            this.mPreviewEventListener.onPreviewVideoTitle(null);
        }
    }

    private void playerIngUI() {
        this.startUpdateProgress();
        this.setBackFastUI(true);
        this.ivPlayButton.setImageResource(R.drawable.ps_ic_audio_stop);
    }

    private void setBackFastUI(boolean isEnabled) {
        this.ivPlayBack.setEnabled(isEnabled);
        this.ivPlayFast.setEnabled(isEnabled);
        if (isEnabled) {
            this.ivPlayBack.setAlpha(1.0f);
            this.ivPlayFast.setAlpha(1.0f);
        } else {
            this.ivPlayBack.setAlpha(0.5f);
            this.ivPlayFast.setAlpha(0.5f);
        }
    }

    @Override
    public void onViewAttachedToWindow() {
        this.isPausePlayer = false;
        this.setMediaPlayerListener();
        this.playerDefaultUI(true);
    }

    @Override
    public void onViewDetachedFromWindow() {
        this.isPausePlayer = false;
        this.mHandler.removeCallbacks(this.mTickerRunnable);
        this.setNullMediaPlayerListener();
        this.resetMediaPlayer();
        this.playerDefaultUI(true);
    }

    public void releaseAudio() {
        this.mHandler.removeCallbacks(this.mTickerRunnable);
        if (this.mPlayer != null) {
            this.setNullMediaPlayerListener();
            this.mPlayer.release();
            this.mPlayer = null;
        }
    }

    private void setMediaPlayerListener() {
        this.mPlayer.setOnCompletionListener(this.mPlayCompletionListener);
        this.mPlayer.setOnErrorListener(this.mPlayErrorListener);
        this.mPlayer.setOnPreparedListener(this.mPlayPreparedListener);
    }

    private void setNullMediaPlayerListener() {
        this.mPlayer.setOnCompletionListener(null);
        this.mPlayer.setOnErrorListener(null);
        this.mPlayer.setOnPreparedListener(null);
    }
}

