/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.adapter.holder;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.luck.picture.lib.R;
import com.luck.picture.lib.adapter.holder.PreviewAudioHolder;
import com.luck.picture.lib.adapter.holder.PreviewImageHolder;
import com.luck.picture.lib.adapter.holder.PreviewVideoHolder;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.interfaces.OnCallbackListener;
import com.luck.picture.lib.photoview.OnViewTapListener;
import com.luck.picture.lib.photoview.PhotoView;
import com.luck.picture.lib.utils.BitmapUtils;
import com.luck.picture.lib.utils.DensityUtil;
import com.luck.picture.lib.utils.MediaUtils;

public class BasePreviewHolder
extends RecyclerView.ViewHolder {
    public static final int ADAPTER_TYPE_IMAGE = 1;
    public static final int ADAPTER_TYPE_VIDEO = 2;
    public static final int ADAPTER_TYPE_AUDIO = 3;
    protected final int screenWidth;
    protected final int screenHeight;
    protected final int screenAppInHeight;
    protected final PictureSelectionConfig config = PictureSelectionConfig.getInstance();
    public PhotoView coverImageView;
    protected OnPreviewEventListener mPreviewEventListener;

    public static BasePreviewHolder generate(ViewGroup parent, int viewType, int resource) {
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(resource, parent, false);
        if (viewType == 2) {
            return new PreviewVideoHolder(itemView);
        }
        if (viewType == 3) {
            return new PreviewAudioHolder(itemView);
        }
        return new PreviewImageHolder(itemView);
    }

    public BasePreviewHolder(@NonNull View itemView) {
        super(itemView);
        this.screenWidth = DensityUtil.getRealScreenWidth(itemView.getContext());
        this.screenHeight = DensityUtil.getScreenHeight(itemView.getContext());
        this.screenAppInHeight = DensityUtil.getRealScreenHeight(itemView.getContext());
        this.coverImageView = (PhotoView)itemView.findViewById(R.id.preview_image);
    }

    public void bindData(final LocalMedia media, int position) {
        final String path = media.getAvailablePath();
        int[] maxImageSize = BitmapUtils.getMaxImageSize(media.getWidth(), media.getHeight(), this.screenWidth, this.screenHeight);
        PictureSelectionConfig.imageEngine.loadImageBitmap(this.itemView.getContext(), path, maxImageSize[0], maxImageSize[1], new OnCallbackListener<Bitmap>(){

            @Override
            public void onCall(Bitmap bitmap) {
                if (bitmap != null) {
                    if (PictureMimeType.isHasWebp(media.getMimeType()) || PictureMimeType.isUrlHasWebp(path) || PictureMimeType.isUrlHasGif(path) || PictureMimeType.isHasGif(media.getMimeType())) {
                        PictureSelectionConfig.imageEngine.loadImage(BasePreviewHolder.this.itemView.getContext(), path, (ImageView)BasePreviewHolder.this.coverImageView);
                    } else {
                        BasePreviewHolder.this.coverImageView.setImageBitmap(bitmap);
                    }
                    if (MediaUtils.isLongImage(bitmap.getWidth(), bitmap.getHeight())) {
                        BasePreviewHolder.this.coverImageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
                    } else {
                        BasePreviewHolder.this.coverImageView.setScaleType(ImageView.ScaleType.FIT_CENTER);
                    }
                    BasePreviewHolder.this.mPreviewEventListener.onLoadCompleteBeginScale(BasePreviewHolder.this, bitmap.getWidth(), bitmap.getHeight());
                } else {
                    BasePreviewHolder.this.mPreviewEventListener.onLoadCompleteError(BasePreviewHolder.this);
                }
            }
        });
        this.setScaleDisplaySize(media);
        this.coverImageView.setOnViewTapListener(new OnViewTapListener(){

            @Override
            public void onViewTap(View view, float x, float y) {
                if (BasePreviewHolder.this.mPreviewEventListener != null) {
                    BasePreviewHolder.this.mPreviewEventListener.onBackPressed();
                }
            }
        });
        this.coverImageView.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View view) {
                if (BasePreviewHolder.this.mPreviewEventListener != null) {
                    BasePreviewHolder.this.mPreviewEventListener.onLongPressDownload(media);
                }
                return false;
            }
        });
    }

    protected void setScaleDisplaySize(LocalMedia media) {
        if (!this.config.isPreviewZoomEffect && this.screenWidth < this.screenHeight) {
            float ratio = (float)media.getWidth() / (float)media.getHeight();
            int displayHeight = (int)((float)this.screenWidth / ratio);
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.coverImageView.getLayoutParams();
            layoutParams.width = this.screenWidth;
            layoutParams.height = displayHeight > this.screenHeight ? this.screenAppInHeight : this.screenHeight;
            layoutParams.gravity = 17;
        }
    }

    public void onViewAttachedToWindow() {
    }

    public void onViewDetachedFromWindow() {
    }

    public void setOnPreviewEventListener(OnPreviewEventListener listener) {
        this.mPreviewEventListener = listener;
    }

    public static interface OnPreviewEventListener {
        public void onLoadCompleteBeginScale(BasePreviewHolder var1, int var2, int var3);

        public void onLoadCompleteError(BasePreviewHolder var1);

        public void onBackPressed();

        public void onPreviewVideoTitle(String var1);

        public void onLongPressDownload(LocalMedia var1);
    }
}

