/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.magical;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.content.Context;
import android.transition.ChangeBounds;
import android.transition.ChangeImageTransform;
import android.transition.ChangeTransform;
import android.transition.Transition;
import android.transition.TransitionManager;
import android.transition.TransitionSet;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.RequiresApi;
import androidx.core.content.ContextCompat;
import androidx.viewpager2.widget.ViewPager2;
import com.luck.picture.lib.R;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.magical.MagicalViewWrapper;
import com.luck.picture.lib.magical.OnMagicalViewCallback;
import com.luck.picture.lib.utils.DensityUtil;

public class MagicalView
extends FrameLayout {
    private float mAlpha = 0.0f;
    private final long animationDuration = 250L;
    private int mOriginLeft;
    private int mOriginTop;
    private int mOriginHeight;
    private int mOriginWidth;
    private int screenWidth;
    private int screenHeight;
    private final int appInScreenHeight;
    private int targetImageTop;
    private int targetImageWidth;
    private int targetImageHeight;
    private int targetEndLeft;
    private int realWidth;
    private int realHeight;
    private boolean isAnimating = false;
    private final FrameLayout contentLayout;
    private final View backgroundView;
    private final MagicalViewWrapper magicalWrapper;
    private final boolean isPreviewFullScreenMode;
    private int startX;
    private int startY;
    private OnMagicalViewCallback onMagicalViewCallback;

    public MagicalView(Context context) {
        this(context, null);
    }

    public MagicalView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MagicalView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        PictureSelectionConfig config = PictureSelectionConfig.getInstance();
        this.isPreviewFullScreenMode = config.isPreviewFullScreenMode;
        this.appInScreenHeight = DensityUtil.getRealScreenHeight(this.getContext());
        this.getScreenSize();
        this.backgroundView = new View(context);
        this.backgroundView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.backgroundView.setBackgroundColor(ContextCompat.getColor((Context)context, (int)R.color.ps_color_black));
        this.backgroundView.setAlpha(this.mAlpha);
        this.addView(this.backgroundView);
        this.contentLayout = new FrameLayout(context);
        this.contentLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.addView((View)this.contentLayout);
        this.magicalWrapper = new MagicalViewWrapper((View)this.contentLayout);
    }

    public void startNormal(int realWidth, int realHeight, boolean showImmediately) {
        this.realWidth = realWidth;
        this.realHeight = realHeight;
        this.mOriginLeft = 0;
        this.mOriginTop = 0;
        this.mOriginWidth = 0;
        this.mOriginHeight = 0;
        this.setVisibility(0);
        this.setOriginParams();
        this.showNormalMin(this.targetImageTop, this.targetEndLeft, this.targetImageWidth, this.targetImageHeight);
        if (showImmediately) {
            this.mAlpha = 1.0f;
            this.backgroundView.setAlpha(this.mAlpha);
        } else {
            this.mAlpha = 0.0f;
            this.backgroundView.setAlpha(this.mAlpha);
            this.contentLayout.setAlpha(0.0f);
            this.contentLayout.animate().alpha(1.0f).setDuration(250L).start();
            this.backgroundView.animate().alpha(1.0f).setDuration(250L).start();
        }
        this.setShowEndParams();
    }

    public void start(boolean showImmediately) {
        this.mAlpha = showImmediately ? (this.mAlpha = 1.0f) : 0.0f;
        this.backgroundView.setAlpha(this.mAlpha);
        this.setVisibility(0);
        this.setOriginParams();
        this.beginShow(showImmediately);
    }

    public void resetStart() {
        this.getScreenSize();
        this.start(true);
    }

    private void getScreenSize() {
        this.screenWidth = DensityUtil.getRealScreenWidth(this.getContext());
        this.screenHeight = this.isPreviewFullScreenMode ? DensityUtil.getRealScreenHeight(this.getContext()) : DensityUtil.getScreenHeight(this.getContext());
    }

    public void changeRealScreenHeight(int imageWidth, int imageHeight, boolean showImmediately) {
        if (this.isPreviewFullScreenMode || this.screenWidth > this.screenHeight) {
            return;
        }
        float ratio = (float)imageWidth / (float)imageHeight;
        int displayHeight = (int)((float)this.screenWidth / ratio);
        if (displayHeight > this.screenHeight) {
            this.screenHeight = this.appInScreenHeight;
            if (showImmediately) {
                this.magicalWrapper.setWidth(this.screenWidth);
                this.magicalWrapper.setHeight(this.screenHeight);
            }
        }
    }

    public void resetStartNormal(int realWidth, int realHeight, boolean showImmediately) {
        this.getScreenSize();
        this.startNormal(realWidth, realHeight, showImmediately);
    }

    public void setViewParams(int left, int top, int originWidth, int originHeight, int realWidth, int realHeight) {
        this.realWidth = realWidth;
        this.realHeight = realHeight;
        this.mOriginLeft = left;
        this.mOriginTop = top;
        this.mOriginWidth = originWidth;
        this.mOriginHeight = originHeight;
    }

    private void setOriginParams() {
        int[] locationImage = new int[2];
        this.contentLayout.getLocationOnScreen(locationImage);
        this.targetEndLeft = 0;
        if ((float)this.screenWidth / (float)this.screenHeight < (float)this.realWidth / (float)this.realHeight) {
            this.targetImageWidth = this.screenWidth;
            this.targetImageHeight = (int)((float)this.targetImageWidth * ((float)this.realHeight / (float)this.realWidth));
            this.targetImageTop = (this.screenHeight - this.targetImageHeight) / 2;
        } else {
            this.targetImageHeight = this.screenHeight;
            this.targetImageWidth = (int)((float)this.targetImageHeight * ((float)this.realWidth / (float)this.realHeight));
            this.targetImageTop = 0;
            this.targetEndLeft = (this.screenWidth - this.targetImageWidth) / 2;
        }
        this.magicalWrapper.setWidth(this.mOriginWidth);
        this.magicalWrapper.setHeight(this.mOriginHeight);
        this.magicalWrapper.setMarginLeft(this.mOriginLeft);
        this.magicalWrapper.setMarginTop(this.mOriginTop);
    }

    private void beginShow(boolean showImmediately) {
        if (showImmediately) {
            this.mAlpha = 1.0f;
            this.backgroundView.setAlpha(this.mAlpha);
            this.showNormalMin(this.targetImageTop, this.targetEndLeft, this.targetImageWidth, this.targetImageHeight);
            this.setShowEndParams();
        } else {
            ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
            valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    float value = ((Float)animation.getAnimatedValue()).floatValue();
                    MagicalView.this.showNormalMin(value, MagicalView.this.mOriginTop, MagicalView.this.targetImageTop, MagicalView.this.mOriginLeft, MagicalView.this.targetEndLeft, MagicalView.this.mOriginWidth, MagicalView.this.targetImageWidth, MagicalView.this.mOriginHeight, MagicalView.this.targetImageHeight);
                }
            });
            valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    MagicalView.this.setShowEndParams();
                }
            });
            valueAnimator.setDuration(250L).start();
            this.changeBackgroundViewAlpha(false);
        }
    }

    private void setShowEndParams() {
        this.isAnimating = false;
        this.changeContentViewToFullscreen();
        if (this.onMagicalViewCallback != null) {
            this.onMagicalViewCallback.onBeginMagicalAnimComplete(this, false);
        }
    }

    private void showNormalMin(float animRatio, float startY, float endY, float startLeft, float endLeft, float startWidth, float endWidth, float startHeight, float endHeight) {
        this.showNormalMin(false, animRatio, startY, endY, startLeft, endLeft, startWidth, endWidth, startHeight, endHeight);
    }

    private void showNormalMin(float endY, float endLeft, float endWidth, float endHeight) {
        this.showNormalMin(true, 0.0f, 0.0f, endY, 0.0f, endLeft, 0.0f, endWidth, 0.0f, endHeight);
    }

    private void showNormalMin(boolean showImmediately, float animRatio, float startY, float endY, float startLeft, float endLeft, float startWidth, float endWidth, float startHeight, float endHeight) {
        if (showImmediately) {
            this.magicalWrapper.setWidth(endWidth);
            this.magicalWrapper.setHeight(endHeight);
            this.magicalWrapper.setMarginLeft((int)endLeft);
            this.magicalWrapper.setMarginTop((int)endY);
        } else {
            float xOffset = animRatio * (endLeft - startLeft);
            float widthOffset = animRatio * (endWidth - startWidth);
            float heightOffset = animRatio * (endHeight - startHeight);
            float topOffset = animRatio * (endY - startY);
            this.magicalWrapper.setWidth(startWidth + widthOffset);
            this.magicalWrapper.setHeight(startHeight + heightOffset);
            this.magicalWrapper.setMarginLeft((int)(startLeft + xOffset));
            this.magicalWrapper.setMarginTop((int)(startY + topOffset));
        }
    }

    public void backToMin() {
        if (this.isAnimating) {
            return;
        }
        if (this.mOriginWidth == 0 || this.mOriginHeight == 0) {
            this.backToMinWithoutView();
            return;
        }
        if (this.onMagicalViewCallback != null) {
            this.onMagicalViewCallback.onBeginBackMinAnim();
        }
        this.beginBackToMin(false);
        this.backToMinWithTransition();
    }

    @RequiresApi(api=21)
    private void backToMinWithTransition() {
        this.contentLayout.post(new Runnable(){

            @Override
            public void run() {
                TransitionManager.beginDelayedTransition((ViewGroup)((ViewGroup)MagicalView.this.contentLayout.getParent()), (Transition)new TransitionSet().setDuration(250L).addTransition((Transition)new ChangeBounds()).addTransition((Transition)new ChangeTransform()).addTransition((Transition)new ChangeImageTransform()));
                MagicalView.this.beginBackToMin(true);
                MagicalView.this.contentLayout.setTranslationX(0.0f);
                MagicalView.this.contentLayout.setTranslationY(0.0f);
                MagicalView.this.magicalWrapper.setWidth(MagicalView.this.mOriginWidth);
                MagicalView.this.magicalWrapper.setHeight(MagicalView.this.mOriginHeight);
                MagicalView.this.magicalWrapper.setMarginTop(MagicalView.this.mOriginTop);
                MagicalView.this.magicalWrapper.setMarginLeft(MagicalView.this.mOriginLeft);
                MagicalView.this.changeBackgroundViewAlpha(true);
            }
        });
    }

    private void beginBackToMin(boolean isResetSize) {
        if (isResetSize) {
            this.onMagicalViewCallback.onBeginBackMinMagicalFinish(true);
        }
    }

    private void backToMinWithoutView() {
        this.contentLayout.animate().alpha(0.0f).setDuration(250L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                if (MagicalView.this.onMagicalViewCallback != null) {
                    MagicalView.this.onMagicalViewCallback.onMagicalViewFinish();
                }
            }
        }).start();
        this.backgroundView.animate().alpha(0.0f).setDuration(250L).start();
    }

    private void changeBackgroundViewAlpha(final boolean isAlpha) {
        float end = isAlpha ? 0.0f : 1.0f;
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{this.mAlpha, end});
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                MagicalView.this.isAnimating = true;
                MagicalView.this.mAlpha = ((Float)animation.getAnimatedValue()).floatValue();
                MagicalView.this.backgroundView.setAlpha(MagicalView.this.mAlpha);
                if (MagicalView.this.onMagicalViewCallback != null) {
                    MagicalView.this.onMagicalViewCallback.onBackgroundAlpha(MagicalView.this.mAlpha);
                }
            }
        });
        valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                MagicalView.this.isAnimating = false;
                if (isAlpha && MagicalView.this.onMagicalViewCallback != null) {
                    MagicalView.this.onMagicalViewCallback.onMagicalViewFinish();
                }
            }
        });
        valueAnimator.setDuration(250L);
        valueAnimator.start();
    }

    public void setMagicalContent(View view) {
        this.contentLayout.addView(view);
    }

    private void changeContentViewToFullscreen() {
        this.targetImageHeight = this.screenHeight;
        this.targetImageWidth = this.screenWidth;
        this.targetImageTop = 0;
        this.magicalWrapper.setHeight(this.screenHeight);
        this.magicalWrapper.setWidth(this.screenWidth);
        this.magicalWrapper.setMarginTop(0);
        this.magicalWrapper.setMarginLeft(0);
    }

    public void setBackgroundAlpha(float mAlpha) {
        this.mAlpha = mAlpha;
        this.backgroundView.setAlpha(mAlpha);
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        View childView = this.contentLayout.getChildAt(0);
        ViewPager2 viewPager2 = null;
        if (childView instanceof ViewPager2) {
            viewPager2 = (ViewPager2)childView;
        }
        switch (event.getAction()) {
            case 0: {
                this.startX = (int)event.getX();
                this.startY = (int)event.getY();
                if (viewPager2 == null) break;
                viewPager2.setUserInputEnabled(true);
                break;
            }
            case 2: {
                int endX = (int)event.getX();
                int endY = (int)event.getY();
                int disX = Math.abs(endX - this.startX);
                int disY = Math.abs(endY - this.startY);
                if (disX > disY) {
                    if (viewPager2 == null) break;
                    viewPager2.setUserInputEnabled(true);
                    break;
                }
                if (viewPager2 == null) break;
                viewPager2.setUserInputEnabled(this.canScrollVertically(this.startY - endY));
                break;
            }
            case 1: 
            case 3: {
                if (viewPager2 == null) break;
                viewPager2.setUserInputEnabled(true);
            }
        }
        return super.dispatchTouchEvent(event);
    }

    public void setOnMojitoViewCallback(OnMagicalViewCallback onMagicalViewCallback) {
        this.onMagicalViewCallback = onMagicalViewCallback;
    }
}

