/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.utils;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.graphics.BitmapFactory;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import androidx.exifinterface.media.ExifInterface;
import com.luck.picture.lib.app.PictureAppMaster;
import com.luck.picture.lib.basic.PictureContentResolver;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.entity.MediaExtraInfo;
import com.luck.picture.lib.utils.DateUtils;
import com.luck.picture.lib.utils.PictureFileUtils;
import com.luck.picture.lib.utils.SdkVersionUtils;
import com.luck.picture.lib.utils.ValueOf;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

public class MediaUtils {
    public static final String QUERY_ARG_SQL_LIMIT = "android:query-arg-sql-limit";

    public static String getRealPathUri(long id2, String mimeType) {
        Uri contentUri = PictureMimeType.isHasImage(mimeType) ? MediaStore.Images.Media.EXTERNAL_CONTENT_URI : (PictureMimeType.isHasVideo(mimeType) ? MediaStore.Video.Media.EXTERNAL_CONTENT_URI : (PictureMimeType.isHasAudio(mimeType) ? MediaStore.Audio.Media.EXTERNAL_CONTENT_URI : MediaStore.Files.getContentUri((String)"external")));
        return ContentUris.withAppendedId((Uri)contentUri, (long)id2).toString();
    }

    public static String getMimeTypeFromMediaUrl(String url) {
        String fileExtension = MimeTypeMap.getFileExtensionFromUrl((String)url);
        String mimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(fileExtension.toLowerCase());
        return TextUtils.isEmpty((CharSequence)mimeType) ? "image/jpeg" : mimeType;
    }

    public static boolean isLongImage(int width, int height) {
        if (width <= 0 || height <= 0) {
            return false;
        }
        return height > width * 3;
    }

    public static long generateCameraBucketId(Context context, File cameraFile, String outPutCameraDir) {
        long bucketId = TextUtils.isEmpty((CharSequence)outPutCameraDir) ? MediaUtils.getCameraFirstBucketId(context) : (cameraFile.getParentFile() != null ? (long)cameraFile.getParentFile().getName().hashCode() : MediaUtils.getCameraFirstBucketId(context));
        return bucketId;
    }

    public static long generateSoundsBucketId(Context context, File cameraFile, String outPutAudioDir) {
        long bucketId = TextUtils.isEmpty((CharSequence)outPutAudioDir) ? MediaUtils.getSoundsFirstBucketId(context) : (cameraFile.getParentFile() != null ? (long)cameraFile.getParentFile().getName().hashCode() : MediaUtils.getSoundsFirstBucketId(context));
        return bucketId;
    }

    public static String generateCameraFolderName(String absolutePath) {
        File cameraFile = new File(absolutePath);
        String folderName = cameraFile.getParentFile() != null ? cameraFile.getParentFile().getName() : "Camera";
        return folderName;
    }

    public static MediaExtraInfo getImageSize(Context context, String url) {
        MediaExtraInfo mediaExtraInfo = new MediaExtraInfo();
        try {
            ExifInterface exifInterface;
            if (PictureMimeType.isContent(url)) {
                InputStream inputStream = PictureContentResolver.getContentResolverOpenInputStream(context, Uri.parse((String)url));
                exifInterface = new ExifInterface(inputStream);
            } else {
                exifInterface = new ExifInterface(url);
            }
            mediaExtraInfo.setWidth(exifInterface.getAttributeInt("ImageWidth", 1));
            mediaExtraInfo.setHeight(exifInterface.getAttributeInt("ImageLength", 1));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mediaExtraInfo;
    }

    public static MediaExtraInfo getImageSize(String url) {
        MediaExtraInfo mediaExtraInfo = new MediaExtraInfo();
        try {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            InputStream inputStream = PictureMimeType.isContent(url) ? PictureContentResolver.getContentResolverOpenInputStream(PictureAppMaster.getInstance().getAppContext(), Uri.parse((String)url)) : new FileInputStream(url);
            BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
            mediaExtraInfo.setWidth(options.outWidth);
            mediaExtraInfo.setHeight(options.outHeight);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mediaExtraInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MediaExtraInfo getVideoSize(Context context, String url) {
        MediaExtraInfo mediaExtraInfo = new MediaExtraInfo();
        MediaMetadataRetriever retriever = new MediaMetadataRetriever();
        try {
            int width;
            int height;
            if (PictureMimeType.isContent(url)) {
                retriever.setDataSource(context, Uri.parse((String)url));
            } else {
                retriever.setDataSource(url);
            }
            String orientation = retriever.extractMetadata(24);
            if (TextUtils.equals((CharSequence)"90", (CharSequence)orientation) || TextUtils.equals((CharSequence)"270", (CharSequence)orientation)) {
                height = ValueOf.toInt(retriever.extractMetadata(18));
                width = ValueOf.toInt(retriever.extractMetadata(19));
            } else {
                width = ValueOf.toInt(retriever.extractMetadata(18));
                height = ValueOf.toInt(retriever.extractMetadata(19));
            }
            mediaExtraInfo.setWidth(width);
            mediaExtraInfo.setHeight(height);
            mediaExtraInfo.setDuration(ValueOf.toLong(retriever.extractMetadata(9)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            retriever.release();
        }
        return mediaExtraInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MediaExtraInfo getAudioSize(Context context, String url) {
        MediaExtraInfo mediaExtraInfo = new MediaExtraInfo();
        MediaMetadataRetriever retriever = new MediaMetadataRetriever();
        try {
            if (PictureMimeType.isContent(url)) {
                retriever.setDataSource(context, Uri.parse((String)url));
            } else {
                retriever.setDataSource(url);
            }
            mediaExtraInfo.setDuration(ValueOf.toLong(retriever.extractMetadata(9)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            retriever.release();
        }
        return mediaExtraInfo;
    }

    public static void removeMedia(Context context, int id2) {
        try {
            ContentResolver cr = context.getApplicationContext().getContentResolver();
            Uri uri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
            String selection = "_id=?";
            cr.delete(uri, selection, new String[]{Long.toString(id2)});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDCIMLastImageId(Context context) {
        try (Cursor data = null;){
            String absolutePath = PictureFileUtils.getDCIMCameraPath();
            String selection = "_data like ?";
            String[] selectionArgs = new String[]{absolutePath + "%"};
            if (SdkVersionUtils.isR()) {
                Bundle queryArgs = MediaUtils.createQueryArgsBundle(selection, selectionArgs, 1, 0);
                data = context.getApplicationContext().getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, null, queryArgs, null);
            } else {
                String orderBy = "_id DESC limit 1 offset 0";
                data = context.getApplicationContext().getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, null, selection, selectionArgs, orderBy);
            }
            if (data != null && data.getCount() > 0 && data.moveToFirst()) {
                int id2 = data.getInt(data.getColumnIndex("_id"));
                long date = data.getLong(data.getColumnIndex("date_added"));
                int duration = DateUtils.dateDiffer(date);
                int n = duration <= 1 ? id2 : -1;
                return n;
            }
            int n = -1;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getCameraFirstBucketId(Context context) {
        try (Cursor data = null;){
            String absolutePath = PictureFileUtils.getDCIMCameraPath();
            String selection = "_data like ?";
            String[] selectionArgs = new String[]{absolutePath + "%"};
            if (SdkVersionUtils.isR()) {
                Bundle queryArgs = MediaUtils.createQueryArgsBundle(selection, selectionArgs, 1, 0);
                data = context.getApplicationContext().getContentResolver().query(MediaStore.Files.getContentUri((String)"external"), null, queryArgs, null);
            } else {
                String orderBy = "_id DESC limit 1 offset 0";
                data = context.getApplicationContext().getContentResolver().query(MediaStore.Files.getContentUri((String)"external"), null, selection, selectionArgs, orderBy);
            }
            if (data != null && data.getCount() > 0 && data.moveToFirst()) {
                long l = data.getLong(data.getColumnIndex("bucket_id"));
                return l;
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getSoundsFirstBucketId(Context context) {
        try (Cursor data = null;){
            String absolutePath = PictureFileUtils.getSoundsPath();
            String selection = "_data like ?";
            String[] selectionArgs = new String[]{absolutePath + "%"};
            if (SdkVersionUtils.isR()) {
                Bundle queryArgs = MediaUtils.createQueryArgsBundle(selection, selectionArgs, 1, 0);
                data = context.getApplicationContext().getContentResolver().query(MediaStore.Files.getContentUri((String)"external"), null, queryArgs, null);
            } else {
                String orderBy = "_id DESC limit 1 offset 0";
                data = context.getApplicationContext().getContentResolver().query(MediaStore.Files.getContentUri((String)"external"), null, selection, selectionArgs, orderBy);
            }
            if (data != null && data.getCount() > 0 && data.moveToFirst()) {
                long l = data.getLong(data.getColumnIndex("bucket_id"));
                return l;
            }
        }
        return -1L;
    }

    public static Bundle createQueryArgsBundle(String selection, String[] selectionArgs, int limitCount, int offset) {
        Bundle queryArgs = new Bundle();
        if (Build.VERSION.SDK_INT >= 26) {
            queryArgs.putString("android:query-arg-sql-selection", selection);
            queryArgs.putStringArray("android:query-arg-sql-selection-args", selectionArgs);
            queryArgs.putString("android:query-arg-sql-sort-order", "_id DESC");
            if (SdkVersionUtils.isR()) {
                queryArgs.putString(QUERY_ARG_SQL_LIMIT, limitCount + " offset " + offset);
            }
        }
        return queryArgs;
    }

    public static void deleteUri(Context context, String path) {
        try {
            if (PictureMimeType.isContent(path)) {
                context.getContentResolver().delete(Uri.parse((String)path), null, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

