/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.utils;

import android.content.ContentValues;
import android.content.Context;
import android.net.Uri;
import android.provider.MediaStore;
import com.luck.picture.lib.basic.PictureContentResolver;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.interfaces.OnCallbackListener;
import com.luck.picture.lib.thread.PictureThreadUtils;
import com.luck.picture.lib.utils.MediaStoreUtils;
import com.luck.picture.lib.utils.PictureFileUtils;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

public class DownloadFileUtils {
    public static void saveLocalFile(final Context context, final String path, final String fileName, final String mimeType, final OnCallbackListener<String> listener) {
        PictureThreadUtils.executeByIo(new PictureThreadUtils.SimpleTask<String>(){

            @Override
            public String doInBackground() throws Throwable {
                OutputStream outputStream;
                InputStream inputStream;
                boolean bufferCopy;
                Uri uri;
                if (PictureMimeType.isHasVideo(mimeType)) {
                    ContentValues contentValues = MediaStoreUtils.buildVideoContentValues(fileName, mimeType);
                    uri = context.getContentResolver().insert(MediaStore.Video.Media.EXTERNAL_CONTENT_URI, contentValues);
                } else {
                    ContentValues contentValues = MediaStoreUtils.buildImageContentValues(fileName, mimeType);
                    uri = context.getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, contentValues);
                }
                if (uri != null && (bufferCopy = PictureFileUtils.writeFileFromIS(inputStream = PictureMimeType.isHasHttp(path) ? new URL(path).openStream() : (PictureMimeType.isContent(path) ? PictureContentResolver.getContentResolverOpenInputStream(context, Uri.parse((String)path)) : new FileInputStream(path)), outputStream = PictureContentResolver.getContentResolverOpenOutputStream(context, uri)))) {
                    return PictureFileUtils.getPath(context, uri);
                }
                return null;
            }

            @Override
            public void onSuccess(String result) {
                PictureThreadUtils.cancel((PictureThreadUtils.Task)this);
                if (listener != null) {
                    listener.onCall(result);
                }
            }
        });
    }
}

