/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.service;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.os.IBinder;
import androidx.core.app.NotificationCompat;
import com.luck.picture.lib.R;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.utils.SdkVersionUtils;

public class ForegroundService
extends Service {
    private static final String CHANNEL_ID = "com.luck.picture.lib." + ForegroundService.class.getName();
    private static final String CHANNEL_NAME = "com.luck.picture.lib";
    private static final int NOTIFICATION_ID = 1;
    private static boolean isForegroundServiceIng = false;

    public IBinder onBind(Intent intent) {
        return null;
    }

    public void onCreate() {
        super.onCreate();
        Notification notification = this.createForegroundNotification();
        this.startForeground(1, notification);
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        isForegroundServiceIng = true;
        return super.onStartCommand(intent, flags, startId);
    }

    public void onDestroy() {
        isForegroundServiceIng = false;
        this.stopForeground(true);
        super.onDestroy();
    }

    private Notification createForegroundNotification() {
        int importance = 0;
        if (SdkVersionUtils.isMaxN()) {
            importance = 4;
        }
        if (SdkVersionUtils.isO()) {
            NotificationChannel channel = new NotificationChannel(CHANNEL_ID, (CharSequence)CHANNEL_NAME, importance);
            channel.setLightColor(-16776961);
            channel.canBypassDnd();
            channel.setBypassDnd(true);
            channel.setLockscreenVisibility(0);
            NotificationManager notificationManager = (NotificationManager)this.getSystemService("notification");
            notificationManager.createNotificationChannel(channel);
        }
        return new NotificationCompat.Builder((Context)this, CHANNEL_ID).setSmallIcon(R.drawable.ps_trans_1px).setContentTitle((CharSequence)this.getAppName()).setContentText((CharSequence)this.getString(R.string.ps_use_camera)).setOngoing(true).build();
    }

    private String getAppName() {
        try {
            PackageInfo packageInfo = this.getPackageManager().getPackageInfo(this.getPackageName(), 0);
            return packageInfo.applicationInfo.loadLabel(this.getPackageManager()).toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static void startForegroundService(Context context) {
        try {
            if (!isForegroundServiceIng && PictureSelectionConfig.getInstance().isCameraForegroundService) {
                Intent intent = new Intent(context, ForegroundService.class);
                if (SdkVersionUtils.isO()) {
                    context.startForegroundService(intent);
                } else {
                    context.startService(intent);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void stopService(Context context) {
        try {
            if (isForegroundServiceIng) {
                Intent foregroundService = new Intent(context, ForegroundService.class);
                context.stopService(foregroundService);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

