/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.adapter.holder;

import android.content.Context;
import android.graphics.ColorFilter;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.BlendModeColorFilterCompat;
import androidx.core.graphics.BlendModeCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.luck.picture.lib.R;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.style.SelectMainStyle;
import com.luck.picture.lib.utils.StyleUtils;
import java.util.ArrayList;
import java.util.List;

public class PreviewGalleryAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private final List<LocalMedia> mData;
    private OnItemClickListener listener;

    public PreviewGalleryAdapter(List<LocalMedia> list) {
        this.mData = new ArrayList<LocalMedia>(list);
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.preview_gallery_item, parent, false);
        return new ViewHolder(itemView);
    }

    public void clear() {
        this.mData.clear();
    }

    public void addGalleryData(boolean isBottomPreview, LocalMedia currentMedia) {
        int lastCheckPosition = this.getLastCheckPosition();
        if (lastCheckPosition != -1) {
            LocalMedia lastSelectedMedia = this.mData.get(lastCheckPosition);
            lastSelectedMedia.setChecked(false);
            this.notifyItemChanged(lastCheckPosition);
        }
        if (isBottomPreview && this.mData.contains(currentMedia)) {
            int currentPosition = this.getCurrentPosition(currentMedia);
            LocalMedia media = this.mData.get(currentPosition);
            media.setMaxSelectEnabledMask(false);
            media.setChecked(true);
            this.notifyItemChanged(currentPosition);
        } else {
            currentMedia.setChecked(true);
            this.mData.add(currentMedia);
            this.notifyItemChanged(this.mData.size() - 1);
        }
    }

    public void removeGalleryData(boolean isBottomPreview, LocalMedia currentMedia) {
        int currentPosition = this.getCurrentPosition(currentMedia);
        if (currentPosition != -1) {
            if (isBottomPreview) {
                LocalMedia media = this.mData.get(currentPosition);
                media.setMaxSelectEnabledMask(true);
                this.notifyItemChanged(currentPosition);
            } else {
                this.mData.remove(currentPosition);
                this.notifyItemRemoved(currentPosition);
            }
        }
    }

    public void isSelectMedia(LocalMedia currentMedia) {
        int currentPosition;
        int lastCheckPosition = this.getLastCheckPosition();
        if (lastCheckPosition != -1) {
            LocalMedia lastSelectedMedia = this.mData.get(lastCheckPosition);
            lastSelectedMedia.setChecked(false);
            this.notifyItemChanged(lastCheckPosition);
        }
        if ((currentPosition = this.getCurrentPosition(currentMedia)) != -1) {
            LocalMedia media = this.mData.get(currentPosition);
            media.setChecked(true);
            this.notifyItemChanged(currentPosition);
        }
    }

    private int getLastCheckPosition() {
        for (int i = 0; i < this.mData.size(); ++i) {
            LocalMedia media = this.mData.get(i);
            if (!media.isChecked()) continue;
            return i;
        }
        return -1;
    }

    private int getCurrentPosition(LocalMedia currentMedia) {
        for (int i = 0; i < this.mData.size(); ++i) {
            LocalMedia media = this.mData.get(i);
            if (!TextUtils.equals((CharSequence)media.getPath(), (CharSequence)currentMedia.getPath()) && media.getId() != currentMedia.getId()) continue;
            return i;
        }
        return -1;
    }

    public void onBindViewHolder(final @NonNull ViewHolder holder, int position) {
        final LocalMedia item = this.mData.get(position);
        ColorFilter colorFilter = BlendModeColorFilterCompat.createBlendModeColorFilterCompat((int)ContextCompat.getColor((Context)holder.itemView.getContext(), (int)(item.isMaxSelectEnabledMask() ? R.color.ps_color_half_white : R.color.ps_color_transparent)), (BlendModeCompat)BlendModeCompat.SRC_ATOP);
        if (item.isChecked() && item.isMaxSelectEnabledMask()) {
            holder.viewBorder.setVisibility(0);
        } else {
            holder.viewBorder.setVisibility(item.isChecked() ? 0 : 8);
        }
        String path = item.getPath();
        if (item.isEditorImage() && !TextUtils.isEmpty((CharSequence)item.getCutPath())) {
            path = item.getCutPath();
            holder.ivEditor.setVisibility(0);
        } else {
            holder.ivEditor.setVisibility(8);
        }
        holder.ivImage.setColorFilter(colorFilter);
        if (PictureSelectionConfig.imageEngine != null) {
            PictureSelectionConfig.imageEngine.loadImage(holder.itemView.getContext(), path, holder.ivImage);
        }
        holder.ivPlay.setVisibility(PictureMimeType.isHasVideo(item.getMimeType()) ? 0 : 8);
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (PreviewGalleryAdapter.this.listener != null) {
                    PreviewGalleryAdapter.this.listener.onItemClick(holder.getAbsoluteAdapterPosition(), item, view);
                }
            }
        });
    }

    public void setItemClickListener(OnItemClickListener listener) {
        this.listener = listener;
    }

    public int getItemCount() {
        return this.mData.size();
    }

    public static interface OnItemClickListener {
        public void onItemClick(int var1, LocalMedia var2, View var3);
    }

    static class ViewHolder
    extends RecyclerView.ViewHolder {
        ImageView ivImage;
        ImageView ivPlay;
        ImageView ivEditor;
        View viewBorder;

        public ViewHolder(View itemView) {
            super(itemView);
            int adapterPreviewGalleryItemSize;
            this.ivImage = (ImageView)itemView.findViewById(R.id.ivImage);
            this.ivPlay = (ImageView)itemView.findViewById(R.id.ivPlay);
            this.ivEditor = (ImageView)itemView.findViewById(R.id.ivEditor);
            this.viewBorder = itemView.findViewById(R.id.viewBorder);
            SelectMainStyle selectMainStyle = PictureSelectionConfig.selectorStyle.getSelectMainStyle();
            if (StyleUtils.checkStyleValidity(selectMainStyle.getAdapterImageEditorResources())) {
                this.ivEditor.setImageResource(selectMainStyle.getAdapterImageEditorResources());
            }
            if (StyleUtils.checkStyleValidity(selectMainStyle.getAdapterPreviewGalleryFrameResource())) {
                this.viewBorder.setBackgroundResource(selectMainStyle.getAdapterPreviewGalleryFrameResource());
            }
            if (StyleUtils.checkSizeValidity(adapterPreviewGalleryItemSize = selectMainStyle.getAdapterPreviewGalleryItemSize())) {
                RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(adapterPreviewGalleryItemSize, adapterPreviewGalleryItemSize);
                itemView.setLayoutParams((ViewGroup.LayoutParams)params);
            }
        }
    }
}

