/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.adapter;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PointF;
import android.media.MediaPlayer;
import android.net.Uri;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.VideoView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.luck.picture.lib.R;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.interfaces.OnCallbackListener;
import com.luck.picture.lib.large.ImageSource;
import com.luck.picture.lib.large.ImageViewState;
import com.luck.picture.lib.large.SubsamplingScaleImageView;
import com.luck.picture.lib.photoview.OnViewTapListener;
import com.luck.picture.lib.photoview.PhotoView;
import com.luck.picture.lib.utils.DensityUtil;
import com.luck.picture.lib.utils.MediaUtils;
import java.io.File;
import java.util.List;

public class PicturePreviewAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private static final int ADAPTER_TYPE_IMAGE = 1;
    private static final int ADAPTER_TYPE_VIDEO = 2;
    private final List<LocalMedia> mData;
    private final PictureSelectionConfig config;
    private final int screenWidth;
    private final int screenHeight;
    private PreviewVideoHolder currentVideoHolder;
    private OnPreviewEventListener mPreviewEventListener;

    public PicturePreviewAdapter(Context context, List<LocalMedia> list, PictureSelectionConfig config) {
        this.mData = list;
        this.config = config;
        this.screenWidth = DensityUtil.getScreenWidth(context);
        this.screenHeight = DensityUtil.getScreenHeight(context);
    }

    @NonNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (viewType == 2) {
            return new PreviewVideoHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.ps_preview_video, parent, false));
        }
        return new PreviewImageHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.ps_preview_image, parent, false));
    }

    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
        PhotoView previewView;
        final LocalMedia media = this.mData.get(position);
        final String path = media.isCut() && !media.isCompressed() ? media.getCutPath() : (media.isCompressed() || media.isCut() && media.isCompressed() ? media.getCompressPath() : (media.isToSandboxPath() ? media.getSandboxPath() : media.getPath()));
        if (this.getItemViewType(position) == 2) {
            final PreviewVideoHolder videoHolder = (PreviewVideoHolder)holder;
            previewView = videoHolder.previewView;
            PictureSelectionConfig.imageEngine.loadImage(holder.itemView.getContext(), path, (ImageView)previewView);
            videoHolder.ivPlayButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (videoHolder.ivPlayButton.getVisibility() == 0) {
                        videoHolder.ivPlayButton.setVisibility(8);
                    }
                    if (previewView.getVisibility() == 0) {
                        previewView.setVisibility(8);
                    }
                    if (videoHolder.videoView.getVisibility() == 8) {
                        videoHolder.videoView.setVisibility(0);
                    }
                    if (PictureMimeType.isContent(path)) {
                        videoHolder.videoView.setVideoURI(Uri.parse((String)path));
                    } else if (TextUtils.isEmpty((CharSequence)media.getSandboxPath())) {
                        videoHolder.videoView.setVideoPath(media.getSandboxPath());
                    } else {
                        videoHolder.videoView.setVideoPath(media.getPath());
                    }
                    videoHolder.videoView.start();
                    PicturePreviewAdapter.this.mPreviewEventListener.onPreviewVideoTitle(media.getFileName());
                }
            });
        } else {
            final PreviewImageHolder imageHolder = (PreviewImageHolder)holder;
            previewView = imageHolder.previewView;
            boolean isGif = PictureMimeType.isGif(media.getMimeType());
            boolean isLongImage = MediaUtils.isLongImage(media.getWidth(), media.getHeight());
            imageHolder.previewLongView.setVisibility(isLongImage && !isGif ? 0 : 8);
            if (PictureMimeType.isHasHttp(path)) {
                String mimeType = PictureMimeType.getImageMimeType(path);
                if (PictureMimeType.isGif(mimeType) || PictureMimeType.isGif(media.getMimeType()) || PictureMimeType.isWebp(mimeType) || PictureMimeType.isWebp(media.getMimeType())) {
                    PictureSelectionConfig.imageEngine.loadImage(holder.itemView.getContext(), path, (ImageView)previewView);
                } else {
                    PictureSelectionConfig.imageEngine.loadImageBitmap(holder.itemView.getContext(), path, new OnCallbackListener<Bitmap>(){

                        @Override
                        public void onCall(Bitmap resource) {
                            boolean isLongImage = MediaUtils.isLongImg(resource.getWidth(), resource.getHeight());
                            imageHolder.previewLongView.setVisibility(isLongImage ? 0 : 8);
                            previewView.setVisibility(isLongImage ? 8 : 0);
                            if (isLongImage) {
                                imageHolder.previewLongView.setQuickScaleEnabled(true);
                                imageHolder.previewLongView.setZoomEnabled(true);
                                imageHolder.previewLongView.setDoubleTapZoomDuration(100);
                                imageHolder.previewLongView.setMinimumScaleType(2);
                                imageHolder.previewLongView.setDoubleTapZoomDpi(2);
                                imageHolder.previewLongView.setImage(ImageSource.cachedBitmap(resource), new ImageViewState(0.0f, new PointF(0.0f, 0.0f), 0));
                            } else {
                                previewView.setImageBitmap(resource);
                            }
                        }
                    });
                }
            } else if (isLongImage) {
                Uri uri = PictureMimeType.isContent(path) ? Uri.parse((String)path) : Uri.fromFile((File)new File(path));
                imageHolder.previewLongView.setQuickScaleEnabled(true);
                imageHolder.previewLongView.setZoomEnabled(true);
                imageHolder.previewLongView.setDoubleTapZoomDuration(100);
                imageHolder.previewLongView.setMinimumScaleType(2);
                imageHolder.previewLongView.setDoubleTapZoomDpi(2);
                imageHolder.previewLongView.setImage(ImageSource.uri(uri), new ImageViewState(0.0f, new PointF(0.0f, 0.0f), 0));
            } else {
                PictureSelectionConfig.imageEngine.loadImage(holder.itemView.getContext(), path, (ImageView)previewView);
            }
            imageHolder.previewLongView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (PicturePreviewAdapter.this.mPreviewEventListener != null) {
                        PicturePreviewAdapter.this.mPreviewEventListener.onBackPressed();
                    }
                }
            });
            previewView.setVisibility(isLongImage && !isGif ? 8 : 0);
        }
        if (this.config.isAutoScalePreviewImage && this.screenWidth < this.screenHeight) {
            float width = Math.min(media.getWidth(), media.getHeight());
            float height = Math.max(media.getHeight(), media.getWidth());
            if (width > 0.0f && height > 0.0f) {
                int displayHeight = (int)Math.ceil(width * height / width);
                FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)previewView.getLayoutParams();
                layoutParams.width = this.screenWidth;
                layoutParams.height = displayHeight < this.screenHeight ? displayHeight + this.screenHeight : displayHeight;
                layoutParams.gravity = 17;
            }
        }
        previewView.setOnViewTapListener(new OnViewTapListener(){

            @Override
            public void onViewTap(View view, float x, float y) {
                if (PicturePreviewAdapter.this.mPreviewEventListener != null) {
                    PicturePreviewAdapter.this.mPreviewEventListener.onBackPressed();
                }
            }
        });
        previewView.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View view) {
                if (PicturePreviewAdapter.this.mPreviewEventListener != null) {
                    PicturePreviewAdapter.this.mPreviewEventListener.onLongPressDownload(media);
                }
                return false;
            }
        });
    }

    public int getItemViewType(int position) {
        if (PictureMimeType.isHasVideo(this.mData.get(position).getMimeType())) {
            return 2;
        }
        return 1;
    }

    public int getItemCount() {
        return this.mData != null ? this.mData.size() : 0;
    }

    private void addVideoListener(final PreviewVideoHolder videoHolder) {
        videoHolder.videoView.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

            public void onCompletion(MediaPlayer mediaPlayer) {
                videoHolder.ivPlayButton.setVisibility(0);
                videoHolder.previewView.setVisibility(0);
                videoHolder.videoView.setVisibility(8);
                if (PicturePreviewAdapter.this.mPreviewEventListener != null) {
                    PicturePreviewAdapter.this.mPreviewEventListener.onPreviewVideoTitle(null);
                }
            }
        });
        videoHolder.videoView.setOnErrorListener(new MediaPlayer.OnErrorListener(){

            public boolean onError(MediaPlayer mediaPlayer, int i, int i1) {
                if (videoHolder.ivPlayButton.getVisibility() == 8) {
                    videoHolder.ivPlayButton.setVisibility(0);
                }
                if (PicturePreviewAdapter.this.mPreviewEventListener != null) {
                    PicturePreviewAdapter.this.mPreviewEventListener.onPreviewVideoTitle(null);
                }
                if (videoHolder.videoView.getVisibility() == 0) {
                    videoHolder.videoView.setVisibility(8);
                }
                if (videoHolder.previewView.getVisibility() == 8) {
                    videoHolder.previewView.setVisibility(0);
                }
                return false;
            }
        });
        videoHolder.videoView.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

            public void onPrepared(MediaPlayer mediaPlayer) {
                mediaPlayer.setOnInfoListener(new MediaPlayer.OnInfoListener(){

                    public boolean onInfo(MediaPlayer mediaPlayer, int what, int i1) {
                        if (what == 3) {
                            videoHolder.videoView.setBackgroundColor(0);
                            return true;
                        }
                        return false;
                    }
                });
            }
        });
    }

    public void onViewDetachedFromWindow(@NonNull RecyclerView.ViewHolder holder) {
        super.onViewDetachedFromWindow(holder);
        if (holder instanceof PreviewVideoHolder) {
            PreviewVideoHolder videoHolder = (PreviewVideoHolder)holder;
            this.releaseVideo(videoHolder);
        }
    }

    public void onViewAttachedToWindow(@NonNull RecyclerView.ViewHolder holder) {
        super.onViewAttachedToWindow(holder);
        if (holder instanceof PreviewVideoHolder) {
            this.currentVideoHolder = (PreviewVideoHolder)holder;
            this.addVideoListener(this.currentVideoHolder);
        }
    }

    public void destroyCurrentVideoHolder() {
        if (this.currentVideoHolder != null) {
            this.releaseVideo(this.currentVideoHolder);
        }
    }

    private void releaseVideo(PreviewVideoHolder videoHolder) {
        videoHolder.videoView.stopPlayback();
        videoHolder.previewView.setVisibility(0);
        videoHolder.ivPlayButton.setVisibility(0);
        videoHolder.videoView.setVisibility(8);
        videoHolder.videoView.setOnErrorListener(null);
        videoHolder.videoView.setOnCompletionListener(null);
        videoHolder.videoView.setOnPreparedListener(null);
    }

    public void setOnPreviewEventListener(OnPreviewEventListener listener) {
        this.mPreviewEventListener = listener;
    }

    public static interface OnPreviewEventListener {
        public void onBackPressed();

        public void onPreviewVideoTitle(String var1);

        public void onLongPressDownload(LocalMedia var1);
    }

    private static class PreviewVideoHolder
    extends RecyclerView.ViewHolder {
        ImageView ivPlayButton;
        VideoView videoView;
        PhotoView previewView;

        public PreviewVideoHolder(@NonNull View itemView) {
            super(itemView);
            this.previewView = (PhotoView)itemView.findViewById(R.id.preview_image);
            this.ivPlayButton = (ImageView)itemView.findViewById(R.id.iv_play_video);
            this.videoView = (VideoView)itemView.findViewById(R.id.video_view);
        }
    }

    private static class PreviewImageHolder
    extends RecyclerView.ViewHolder {
        PhotoView previewView;
        SubsamplingScaleImageView previewLongView;

        public PreviewImageHolder(@NonNull View itemView) {
            super(itemView);
            this.previewView = (PhotoView)itemView.findViewById(R.id.preview_image);
            this.previewLongView = (SubsamplingScaleImageView)itemView.findViewById(R.id.preview_long_image);
        }
    }
}

