/*
 * Decompiled with CFR 0.152.
 */
package com.luck.lib.camerax;

import android.app.Activity;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.graphics.SurfaceTexture;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.ImageCaptureException;
import androidx.camera.core.Preview;
import androidx.camera.core.UseCase;
import androidx.camera.core.VideoCapture;
import androidx.camera.lifecycle.ProcessCameraProvider;
import androidx.camera.view.PreviewView;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.LifecycleOwner;
import com.google.common.util.concurrent.ListenableFuture;
import com.luck.lib.camerax.R;
import com.luck.lib.camerax.SimpleCameraX;
import com.luck.lib.camerax.listener.CameraListener;
import com.luck.lib.camerax.listener.CaptureListener;
import com.luck.lib.camerax.listener.ClickListener;
import com.luck.lib.camerax.listener.ImageCallbackListener;
import com.luck.lib.camerax.listener.TypeListener;
import com.luck.lib.camerax.permissions.PermissionChecker;
import com.luck.lib.camerax.permissions.PermissionResultCallback;
import com.luck.lib.camerax.permissions.PermissionUtil;
import com.luck.lib.camerax.utils.CameraUtils;
import com.luck.lib.camerax.utils.DensityUtil;
import com.luck.lib.camerax.utils.FileUtils;
import com.luck.lib.camerax.widget.CaptureLayout;
import java.io.File;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NotNull;

public class CustomCameraView
extends RelativeLayout {
    public static final int DEFAULT_MAX_RECORD_VIDEO = 60000;
    public static final int DEFAULT_MIN_RECORD_VIDEO = 1500;
    private static final int TYPE_FLASH_AUTO = 33;
    private static final int TYPE_FLASH_ON = 34;
    private static final int TYPE_FLASH_OFF = 35;
    private int typeFlash = 35;
    private PreviewView mCameraPreviewView;
    private ProcessCameraProvider mCameraProvider;
    private ImageCapture mImageCapture;
    private VideoCapture mVideoCapture;
    private int buttonFeatures;
    private String outPutCameraDir;
    private String outPutCameraFileName;
    private int recordVideoMinSecond;
    private String imageFormat;
    private String imageFormatForQ;
    private String videoFormat;
    private String videoFormatForQ;
    private int useCameraCases = 1;
    private int lensFacing = 1;
    private CameraListener mCameraListener;
    private ClickListener mOnClickListener;
    private ImageCallbackListener mImageCallbackListener;
    private ImageView mImagePreview;
    private ImageView mSwitchCamera;
    private ImageView mFlashLamp;
    private CaptureLayout mCaptureLayout;
    private MediaPlayer mMediaPlayer;
    private TextureView mTextureView;
    private long recordTime = 0L;
    private final TextureView.SurfaceTextureListener surfaceTextureListener = new TextureView.SurfaceTextureListener(){

        public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
            String outputPath = SimpleCameraX.getOutputPath(((Activity)CustomCameraView.this.getContext()).getIntent());
            CustomCameraView.this.startVideoPlay(outputPath);
        }

        public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
        }

        public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
            return false;
        }

        public void onSurfaceTextureUpdated(SurfaceTexture surface) {
        }
    };

    private boolean isImageCaptureEnabled() {
        return this.useCameraCases == 1;
    }

    public CustomCameraView(Context context) {
        super(context);
        this.initView();
    }

    public CustomCameraView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public CustomCameraView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    private void initView() {
        CustomCameraView.inflate((Context)this.getContext(), (int)R.layout.picture_camera_view, (ViewGroup)this);
        this.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.picture_color_black));
        this.mCameraPreviewView = (PreviewView)this.findViewById(R.id.cameraPreviewView);
        this.mTextureView = (TextureView)this.findViewById(R.id.video_play_preview);
        this.mImagePreview = (ImageView)this.findViewById(R.id.cover_preview);
        this.mSwitchCamera = (ImageView)this.findViewById(R.id.image_switch);
        this.mFlashLamp = (ImageView)this.findViewById(R.id.image_flash);
        this.mCaptureLayout = (CaptureLayout)this.findViewById(R.id.capture_layout);
        this.mSwitchCamera.setImageResource(R.drawable.picture_ic_camera);
        this.mFlashLamp.setOnClickListener(v -> {
            ++this.typeFlash;
            if (this.typeFlash > 35) {
                this.typeFlash = 33;
            }
            this.setFlashMode();
        });
        this.mCaptureLayout.setDuration(60000);
        this.mSwitchCamera.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CustomCameraView.this.toggleCamera();
            }
        });
        this.mCaptureLayout.setCaptureListener(new CaptureListener(){

            @Override
            public void takePictures() {
                ImageCapture.OutputFileOptions fileOptions;
                if (!CustomCameraView.this.mCameraProvider.isBound((UseCase)CustomCameraView.this.mImageCapture)) {
                    CustomCameraView.this.bindCameraImageUseCases();
                }
                CustomCameraView.this.useCameraCases = 1;
                CustomCameraView.this.mCaptureLayout.setButtonCaptureEnabled(false);
                CustomCameraView.this.mSwitchCamera.setVisibility(4);
                CustomCameraView.this.mFlashLamp.setVisibility(4);
                if (Build.VERSION.SDK_INT >= 29 && TextUtils.isEmpty((CharSequence)CustomCameraView.this.outPutCameraDir)) {
                    ContentValues contentValues = CameraUtils.buildImageContentValues(CustomCameraView.this.outPutCameraFileName, CustomCameraView.this.imageFormatForQ);
                    fileOptions = new ImageCapture.OutputFileOptions.Builder(CustomCameraView.this.getContext().getContentResolver(), MediaStore.Images.Media.EXTERNAL_CONTENT_URI, contentValues).build();
                } else {
                    File cameraFile = FileUtils.createCameraFile(CustomCameraView.this.getContext(), 1, CustomCameraView.this.outPutCameraFileName, CustomCameraView.this.imageFormat, CustomCameraView.this.outPutCameraDir);
                    fileOptions = new ImageCapture.OutputFileOptions.Builder(cameraFile).build();
                }
                CustomCameraView.this.mImageCapture.takePicture(fileOptions, ContextCompat.getMainExecutor((Context)CustomCameraView.this.getContext()), (ImageCapture.OnImageSavedCallback)new MyImageResultCallback(CustomCameraView.this.mImagePreview, CustomCameraView.this.mCaptureLayout, CustomCameraView.this.mImageCallbackListener, CustomCameraView.this.mCameraListener));
            }

            @Override
            public void recordStart() {
                VideoCapture.OutputFileOptions fileOptions;
                if (!CustomCameraView.this.mCameraProvider.isBound((UseCase)CustomCameraView.this.mVideoCapture)) {
                    CustomCameraView.this.bindCameraVideoUseCases();
                }
                CustomCameraView.this.useCameraCases = 4;
                CustomCameraView.this.mSwitchCamera.setVisibility(4);
                CustomCameraView.this.mFlashLamp.setVisibility(4);
                if (Build.VERSION.SDK_INT >= 29 && TextUtils.isEmpty((CharSequence)CustomCameraView.this.outPutCameraDir)) {
                    ContentValues contentValues = CameraUtils.buildVideoContentValues(CustomCameraView.this.outPutCameraFileName, CustomCameraView.this.videoFormatForQ);
                    fileOptions = new VideoCapture.OutputFileOptions.Builder(CustomCameraView.this.getContext().getContentResolver(), MediaStore.Video.Media.EXTERNAL_CONTENT_URI, contentValues).build();
                } else {
                    File cameraFile = FileUtils.createCameraFile(CustomCameraView.this.getContext(), 2, CustomCameraView.this.outPutCameraFileName, CustomCameraView.this.videoFormat, CustomCameraView.this.outPutCameraDir);
                    fileOptions = new VideoCapture.OutputFileOptions.Builder(cameraFile).build();
                }
                CustomCameraView.this.mVideoCapture.startRecording(fileOptions, ContextCompat.getMainExecutor((Context)CustomCameraView.this.getContext()), new VideoCapture.OnVideoSavedCallback(){

                    public void onVideoSaved(@NonNull @NotNull VideoCapture.OutputFileResults outputFileResults) {
                        long minSecond;
                        long l = minSecond = CustomCameraView.this.recordVideoMinSecond <= 0 ? 1500L : (long)CustomCameraView.this.recordVideoMinSecond;
                        if (CustomCameraView.this.recordTime < minSecond || outputFileResults.getSavedUri() == null) {
                            return;
                        }
                        Uri savedUri = outputFileResults.getSavedUri();
                        Activity activity = (Activity)CustomCameraView.this.getContext();
                        SimpleCameraX.putOutputUri(activity.getIntent(), savedUri);
                        String outPutPath = FileUtils.isContent(savedUri.toString()) ? savedUri.toString() : savedUri.getPath();
                        CustomCameraView.this.mTextureView.setVisibility(0);
                        CustomCameraView.this.mCameraPreviewView.setVisibility(4);
                        if (CustomCameraView.this.mTextureView.isAvailable()) {
                            CustomCameraView.this.startVideoPlay(outPutPath);
                        } else {
                            CustomCameraView.this.mTextureView.setSurfaceTextureListener(CustomCameraView.this.surfaceTextureListener);
                        }
                    }

                    public void onError(int videoCaptureError, @NonNull @NotNull String message, @Nullable @org.jetbrains.annotations.Nullable Throwable cause) {
                        if (CustomCameraView.this.mCameraListener != null) {
                            CustomCameraView.this.mCameraListener.onError(videoCaptureError, message, cause);
                        }
                    }
                });
            }

            @Override
            public void recordShort(long time) {
                CustomCameraView.this.recordTime = time;
                CustomCameraView.this.mSwitchCamera.setVisibility(0);
                CustomCameraView.this.mFlashLamp.setVisibility(0);
                CustomCameraView.this.mCaptureLayout.resetCaptureLayout();
                CustomCameraView.this.mCaptureLayout.setTextWithAnimation(CustomCameraView.this.getContext().getString(R.string.picture_recording_time_is_short));
                CustomCameraView.this.mVideoCapture.stopRecording();
            }

            @Override
            public void recordEnd(long time) {
                CustomCameraView.this.recordTime = time;
                try {
                    CustomCameraView.this.mVideoCapture.stopRecording();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void recordZoom(float zoom) {
            }

            @Override
            public void recordError() {
                if (CustomCameraView.this.mCameraListener != null) {
                    CustomCameraView.this.mCameraListener.onError(0, "An unknown error", null);
                }
            }
        });
        this.mCaptureLayout.setTypeListener(new TypeListener(){

            @Override
            public void cancel() {
                CustomCameraView.this.onCancelMedia();
                String outputPath = SimpleCameraX.getOutputPath(((Activity)CustomCameraView.this.getContext()).getIntent());
                FileUtils.deleteFile(CustomCameraView.this.getContext(), outputPath);
            }

            @Override
            public void confirm() {
                Activity activity = (Activity)CustomCameraView.this.getContext();
                String outputPath = SimpleCameraX.getOutputPath(activity.getIntent());
                if (CustomCameraView.this.isImageCaptureEnabled()) {
                    CustomCameraView.this.mImagePreview.setVisibility(4);
                    if (CustomCameraView.this.mCameraListener != null) {
                        CustomCameraView.this.mCameraListener.onPictureSuccess(outputPath);
                    }
                } else {
                    CustomCameraView.this.stopVideoPlay();
                    if (CustomCameraView.this.mCameraListener != null) {
                        CustomCameraView.this.mCameraListener.onRecordSuccess(outputPath);
                    }
                }
            }
        });
        this.mCaptureLayout.setLeftClickListener(new ClickListener(){

            @Override
            public void onClick() {
                if (CustomCameraView.this.mOnClickListener != null) {
                    CustomCameraView.this.mOnClickListener.onClick();
                }
            }
        });
    }

    public void setCameraConfig(Intent intent) {
        Bundle extras = intent.getExtras();
        boolean isCameraAroundState = extras.getBoolean("com.luck.lib.camerax.CameraAroundState", false);
        this.buttonFeatures = extras.getInt("com.luck.lib.camerax.CameraMode", 0);
        this.lensFacing = isCameraAroundState ? 0 : 1;
        this.outPutCameraDir = extras.getString("com.luck.lib.camerax.OutputPathDir");
        this.outPutCameraFileName = extras.getString("com.luck.lib.camerax.CameraFileName");
        int recordVideoMaxSecond = extras.getInt("com.luck.lib.camerax.RecordVideoMaxSecond", 60000);
        this.recordVideoMinSecond = extras.getInt("com.luck.lib.camerax.RecordVideoMaxSecond", 1500);
        this.imageFormat = extras.getString("com.luck.lib.camerax.CameraImageFormat", ".jpeg");
        this.imageFormatForQ = extras.getString("com.luck.lib.camerax.CameraImageFormatForQ", "image/jpeg");
        this.videoFormat = extras.getString("com.luck.lib.camerax.CameraVideoFormat", ".mp4");
        this.videoFormatForQ = extras.getString("com.luck.lib.camerax.CameraVideoFormatForQ", "video/mp4");
        int captureLoadingColor = extras.getInt("com.luck.lib.camerax.CaptureLoadingColor", -8552961);
        this.mCaptureLayout.setButtonFeatures(this.buttonFeatures);
        if (recordVideoMaxSecond > 0) {
            this.setRecordVideoMaxTime(recordVideoMaxSecond);
        }
        if (this.recordVideoMinSecond > 0) {
            this.setRecordVideoMinTime(this.recordVideoMinSecond);
        }
        this.setCaptureLoadingColor(captureLoadingColor);
        String[] permissionArray = new String[]{"android.permission.CAMERA", "android.permission.WRITE_EXTERNAL_STORAGE"};
        PermissionChecker.getInstance().requestPermissions((Activity)this.getContext(), permissionArray, new PermissionResultCallback(){

            @Override
            public void onGranted() {
                CustomCameraView.this.buildUseCameraCases();
            }

            @Override
            public void onDenied() {
                PermissionUtil.goIntentSetting((Activity)CustomCameraView.this.getContext(), 1102);
            }
        });
    }

    public void buildUseCameraCases() {
        final ListenableFuture cameraProviderFuture = ProcessCameraProvider.getInstance((Context)this.getContext());
        cameraProviderFuture.addListener(new Runnable(){

            @Override
            public void run() {
                try {
                    CustomCameraView.this.mCameraProvider = (ProcessCameraProvider)cameraProviderFuture.get();
                    CustomCameraView.this.bindCameraUseCases();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, ContextCompat.getMainExecutor((Context)this.getContext()));
    }

    private void bindCameraUseCases() {
        if (this.buttonFeatures == 0 || this.buttonFeatures == 1) {
            this.bindCameraImageUseCases();
        } else {
            this.bindCameraVideoUseCases();
        }
    }

    private void bindCameraImageUseCases() {
        try {
            int screenAspectRatio = this.aspectRatio(DensityUtil.getScreenWidth(this.getContext()), DensityUtil.getScreenHeight(this.getContext()));
            CameraSelector cameraSelector = new CameraSelector.Builder().requireLensFacing(this.lensFacing).build();
            Preview preview = new Preview.Builder().setTargetAspectRatio(screenAspectRatio).build();
            this.mImageCapture = new ImageCapture.Builder().setCaptureMode(1).setTargetAspectRatio(screenAspectRatio).build();
            ImageAnalysis mImageAnalyzer = new ImageAnalysis.Builder().setTargetAspectRatio(screenAspectRatio).build();
            this.mCameraProvider.unbindAll();
            this.mCameraProvider.bindToLifecycle((LifecycleOwner)this.getContext(), cameraSelector, new UseCase[]{preview, this.mImageCapture, mImageAnalyzer});
            preview.setSurfaceProvider(this.mCameraPreviewView.getSurfaceProvider());
            this.setFlashMode();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void bindCameraVideoUseCases() {
        try {
            CameraSelector cameraSelector = new CameraSelector.Builder().requireLensFacing(this.lensFacing).build();
            Preview preview = new Preview.Builder().build();
            this.mVideoCapture = new VideoCapture.Builder().build();
            this.mCameraProvider.unbindAll();
            this.mCameraProvider.bindToLifecycle((LifecycleOwner)this.getContext(), cameraSelector, new UseCase[]{preview, this.mVideoCapture});
            preview.setSurfaceProvider(this.mCameraPreviewView.getSurfaceProvider());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int aspectRatio(int width, int height) {
        int previewRatio = Math.max(width, height) / Math.min(width, height);
        double RATIO_4_3_VALUE = 1.3333333333333333;
        double RATIO_16_9_VALUE = 1.7777777777777777;
        if (Math.abs((double)previewRatio - RATIO_4_3_VALUE) <= Math.abs((double)previewRatio - RATIO_16_9_VALUE)) {
            return 0;
        }
        return 1;
    }

    public void setCameraListener(CameraListener cameraListener) {
        this.mCameraListener = cameraListener;
    }

    public void setRecordVideoMaxTime(int maxDurationTime) {
        this.mCaptureLayout.setDuration(maxDurationTime);
    }

    public void setRecordVideoMinTime(int minDurationTime) {
        this.mCaptureLayout.setMinDuration(minDurationTime);
    }

    public void setCaptureLoadingColor(int color2) {
        this.mCaptureLayout.setCaptureLoadingColor(color2);
    }

    public void toggleCamera() {
        this.lensFacing = 0 == this.lensFacing ? 1 : 0;
        this.bindCameraUseCases();
    }

    private void setFlashMode() {
        if (this.mImageCapture == null) {
            return;
        }
        switch (this.typeFlash) {
            case 33: {
                this.mFlashLamp.setImageResource(R.drawable.picture_ic_flash_auto);
                this.mImageCapture.setFlashMode(0);
                break;
            }
            case 34: {
                this.mFlashLamp.setImageResource(R.drawable.picture_ic_flash_on);
                this.mImageCapture.setFlashMode(1);
                break;
            }
            case 35: {
                this.mFlashLamp.setImageResource(R.drawable.picture_ic_flash_off);
                this.mImageCapture.setFlashMode(2);
            }
        }
    }

    public void setOnCancelClickListener(ClickListener clickListener) {
        this.mOnClickListener = clickListener;
    }

    public void setImageCallbackListener(ImageCallbackListener mImageCallbackListener) {
        this.mImageCallbackListener = mImageCallbackListener;
    }

    private void resetState() {
        if (this.isImageCaptureEnabled()) {
            this.mImagePreview.setVisibility(4);
        } else {
            try {
                this.mVideoCapture.stopRecording();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.mSwitchCamera.setVisibility(0);
        this.mFlashLamp.setVisibility(0);
        this.mCameraPreviewView.setVisibility(0);
        this.mCaptureLayout.resetCaptureLayout();
    }

    private void startVideoPlay(String url) {
        try {
            if (this.mMediaPlayer == null) {
                this.mMediaPlayer = new MediaPlayer();
            } else {
                this.mMediaPlayer.reset();
            }
            if (FileUtils.isContent(url)) {
                this.mMediaPlayer.setDataSource(this.getContext(), Uri.parse((String)url));
            } else {
                this.mMediaPlayer.setDataSource(url);
            }
            this.mMediaPlayer.setSurface(new Surface(this.mTextureView.getSurfaceTexture()));
            this.mMediaPlayer.setVideoScalingMode(1);
            this.mMediaPlayer.setAudioStreamType(3);
            this.mMediaPlayer.setOnVideoSizeChangedListener(new MediaPlayer.OnVideoSizeChangedListener(){

                public void onVideoSizeChanged(MediaPlayer mp, int width, int height) {
                    CustomCameraView.this.updateVideoViewSize(CustomCameraView.this.mMediaPlayer.getVideoWidth(), CustomCameraView.this.mMediaPlayer.getVideoHeight());
                }
            });
            this.mMediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                public void onPrepared(MediaPlayer mp) {
                    CustomCameraView.this.mMediaPlayer.start();
                }
            });
            this.mMediaPlayer.setLooping(true);
            this.mMediaPlayer.prepareAsync();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateVideoViewSize(float videoWidth, float videoHeight) {
        if (videoWidth > videoHeight) {
            int height = (int)(videoHeight / videoWidth * (float)this.getWidth());
            FrameLayout.LayoutParams videoViewParam = new FrameLayout.LayoutParams(-1, height);
            videoViewParam.gravity = 17;
            this.mTextureView.setLayoutParams((ViewGroup.LayoutParams)videoViewParam);
        }
    }

    public void onCancelMedia() {
        this.stopVideoPlay();
        this.resetState();
    }

    private void stopVideoPlay() {
        if (this.mMediaPlayer != null && this.mMediaPlayer.isPlaying()) {
            this.mMediaPlayer.stop();
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
        }
        this.mTextureView.setVisibility(8);
    }

    private static class MyImageResultCallback
    implements ImageCapture.OnImageSavedCallback {
        private final WeakReference<ImageView> mImagePreviewReference;
        private final WeakReference<CaptureLayout> mCaptureLayoutReference;
        private final WeakReference<ImageCallbackListener> mImageCallbackListenerReference;
        private final WeakReference<CameraListener> mCameraListenerReference;

        public MyImageResultCallback(ImageView imagePreview, CaptureLayout captureLayout, ImageCallbackListener imageCallbackListener, CameraListener cameraListener) {
            this.mImagePreviewReference = new WeakReference<ImageView>(imagePreview);
            this.mCaptureLayoutReference = new WeakReference<CaptureLayout>(captureLayout);
            this.mImageCallbackListenerReference = new WeakReference<ImageCallbackListener>(imageCallbackListener);
            this.mCameraListenerReference = new WeakReference<CameraListener>(cameraListener);
        }

        public void onImageSaved(@NonNull ImageCapture.OutputFileResults outputFileResults) {
            if (outputFileResults.getSavedUri() == null || this.mCaptureLayoutReference.get() == null || this.mImagePreviewReference.get() == null || this.mImageCallbackListenerReference.get() == null) {
                return;
            }
            Uri savedUri = outputFileResults.getSavedUri();
            Context context = ((ImageView)this.mImagePreviewReference.get()).getContext();
            SimpleCameraX.putOutputUri(((Activity)context).getIntent(), savedUri);
            String outPutCameraPath = FileUtils.isContent(savedUri.toString()) ? savedUri.toString() : savedUri.getPath();
            ((CaptureLayout)((Object)this.mCaptureLayoutReference.get())).setButtonCaptureEnabled(true);
            ((ImageCallbackListener)this.mImageCallbackListenerReference.get()).onLoadImage(outPutCameraPath, (ImageView)this.mImagePreviewReference.get());
            ((ImageView)this.mImagePreviewReference.get()).setVisibility(0);
            ((CaptureLayout)((Object)this.mCaptureLayoutReference.get())).startTypeBtnAnimator();
        }

        public void onError(@NonNull ImageCaptureException exception) {
            if (this.mCaptureLayoutReference.get() != null) {
                ((CaptureLayout)((Object)this.mCaptureLayoutReference.get())).setButtonCaptureEnabled(true);
            }
            if (this.mCameraListenerReference.get() != null) {
                ((CameraListener)this.mCameraListenerReference.get()).onError(exception.getImageCaptureError(), exception.getMessage(), exception.getCause());
            }
        }
    }
}

