/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.immersive;

import android.os.Build;
import android.text.TextUtils;
import com.luck.picture.lib.tools.StringUtils;
import com.luck.picture.lib.tools.ValueOf;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class RomUtils {
    private static Integer romType;

    public static int getLightStatausBarAvailableRomType() {
        if (romType != null) {
            return romType;
        }
        if (RomUtils.isMIUIV6OrAbove()) {
            romType = 1;
            return romType;
        }
        if (RomUtils.isFlymeV4OrAbove()) {
            romType = 2;
            return romType;
        }
        if (RomUtils.isAndroid5OrAbove()) {
            romType = 3;
            return romType;
        }
        romType = 4;
        return romType;
    }

    private static boolean isFlymeV4OrAbove() {
        return RomUtils.getFlymeVersion() >= 4;
    }

    public static int getFlymeVersion() {
        String displayId = Build.DISPLAY;
        if (!TextUtils.isEmpty((CharSequence)displayId) && displayId.contains("Flyme")) {
            displayId = displayId.replaceAll("Flyme", "");
            displayId = displayId.replaceAll("OS", "");
            displayId = displayId.replaceAll(" ", "");
            String version = displayId.substring(0, 1);
            return StringUtils.stringToInt(version);
        }
        return 0;
    }

    private static boolean isMIUIV6OrAbove() {
        String miuiVersionCodeStr = RomUtils.getSystemProperty();
        if (!TextUtils.isEmpty((CharSequence)miuiVersionCodeStr)) {
            try {
                int miuiVersionCode = ValueOf.toInt(miuiVersionCodeStr);
                if (miuiVersionCode >= 4) {
                    return true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static int getMIUIVersionCode() {
        String miuiVersionCodeStr = RomUtils.getSystemProperty();
        int miuiVersionCode = 0;
        if (!TextUtils.isEmpty((CharSequence)miuiVersionCodeStr)) {
            try {
                miuiVersionCode = ValueOf.toInt(miuiVersionCodeStr);
                return miuiVersionCode;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return miuiVersionCode;
    }

    private static boolean isAndroid5OrAbove() {
        return Build.VERSION.SDK_INT >= 21;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getSystemProperty() {
        String line;
        BufferedReader input = null;
        try {
            Process p = Runtime.getRuntime().exec("getprop ro.miui.ui.version.code");
            input = new BufferedReader(new InputStreamReader(p.getInputStream()), 1024);
            line = input.readLine();
            input.close();
        }
        catch (IOException ex) {
            String string2 = null;
            return string2;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return line;
    }

    public static class AvailableRomType {
        public static final int MIUI = 1;
        public static final int FLYME = 2;
        public static final int ANDROID_NATIVE = 3;
        public static final int NA = 4;
    }
}

