/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.adapter;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.ColorFilter;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.BlendModeColorFilterCompat;
import androidx.core.graphics.BlendModeCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.luck.picture.lib.R;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.dialog.PictureCustomDialog;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.listener.OnPhotoSelectChangedListener;
import com.luck.picture.lib.tools.AnimUtils;
import com.luck.picture.lib.tools.AttrsUtils;
import com.luck.picture.lib.tools.DateUtils;
import com.luck.picture.lib.tools.MediaUtils;
import com.luck.picture.lib.tools.StringUtils;
import com.luck.picture.lib.tools.ToastUtils;
import com.luck.picture.lib.tools.ValueOf;
import com.luck.picture.lib.tools.VoiceUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PictureImageGridAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private final Context context;
    private boolean showCamera;
    private OnPhotoSelectChangedListener<LocalMedia> imageSelectChangedListener;
    private List<LocalMedia> data = new ArrayList<LocalMedia>();
    private List<LocalMedia> selectData = new ArrayList<LocalMedia>();
    private final PictureSelectionConfig config;

    public PictureImageGridAdapter(Context context, PictureSelectionConfig config) {
        this.context = context;
        this.config = config;
        this.showCamera = config.isCamera;
    }

    public void setShowCamera(boolean showCamera) {
        this.showCamera = showCamera;
    }

    public boolean isShowCamera() {
        return this.showCamera;
    }

    public void bindData(List<LocalMedia> data) {
        this.data = data == null ? new ArrayList() : data;
        this.notifyDataSetChanged();
    }

    public void bindSelectData(List<LocalMedia> images) {
        ArrayList<LocalMedia> selection = new ArrayList<LocalMedia>();
        int size = images.size();
        for (int i = 0; i < size; ++i) {
            LocalMedia media = images.get(i);
            selection.add(media);
        }
        this.selectData = selection;
        if (!this.config.isSingleDirectReturn) {
            this.subSelectPosition();
            if (this.imageSelectChangedListener != null) {
                this.imageSelectChangedListener.onChange(this.selectData);
            }
        }
    }

    public List<LocalMedia> getSelectedData() {
        return this.selectData == null ? new ArrayList() : this.selectData;
    }

    public int getSelectedSize() {
        return this.selectData == null ? 0 : this.selectData.size();
    }

    public List<LocalMedia> getData() {
        return this.data == null ? new ArrayList() : this.data;
    }

    public boolean isDataEmpty() {
        return this.data == null || this.data.size() == 0;
    }

    public void clear() {
        if (this.getSize() > 0) {
            this.data.clear();
        }
    }

    public int getSize() {
        return this.data == null ? 0 : this.data.size();
    }

    public LocalMedia getItem(int position) {
        return this.getSize() > 0 ? this.data.get(position) : null;
    }

    public int getItemViewType(int position) {
        if (this.showCamera && position == 0) {
            return 1;
        }
        return 2;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == 1) {
            View view = LayoutInflater.from((Context)this.context).inflate(R.layout.picture_item_camera, parent, false);
            return new CameraViewHolder(view);
        }
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.picture_image_grid_item, parent, false);
        return new ViewHolder(view);
    }

    public void onBindViewHolder(@NotNull RecyclerView.ViewHolder holder, int position) {
        if (this.getItemViewType(position) == 1) {
            CameraViewHolder headerHolder = (CameraViewHolder)holder;
            headerHolder.itemView.setOnClickListener(v -> {
                if (this.imageSelectChangedListener != null) {
                    this.imageSelectChangedListener.onTakePhoto();
                }
            });
        } else {
            ViewHolder contentHolder = (ViewHolder)holder;
            LocalMedia image = this.data.get(this.showCamera ? position - 1 : position);
            image.position = contentHolder.getAbsoluteAdapterPosition();
            String mimeType = image.getMimeType();
            if (this.config.checkNumMode) {
                this.notifyCheckChanged(contentHolder, image);
            }
            if (this.config.isSingleDirectReturn) {
                contentHolder.tvCheck.setVisibility(8);
                contentHolder.btnCheck.setVisibility(8);
            } else {
                this.selectImage(contentHolder, this.isSelected(image));
                contentHolder.tvCheck.setVisibility(0);
                contentHolder.btnCheck.setVisibility(0);
                if (this.config.isMaxSelectEnabledMask) {
                    this.dispatchHandleMask(contentHolder, image);
                }
            }
            String path = image.getPath();
            if (image.isEditorImage() && !TextUtils.isEmpty((CharSequence)image.getCutPath())) {
                contentHolder.ivEditor.setVisibility(0);
                path = image.getCutPath();
            } else {
                contentHolder.ivEditor.setVisibility(8);
            }
            boolean isGif = PictureMimeType.isGif(mimeType);
            boolean isWebp = PictureMimeType.isWebp(mimeType);
            boolean isLongImg = MediaUtils.isLongImg(image);
            if ((isGif || isWebp) && !isLongImg) {
                contentHolder.tvImageMimeType.setVisibility(0);
                contentHolder.tvImageMimeType.setText((CharSequence)(isGif ? this.context.getString(R.string.picture_gif_tag) : this.context.getString(R.string.picture_webp_tag)));
            } else {
                contentHolder.tvImageMimeType.setVisibility(8);
            }
            if (PictureMimeType.isHasImage(image.getMimeType())) {
                if (image.loadLongImageStatus == -1) {
                    image.isLongImage = isLongImg;
                    image.loadLongImageStatus = 0;
                }
                contentHolder.tvLongChart.setVisibility(image.isLongImage ? 0 : 8);
            } else {
                image.loadLongImageStatus = -1;
                contentHolder.tvLongChart.setVisibility(8);
            }
            boolean isHasVideo = PictureMimeType.isHasVideo(mimeType);
            if (isHasVideo || PictureMimeType.isHasAudio(mimeType)) {
                contentHolder.tvDuration.setVisibility(0);
                contentHolder.tvDuration.setText((CharSequence)DateUtils.formatDurationTime(image.getDuration()));
                if (PictureSelectionConfig.uiStyle != null) {
                    if (isHasVideo) {
                        if (PictureSelectionConfig.uiStyle.picture_adapter_item_video_textLeftDrawable != 0) {
                            contentHolder.tvDuration.setCompoundDrawablesRelativeWithIntrinsicBounds(PictureSelectionConfig.uiStyle.picture_adapter_item_video_textLeftDrawable, 0, 0, 0);
                        } else {
                            contentHolder.tvDuration.setCompoundDrawablesRelativeWithIntrinsicBounds(R.drawable.picture_icon_video, 0, 0, 0);
                        }
                    } else if (PictureSelectionConfig.uiStyle.picture_adapter_item_audio_textLeftDrawable != 0) {
                        contentHolder.tvDuration.setCompoundDrawablesRelativeWithIntrinsicBounds(PictureSelectionConfig.uiStyle.picture_adapter_item_audio_textLeftDrawable, 0, 0, 0);
                    } else {
                        contentHolder.tvDuration.setCompoundDrawablesRelativeWithIntrinsicBounds(R.drawable.picture_icon_audio, 0, 0, 0);
                    }
                } else {
                    contentHolder.tvDuration.setCompoundDrawablesRelativeWithIntrinsicBounds(isHasVideo ? R.drawable.picture_icon_video : R.drawable.picture_icon_audio, 0, 0, 0);
                }
            } else {
                contentHolder.tvDuration.setVisibility(8);
            }
            if (this.config.chooseMode == PictureMimeType.ofAudio()) {
                contentHolder.ivPicture.setImageResource(R.drawable.picture_audio_placeholder);
            } else if (PictureSelectionConfig.imageEngine != null) {
                PictureSelectionConfig.imageEngine.loadGridImage(this.context, path, contentHolder.ivPicture);
            }
            if (this.config.enablePreview || this.config.enPreviewVideo || this.config.enablePreviewAudio) {
                contentHolder.btnCheck.setOnClickListener(v -> {
                    String newPath;
                    if (this.config.isMaxSelectEnabledMask) {
                        if (this.config.isWithVideoImage) {
                            String errorMsg;
                            boolean isNotOption;
                            int selectedCount = this.getSelectedSize();
                            int videoSize = 0;
                            for (int i = 0; i < selectedCount; ++i) {
                                LocalMedia media = this.selectData.get(i);
                                if (!PictureMimeType.isHasVideo(media.getMimeType())) continue;
                                ++videoSize;
                            }
                            if (PictureMimeType.isHasVideo(image.getMimeType())) {
                                isNotOption = !contentHolder.tvCheck.isSelected() && videoSize >= this.config.maxVideoSelectNum;
                                errorMsg = StringUtils.getMsg(this.context, image.getMimeType(), this.config.maxVideoSelectNum);
                            } else {
                                isNotOption = !contentHolder.tvCheck.isSelected() && selectedCount >= this.config.maxSelectNum;
                                errorMsg = StringUtils.getMsg(this.context, image.getMimeType(), this.config.maxSelectNum);
                            }
                            if (isNotOption) {
                                this.showPromptDialog(errorMsg);
                                return;
                            }
                        } else if (!contentHolder.tvCheck.isSelected() && this.getSelectedSize() >= this.config.maxSelectNum) {
                            String msg = StringUtils.getMsg(this.context, image.getMimeType(), this.config.maxSelectNum);
                            this.showPromptDialog(msg);
                            return;
                        }
                    }
                    if (!TextUtils.isEmpty((CharSequence)(newPath = image.getRealPath())) && !new File(newPath).exists()) {
                        ToastUtils.s(this.context, PictureMimeType.s(this.context, mimeType));
                        return;
                    }
                    this.changeCheckboxState(contentHolder, image);
                });
            }
            contentHolder.contentView.setOnClickListener(v -> {
                boolean eqResult;
                int index;
                if (this.config.isMaxSelectEnabledMask && image.isMaxSelectEnabledMask()) {
                    return;
                }
                String newPath = image.getRealPath();
                if (!TextUtils.isEmpty((CharSequence)newPath) && !new File(newPath).exists()) {
                    ToastUtils.s(this.context, PictureMimeType.s(this.context, mimeType));
                    return;
                }
                int n = index = this.showCamera ? position - 1 : position;
                if (index == -1) {
                    return;
                }
                boolean bl = eqResult = PictureMimeType.isHasImage(mimeType) && this.config.enablePreview || this.config.isSingleDirectReturn || PictureMimeType.isHasVideo(mimeType) && (this.config.enPreviewVideo || this.config.selectionMode == 1) || PictureMimeType.isHasAudio(mimeType) && (this.config.enablePreviewAudio || this.config.selectionMode == 1);
                if (eqResult) {
                    if (PictureMimeType.isHasVideo(image.getMimeType())) {
                        if (this.config.videoMinSecond > 0 && image.getDuration() < (long)this.config.videoMinSecond) {
                            this.showPromptDialog(this.context.getString(R.string.picture_choose_min_seconds, new Object[]{this.config.videoMinSecond / 1000}));
                            return;
                        }
                        if (this.config.videoMaxSecond > 0 && image.getDuration() > (long)this.config.videoMaxSecond) {
                            this.showPromptDialog(this.context.getString(R.string.picture_choose_max_seconds, new Object[]{this.config.videoMaxSecond / 1000}));
                            return;
                        }
                    }
                    this.imageSelectChangedListener.onPictureClick(image, index);
                } else {
                    this.changeCheckboxState(contentHolder, image);
                }
            });
        }
    }

    private void dispatchHandleMask(ViewHolder contentHolder, LocalMedia item) {
        if (this.config.isWithVideoImage && this.config.maxVideoSelectNum > 0) {
            if (this.getSelectedSize() >= this.config.maxSelectNum) {
                boolean isSelected = contentHolder.tvCheck.isSelected();
                ColorFilter colorFilter = BlendModeColorFilterCompat.createBlendModeColorFilterCompat((int)(isSelected ? ContextCompat.getColor((Context)this.context, (int)R.color.picture_color_80) : ContextCompat.getColor((Context)this.context, (int)R.color.picture_color_half_white)), (BlendModeCompat)BlendModeCompat.SRC_ATOP);
                contentHolder.ivPicture.setColorFilter(colorFilter);
                item.setMaxSelectEnabledMask(!isSelected);
            } else {
                item.setMaxSelectEnabledMask(false);
            }
        } else {
            LocalMedia media;
            LocalMedia localMedia = media = this.selectData.size() > 0 ? this.selectData.get(0) : null;
            if (media != null) {
                boolean isSelected = contentHolder.tvCheck.isSelected();
                if (this.config.chooseMode == PictureMimeType.ofAll()) {
                    if (PictureMimeType.isHasImage(media.getMimeType())) {
                        if (!isSelected && !PictureMimeType.isHasImage(item.getMimeType())) {
                            ColorFilter colorFilter = BlendModeColorFilterCompat.createBlendModeColorFilterCompat((int)ContextCompat.getColor((Context)this.context, (int)(PictureMimeType.isHasVideo(item.getMimeType()) ? R.color.picture_color_half_white : R.color.picture_color_20)), (BlendModeCompat)BlendModeCompat.SRC_ATOP);
                            contentHolder.ivPicture.setColorFilter(colorFilter);
                        }
                        item.setMaxSelectEnabledMask(PictureMimeType.isHasVideo(item.getMimeType()));
                    } else if (PictureMimeType.isHasVideo(media.getMimeType())) {
                        if (!isSelected && !PictureMimeType.isHasVideo(item.getMimeType())) {
                            ColorFilter colorFilter = BlendModeColorFilterCompat.createBlendModeColorFilterCompat((int)ContextCompat.getColor((Context)this.context, (int)(PictureMimeType.isHasImage(item.getMimeType()) ? R.color.picture_color_half_white : R.color.picture_color_20)), (BlendModeCompat)BlendModeCompat.SRC_ATOP);
                            contentHolder.ivPicture.setColorFilter(colorFilter);
                        }
                        item.setMaxSelectEnabledMask(PictureMimeType.isHasImage(item.getMimeType()));
                    }
                } else if (this.config.chooseMode == PictureMimeType.ofVideo() && this.config.maxVideoSelectNum > 0) {
                    if (!isSelected && this.getSelectedSize() == this.config.maxVideoSelectNum) {
                        ColorFilter colorFilter = BlendModeColorFilterCompat.createBlendModeColorFilterCompat((int)ContextCompat.getColor((Context)this.context, (int)R.color.picture_color_half_white), (BlendModeCompat)BlendModeCompat.SRC_ATOP);
                        contentHolder.ivPicture.setColorFilter(colorFilter);
                    }
                    item.setMaxSelectEnabledMask(!isSelected && this.getSelectedSize() == this.config.maxVideoSelectNum);
                } else {
                    if (!isSelected && this.getSelectedSize() == this.config.maxSelectNum) {
                        ColorFilter colorFilter = BlendModeColorFilterCompat.createBlendModeColorFilterCompat((int)ContextCompat.getColor((Context)this.context, (int)R.color.picture_color_half_white), (BlendModeCompat)BlendModeCompat.SRC_ATOP);
                        contentHolder.ivPicture.setColorFilter(colorFilter);
                    }
                    item.setMaxSelectEnabledMask(!isSelected && this.getSelectedSize() == this.config.maxSelectNum);
                }
            } else {
                item.setMaxSelectEnabledMask(false);
            }
        }
    }

    public int getItemCount() {
        return this.showCamera ? this.data.size() + 1 : this.data.size();
    }

    public boolean isSelected(LocalMedia image) {
        int size = this.selectData.size();
        for (int i = 0; i < size; ++i) {
            LocalMedia media = this.selectData.get(i);
            if (media == null || TextUtils.isEmpty((CharSequence)media.getPath()) || !TextUtils.equals((CharSequence)media.getPath(), (CharSequence)image.getPath()) && media.getId() != image.getId()) continue;
            this.setLocalMediaCropInfo(media, image);
            return true;
        }
        return false;
    }

    private void setLocalMediaCropInfo(LocalMedia selectedMedia, LocalMedia curMedia) {
        if (selectedMedia.isEditorImage() && !curMedia.isEditorImage()) {
            curMedia.setCut(selectedMedia.isCut());
            curMedia.setCutPath(selectedMedia.getCutPath());
            curMedia.setCropImageWidth(selectedMedia.getCropImageWidth());
            curMedia.setCropImageHeight(selectedMedia.getCropImageHeight());
            curMedia.setCropOffsetX(selectedMedia.getCropOffsetX());
            curMedia.setCropOffsetY(selectedMedia.getCropOffsetY());
            curMedia.setCropResultAspectRatio(selectedMedia.getCropResultAspectRatio());
            curMedia.setAndroidQToPath(selectedMedia.getAndroidQToPath());
            curMedia.setEditorImage(selectedMedia.isEditorImage());
        }
    }

    private void notifyCheckChanged(ViewHolder viewHolder, LocalMedia imageBean) {
        viewHolder.tvCheck.setText((CharSequence)"");
        int size = this.selectData.size();
        for (int i = 0; i < size; ++i) {
            LocalMedia media = this.selectData.get(i);
            if (!media.getPath().equals(imageBean.getPath()) && media.getId() != imageBean.getId()) continue;
            imageBean.setNum(media.getNum());
            media.setPosition(imageBean.getPosition());
            viewHolder.tvCheck.setText((CharSequence)ValueOf.toString(imageBean.getNum()));
        }
    }

    @SuppressLint(value={"StringFormatMatches"})
    private void changeCheckboxState(ViewHolder contentHolder, LocalMedia image) {
        String mimeType;
        boolean isChecked = contentHolder.tvCheck.isSelected();
        int count = this.selectData.size();
        String string2 = mimeType = count > 0 ? this.selectData.get(0).getMimeType() : "";
        if (this.config.isWithVideoImage) {
            int videoSize = 0;
            for (int i = 0; i < count; ++i) {
                LocalMedia media = this.selectData.get(i);
                if (!PictureMimeType.isHasVideo(media.getMimeType())) continue;
                ++videoSize;
            }
            if (PictureMimeType.isHasVideo(image.getMimeType())) {
                if (this.config.maxVideoSelectNum <= 0) {
                    this.showPromptDialog(this.context.getString(R.string.picture_rule));
                    return;
                }
                if (count >= this.config.maxSelectNum && !isChecked) {
                    this.showPromptDialog(this.context.getString(R.string.picture_message_max_num, new Object[]{this.config.maxSelectNum}));
                    return;
                }
                if (videoSize >= this.config.maxVideoSelectNum && !isChecked) {
                    this.showPromptDialog(StringUtils.getMsg(this.context, image.getMimeType(), this.config.maxVideoSelectNum));
                    return;
                }
                if (!isChecked && this.config.videoMinSecond > 0 && image.getDuration() < (long)this.config.videoMinSecond) {
                    this.showPromptDialog(this.context.getString(R.string.picture_choose_min_seconds, new Object[]{this.config.videoMinSecond / 1000}));
                    return;
                }
                if (!isChecked && this.config.videoMaxSecond > 0 && image.getDuration() > (long)this.config.videoMaxSecond) {
                    this.showPromptDialog(this.context.getString(R.string.picture_choose_max_seconds, new Object[]{this.config.videoMaxSecond / 1000}));
                    return;
                }
            } else if (count >= this.config.maxSelectNum && !isChecked) {
                this.showPromptDialog(this.context.getString(R.string.picture_message_max_num, new Object[]{this.config.maxSelectNum}));
                return;
            }
        } else {
            boolean mimeTypeSame;
            if (!TextUtils.isEmpty((CharSequence)mimeType) && !(mimeTypeSame = PictureMimeType.isMimeTypeSame(mimeType, image.getMimeType()))) {
                this.showPromptDialog(this.context.getString(R.string.picture_rule));
                return;
            }
            if (PictureMimeType.isHasVideo(mimeType) && this.config.maxVideoSelectNum > 0) {
                if (count >= this.config.maxVideoSelectNum && !isChecked) {
                    this.showPromptDialog(StringUtils.getMsg(this.context, mimeType, this.config.maxVideoSelectNum));
                    return;
                }
                if (!isChecked && this.config.videoMinSecond > 0 && image.getDuration() < (long)this.config.videoMinSecond) {
                    this.showPromptDialog(this.context.getString(R.string.picture_choose_min_seconds, new Object[]{this.config.videoMinSecond / 1000}));
                    return;
                }
                if (!isChecked && this.config.videoMaxSecond > 0 && image.getDuration() > (long)this.config.videoMaxSecond) {
                    this.showPromptDialog(this.context.getString(R.string.picture_choose_max_seconds, new Object[]{this.config.videoMaxSecond / 1000}));
                    return;
                }
            } else {
                if (count >= this.config.maxSelectNum && !isChecked) {
                    this.showPromptDialog(StringUtils.getMsg(this.context, mimeType, this.config.maxSelectNum));
                    return;
                }
                if (PictureMimeType.isHasVideo(image.getMimeType())) {
                    if (!isChecked && this.config.videoMinSecond > 0 && image.getDuration() < (long)this.config.videoMinSecond) {
                        this.showPromptDialog(this.context.getString(R.string.picture_choose_min_seconds, new Object[]{this.config.videoMinSecond / 1000}));
                        return;
                    }
                    if (!isChecked && this.config.videoMaxSecond > 0 && image.getDuration() > (long)this.config.videoMaxSecond) {
                        this.showPromptDialog(this.context.getString(R.string.picture_choose_max_seconds, new Object[]{this.config.videoMaxSecond / 1000}));
                        return;
                    }
                }
            }
        }
        if (isChecked) {
            for (int i = 0; i < count; ++i) {
                LocalMedia media = this.selectData.get(i);
                if (media == null || TextUtils.isEmpty((CharSequence)media.getPath()) || !media.getPath().equals(image.getPath()) && media.getId() != image.getId()) continue;
                this.selectData.remove(media);
                this.subSelectPosition();
                AnimUtils.disZoom((View)contentHolder.ivPicture, this.config.zoomAnim);
                break;
            }
        } else {
            if (this.config.selectionMode == 1) {
                this.singleRadioMediaImage();
            }
            this.selectData.add(image);
            image.setNum(this.selectData.size());
            VoiceUtils.getInstance().play();
            AnimUtils.zoom((View)contentHolder.ivPicture, this.config.zoomAnim);
            contentHolder.tvCheck.startAnimation(AnimationUtils.loadAnimation((Context)this.context, (int)R.anim.picture_anim_modal_in));
        }
        boolean isRefreshAll = false;
        if (this.config.isMaxSelectEnabledMask) {
            if (this.config.chooseMode == PictureMimeType.ofAll()) {
                if (this.config.isWithVideoImage && this.config.maxVideoSelectNum > 0) {
                    if (this.getSelectedSize() >= this.config.maxSelectNum) {
                        isRefreshAll = true;
                    }
                    if (isChecked && this.getSelectedSize() == this.config.maxSelectNum - 1) {
                        isRefreshAll = true;
                    }
                } else {
                    if (!isChecked && this.getSelectedSize() == 1) {
                        isRefreshAll = true;
                    }
                    if (isChecked && this.getSelectedSize() == 0) {
                        isRefreshAll = true;
                    }
                }
            } else if (this.config.chooseMode == PictureMimeType.ofVideo() && this.config.maxVideoSelectNum > 0) {
                if (!isChecked && this.getSelectedSize() == this.config.maxVideoSelectNum) {
                    isRefreshAll = true;
                }
                if (isChecked && this.getSelectedSize() == this.config.maxVideoSelectNum - 1) {
                    isRefreshAll = true;
                }
            } else {
                if (!isChecked && this.getSelectedSize() == this.config.maxSelectNum) {
                    isRefreshAll = true;
                }
                if (isChecked && this.getSelectedSize() == this.config.maxSelectNum - 1) {
                    isRefreshAll = true;
                }
            }
        }
        if (isRefreshAll) {
            this.notifyDataSetChanged();
        } else {
            this.notifyItemChanged(contentHolder.getAbsoluteAdapterPosition());
        }
        this.selectImage(contentHolder, !isChecked);
        if (this.imageSelectChangedListener != null) {
            this.imageSelectChangedListener.onChange(this.selectData);
        }
    }

    private void singleRadioMediaImage() {
        if (this.selectData != null && this.selectData.size() > 0) {
            LocalMedia media = this.selectData.get(0);
            this.notifyItemChanged(media.position);
            this.selectData.clear();
        }
    }

    private void subSelectPosition() {
        if (this.config.checkNumMode) {
            int size = this.selectData.size();
            for (int index = 0; index < size; ++index) {
                LocalMedia media = this.selectData.get(index);
                media.setNum(index + 1);
                this.notifyItemChanged(media.position);
            }
        }
    }

    public void selectImage(ViewHolder holder, boolean isChecked) {
        holder.tvCheck.setSelected(isChecked);
        ColorFilter colorFilter = BlendModeColorFilterCompat.createBlendModeColorFilterCompat((int)(isChecked ? ContextCompat.getColor((Context)this.context, (int)R.color.picture_color_80) : ContextCompat.getColor((Context)this.context, (int)R.color.picture_color_20)), (BlendModeCompat)BlendModeCompat.SRC_ATOP);
        holder.ivPicture.setColorFilter(colorFilter);
    }

    private void showPromptDialog(String content) {
        if (PictureSelectionConfig.onChooseLimitCallback != null) {
            PictureSelectionConfig.onChooseLimitCallback.onChooseLimit(this.context, content);
        } else {
            final PictureCustomDialog dialog = new PictureCustomDialog(this.context, R.layout.picture_prompt_dialog);
            TextView btnOk = (TextView)dialog.findViewById(R.id.btnOk);
            TextView tvContent = (TextView)dialog.findViewById(R.id.tv_content);
            tvContent.setText((CharSequence)content);
            btnOk.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    dialog.dismiss();
                }
            });
            dialog.show();
        }
    }

    public void setOnPhotoSelectChangedListener(OnPhotoSelectChangedListener<LocalMedia> imageSelectChangedListener) {
        this.imageSelectChangedListener = imageSelectChangedListener;
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        ImageView ivPicture;
        ImageView ivEditor;
        TextView tvCheck;
        TextView tvDuration;
        TextView tvImageMimeType;
        TextView tvLongChart;
        View contentView;
        View btnCheck;

        public ViewHolder(View itemView) {
            super(itemView);
            this.contentView = itemView;
            this.ivPicture = (ImageView)itemView.findViewById(R.id.ivPicture);
            this.tvCheck = (TextView)itemView.findViewById(R.id.tvCheck);
            this.btnCheck = itemView.findViewById(R.id.btnCheck);
            this.tvDuration = (TextView)itemView.findViewById(R.id.tv_duration);
            this.tvImageMimeType = (TextView)itemView.findViewById(R.id.tv_image_mime_type);
            this.tvLongChart = (TextView)itemView.findViewById(R.id.tv_long_chart);
            this.ivEditor = (ImageView)itemView.findViewById(R.id.ivEditor);
            if (PictureSelectionConfig.uiStyle != null) {
                if (PictureSelectionConfig.uiStyle.picture_check_style != 0) {
                    this.tvCheck.setBackgroundResource(PictureSelectionConfig.uiStyle.picture_check_style);
                }
                if (PictureSelectionConfig.uiStyle.picture_check_textSize != 0) {
                    this.tvCheck.setTextSize((float)PictureSelectionConfig.uiStyle.picture_check_textSize);
                }
                if (PictureSelectionConfig.uiStyle.picture_check_textColor != 0) {
                    this.tvCheck.setTextColor(PictureSelectionConfig.uiStyle.picture_check_textColor);
                }
                if (PictureSelectionConfig.uiStyle.picture_adapter_item_textSize > 0) {
                    this.tvDuration.setTextSize((float)PictureSelectionConfig.uiStyle.picture_adapter_item_textSize);
                }
                if (PictureSelectionConfig.uiStyle.picture_adapter_item_textColor != 0) {
                    this.tvDuration.setTextColor(PictureSelectionConfig.uiStyle.picture_adapter_item_textColor);
                }
                if (PictureSelectionConfig.uiStyle.picture_adapter_item_tag_text != 0) {
                    this.tvImageMimeType.setText((CharSequence)itemView.getContext().getString(PictureSelectionConfig.uiStyle.picture_adapter_item_tag_text));
                }
                if (PictureSelectionConfig.uiStyle.picture_adapter_item_gif_tag_show) {
                    this.tvImageMimeType.setVisibility(0);
                } else {
                    this.tvImageMimeType.setVisibility(8);
                }
                if (PictureSelectionConfig.uiStyle.picture_adapter_item_gif_tag_background != 0) {
                    this.tvImageMimeType.setBackgroundResource(PictureSelectionConfig.uiStyle.picture_adapter_item_gif_tag_background);
                }
                if (PictureSelectionConfig.uiStyle.picture_adapter_item_editor_tag_icon != 0) {
                    this.ivEditor.setImageResource(PictureSelectionConfig.uiStyle.picture_adapter_item_editor_tag_icon);
                }
                if (PictureSelectionConfig.uiStyle.picture_adapter_item_gif_tag_textColor != 0) {
                    this.tvImageMimeType.setTextColor(PictureSelectionConfig.uiStyle.picture_adapter_item_gif_tag_textColor);
                }
                if (PictureSelectionConfig.uiStyle.picture_adapter_item_gif_tag_textSize != 0) {
                    this.tvImageMimeType.setTextSize((float)PictureSelectionConfig.uiStyle.picture_adapter_item_gif_tag_textSize);
                }
            } else if (PictureSelectionConfig.style != null) {
                if (PictureSelectionConfig.style.pictureCheckedStyle != 0) {
                    this.tvCheck.setBackgroundResource(PictureSelectionConfig.style.pictureCheckedStyle);
                }
                if (PictureSelectionConfig.style.picture_adapter_item_editor_tag_icon != 0) {
                    this.ivEditor.setImageResource(PictureSelectionConfig.style.picture_adapter_item_editor_tag_icon);
                }
            } else {
                Drawable checkedStyleDrawable = AttrsUtils.getTypeValueDrawable(itemView.getContext(), R.attr.picture_checked_style, R.drawable.picture_checkbox_selector);
                this.tvCheck.setBackground(checkedStyleDrawable);
            }
        }
    }

    public class CameraViewHolder
    extends RecyclerView.ViewHolder {
        TextView tvCamera;

        public CameraViewHolder(View itemView) {
            super(itemView);
            this.tvCamera = (TextView)itemView.findViewById(R.id.tvCamera);
            if (PictureSelectionConfig.uiStyle != null) {
                if (PictureSelectionConfig.uiStyle.picture_adapter_item_camera_backgroundColor != 0) {
                    itemView.setBackgroundColor(PictureSelectionConfig.uiStyle.picture_adapter_item_camera_backgroundColor);
                }
                if (PictureSelectionConfig.uiStyle.picture_adapter_item_camera_textSize != 0) {
                    this.tvCamera.setTextSize((float)PictureSelectionConfig.uiStyle.picture_adapter_item_camera_textSize);
                }
                if (PictureSelectionConfig.uiStyle.picture_adapter_item_camera_textColor != 0) {
                    this.tvCamera.setTextColor(PictureSelectionConfig.uiStyle.picture_adapter_item_camera_textColor);
                }
                if (PictureSelectionConfig.uiStyle.picture_adapter_item_camera_text != 0) {
                    this.tvCamera.setText((CharSequence)itemView.getContext().getString(PictureSelectionConfig.uiStyle.picture_adapter_item_camera_text));
                } else {
                    this.tvCamera.setText((CharSequence)(((PictureImageGridAdapter)PictureImageGridAdapter.this).config.chooseMode == PictureMimeType.ofAudio() ? PictureImageGridAdapter.this.context.getString(R.string.picture_tape) : PictureImageGridAdapter.this.context.getString(R.string.picture_take_picture)));
                }
                if (PictureSelectionConfig.uiStyle.picture_adapter_item_camera_textTopDrawable != 0) {
                    this.tvCamera.setCompoundDrawablesWithIntrinsicBounds(0, PictureSelectionConfig.uiStyle.picture_adapter_item_camera_textTopDrawable, 0, 0);
                }
            } else {
                this.tvCamera.setText((CharSequence)(((PictureImageGridAdapter)PictureImageGridAdapter.this).config.chooseMode == PictureMimeType.ofAudio() ? PictureImageGridAdapter.this.context.getString(R.string.picture_tape) : PictureImageGridAdapter.this.context.getString(R.string.picture_take_picture)));
            }
        }
    }
}

