/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import android.view.KeyEvent;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.luck.picture.lib.PictureSelectorCameraEmptyActivity;
import com.luck.picture.lib.R;
import com.luck.picture.lib.camera.CustomCameraView;
import com.luck.picture.lib.camera.listener.CameraListener;
import com.luck.picture.lib.camera.listener.ClickListener;
import com.luck.picture.lib.camera.view.CaptureLayout;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.dialog.PictureCustomDialog;
import com.luck.picture.lib.listener.OnPermissionDialogOptionCallback;
import com.luck.picture.lib.permissions.PermissionChecker;
import java.io.File;

public class PictureCustomCameraActivity
extends PictureSelectorCameraEmptyActivity {
    private static final String TAG = PictureCustomCameraActivity.class.getSimpleName();
    private CustomCameraView mCameraView;
    protected boolean isEnterSetting;

    @Override
    public boolean isImmersive() {
        return false;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        this.getWindow().setFlags(1024, 1024);
        this.getWindow().setFlags(0x4000000, 0x4000000);
        this.getWindow().setFlags(0x8000000, 0x8000000);
        if (Build.VERSION.SDK_INT >= 28) {
            WindowManager.LayoutParams lp = this.getWindow().getAttributes();
            lp.layoutInDisplayCutoutMode = 1;
            this.getWindow().setAttributes(lp);
        }
        this.getWindow().addFlags(128);
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.picture_custom_camera);
        this.mCameraView = (CustomCameraView)this.findViewById(R.id.cameraView);
        this.initView();
        this.requestCamera();
    }

    private void requestCamera() {
        if (PermissionChecker.checkSelfPermission((Context)this, "android.permission.WRITE_EXTERNAL_STORAGE")) {
            if (PermissionChecker.checkSelfPermission((Context)this, "android.permission.CAMERA")) {
                if (this.config.buttonFeatures == 257) {
                    this.mCameraView.initCamera();
                } else if (PermissionChecker.checkSelfPermission((Context)this, "android.permission.RECORD_AUDIO")) {
                    this.mCameraView.initCamera();
                } else {
                    PermissionChecker.requestPermissions((Activity)this, new String[]{"android.permission.RECORD_AUDIO"}, 4);
                }
            } else {
                PermissionChecker.requestPermissions((Activity)this, new String[]{"android.permission.CAMERA"}, 2);
            }
        } else {
            PermissionChecker.requestPermissions((Activity)this, new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}, 1);
        }
    }

    protected void onResume() {
        super.onResume();
        if (this.isEnterSetting) {
            if (PermissionChecker.checkSelfPermission((Context)this, "android.permission.WRITE_EXTERNAL_STORAGE")) {
                if (PermissionChecker.checkSelfPermission((Context)this, "android.permission.CAMERA")) {
                    if (this.config.buttonFeatures == 257) {
                        this.mCameraView.initCamera();
                    } else if (PermissionChecker.checkSelfPermission((Context)this, "android.permission.RECORD_AUDIO")) {
                        this.mCameraView.initCamera();
                    } else {
                        PermissionChecker.requestPermissions((Activity)this, new String[]{"android.permission.RECORD_AUDIO"}, 4);
                    }
                } else {
                    this.showPermissionsDialog(false, new String[]{"android.permission.CAMERA"}, this.getString(R.string.picture_camera));
                }
            } else {
                this.showPermissionsDialog(false, new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}, this.getString(R.string.picture_jurisdiction));
            }
            this.isEnterSetting = false;
        }
    }

    protected void initView() {
        CaptureLayout captureLayout;
        if (this.config.recordVideoSecond > 0) {
            this.mCameraView.setRecordVideoMaxTime(this.config.recordVideoSecond);
        }
        if (this.config.recordVideoMinSecond > 0) {
            this.mCameraView.setRecordVideoMinTime(this.config.recordVideoMinSecond);
        }
        if (this.config.captureLoadingColor != 0) {
            this.mCameraView.setCaptureLoadingColor(this.config.captureLoadingColor);
        }
        if ((captureLayout = this.mCameraView.getCaptureLayout()) != null) {
            captureLayout.setButtonFeatures(this.config.buttonFeatures);
        }
        this.mCameraView.setImageCallbackListener((file, imageView) -> {
            if (this.config != null && PictureSelectionConfig.imageEngine != null && file != null) {
                PictureSelectionConfig.imageEngine.loadImage(this.getContext(), file.getAbsolutePath(), imageView);
            }
        });
        this.mCameraView.setCameraListener(new CameraListener(){

            @Override
            public void onPictureSuccess(@NonNull File file) {
                PictureCustomCameraActivity.this.config.cameraMimeType = PictureMimeType.ofImage();
                Intent intent = new Intent();
                intent.putExtra("mediaPath", file.getAbsolutePath());
                intent.putExtra("PictureSelectorConfig", (Parcelable)PictureCustomCameraActivity.this.config);
                if (PictureCustomCameraActivity.this.config.camera) {
                    PictureCustomCameraActivity.this.dispatchHandleCamera(intent);
                } else {
                    PictureCustomCameraActivity.this.setResult(-1, intent);
                    PictureCustomCameraActivity.this.onBackPressed();
                }
            }

            @Override
            public void onRecordSuccess(@NonNull File file) {
                PictureCustomCameraActivity.this.config.cameraMimeType = PictureMimeType.ofVideo();
                Intent intent = new Intent();
                intent.putExtra("mediaPath", file.getAbsolutePath());
                intent.putExtra("PictureSelectorConfig", (Parcelable)PictureCustomCameraActivity.this.config);
                if (PictureCustomCameraActivity.this.config.camera) {
                    PictureCustomCameraActivity.this.dispatchHandleCamera(intent);
                } else {
                    PictureCustomCameraActivity.this.setResult(-1, intent);
                    PictureCustomCameraActivity.this.onBackPressed();
                }
            }

            @Override
            public void onError(int videoCaptureError, @NonNull String message, @Nullable Throwable cause) {
                Log.i((String)TAG, (String)("onError: " + message));
            }
        });
        this.mCameraView.setOnClickListener(new ClickListener(){

            @Override
            public void onClick() {
                PictureCustomCameraActivity.this.onBackPressed();
            }
        });
    }

    @Override
    public void onBackPressed() {
        if (this.config != null && this.config.camera && PictureSelectionConfig.listener != null) {
            PictureSelectionConfig.listener.onCancel();
        }
        this.exit();
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            this.mCameraView.onCancelMedia();
        }
        return super.onKeyDown(keyCode, event);
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        switch (requestCode) {
            case 1: {
                if (grantResults.length > 0 && grantResults[0] == 0) {
                    PermissionChecker.requestPermissions((Activity)this, new String[]{"android.permission.CAMERA"}, 2);
                    break;
                }
                this.showPermissionsDialog(true, new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}, this.getString(R.string.picture_jurisdiction));
                break;
            }
            case 2: {
                if (grantResults.length > 0 && grantResults[0] == 0) {
                    if (PermissionChecker.checkSelfPermission((Context)this, "android.permission.RECORD_AUDIO")) {
                        this.mCameraView.initCamera();
                        break;
                    }
                    PermissionChecker.requestPermissions((Activity)this, new String[]{"android.permission.RECORD_AUDIO"}, 4);
                    break;
                }
                this.showPermissionsDialog(true, new String[]{"android.permission.CAMERA"}, this.getString(R.string.picture_camera));
                break;
            }
            case 4: {
                if (grantResults.length > 0 && grantResults[0] == 0) {
                    this.mCameraView.initCamera();
                    break;
                }
                this.showPermissionsDialog(false, new String[]{"android.permission.RECORD_AUDIO"}, this.getString(R.string.picture_audio));
            }
        }
    }

    @Override
    protected void showPermissionsDialog(boolean isCamera, String[] permissions, String errorMsg) {
        if (this.isFinishing()) {
            return;
        }
        if (PictureSelectionConfig.onPermissionsObtainCallback != null) {
            PictureSelectionConfig.onPermissionsObtainCallback.onPermissionsIntercept(this.getContext(), isCamera, permissions, errorMsg, new OnPermissionDialogOptionCallback(){

                @Override
                public void onCancel() {
                    if (PictureSelectionConfig.listener != null) {
                        PictureSelectionConfig.listener.onCancel();
                    }
                    PictureCustomCameraActivity.this.exit();
                }

                @Override
                public void onSetting() {
                    PictureCustomCameraActivity.this.isEnterSetting = true;
                }
            });
            return;
        }
        PictureCustomDialog dialog = new PictureCustomDialog(this.getContext(), R.layout.picture_wind_base_dialog);
        dialog.setCancelable(false);
        dialog.setCanceledOnTouchOutside(false);
        Button btn_cancel = (Button)dialog.findViewById(R.id.btn_cancel);
        Button btn_commit = (Button)dialog.findViewById(R.id.btn_commit);
        btn_commit.setText((CharSequence)this.getString(R.string.picture_go_setting));
        TextView tvTitle = (TextView)dialog.findViewById(R.id.tvTitle);
        TextView tv_content = (TextView)dialog.findViewById(R.id.tv_content);
        tvTitle.setText((CharSequence)this.getString(R.string.picture_prompt));
        tv_content.setText((CharSequence)errorMsg);
        btn_cancel.setOnClickListener(v -> {
            if (!this.isFinishing()) {
                dialog.dismiss();
            }
            if (PictureSelectionConfig.listener != null) {
                PictureSelectionConfig.listener.onCancel();
            }
            this.exit();
        });
        btn_commit.setOnClickListener(v -> {
            if (!this.isFinishing()) {
                dialog.dismiss();
            }
            PermissionChecker.launchAppDetailsSettings(this.getContext());
            this.isEnterSetting = true;
        });
        dialog.show();
    }
}

