/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.tools;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class BitmapUtils {
    public static Bitmap rotatingImage(Bitmap bitmap, int angle) {
        Matrix matrix = new Matrix();
        matrix.postRotate((float)angle);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
    }

    public static void rotateImage(int degree, String path) {
        if (degree > 0) {
            try {
                BitmapFactory.Options opts = new BitmapFactory.Options();
                opts.inSampleSize = 2;
                File file = new File(path);
                Bitmap bitmap = BitmapFactory.decodeFile((String)file.getAbsolutePath(), (BitmapFactory.Options)opts);
                bitmap = BitmapUtils.rotatingImage(bitmap, degree);
                if (bitmap != null) {
                    BitmapUtils.saveBitmapFile(bitmap, file);
                    bitmap.recycle();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void saveBitmapFile(Bitmap bitmap, File file) {
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)bos);
            bos.flush();
            bos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int getRotationAngle(int orientation) {
        switch (orientation) {
            case 1: {
                return 0;
            }
            case 3: {
                return 180;
            }
            case 6: {
                return 90;
            }
            case 8: {
                return 270;
            }
        }
        return 0;
    }
}

