/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.compress;

import android.content.Context;
import android.net.Uri;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import com.luck.picture.lib.compress.Checker;
import com.luck.picture.lib.compress.CompressionPredicate;
import com.luck.picture.lib.compress.Engine;
import com.luck.picture.lib.compress.InputStreamAdapter;
import com.luck.picture.lib.compress.InputStreamProvider;
import com.luck.picture.lib.compress.OnCompressListener;
import com.luck.picture.lib.compress.OnRenameListener;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.thread.PictureThreadUtils;
import com.luck.picture.lib.tools.AndroidQTransformUtils;
import com.luck.picture.lib.tools.DateUtils;
import com.luck.picture.lib.tools.SdkVersionUtils;
import com.luck.picture.lib.tools.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Luban {
    private static final String TAG = "Luban";
    private String mTargetDir;
    private final String mNewFileName;
    private final boolean focusAlpha;
    private final boolean isCamera;
    private final int mLeastCompressSize;
    private final OnRenameListener mRenameListener;
    private final OnCompressListener mCompressListener;
    private final CompressionPredicate mCompressionPredicate;
    private final List<InputStreamProvider> mStreamProviders;
    private final List<String> mPaths;
    private final List<LocalMedia> mediaList;
    private int index = -1;
    private final int compressQuality;
    private final int dataCount;

    private Luban(Builder builder) {
        this.mPaths = builder.mPaths;
        this.mediaList = builder.mediaList;
        this.dataCount = builder.dataCount;
        this.mTargetDir = builder.mTargetDir;
        this.mNewFileName = builder.mNewFileName;
        this.mRenameListener = builder.mRenameListener;
        this.mStreamProviders = builder.mStreamProviders;
        this.mCompressListener = builder.mCompressListener;
        this.mLeastCompressSize = builder.mLeastCompressSize;
        this.mCompressionPredicate = builder.mCompressionPredicate;
        this.compressQuality = builder.compressQuality;
        this.focusAlpha = builder.focusAlpha;
        this.isCamera = builder.isCamera;
    }

    public static Builder with(Context context) {
        return new Builder(context);
    }

    private File getImageCacheFile(Context context, InputStreamProvider provider, String suffix) {
        File imageCacheDir;
        if (TextUtils.isEmpty((CharSequence)this.mTargetDir) && (imageCacheDir = Luban.getImageCacheDir(context)) != null) {
            this.mTargetDir = imageCacheDir.getAbsolutePath();
        }
        String cacheBuilder = "";
        try {
            LocalMedia media = provider.getMedia();
            String encryptionValue = StringUtils.getEncryptionValue(media.getId(), media.getWidth(), media.getHeight());
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.mTargetDir);
            if (!TextUtils.isEmpty((CharSequence)encryptionValue) && !media.isCut()) {
                cacheBuilder = stringBuilder.append("/IMG_CMP_").append(encryptionValue).append(TextUtils.isEmpty((CharSequence)suffix) ? ".jpeg" : suffix).toString();
            } else {
                String imgCmpTime_ = DateUtils.getCreateFileName("IMG_CMP_");
                cacheBuilder = stringBuilder.append("/").append(imgCmpTime_).append(TextUtils.isEmpty((CharSequence)suffix) ? ".jpeg" : suffix).toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new File(cacheBuilder);
    }

    private File getImageCustomFile(Context context, String filename) {
        if (TextUtils.isEmpty((CharSequence)this.mTargetDir)) {
            File imageCacheDir = Luban.getImageCacheDir(context);
            this.mTargetDir = imageCacheDir != null ? imageCacheDir.getAbsolutePath() : "";
        }
        String cacheBuilder = this.mTargetDir + "/" + filename;
        return new File(cacheBuilder);
    }

    private static File getImageCacheDir(Context context) {
        File cacheDir = context.getExternalFilesDir(Environment.DIRECTORY_PICTURES);
        if (cacheDir != null) {
            if (!(cacheDir.mkdirs() || cacheDir.exists() && cacheDir.isDirectory())) {
                return null;
            }
            return cacheDir;
        }
        if (Log.isLoggable((String)TAG, (int)6)) {
            Log.e((String)TAG, (String)"default disk cache dir is null");
        }
        return null;
    }

    private void launch(final Context context) {
        if (this.mStreamProviders == null || this.mPaths == null || this.mStreamProviders.size() == 0 && this.mCompressListener != null) {
            this.mCompressListener.onError(new NullPointerException("image file cannot be null"));
            return;
        }
        final Iterator<InputStreamProvider> iterator = this.mStreamProviders.iterator();
        if (this.mCompressListener != null) {
            this.mCompressListener.onStart();
        }
        PictureThreadUtils.executeBySingle(new PictureThreadUtils.SimpleTask<List<LocalMedia>>(){

            @Override
            public List<LocalMedia> doInBackground() {
                Luban.this.index = -1;
                while (iterator.hasNext()) {
                    try {
                        String newPath;
                        Luban.this.index++;
                        InputStreamProvider path = (InputStreamProvider)iterator.next();
                        if (path.getMedia().isCompressed() && !TextUtils.isEmpty((CharSequence)path.getMedia().getCompressPath())) {
                            boolean exists = !path.getMedia().isCut() && new File(path.getMedia().getCompressPath()).exists();
                            File result = exists ? new File(path.getMedia().getCompressPath()) : Luban.this.compress(context, path);
                            newPath = result.getAbsolutePath();
                        } else if (PictureMimeType.isHasHttp(path.getMedia().getPath()) && TextUtils.isEmpty((CharSequence)path.getMedia().getCutPath())) {
                            newPath = path.getMedia().getPath();
                        } else {
                            File result = PictureMimeType.isHasVideo(path.getMedia().getMimeType()) ? new File(path.getPath()) : Luban.this.compress(context, path);
                            newPath = result.getAbsolutePath();
                        }
                        if (Luban.this.mediaList != null && Luban.this.mediaList.size() > 0) {
                            boolean isLast;
                            LocalMedia media = (LocalMedia)Luban.this.mediaList.get(Luban.this.index);
                            boolean isHasHttp = PictureMimeType.isHasHttp(newPath);
                            boolean isHasVideo = PictureMimeType.isHasVideo(media.getMimeType());
                            media.setCompressed(!isHasHttp && !isHasVideo);
                            media.setCompressPath(isHasHttp || isHasVideo ? null : newPath);
                            media.setAndroidQToPath(SdkVersionUtils.checkedAndroid_Q() ? media.getCompressPath() : null);
                            boolean bl = isLast = Luban.this.index == Luban.this.mediaList.size() - 1;
                            if (isLast) {
                                return Luban.this.mediaList;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    iterator.remove();
                }
                return null;
            }

            @Override
            public void onSuccess(List<LocalMedia> result) {
                if (Luban.this.mCompressListener == null) {
                    return;
                }
                if (result != null) {
                    Luban.this.mCompressListener.onSuccess(result);
                } else {
                    Luban.this.mCompressListener.onError(new Throwable("Failed to compress file"));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File get(InputStreamProvider input, Context context) throws IOException {
        try {
            File file = new Engine(input, this.getImageCacheFile(context, input, Checker.SINGLE.extSuffix(input.getMedia().getMimeType())), this.focusAlpha, this.compressQuality).compress();
            return file;
        }
        finally {
            input.close();
        }
    }

    private List<File> get(Context context) throws Exception {
        ArrayList<File> results = new ArrayList<File>();
        Iterator<InputStreamProvider> iterator = this.mStreamProviders.iterator();
        while (iterator.hasNext()) {
            InputStreamProvider provider = iterator.next();
            if (provider.getMedia() == null) continue;
            if (provider.getMedia().isCompressed() && !TextUtils.isEmpty((CharSequence)provider.getMedia().getCompressPath())) {
                boolean exists = !provider.getMedia().isCut() && new File(provider.getMedia().getCompressPath()).exists();
                File oldFile = exists ? new File(provider.getMedia().getCompressPath()) : this.compress(context, provider);
                results.add(oldFile);
            } else {
                boolean isHasHttp = PictureMimeType.isHasHttp(provider.getMedia().getPath()) && TextUtils.isEmpty((CharSequence)provider.getMedia().getCutPath());
                boolean isHasVideo = PictureMimeType.isHasVideo(provider.getMedia().getMimeType());
                results.add(isHasHttp || isHasVideo ? new File(provider.getMedia().getPath()) : this.compress(context, provider));
            }
            iterator.remove();
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File compress(Context context, InputStreamProvider path) throws Exception {
        try {
            File file = this.compressRealLocalMedia(context, path);
            return file;
        }
        finally {
            path.close();
        }
    }

    private File compressReal(Context context, InputStreamProvider streamProvider) throws IOException {
        String suffix = Checker.SINGLE.extSuffix(streamProvider.getMedia() != null ? streamProvider.getMedia().getMimeType() : "");
        File outFile = this.getImageCacheFile(context, streamProvider, TextUtils.isEmpty((CharSequence)suffix) ? suffix : suffix);
        if (this.mRenameListener != null) {
            String filename = this.mRenameListener.rename(streamProvider.getPath());
            outFile = this.getImageCustomFile(context, filename);
        }
        File result = this.mCompressionPredicate != null ? (this.mCompressionPredicate.apply(streamProvider.getPath()) && Checker.SINGLE.needCompress(this.mLeastCompressSize, streamProvider.getPath()) ? new Engine(streamProvider, outFile, this.focusAlpha, this.compressQuality).compress() : new File(streamProvider.getPath())) : (suffix.startsWith(".gif") ? new File(streamProvider.getPath()) : (Checker.SINGLE.needCompress(this.mLeastCompressSize, streamProvider.getPath()) ? new Engine(streamProvider, outFile, this.focusAlpha, this.compressQuality).compress() : new File(streamProvider.getPath())));
        return result;
    }

    private File compressRealLocalMedia(Context context, InputStreamProvider streamProvider) throws Exception {
        File result;
        LocalMedia media = streamProvider.getMedia();
        String newPath = media.isCut() && !TextUtils.isEmpty((CharSequence)media.getCutPath()) ? media.getCutPath() : media.getRealPath();
        String suffix = Checker.SINGLE.extSuffix(media.getMimeType());
        File outFile = this.getImageCacheFile(context, streamProvider, suffix);
        String filename = "";
        if (!TextUtils.isEmpty((CharSequence)this.mNewFileName)) {
            filename = this.isCamera || this.dataCount == 1 ? this.mNewFileName : StringUtils.rename(this.mNewFileName);
            outFile = this.getImageCustomFile(context, filename);
        }
        if (outFile.exists()) {
            return outFile;
        }
        if (this.mCompressionPredicate != null) {
            if (suffix.startsWith(".gif")) {
                if (SdkVersionUtils.checkedAndroid_Q()) {
                    if (media.isCut() && !TextUtils.isEmpty((CharSequence)media.getCutPath())) {
                        result = new File(media.getCutPath());
                    } else {
                        String androidQToPath = AndroidQTransformUtils.copyPathToAndroidQ(context, streamProvider.getMedia().getId(), streamProvider.getPath(), media.getWidth(), media.getHeight(), media.getMimeType(), filename);
                        result = new File(androidQToPath);
                    }
                } else {
                    result = new File(newPath);
                }
            } else {
                boolean isCompress = Checker.SINGLE.needCompressToLocalMedia(this.mLeastCompressSize, newPath);
                if (this.mCompressionPredicate.apply(newPath) && isCompress) {
                    result = new Engine(streamProvider, outFile, this.focusAlpha, this.compressQuality).compress();
                } else if (isCompress) {
                    result = new Engine(streamProvider, outFile, this.focusAlpha, this.compressQuality).compress();
                } else if (SdkVersionUtils.checkedAndroid_Q()) {
                    String newFilePath = media.isCut() ? media.getCutPath() : AndroidQTransformUtils.copyPathToAndroidQ(context, media.getId(), streamProvider.getPath(), media.getWidth(), media.getHeight(), media.getMimeType(), filename);
                    result = new File(TextUtils.isEmpty((CharSequence)newFilePath) ? newPath : newFilePath);
                } else {
                    result = new File(newPath);
                }
            }
        } else if (suffix.startsWith(".gif")) {
            if (SdkVersionUtils.checkedAndroid_Q()) {
                String newFilePath = media.isCut() ? media.getCutPath() : AndroidQTransformUtils.copyPathToAndroidQ(context, media.getId(), streamProvider.getPath(), media.getWidth(), media.getHeight(), media.getMimeType(), filename);
                result = new File(TextUtils.isEmpty((CharSequence)newFilePath) ? newPath : newFilePath);
            } else {
                result = new File(newPath);
            }
        } else {
            boolean isCompress = Checker.SINGLE.needCompressToLocalMedia(this.mLeastCompressSize, newPath);
            if (isCompress) {
                result = new Engine(streamProvider, outFile, this.focusAlpha, this.compressQuality).compress();
            } else if (SdkVersionUtils.checkedAndroid_Q()) {
                String newFilePath = media.isCut() ? media.getCutPath() : AndroidQTransformUtils.copyPathToAndroidQ(context, media.getId(), streamProvider.getPath(), media.getWidth(), media.getHeight(), media.getMimeType(), filename);
                result = new File(TextUtils.isEmpty((CharSequence)newFilePath) ? newPath : newFilePath);
            } else {
                result = new File(newPath);
            }
        }
        return result;
    }

    public static class Builder {
        private final Context context;
        private String mTargetDir;
        private String mNewFileName;
        private boolean focusAlpha;
        private boolean isCamera;
        private int compressQuality;
        private int mLeastCompressSize = 100;
        private OnRenameListener mRenameListener;
        private OnCompressListener mCompressListener;
        private CompressionPredicate mCompressionPredicate;
        private final List<InputStreamProvider> mStreamProviders;
        private final List<String> mPaths;
        private List<LocalMedia> mediaList;
        private int dataCount;

        Builder(Context context) {
            this.context = context;
            this.mPaths = new ArrayList<String>();
            this.mediaList = new ArrayList<LocalMedia>();
            this.mStreamProviders = new ArrayList<InputStreamProvider>();
        }

        private Luban build() {
            return new Luban(this);
        }

        public Builder load(InputStreamProvider inputStreamProvider) {
            this.mStreamProviders.add(inputStreamProvider);
            return this;
        }

        public <T> Builder loadMediaData(List<LocalMedia> list) {
            this.mediaList = list;
            this.dataCount = list.size();
            for (LocalMedia src : list) {
                this.load(src);
            }
            return this;
        }

        private Builder load(final LocalMedia media) {
            this.mStreamProviders.add(new InputStreamAdapter(){

                @Override
                public InputStream openInternal() throws IOException {
                    if (PictureMimeType.isContent(media.getPath()) && !media.isCut()) {
                        if (TextUtils.isEmpty((CharSequence)media.getAndroidQToPath())) {
                            return context.getContentResolver().openInputStream(Uri.parse((String)media.getPath()));
                        }
                        return new FileInputStream(media.getAndroidQToPath());
                    }
                    if (PictureMimeType.isHasHttp(media.getPath()) && TextUtils.isEmpty((CharSequence)media.getCutPath())) {
                        return null;
                    }
                    return new FileInputStream(media.isCut() ? media.getCutPath() : media.getPath());
                }

                @Override
                public String getPath() {
                    if (media.isCut()) {
                        return media.getCutPath();
                    }
                    return TextUtils.isEmpty((CharSequence)media.getAndroidQToPath()) ? media.getPath() : media.getAndroidQToPath();
                }

                @Override
                public LocalMedia getMedia() {
                    return media;
                }
            });
            return this;
        }

        public Builder load(final Uri uri) {
            this.mStreamProviders.add(new InputStreamAdapter(){

                @Override
                public InputStream openInternal() throws IOException {
                    return context.getContentResolver().openInputStream(uri);
                }

                @Override
                public String getPath() {
                    return uri.getPath();
                }

                @Override
                public LocalMedia getMedia() {
                    return null;
                }
            });
            return this;
        }

        public Builder load(final File file) {
            this.mStreamProviders.add(new InputStreamAdapter(){

                @Override
                public InputStream openInternal() throws IOException {
                    return new FileInputStream(file);
                }

                @Override
                public String getPath() {
                    return file.getAbsolutePath();
                }

                @Override
                public LocalMedia getMedia() {
                    return null;
                }
            });
            return this;
        }

        public Builder load(final String string2) {
            this.mStreamProviders.add(new InputStreamAdapter(){

                @Override
                public InputStream openInternal() throws IOException {
                    return new FileInputStream(string2);
                }

                @Override
                public String getPath() {
                    return string2;
                }

                @Override
                public LocalMedia getMedia() {
                    return null;
                }
            });
            return this;
        }

        public <T> Builder load(List<T> list) {
            for (T src : list) {
                if (src instanceof String) {
                    this.load((String)src);
                    continue;
                }
                if (src instanceof File) {
                    this.load((File)src);
                    continue;
                }
                if (src instanceof Uri) {
                    this.load((Uri)src);
                    continue;
                }
                throw new IllegalArgumentException("Incoming data type exception, it must be String, File, Uri or Bitmap");
            }
            return this;
        }

        public Builder putGear(int gear) {
            return this;
        }

        @Deprecated
        public Builder setRenameListener(OnRenameListener listener) {
            this.mRenameListener = listener;
            return this;
        }

        public Builder setCompressListener(OnCompressListener listener) {
            this.mCompressListener = listener;
            return this;
        }

        public Builder setTargetDir(String targetDir) {
            this.mTargetDir = targetDir;
            return this;
        }

        public Builder setNewCompressFileName(String newFileName) {
            this.mNewFileName = newFileName;
            return this;
        }

        public Builder isCamera(boolean isCamera) {
            this.isCamera = isCamera;
            return this;
        }

        public Builder setFocusAlpha(boolean focusAlpha) {
            this.focusAlpha = focusAlpha;
            return this;
        }

        public Builder setCompressQuality(int compressQuality) {
            this.compressQuality = compressQuality;
            return this;
        }

        public Builder ignoreBy(int size) {
            this.mLeastCompressSize = size;
            return this;
        }

        public Builder filter(CompressionPredicate compressionPredicate) {
            this.mCompressionPredicate = compressionPredicate;
            return this;
        }

        public void launch() {
            this.build().launch(this.context);
        }

        public File get(final String path) throws IOException {
            return this.build().get(new InputStreamAdapter(){

                @Override
                public InputStream openInternal() throws IOException {
                    return new FileInputStream(path);
                }

                @Override
                public String getPath() {
                    return path;
                }

                @Override
                public LocalMedia getMedia() {
                    return null;
                }
            }, this.context);
        }

        public List<File> get() throws Exception {
            return this.build().get(this.context);
        }
    }
}

