/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.compress;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import com.luck.picture.lib.compress.Checker;
import com.luck.picture.lib.compress.InputStreamProvider;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class Engine {
    private InputStreamProvider srcImg;
    private File tagImg;
    private int srcWidth;
    private int srcHeight;
    private boolean focusAlpha;
    private static final int DEFAULT_QUALITY = 80;
    private int compressQuality;

    Engine(InputStreamProvider srcImg, File tagImg, boolean focusAlpha, int compressQuality) throws IOException {
        this.tagImg = tagImg;
        this.srcImg = srcImg;
        this.focusAlpha = focusAlpha;
        int n = this.compressQuality = compressQuality <= 0 ? 80 : compressQuality;
        if (srcImg.getMedia().getWidth() > 0 && srcImg.getMedia().getHeight() > 0) {
            this.srcWidth = srcImg.getMedia().getWidth();
            this.srcHeight = srcImg.getMedia().getHeight();
        } else {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            options.inSampleSize = 1;
            BitmapFactory.decodeStream((InputStream)srcImg.open(), null, (BitmapFactory.Options)options);
            this.srcWidth = options.outWidth;
            this.srcHeight = options.outHeight;
        }
    }

    private int computeSize() {
        this.srcWidth = this.srcWidth % 2 == 1 ? this.srcWidth + 1 : this.srcWidth;
        this.srcHeight = this.srcHeight % 2 == 1 ? this.srcHeight + 1 : this.srcHeight;
        int longSide = Math.max(this.srcWidth, this.srcHeight);
        int shortSide = Math.min(this.srcWidth, this.srcHeight);
        float scale = (float)shortSide / (float)longSide;
        if (scale <= 1.0f && (double)scale > 0.5625) {
            if (longSide < 1664) {
                return 1;
            }
            if (longSide < 4990) {
                return 2;
            }
            if (longSide > 4990 && longSide < 10240) {
                return 4;
            }
            return longSide / 1280;
        }
        if ((double)scale <= 0.5625 && (double)scale > 0.5) {
            return longSide / 1280 == 0 ? 1 : longSide / 1280;
        }
        return (int)Math.ceil((double)longSide / (1280.0 / (double)scale));
    }

    private Bitmap rotatingImage(Bitmap bitmap, int angle) {
        Matrix matrix = new Matrix();
        matrix.postRotate((float)angle);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
    }

    File compress() throws IOException {
        int orientation;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inSampleSize = this.computeSize();
        Bitmap tagBitmap = BitmapFactory.decodeStream((InputStream)this.srcImg.open(), null, (BitmapFactory.Options)options);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        if (this.srcImg.getMedia() != null && !this.srcImg.getMedia().isCut() && Checker.SINGLE.isJPG(this.srcImg.getMedia().getMimeType()) && (orientation = this.srcImg.getMedia().getOrientation()) > 0) {
            boolean isOrientation = true;
            switch (orientation) {
                case 6: {
                    orientation = 90;
                    break;
                }
                case 3: {
                    orientation = 180;
                    break;
                }
                case 8: {
                    orientation = 270;
                    break;
                }
                default: {
                    isOrientation = false;
                }
            }
            if (isOrientation) {
                tagBitmap = this.rotatingImage(tagBitmap, orientation);
            }
        }
        if (tagBitmap != null) {
            this.compressQuality = this.compressQuality <= 0 || this.compressQuality > 100 ? 80 : this.compressQuality;
            tagBitmap.compress(this.focusAlpha ? Bitmap.CompressFormat.PNG : Bitmap.CompressFormat.JPEG, this.compressQuality, (OutputStream)stream);
            tagBitmap.recycle();
        }
        FileOutputStream fos = new FileOutputStream(this.tagImg);
        fos.write(stream.toByteArray());
        fos.flush();
        fos.close();
        stream.close();
        return this.tagImg;
    }
}

