/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.text.TextUtils;
import android.view.Window;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.luck.picture.lib.PictureBaseActivity;
import com.luck.picture.lib.PictureMediaScannerConnection;
import com.luck.picture.lib.R;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.entity.MediaExtraInfo;
import com.luck.picture.lib.immersive.ImmersiveManage;
import com.luck.picture.lib.manager.UCropManager;
import com.luck.picture.lib.permissions.PermissionChecker;
import com.luck.picture.lib.tools.BitmapUtils;
import com.luck.picture.lib.tools.MediaUtils;
import com.luck.picture.lib.tools.PictureFileUtils;
import com.luck.picture.lib.tools.SdkVersionUtils;
import com.luck.picture.lib.tools.ToastUtils;
import com.luck.picture.lib.tools.ValueOf;
import com.yalantis.ucrop.UCrop;
import java.io.File;
import java.util.ArrayList;

public class PictureSelectorCameraEmptyActivity
extends PictureBaseActivity {
    @Override
    public void immersive() {
        ImmersiveManage.immersiveAboveAPI23(this, ContextCompat.getColor((Context)this, (int)R.color.picture_color_transparent), ContextCompat.getColor((Context)this, (int)R.color.picture_color_transparent), this.openWhiteStatusBar);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.config == null) {
            this.exit();
            return;
        }
        if (!this.config.isUseCustomCamera) {
            this.setActivitySize();
            if (savedInstanceState == null) {
                if (PermissionChecker.checkSelfPermission((Context)this, "android.permission.READ_EXTERNAL_STORAGE") && PermissionChecker.checkSelfPermission((Context)this, "android.permission.WRITE_EXTERNAL_STORAGE")) {
                    if (PictureSelectionConfig.onCustomCameraInterfaceListener != null) {
                        if (this.config.chooseMode == 2) {
                            PictureSelectionConfig.onCustomCameraInterfaceListener.onCameraClick(this.getContext(), this.config, 2);
                        } else {
                            PictureSelectionConfig.onCustomCameraInterfaceListener.onCameraClick(this.getContext(), this.config, 1);
                        }
                    } else {
                        this.onTakePhoto();
                    }
                } else {
                    PermissionChecker.requestPermissions((Activity)this, new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"}, 1);
                }
            }
        }
    }

    private void setActivitySize() {
        Window window = this.getWindow();
        window.setGravity(51);
        WindowManager.LayoutParams params = window.getAttributes();
        params.x = 0;
        params.y = 0;
        params.height = 1;
        params.width = 1;
        window.setAttributes(params);
    }

    @Override
    public int getResourceId() {
        return R.layout.picture_empty;
    }

    private void onTakePhoto() {
        if (PermissionChecker.checkSelfPermission((Context)this, "android.permission.CAMERA")) {
            boolean isPermissionChecker = true;
            if (this.config != null && this.config.isUseCustomCamera) {
                isPermissionChecker = PermissionChecker.checkSelfPermission((Context)this, "android.permission.RECORD_AUDIO");
            }
            if (isPermissionChecker) {
                this.startCamera();
            } else {
                PermissionChecker.requestPermissions((Activity)this, new String[]{"android.permission.RECORD_AUDIO"}, 4);
            }
        } else {
            PermissionChecker.requestPermissions((Activity)this, new String[]{"android.permission.CAMERA"}, 2);
        }
    }

    private void startCamera() {
        switch (this.config.chooseMode) {
            case 0: 
            case 1: {
                this.startOpenCamera();
                break;
            }
            case 2: {
                this.startOpenCameraVideo();
                break;
            }
            case 3: {
                this.startOpenCameraAudio();
                break;
            }
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == -1) {
            switch (requestCode) {
                case 69: {
                    this.singleCropHandleResult(data);
                    break;
                }
                case 909: {
                    this.dispatchHandleCamera(data);
                    break;
                }
            }
        } else if (resultCode == 0) {
            if (PictureSelectionConfig.listener != null) {
                PictureSelectionConfig.listener.onCancel();
            }
            if (requestCode == 909) {
                MediaUtils.deleteCamera((Context)this, this.config.cameraPath);
            }
            this.exit();
        } else if (resultCode == 96) {
            if (data == null) {
                return;
            }
            Throwable throwable = (Throwable)data.getSerializableExtra("com.yalantis.ucrop.Error");
            if (throwable != null) {
                ToastUtils.s(this.getContext(), throwable.getMessage());
            }
        }
    }

    protected void singleCropHandleResult(Intent data) {
        String path;
        if (data == null) {
            return;
        }
        ArrayList<LocalMedia> medias = new ArrayList<LocalMedia>();
        Uri resultUri = UCrop.getOutput(data);
        if (resultUri == null) {
            return;
        }
        String cutPath = resultUri.getPath();
        boolean isCutEmpty = TextUtils.isEmpty((CharSequence)cutPath);
        LocalMedia media = new LocalMedia(this.config.cameraPath, 0L, false, this.config.isCamera ? 1 : 0, 0, this.config.chooseMode);
        if (SdkVersionUtils.checkedAndroid_Q()) {
            int lastIndexOf = this.config.cameraPath.lastIndexOf("/") + 1;
            media.setId(lastIndexOf > 0 ? ValueOf.toLong(this.config.cameraPath.substring(lastIndexOf)) : -1L);
            media.setAndroidQToPath(cutPath);
            if (isCutEmpty) {
                if (PictureMimeType.isContent(this.config.cameraPath)) {
                    path = PictureFileUtils.getPath((Context)this, Uri.parse((String)this.config.cameraPath));
                    media.setSize(!TextUtils.isEmpty((CharSequence)path) ? new File(path).length() : 0L);
                } else {
                    media.setSize(new File(this.config.cameraPath).length());
                }
            } else {
                media.setSize(new File(cutPath).length());
            }
        } else {
            media.setId(System.currentTimeMillis());
            media.setSize(new File(isCutEmpty ? media.getPath() : cutPath).length());
        }
        media.setCut(!isCutEmpty);
        media.setCutPath(cutPath);
        String mimeType = PictureMimeType.getImageMimeType(cutPath);
        media.setMimeType(mimeType);
        media.setOrientation(-1);
        if (PictureMimeType.isContent(media.getPath())) {
            path = PictureFileUtils.getPath(this.getContext(), Uri.parse((String)media.getPath()));
            media.setRealPath(path);
            if (PictureMimeType.isHasVideo(media.getMimeType())) {
                MediaExtraInfo mediaExtraInfo = MediaUtils.getVideoSize(media.getRealPath());
                media.setWidth(mediaExtraInfo.getWidth());
                media.setHeight(mediaExtraInfo.getHeight());
            } else if (PictureMimeType.isHasImage(media.getMimeType())) {
                MediaExtraInfo mediaExtraInfo = MediaUtils.getImageSize(media.getRealPath());
                media.setWidth(mediaExtraInfo.getWidth());
                media.setHeight(mediaExtraInfo.getHeight());
            }
        } else {
            MediaExtraInfo mediaExtraInfo;
            media.setRealPath(media.getPath());
            if (PictureMimeType.isHasVideo(media.getMimeType())) {
                mediaExtraInfo = MediaUtils.getVideoSize(media.getPath());
                media.setWidth(mediaExtraInfo.getWidth());
                media.setHeight(mediaExtraInfo.getHeight());
            } else if (PictureMimeType.isHasImage(media.getMimeType())) {
                mediaExtraInfo = MediaUtils.getImageSize(media.getPath());
                media.setWidth(mediaExtraInfo.getWidth());
                media.setHeight(mediaExtraInfo.getHeight());
            }
        }
        medias.add(media);
        this.handlerResult(medias);
    }

    protected void dispatchHandleCamera(Intent intent) {
        String mimeType;
        boolean isAudio = this.config.chooseMode == PictureMimeType.ofAudio();
        String string2 = this.config.cameraPath = isAudio ? this.getAudioPath(intent) : this.config.cameraPath;
        if (TextUtils.isEmpty((CharSequence)this.config.cameraPath)) {
            return;
        }
        LocalMedia media = new LocalMedia();
        if (PictureMimeType.isContent(this.config.cameraPath)) {
            MediaExtraInfo mediaExtraInfo;
            String path = PictureFileUtils.getPath(this.getContext(), Uri.parse((String)this.config.cameraPath));
            File cameraFile = new File(path);
            mimeType = PictureMimeType.getMimeType(this.config.cameraMimeType);
            media.setSize(cameraFile.length());
            if (PictureMimeType.isHasImage(mimeType)) {
                mediaExtraInfo = MediaUtils.getImageSize(path);
                media.setWidth(mediaExtraInfo.getWidth());
                media.setHeight(mediaExtraInfo.getHeight());
            } else if (PictureMimeType.isHasVideo(mimeType)) {
                mediaExtraInfo = MediaUtils.getVideoSize(path);
                media.setWidth(mediaExtraInfo.getWidth());
                media.setHeight(mediaExtraInfo.getHeight());
                media.setDuration(mediaExtraInfo.getDuration());
            } else if (PictureMimeType.isHasAudio(mimeType)) {
                mediaExtraInfo = MediaUtils.getAudioSize(path);
                media.setDuration(mediaExtraInfo.getDuration());
            }
            int lastIndexOf = this.config.cameraPath.lastIndexOf("/") + 1;
            media.setId(lastIndexOf > 0 ? ValueOf.toLong(this.config.cameraPath.substring(lastIndexOf)) : -1L);
            media.setRealPath(path);
            String mediaPath = intent != null ? intent.getStringExtra("mediaPath") : null;
            media.setAndroidQToPath(mediaPath);
        } else {
            File cameraFile = new File(this.config.cameraPath);
            mimeType = PictureMimeType.getMimeType(this.config.cameraMimeType);
            media.setSize(cameraFile.length());
            if (PictureMimeType.isHasImage(mimeType)) {
                int degree = PictureFileUtils.readPictureDegree(this.getContext(), this.config.cameraPath);
                BitmapUtils.rotateImage(degree, this.config.cameraPath);
                MediaExtraInfo mediaExtraInfo = MediaUtils.getImageSize(this.config.cameraPath);
                media.setWidth(mediaExtraInfo.getWidth());
                media.setHeight(mediaExtraInfo.getHeight());
            } else if (PictureMimeType.isHasVideo(mimeType)) {
                MediaExtraInfo mediaExtraInfo = MediaUtils.getVideoSize(this.config.cameraPath);
                media.setWidth(mediaExtraInfo.getWidth());
                media.setHeight(mediaExtraInfo.getHeight());
                media.setDuration(mediaExtraInfo.getDuration());
            } else if (PictureMimeType.isHasAudio(mimeType)) {
                MediaExtraInfo mediaExtraInfo = MediaUtils.getAudioSize(this.config.cameraPath);
                media.setDuration(mediaExtraInfo.getDuration());
            }
            media.setId(System.currentTimeMillis());
        }
        media.setPath(this.config.cameraPath);
        media.setMimeType(mimeType);
        if (SdkVersionUtils.checkedAndroid_Q() && PictureMimeType.isHasVideo(media.getMimeType())) {
            media.setParentFolderName(Environment.DIRECTORY_MOVIES);
        } else {
            media.setParentFolderName("Camera");
        }
        media.setChooseModel(this.config.chooseMode);
        long bucketId = MediaUtils.getCameraFirstBucketId(this.getContext());
        media.setBucketId(bucketId);
        media.setDateAddedTime(ValueOf.toLong(String.valueOf(System.currentTimeMillis()).substring(0, 10)));
        this.dispatchCameraHandleResult(media);
        if (!SdkVersionUtils.checkedAndroid_Q()) {
            int lastImageId;
            if (this.config.isFallbackVersion3) {
                new PictureMediaScannerConnection(this.getContext(), this.config.cameraPath);
            } else {
                this.sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", Uri.fromFile((File)new File(this.config.cameraPath))));
            }
            if (PictureMimeType.isHasImage(media.getMimeType()) && (lastImageId = MediaUtils.getDCIMLastImageId(this.getContext())) != -1) {
                MediaUtils.removeMedia(this.getContext(), lastImageId);
            }
        }
    }

    private void dispatchCameraHandleResult(LocalMedia media) {
        boolean isHasImage = PictureMimeType.isHasImage(media.getMimeType());
        if (this.config.enableCrop && isHasImage) {
            this.config.originalPath = this.config.cameraPath;
            UCropManager.ofCrop((Activity)this, this.config.cameraPath, media.getMimeType());
        } else if (this.config.isCompress && isHasImage && !this.config.isCheckOriginalImage) {
            ArrayList<LocalMedia> result = new ArrayList<LocalMedia>();
            result.add(media);
            this.compressImage(result);
        } else {
            ArrayList<LocalMedia> result = new ArrayList<LocalMedia>();
            result.add(media);
            this.onResult(result);
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        switch (requestCode) {
            case 1: {
                if (grantResults.length > 0 && grantResults[0] == 0) {
                    PermissionChecker.requestPermissions((Activity)this, new String[]{"android.permission.CAMERA"}, 2);
                    break;
                }
                ToastUtils.s(this.getContext(), this.getString(R.string.picture_jurisdiction));
                this.exit();
                break;
            }
            case 2: {
                if (grantResults.length > 0 && grantResults[0] == 0) {
                    this.onTakePhoto();
                    break;
                }
                this.exit();
                ToastUtils.s(this.getContext(), this.getString(R.string.picture_camera));
                break;
            }
            case 4: {
                if (grantResults.length > 0 && grantResults[0] == 0) {
                    this.onTakePhoto();
                    break;
                }
                this.exit();
                ToastUtils.s(this.getContext(), this.getString(R.string.picture_audio));
            }
        }
    }

    public void onBackPressed() {
        if (SdkVersionUtils.checkedAndroid_Q()) {
            this.finishAfterTransition();
        } else {
            super.onBackPressed();
        }
        this.exit();
    }
}

