/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.thread;

import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public final class PictureThreadUtils {
    private static final Handler HANDLER = new Handler(Looper.getMainLooper());
    private static final Map<Integer, Map<Integer, ExecutorService>> TYPE_PRIORITY_POOLS = new HashMap<Integer, Map<Integer, ExecutorService>>();
    private static final Map<Task, ExecutorService> TASK_POOL_MAP = new ConcurrentHashMap<Task, ExecutorService>();
    private static final byte TYPE_IO = -4;
    private static Executor sDeliver;

    public static void runOnUiThread(Runnable runnable) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            runnable.run();
        } else {
            HANDLER.post(runnable);
        }
    }

    public static ExecutorService getIoPool() {
        return PictureThreadUtils.getPoolByTypeAndPriority();
    }

    public static <T> void executeByIo(Task<T> task) {
        PictureThreadUtils.execute(PictureThreadUtils.getPoolByTypeAndPriority(), task);
    }

    public static void cancel(Task task) {
        if (task == null) {
            return;
        }
        task.cancel();
    }

    public static void cancel(Task ... tasks) {
        if (tasks == null || tasks.length == 0) {
            return;
        }
        for (Task task : tasks) {
            if (task == null) continue;
            task.cancel();
        }
    }

    public static void cancel(List<Task> tasks) {
        if (tasks == null || tasks.size() == 0) {
            return;
        }
        for (Task task : tasks) {
            if (task == null) continue;
            task.cancel();
        }
    }

    public static void cancel(ExecutorService executorService) {
        if (executorService instanceof ThreadPoolExecutor4Util) {
            for (Map.Entry<Task, ExecutorService> taskTaskInfoEntry : TASK_POOL_MAP.entrySet()) {
                if (taskTaskInfoEntry.getValue() != executorService) continue;
                PictureThreadUtils.cancel(taskTaskInfoEntry.getKey());
            }
        } else {
            Log.e((String)"ThreadUtils", (String)"The executorService is not ThreadUtils's pool.");
        }
    }

    private static <T> void execute(ExecutorService pool, Task<T> task) {
        PictureThreadUtils.execute(pool, task, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> void execute(ExecutorService pool, Task<T> task, TimeUnit unit) {
        Map<Task, ExecutorService> map = TASK_POOL_MAP;
        synchronized (map) {
            if (TASK_POOL_MAP.get(task) != null) {
                Log.e((String)"ThreadUtils", (String)"Task can only be executed once.");
                return;
            }
            TASK_POOL_MAP.put(task, pool);
        }
        pool.execute(task);
    }

    private static ExecutorService getPoolByTypeAndPriority() {
        return PictureThreadUtils.getPoolByTypeAndPriority(5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ExecutorService getPoolByTypeAndPriority(int priority) {
        Map<Integer, Map<Integer, ExecutorService>> map = TYPE_PRIORITY_POOLS;
        synchronized (map) {
            ExecutorService pool;
            Map<Integer, ExecutorService> priorityPools = TYPE_PRIORITY_POOLS.get(-4);
            if (priorityPools == null) {
                priorityPools = new ConcurrentHashMap<Integer, ExecutorService>();
                pool = ThreadPoolExecutor4Util.createPool(priority);
                priorityPools.put(priority, pool);
                TYPE_PRIORITY_POOLS.put(-4, priorityPools);
            } else {
                pool = priorityPools.get(priority);
                if (pool == null) {
                    pool = ThreadPoolExecutor4Util.createPool(priority);
                    priorityPools.put(priority, pool);
                }
            }
            return pool;
        }
    }

    private static Executor getGlobalDeliver() {
        if (sDeliver == null) {
            sDeliver = new Executor(){

                @Override
                public void execute(@NonNull Runnable command) {
                    PictureThreadUtils.runOnUiThread(command);
                }
            };
        }
        return sDeliver;
    }

    public static abstract class Task<T>
    implements Runnable {
        private static final int NEW = 0;
        private static final int RUNNING = 1;
        private static final int EXCEPTIONAL = 2;
        private static final int COMPLETING = 3;
        private static final int CANCELLED = 4;
        private static final int INTERRUPTED = 5;
        private static final int TIMEOUT = 6;
        private final AtomicInteger state = new AtomicInteger(0);
        private volatile boolean isSchedule;
        private volatile Thread runner;
        private Timer mTimer;
        private long mTimeoutMillis;
        private OnTimeoutListener mTimeoutListener;
        private Executor deliver;

        public abstract T doInBackground() throws Throwable;

        public abstract void onSuccess(T var1);

        public abstract void onCancel();

        public abstract void onFail(Throwable var1);

        @Override
        public void run() {
            if (this.isSchedule) {
                if (this.runner == null) {
                    if (!this.state.compareAndSet(0, 1)) {
                        return;
                    }
                    this.runner = Thread.currentThread();
                    if (this.mTimeoutListener != null) {
                        Log.w((String)"ThreadUtils", (String)"Scheduled task doesn't support timeout.");
                    }
                } else if (this.state.get() != 1) {
                    return;
                }
            } else {
                if (!this.state.compareAndSet(0, 1)) {
                    return;
                }
                this.runner = Thread.currentThread();
                if (this.mTimeoutListener != null) {
                    this.mTimer = new Timer();
                    this.mTimer.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            if (!this.isDone() && mTimeoutListener != null) {
                                this.timeout();
                                mTimeoutListener.onTimeout();
                            }
                        }
                    }, this.mTimeoutMillis);
                }
            }
            try {
                final T result = this.doInBackground();
                if (this.isSchedule) {
                    if (this.state.get() != 1) {
                        return;
                    }
                    this.getDeliver().execute(new Runnable(){

                        @Override
                        public void run() {
                            this.onSuccess(result);
                        }
                    });
                } else {
                    if (!this.state.compareAndSet(1, 3)) {
                        return;
                    }
                    this.getDeliver().execute(new Runnable(){

                        @Override
                        public void run() {
                            this.onSuccess(result);
                            this.onDone();
                        }
                    });
                }
            }
            catch (InterruptedException ignore) {
                this.state.compareAndSet(4, 5);
            }
            catch (Throwable throwable) {
                if (!this.state.compareAndSet(1, 2)) {
                    return;
                }
                this.getDeliver().execute(new Runnable(){

                    @Override
                    public void run() {
                        this.onFail(throwable);
                        this.onDone();
                    }
                });
            }
        }

        public void cancel() {
            this.cancel(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel(boolean mayInterruptIfRunning) {
            AtomicInteger atomicInteger = this.state;
            synchronized (atomicInteger) {
                if (this.state.get() > 1) {
                    return;
                }
                this.state.set(4);
            }
            if (mayInterruptIfRunning && this.runner != null) {
                this.runner.interrupt();
            }
            this.getDeliver().execute(new Runnable(){

                @Override
                public void run() {
                    this.onCancel();
                    this.onDone();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void timeout() {
            AtomicInteger atomicInteger = this.state;
            synchronized (atomicInteger) {
                if (this.state.get() > 1) {
                    return;
                }
                this.state.set(6);
            }
            if (this.runner != null) {
                this.runner.interrupt();
            }
            this.onDone();
        }

        public boolean isCanceled() {
            return this.state.get() >= 4;
        }

        public boolean isDone() {
            return this.state.get() > 1;
        }

        public Task<T> setDeliver(Executor deliver) {
            this.deliver = deliver;
            return this;
        }

        public Task<T> setTimeout(long timeoutMillis, OnTimeoutListener listener) {
            this.mTimeoutMillis = timeoutMillis;
            this.mTimeoutListener = listener;
            return this;
        }

        private void setSchedule(boolean isSchedule) {
            this.isSchedule = isSchedule;
        }

        private Executor getDeliver() {
            if (this.deliver == null) {
                return PictureThreadUtils.getGlobalDeliver();
            }
            return this.deliver;
        }

        @CallSuper
        protected void onDone() {
            TASK_POOL_MAP.remove(this);
            if (this.mTimer != null) {
                this.mTimer.cancel();
                this.mTimer = null;
                this.mTimeoutListener = null;
            }
        }

        public static interface OnTimeoutListener {
            public void onTimeout();
        }
    }

    public static abstract class SimpleTask<T>
    extends Task<T> {
        @Override
        public void onCancel() {
            Log.e((String)"ThreadUtils", (String)("onCancel: " + Thread.currentThread()));
        }

        @Override
        public void onFail(Throwable t) {
            Log.e((String)"ThreadUtils", (String)"onFail: ", (Throwable)t);
        }
    }

    static final class UtilsThreadFactory
    extends AtomicLong
    implements ThreadFactory {
        private static final AtomicInteger POOL_NUMBER = new AtomicInteger(1);
        private static final long serialVersionUID = -9209200509960368598L;
        private final String namePrefix;
        private final int priority;
        private final boolean isDaemon;

        UtilsThreadFactory(String prefix, int priority) {
            this(prefix, priority, false);
        }

        UtilsThreadFactory(String prefix, int priority, boolean isDaemon) {
            this.namePrefix = prefix + "-pool-" + POOL_NUMBER.getAndIncrement() + "-thread-";
            this.priority = priority;
            this.isDaemon = isDaemon;
        }

        @Override
        public Thread newThread(@NonNull Runnable r) {
            Thread t = new Thread(r, this.namePrefix + this.getAndIncrement()){

                @Override
                public void run() {
                    try {
                        super.run();
                    }
                    catch (Throwable t) {
                        Log.e((String)"ThreadUtils", (String)"Request threw uncaught throwable", (Throwable)t);
                    }
                }
            };
            t.setDaemon(this.isDaemon);
            t.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    System.out.println(e);
                }
            });
            t.setPriority(this.priority);
            return t;
        }
    }

    private static final class LinkedBlockingQueue4Util
    extends LinkedBlockingQueue<Runnable> {
        private volatile ThreadPoolExecutor4Util mPool;
        private int mCapacity = Integer.MAX_VALUE;

        LinkedBlockingQueue4Util() {
        }

        LinkedBlockingQueue4Util(boolean isAddSubThreadFirstThenAddQueue) {
            if (isAddSubThreadFirstThenAddQueue) {
                this.mCapacity = 0;
            }
        }

        LinkedBlockingQueue4Util(int capacity) {
            this.mCapacity = capacity;
        }

        @Override
        public boolean offer(@NonNull Runnable runnable) {
            if (this.mCapacity <= this.size() && this.mPool != null && this.mPool.getPoolSize() < this.mPool.getMaximumPoolSize()) {
                return false;
            }
            return super.offer(runnable);
        }
    }

    static final class ThreadPoolExecutor4Util
    extends ThreadPoolExecutor {
        private final AtomicInteger mSubmittedCount = new AtomicInteger();
        private final LinkedBlockingQueue4Util mWorkQueue;

        private static ExecutorService createPool(int priority) {
            return new ThreadPoolExecutor4Util(0, 4, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue4Util(), (ThreadFactory)new UtilsThreadFactory("io", priority));
        }

        ThreadPoolExecutor4Util(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, LinkedBlockingQueue4Util workQueue, ThreadFactory threadFactory) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, (BlockingQueue<Runnable>)workQueue, threadFactory);
            workQueue.mPool = this;
            this.mWorkQueue = workQueue;
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            this.mSubmittedCount.decrementAndGet();
            super.afterExecute(r, t);
        }

        @Override
        public void execute(@NonNull Runnable command) {
            if (this.isShutdown()) {
                return;
            }
            this.mSubmittedCount.incrementAndGet();
            try {
                super.execute(command);
            }
            catch (RejectedExecutionException ignore) {
                Log.e((String)"ThreadUtils", (String)"This will not happen!");
                this.mWorkQueue.offer(command);
            }
            catch (Throwable t) {
                this.mSubmittedCount.decrementAndGet();
            }
        }
    }
}

