/*
 * Decompiled with CFR 0.152.
 */
package com.yalantis.ucrop;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import android.view.animation.LayoutAnimationController;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.SimpleItemAnimator;
import com.yalantis.ucrop.PicturePhotoGalleryAdapter;
import com.yalantis.ucrop.R;
import com.yalantis.ucrop.UCropActivity;
import com.yalantis.ucrop.model.CutInfo;
import com.yalantis.ucrop.util.FileUtils;
import com.yalantis.ucrop.util.MimeType;
import com.yalantis.ucrop.util.ScreenUtils;
import java.io.File;
import java.util.ArrayList;

public class PictureMultiCuttingActivity
extends UCropActivity {
    private static final int MIN_NUM = 1;
    private RecyclerView mRecyclerView;
    private PicturePhotoGalleryAdapter mAdapter;
    private ArrayList<CutInfo> list;
    private boolean isWithVideoImage;
    private int cutIndex;
    private int oldCutIndex;
    private String renameCropFilename;
    private boolean isCamera;
    private boolean isAnimation;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        this.renameCropFilename = intent.getStringExtra("com.yalantis.ucrop.RenameCropFileName");
        this.isCamera = intent.getBooleanExtra("com.yalantis.ucrop.isCamera", false);
        this.isWithVideoImage = intent.getBooleanExtra("com.yalantis.ucrop.isWithVideoImage", false);
        this.list = this.getIntent().getParcelableArrayListExtra("com.yalantis.ucrop.cuts");
        this.isAnimation = this.getIntent().getBooleanExtra(".isMultipleAnimation", true);
        if (this.list == null || this.list.size() == 0) {
            this.onBackPressed();
            return;
        }
        if (this.list.size() > 1) {
            this.initLoadCutData();
            this.addPhotoRecyclerView();
        }
    }

    private void addPhotoRecyclerView() {
        boolean isMultipleSkipCrop = this.getIntent().getBooleanExtra("com.yalantis.ucrop.skip_multiple_crop", true);
        this.mRecyclerView = new RecyclerView((Context)this);
        this.mRecyclerView.setId(R.id.id_recycler);
        this.mRecyclerView.setBackgroundColor(ContextCompat.getColor((Context)this, (int)R.color.ucrop_color_widget_background));
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-1, ScreenUtils.dip2px((Context)this, 80.0f));
        this.mRecyclerView.setLayoutParams((ViewGroup.LayoutParams)lp);
        LinearLayoutManager mLayoutManager = new LinearLayoutManager((Context)this);
        mLayoutManager.setOrientation(0);
        if (this.isAnimation) {
            LayoutAnimationController animation = AnimationUtils.loadLayoutAnimation((Context)this.getApplicationContext(), (int)R.anim.ucrop_layout_animation_fall_down);
            this.mRecyclerView.setLayoutAnimation(animation);
        }
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)mLayoutManager);
        ((SimpleItemAnimator)this.mRecyclerView.getItemAnimator()).setSupportsChangeAnimations(false);
        this.resetCutDataStatus();
        this.list.get(this.cutIndex).setCut(true);
        this.mAdapter = new PicturePhotoGalleryAdapter((Context)this, this.list);
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        if (isMultipleSkipCrop) {
            this.mAdapter.setOnItemClickListener(new PicturePhotoGalleryAdapter.OnItemClickListener(){

                @Override
                public void onItemClick(int position, View view) {
                    CutInfo cutInfo = (CutInfo)PictureMultiCuttingActivity.this.list.get(position);
                    if (MimeType.eqVideo(cutInfo.getMimeType())) {
                        return;
                    }
                    if (PictureMultiCuttingActivity.this.cutIndex == position) {
                        return;
                    }
                    PictureMultiCuttingActivity.this.resetLastCropStatus();
                    PictureMultiCuttingActivity.this.cutIndex = position;
                    PictureMultiCuttingActivity.this.oldCutIndex = PictureMultiCuttingActivity.this.cutIndex;
                    PictureMultiCuttingActivity.this.resetCutData();
                }
            });
        }
        this.uCropPhotoBox.addView((View)this.mRecyclerView);
        this.changeLayoutParams(this.mShowBottomControls);
        FrameLayout uCropFrame = (FrameLayout)this.findViewById(R.id.ucrop_frame);
        ((RelativeLayout.LayoutParams)uCropFrame.getLayoutParams()).addRule(2, R.id.id_recycler);
        ((RelativeLayout.LayoutParams)this.mRecyclerView.getLayoutParams()).addRule(2, R.id.controls_wrapper);
    }

    protected void resetCutData() {
        File file;
        this.uCropPhotoBox.removeView((View)this.mRecyclerView);
        if (this.mBlockingView != null) {
            this.uCropPhotoBox.removeView(this.mBlockingView);
        }
        this.setContentView(R.layout.ucrop_activity_photobox);
        this.uCropPhotoBox = (RelativeLayout)this.findViewById(R.id.ucrop_photobox);
        this.addBlockingView();
        Intent intent = this.getIntent();
        Bundle extras = intent.getExtras();
        String path = this.list.get(this.cutIndex).getPath();
        boolean isHttp = MimeType.isHttp(path);
        String suffix = MimeType.getLastImgType(path.startsWith("content://") ? FileUtils.getPath((Context)this, Uri.parse((String)path)) : path);
        Uri uri = isHttp || path.startsWith("content://") ? Uri.parse((String)path) : Uri.fromFile((File)new File(path));
        extras.putParcelable("com.yalantis.ucrop.InputUri", (Parcelable)uri);
        File file2 = file = Environment.getExternalStorageState().equals("mounted") ? this.getExternalFilesDir(Environment.DIRECTORY_PICTURES) : this.getCacheDir();
        extras.putParcelable("com.yalantis.ucrop.OutputUri", (Parcelable)Uri.fromFile((File)new File(file, TextUtils.isEmpty((CharSequence)this.renameCropFilename) ? FileUtils.getCreateFileName("IMG_") + suffix : (this.isCamera ? this.renameCropFilename : FileUtils.rename(this.renameCropFilename)))));
        intent.putExtras(extras);
        this.setupViews(intent);
        this.refreshPhotoRecyclerData();
        this.setImageData(intent);
        this.setInitialState();
        int scrollWidth = this.cutIndex * ScreenUtils.dip2px((Context)this, 60.0f);
        if ((double)scrollWidth > (double)this.mScreenWidth * 0.8) {
            this.mRecyclerView.scrollBy(ScreenUtils.dip2px((Context)this, 60.0f), 0);
        } else if ((double)scrollWidth < (double)this.mScreenWidth * 0.4) {
            this.mRecyclerView.scrollBy(ScreenUtils.dip2px((Context)this, -60.0f), 0);
        }
    }

    private void refreshPhotoRecyclerData() {
        this.resetCutDataStatus();
        this.list.get(this.cutIndex).setCut(true);
        this.mAdapter.notifyItemChanged(this.cutIndex);
        this.uCropPhotoBox.addView((View)this.mRecyclerView);
        this.changeLayoutParams(this.mShowBottomControls);
        FrameLayout uCropFrame = (FrameLayout)this.findViewById(R.id.ucrop_frame);
        ((RelativeLayout.LayoutParams)uCropFrame.getLayoutParams()).addRule(2, R.id.id_recycler);
        ((RelativeLayout.LayoutParams)this.mRecyclerView.getLayoutParams()).addRule(2, R.id.controls_wrapper);
    }

    private void resetLastCropStatus() {
        int size = this.list.size();
        if (size > 1 && size > this.oldCutIndex) {
            this.list.get(this.oldCutIndex).setCut(false);
            this.mAdapter.notifyItemChanged(this.cutIndex);
        }
    }

    private void resetCutDataStatus() {
        int size = this.list.size();
        for (int i = 0; i < size; ++i) {
            CutInfo cutInfo = this.list.get(i);
            cutInfo.setCut(false);
        }
    }

    private void initLoadCutData() {
        if (this.list == null || this.list.size() == 0) {
            this.onBackPressed();
            return;
        }
        int size = this.list.size();
        if (this.isWithVideoImage) {
            this.getIndex(size);
        }
        for (int i = 0; i < size; ++i) {
            CutInfo cutInfo = this.list.get(i);
            boolean isHttp = MimeType.isHttp(cutInfo.getPath());
            if (!isHttp) continue;
            String path = this.list.get(i).getPath();
            String imgType = MimeType.getLastImgType(path);
            if (TextUtils.isEmpty((CharSequence)path) || TextUtils.isEmpty((CharSequence)imgType)) continue;
            File file = Environment.getExternalStorageState().equals("mounted") ? this.getExternalFilesDir(Environment.DIRECTORY_PICTURES) : this.getCacheDir();
            File newFile = new File(file, new StringBuffer().append("temporary_thumbnail_").append(i).append(imgType).toString());
            String mimeType = MimeType.getImageMimeType(path);
            cutInfo.setMimeType(mimeType);
            cutInfo.setHttpOutUri(Uri.fromFile((File)newFile));
        }
    }

    private void getIndex(int size) {
        for (int i = 0; i < size; ++i) {
            CutInfo cutInfo = this.list.get(i);
            if (cutInfo == null || !MimeType.eqImage(cutInfo.getMimeType())) continue;
            this.cutIndex = i;
            break;
        }
    }

    private void changeLayoutParams(boolean mShowBottomControls) {
        if (this.mRecyclerView.getLayoutParams() == null) {
            return;
        }
        if (mShowBottomControls) {
            ((RelativeLayout.LayoutParams)this.mRecyclerView.getLayoutParams()).addRule(12, 0);
            ((RelativeLayout.LayoutParams)this.mRecyclerView.getLayoutParams()).addRule(2, R.id.wrapper_controls);
        } else {
            ((RelativeLayout.LayoutParams)this.mRecyclerView.getLayoutParams()).addRule(12);
            ((RelativeLayout.LayoutParams)this.mRecyclerView.getLayoutParams()).addRule(2, 0);
        }
    }

    @Override
    protected void setResultUri(Uri uri, float resultAspectRatio, int offsetX, int offsetY, int imageWidth, int imageHeight) {
        try {
            if (this.list.size() < this.cutIndex) {
                this.onBackPressed();
                return;
            }
            CutInfo info = this.list.get(this.cutIndex);
            info.setCutPath(uri.getPath());
            info.setCut(true);
            info.setResultAspectRatio(resultAspectRatio);
            info.setOffsetX(offsetX);
            info.setOffsetY(offsetY);
            info.setImageWidth(imageWidth);
            info.setImageHeight(imageHeight);
            this.resetLastCropStatus();
            ++this.cutIndex;
            if (this.isWithVideoImage && this.cutIndex < this.list.size() && MimeType.eqVideo(this.list.get(this.cutIndex).getMimeType())) {
                String newMimeType;
                while (this.cutIndex < this.list.size() && !MimeType.eqImage(newMimeType = this.list.get(this.cutIndex).getMimeType())) {
                    ++this.cutIndex;
                }
            }
            this.oldCutIndex = this.cutIndex;
            if (this.cutIndex >= this.list.size()) {
                this.setResult(-1, new Intent().putExtra("com.yalantis.ucrop.OutputUriList", this.list));
                this.onBackPressed();
            } else {
                this.resetCutData();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void onDestroy() {
        if (this.mAdapter != null) {
            this.mAdapter.setOnItemClickListener(null);
        }
        super.onDestroy();
    }
}

