/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.widget;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.PopupWindow;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.luck.picture.lib.R;
import com.luck.picture.lib.adapter.PictureAlbumDirectoryAdapter;
import com.luck.picture.lib.config.PictureSelectionConfig;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.entity.LocalMediaFolder;
import com.luck.picture.lib.tools.AnimUtils;
import com.luck.picture.lib.tools.AttrsUtils;
import com.luck.picture.lib.tools.ScreenUtils;
import java.util.List;

public class FolderPopWindow
extends PopupWindow {
    private Context context;
    private View window;
    private RecyclerView recyclerView;
    private PictureAlbumDirectoryAdapter adapter;
    private boolean isDismiss = false;
    private ImageView ivArrowView;
    private Drawable drawableUp;
    private Drawable drawableDown;
    private int chooseMode;
    private PictureSelectionConfig config;
    private int maxHeight;
    private View rootViewBg;

    public FolderPopWindow(Context context, PictureSelectionConfig config) {
        this.context = context;
        this.config = config;
        this.chooseMode = config.chooseMode;
        this.window = LayoutInflater.from((Context)context).inflate(R.layout.picture_window_folder, null);
        this.setContentView(this.window);
        this.setWidth(-1);
        this.setHeight(-2);
        this.setAnimationStyle(R.style.PictureThemeWindowStyle);
        this.setFocusable(true);
        this.setOutsideTouchable(true);
        this.update();
        if (config.style != null) {
            if (config.style.pictureTitleUpResId != 0) {
                this.drawableUp = ContextCompat.getDrawable((Context)context, (int)config.style.pictureTitleUpResId);
            }
            if (config.style.pictureTitleDownResId != 0) {
                this.drawableDown = ContextCompat.getDrawable((Context)context, (int)config.style.pictureTitleDownResId);
            }
        } else if (config.isWeChatStyle) {
            this.drawableUp = ContextCompat.getDrawable((Context)context, (int)R.drawable.picture_icon_wechat_up);
            this.drawableDown = ContextCompat.getDrawable((Context)context, (int)R.drawable.picture_icon_wechat_down);
        } else {
            this.drawableUp = config.upResId != 0 ? ContextCompat.getDrawable((Context)context, (int)config.upResId) : AttrsUtils.getTypeValueDrawable(context, R.attr.picture_arrow_up_icon);
            this.drawableDown = config.downResId != 0 ? ContextCompat.getDrawable((Context)context, (int)config.downResId) : AttrsUtils.getTypeValueDrawable(context, R.attr.picture_arrow_down_icon);
        }
        this.maxHeight = (int)((double)ScreenUtils.getScreenHeight(context) * 0.6);
        this.initView();
    }

    public void initView() {
        this.rootViewBg = this.window.findViewById(R.id.rootViewBg);
        this.adapter = new PictureAlbumDirectoryAdapter(this.config);
        this.recyclerView = (RecyclerView)this.window.findViewById(R.id.folder_list);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.context));
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
        this.window.findViewById(R.id.rootView).setOnClickListener(v -> this.dismiss());
        this.rootViewBg.setOnClickListener(v -> this.dismiss());
    }

    public void bindFolder(List<LocalMediaFolder> folders) {
        this.adapter.setChooseMode(this.chooseMode);
        this.adapter.bindFolderData(folders);
        ViewGroup.LayoutParams lp = this.recyclerView.getLayoutParams();
        lp.height = folders != null && folders.size() > 8 ? this.maxHeight : -2;
    }

    public void setArrowImageView(ImageView ivArrowView) {
        this.ivArrowView = ivArrowView;
    }

    public void showAsDropDown(View anchor) {
        try {
            if (Build.VERSION.SDK_INT == 24) {
                int[] location = new int[2];
                anchor.getLocationInWindow(location);
                this.showAtLocation(anchor, 0, 0, location[1] + anchor.getHeight());
            } else {
                super.showAsDropDown(anchor);
            }
            this.isDismiss = false;
            this.ivArrowView.setImageDrawable(this.drawableUp);
            AnimUtils.rotateArrow(this.ivArrowView, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setOnItemClickListener(PictureAlbumDirectoryAdapter.OnItemClickListener onItemClickListener) {
        this.adapter.setOnItemClickListener(onItemClickListener);
    }

    public void dismiss() {
        if (this.isDismiss) {
            return;
        }
        this.ivArrowView.setImageDrawable(this.drawableDown);
        AnimUtils.rotateArrow(this.ivArrowView, false);
        this.isDismiss = true;
        if (Build.VERSION.SDK_INT <= 16) {
            this.dismiss4Pop();
            this.isDismiss = false;
        } else {
            FolderPopWindow.super.dismiss();
            this.isDismiss = false;
        }
    }

    private void dismiss4Pop() {
        new Handler().post(() -> FolderPopWindow.super.dismiss());
    }

    public void updateFolderCheckStatus(List<LocalMedia> result) {
        try {
            List<LocalMediaFolder> folders = this.adapter.getFolderData();
            int size = folders.size();
            for (int i = 0; i < size; ++i) {
                LocalMediaFolder mediaFolder = folders.get(i);
                mediaFolder.setCheckedNum(0);
                List<LocalMedia> images = mediaFolder.getImages();
                int iSize = images.size();
                int rSize = result.size();
                block3: for (int j = 0; j < iSize; ++j) {
                    LocalMedia oldMedia = images.get(j);
                    String path = oldMedia.getPath();
                    for (int k = 0; k < rSize; ++k) {
                        LocalMedia newMedia = result.get(k);
                        if (!path.equals(newMedia.getPath()) && oldMedia.getId() != newMedia.getId()) continue;
                        mediaFolder.setCheckedNum(1);
                        continue block3;
                    }
                }
            }
            this.adapter.bindFolderData(folders);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

