/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.tools;

import android.content.Context;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.tools.DateUtils;
import com.luck.picture.lib.tools.Digest;
import com.luck.picture.lib.tools.PictureFileUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;

public class AndroidQTransformUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String parseVideoPathToAndroidQ(Context ctx, String path, String customFileName, String mineType) {
        ParcelFileDescriptor parcelFileDescriptor = null;
        try {
            String fileName;
            String suffix = PictureMimeType.getLastImgSuffix(mineType);
            String filesDir = PictureFileUtils.getVideoDiskCacheDir(ctx.getApplicationContext());
            parcelFileDescriptor = ctx.getContentResolver().openFileDescriptor(Uri.parse((String)path), "r");
            FileInputStream inputStream = new FileInputStream(parcelFileDescriptor.getFileDescriptor());
            String md5Value = Digest.computeToQMD5(inputStream);
            if (!TextUtils.isEmpty((CharSequence)md5Value)) {
                fileName = TextUtils.isEmpty((CharSequence)customFileName) ? new StringBuffer().append("VID_").append(md5Value.toUpperCase()).append(suffix).toString() : customFileName;
            } else {
                String string2 = fileName = TextUtils.isEmpty((CharSequence)customFileName) ? DateUtils.getCreateFileName("VID_") + suffix : customFileName;
            }
            if (filesDir != null) {
                String newPath = new StringBuffer().append(filesDir).append(File.separator).append(fileName).toString();
                File outFile = new File(newPath);
                if (outFile.exists()) {
                    String string3 = newPath;
                    PictureFileUtils.close((Closeable)parcelFileDescriptor);
                    return string3;
                }
                boolean copyFileSuccess = PictureFileUtils.copyFile(inputStream, outFile);
                if (copyFileSuccess) {
                    String string4 = newPath;
                    PictureFileUtils.close((Closeable)parcelFileDescriptor);
                    return string4;
                }
            }
            PictureFileUtils.close((Closeable)parcelFileDescriptor);
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
        finally {
            PictureFileUtils.close(parcelFileDescriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String parseImagePathToAndroidQ(Context ctx, String path, String customFileName, String mineType) {
        ParcelFileDescriptor parcelFileDescriptor;
        block7: {
            String string2;
            File outFile;
            String newPath;
            FileInputStream inputStream;
            block8: {
                String fileName;
                parcelFileDescriptor = null;
                parcelFileDescriptor = ctx.getContentResolver().openFileDescriptor(Uri.parse((String)path), "r");
                inputStream = new FileInputStream(parcelFileDescriptor.getFileDescriptor());
                String md5Value = Digest.computeToQMD5(inputStream);
                String suffix = PictureMimeType.getLastImgSuffix(mineType);
                String filesDir = PictureFileUtils.getDiskCacheDir(ctx.getApplicationContext());
                if (!TextUtils.isEmpty((CharSequence)md5Value)) {
                    fileName = TextUtils.isEmpty((CharSequence)customFileName) ? new StringBuffer().append("IMG_").append(md5Value.toUpperCase()).append(suffix).toString() : customFileName;
                } else {
                    String string3 = fileName = TextUtils.isEmpty((CharSequence)customFileName) ? DateUtils.getCreateFileName("IMG_") + suffix : customFileName;
                }
                if (filesDir == null) break block7;
                newPath = new StringBuffer().append(filesDir).append(File.separator).append(fileName).toString();
                outFile = new File(newPath);
                if (!outFile.exists()) break block8;
                String string4 = newPath;
                PictureFileUtils.close((Closeable)parcelFileDescriptor);
                return string4;
            }
            try {
                boolean copyFileSuccess = PictureFileUtils.copyFile(inputStream, outFile);
                if (!copyFileSuccess) break block7;
                string2 = newPath;
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    PictureFileUtils.close(parcelFileDescriptor);
                    throw throwable;
                }
                PictureFileUtils.close((Closeable)parcelFileDescriptor);
            }
            PictureFileUtils.close((Closeable)parcelFileDescriptor);
            return string2;
        }
        PictureFileUtils.close((Closeable)parcelFileDescriptor);
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String parseAudioPathToAndroidQ(Context ctx, String path, String customFileName, String mineType) {
        ParcelFileDescriptor parcelFileDescriptor;
        block7: {
            String string2;
            File outFile;
            String newPath;
            FileInputStream inputStream;
            block8: {
                String fileName;
                parcelFileDescriptor = null;
                parcelFileDescriptor = ctx.getContentResolver().openFileDescriptor(Uri.parse((String)path), "r");
                String suffix = PictureMimeType.getLastImgSuffix(mineType);
                String filesDir = PictureFileUtils.getAudioDiskCacheDir(ctx.getApplicationContext());
                inputStream = new FileInputStream(parcelFileDescriptor.getFileDescriptor());
                String md5Value = Digest.computeToQMD5(inputStream);
                if (!TextUtils.isEmpty((CharSequence)md5Value)) {
                    fileName = TextUtils.isEmpty((CharSequence)customFileName) ? new StringBuffer().append("AUD_").append(md5Value.toUpperCase()).append(suffix).toString() : customFileName;
                } else {
                    String string3 = fileName = TextUtils.isEmpty((CharSequence)customFileName) ? DateUtils.getCreateFileName("AUD_") + suffix : customFileName;
                }
                if (filesDir == null) break block7;
                newPath = new StringBuffer().append(filesDir).append(File.separator).append(fileName).toString();
                outFile = new File(newPath);
                if (!outFile.exists()) break block8;
                String string4 = newPath;
                PictureFileUtils.close((Closeable)parcelFileDescriptor);
                return string4;
            }
            try {
                boolean copyFileSuccess = PictureFileUtils.copyFile(inputStream, outFile);
                if (!copyFileSuccess) break block7;
                string2 = newPath;
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    PictureFileUtils.close(parcelFileDescriptor);
                    throw throwable;
                }
                PictureFileUtils.close((Closeable)parcelFileDescriptor);
            }
            PictureFileUtils.close((Closeable)parcelFileDescriptor);
            return string2;
        }
        PictureFileUtils.close((Closeable)parcelFileDescriptor);
        return "";
    }

    @Nullable
    public static String getPathToAndroidQ(Context context, String cameraFileName, LocalMedia media) {
        if (PictureMimeType.eqVideo(media.getMimeType())) {
            return AndroidQTransformUtils.parseVideoPathToAndroidQ(context.getApplicationContext(), media.getPath(), cameraFileName, media.getMimeType());
        }
        if (PictureMimeType.eqAudio(media.getMimeType())) {
            return AndroidQTransformUtils.parseAudioPathToAndroidQ(context.getApplicationContext(), media.getPath(), cameraFileName, media.getMimeType());
        }
        return AndroidQTransformUtils.parseImagePathToAndroidQ(context.getApplicationContext(), media.getPath(), cameraFileName, media.getMimeType());
    }

    /*
     * Exception decompiling
     */
    public static void copyPathToDCIM(Context context, Uri inputUri, Uri outUri) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

