/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib.config;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import com.luck.picture.lib.R;
import java.io.File;

public final class PictureMimeType {
    public static final String MIME_TYPE_PNG = "image/png";
    public static final String MIME_TYPE_JPEG = "image/jpeg";
    public static final String MIME_TYPE_JPG = "image/jpg";
    public static final String MIME_TYPE_BMP = "image/bmp";
    public static final String MIME_TYPE_GIF = "image/gif";
    public static final String MIME_TYPE_WEBP = "image/webp";
    public static final String MIME_TYPE_3GP = "video/3gp";
    public static final String MIME_TYPE_MP4 = "video/mp4";
    public static final String MIME_TYPE_MPEG = "video/mpeg";
    public static final String MIME_TYPE_AVI = "video/avi";
    public static final String JPEG = ".jpg";
    public static final String PNG = ".png";
    public static final String MP4 = ".mp4";
    public static final String DCIM = "DCIM/Camera";
    public static final String MIME_TYPE_IMAGE = "image/jpeg";
    public static final String MIME_TYPE_VIDEO = "video/mp4";
    public static final String MIME_TYPE_AUDIO = "audio/mpeg";
    public static final String MIME_TYPE_PREFIX_IMAGE = "image";
    public static final String MIME_TYPE_PREFIX_VIDEO = "video";
    public static final String MIME_TYPE_PREFIX_AUDIO = "audio";

    public static final int ofAll() {
        return 0;
    }

    public static final int ofImage() {
        return 1;
    }

    public static final int ofVideo() {
        return 2;
    }

    @Deprecated
    public static final int ofAudio() {
        return 3;
    }

    public static final String ofPNG() {
        return MIME_TYPE_PNG;
    }

    public static final String ofJPEG() {
        return "image/jpeg";
    }

    public static final String ofBMP() {
        return MIME_TYPE_BMP;
    }

    public static final String ofGIF() {
        return MIME_TYPE_GIF;
    }

    public static final String ofWEBP() {
        return MIME_TYPE_WEBP;
    }

    public static final String of3GP() {
        return MIME_TYPE_3GP;
    }

    public static final String ofMP4() {
        return "video/mp4";
    }

    public static final String ofMPEG() {
        return MIME_TYPE_MPEG;
    }

    public static final String ofAVI() {
        return MIME_TYPE_AVI;
    }

    public static boolean isGif(String mimeType) {
        return mimeType != null && (mimeType.equals(MIME_TYPE_GIF) || mimeType.equals("image/GIF"));
    }

    public static boolean eqVideo(String mimeType) {
        return mimeType != null && mimeType.startsWith(MIME_TYPE_PREFIX_VIDEO);
    }

    public static boolean eqAudio(String mimeType) {
        return mimeType != null && mimeType.startsWith(MIME_TYPE_PREFIX_AUDIO);
    }

    public static boolean eqImage(String mimeType) {
        return mimeType != null && mimeType.startsWith(MIME_TYPE_PREFIX_IMAGE);
    }

    public static boolean isJPEG(String mimeType) {
        if (TextUtils.isEmpty((CharSequence)mimeType)) {
            return false;
        }
        return mimeType.startsWith("image/jpeg") || mimeType.startsWith(MIME_TYPE_JPG);
    }

    public static boolean isJPG(String mimeType) {
        if (TextUtils.isEmpty((CharSequence)mimeType)) {
            return false;
        }
        return mimeType.startsWith(MIME_TYPE_JPG);
    }

    public static boolean isHttp(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return false;
        }
        return path.startsWith("http") || path.startsWith("https") || path.startsWith("/http") || path.startsWith("/https");
    }

    public static String getMimeType(File file) {
        if (file != null) {
            String name = file.getName();
            if (name.endsWith(MP4) || name.endsWith(".avi") || name.endsWith(".3gpp") || name.endsWith(".3gp") || name.endsWith(".mov")) {
                return "video/mp4";
            }
            if (name.endsWith(".PNG") || name.endsWith(PNG) || name.endsWith(".jpeg") || name.endsWith(".gif") || name.endsWith(".GIF") || name.endsWith(JPEG) || name.endsWith(".webp") || name.endsWith(".WEBP") || name.endsWith(".JPEG") || name.endsWith(".bmp")) {
                return "image/jpeg";
            }
            if (name.endsWith(".mp3") || name.endsWith(".amr") || name.endsWith(".aac") || name.endsWith(".war") || name.endsWith(".flac") || name.endsWith(".lamr")) {
                return MIME_TYPE_AUDIO;
            }
        }
        return "image/jpeg";
    }

    public static boolean isSuffixOfImage(String name) {
        return !TextUtils.isEmpty((CharSequence)name) && name.endsWith(".PNG") || name.endsWith(PNG) || name.endsWith(".jpeg") || name.endsWith(".gif") || name.endsWith(".GIF") || name.endsWith(JPEG) || name.endsWith(".webp") || name.endsWith(".WEBP") || name.endsWith(".JPEG") || name.endsWith(".bmp");
    }

    public static boolean isMimeTypeSame(String oldMimeType, String newMimeType) {
        return PictureMimeType.getMimeType(oldMimeType) == PictureMimeType.getMimeType(newMimeType);
    }

    public static String getImageMimeType(String path) {
        try {
            if (!TextUtils.isEmpty((CharSequence)path)) {
                File file = new File(path);
                String fileName = file.getName();
                int last = fileName.lastIndexOf(".") + 1;
                String temp = fileName.substring(last);
                return "image/" + temp;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return "image/jpeg";
        }
        return "image/jpeg";
    }

    public static String getMimeType(Context context, Uri uri) {
        Cursor cursor;
        if ("content".equals(uri.getScheme()) && (cursor = context.getApplicationContext().getContentResolver().query(uri, new String[]{"mime_type"}, null, null, null)) != null) {
            int columnIndex;
            if (cursor.moveToFirst() && (columnIndex = cursor.getColumnIndexOrThrow("mime_type")) > -1) {
                return cursor.getString(columnIndex);
            }
            cursor.close();
        }
        return "image/jpeg";
    }

    public static int getMimeType(String mimeType) {
        if (TextUtils.isEmpty((CharSequence)mimeType)) {
            return 1;
        }
        if (mimeType.startsWith(MIME_TYPE_PREFIX_VIDEO)) {
            return 2;
        }
        if (mimeType.startsWith(MIME_TYPE_PREFIX_AUDIO)) {
            return 3;
        }
        return 1;
    }

    public static String getLastImgType(String path) {
        try {
            int index = path.lastIndexOf(".");
            if (index > 0) {
                String imageType;
                switch (imageType = path.substring(index)) {
                    case ".png": 
                    case ".PNG": 
                    case ".jpg": 
                    case ".jpeg": 
                    case ".JPEG": 
                    case ".WEBP": 
                    case ".bmp": 
                    case ".BMP": 
                    case ".webp": 
                    case ".gif": 
                    case ".GIF": {
                        return imageType;
                    }
                }
                return PNG;
            }
            return PNG;
        }
        catch (Exception e) {
            e.printStackTrace();
            return PNG;
        }
    }

    public static String getLastImgSuffix(String mineType) {
        String defaultSuffix = PNG;
        try {
            int index = mineType.lastIndexOf("/") + 1;
            if (index > 0) {
                return "." + mineType.substring(index);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultSuffix;
        }
        return defaultSuffix;
    }

    public static String getMimeTypeFromMediaContentUri(Context context, Uri uri) {
        String mimeType;
        if (uri.getScheme().equals("content")) {
            ContentResolver cr = context.getContentResolver();
            mimeType = cr.getType(uri);
        } else {
            String fileExtension = MimeTypeMap.getFileExtensionFromUrl((String)uri.toString());
            mimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(fileExtension.toLowerCase());
        }
        return TextUtils.isEmpty((CharSequence)mimeType) ? "image/jpeg" : mimeType;
    }

    public static String s(Context context, String mimeType) {
        Context ctx = context.getApplicationContext();
        if (PictureMimeType.eqVideo(mimeType)) {
            return ctx.getString(R.string.picture_video_error);
        }
        if (PictureMimeType.eqAudio(mimeType)) {
            return ctx.getString(R.string.picture_audio_error);
        }
        return ctx.getString(R.string.picture_error);
    }
}

