/*
 * Decompiled with CFR 0.152.
 */
package com.luck.picture.lib;

import android.content.Context;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.text.TextUtils;

public class PictureMediaScannerConnection
implements MediaScannerConnection.MediaScannerConnectionClient {
    private MediaScannerConnection mMs;
    private String mPath;
    private ScanListener mListener;
    private String mimeType;

    public PictureMediaScannerConnection(Context context, String path, ScanListener l) {
        this.mListener = l;
        this.mPath = path;
        this.mMs = new MediaScannerConnection(context.getApplicationContext(), (MediaScannerConnection.MediaScannerConnectionClient)this);
        this.mMs.connect();
    }

    public PictureMediaScannerConnection(Context context, String path) {
        this.mPath = path;
        this.mMs = new MediaScannerConnection(context.getApplicationContext(), (MediaScannerConnection.MediaScannerConnectionClient)this);
        this.mMs.connect();
    }

    public PictureMediaScannerConnection(Context context, String path, String mimeType) {
        this.mPath = path;
        this.mimeType = mimeType;
        this.mMs = new MediaScannerConnection(context.getApplicationContext(), (MediaScannerConnection.MediaScannerConnectionClient)this);
        this.mMs.connect();
    }

    public void onMediaScannerConnected() {
        if (!TextUtils.isEmpty((CharSequence)this.mPath)) {
            this.mMs.scanFile(this.mPath, this.mimeType);
        }
    }

    public void onScanCompleted(String path, Uri uri) {
        this.mMs.disconnect();
        if (this.mListener != null) {
            this.mListener.onScanFinish();
        }
    }

    public static interface ScanListener {
        public void onScanFinish();
    }
}

