/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.view;

import android.content.Context;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.SurfaceView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

final class TransformableSurfaceView
extends SurfaceView {
    private RectF mOverriddenLayoutRect;

    TransformableSurfaceView(@NonNull Context context) {
        super(context);
    }

    TransformableSurfaceView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    TransformableSurfaceView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    TransformableSurfaceView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mOverriddenLayoutRect == null) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        } else {
            this.setMeasuredDimension((int)this.mOverriddenLayoutRect.width(), (int)this.mOverriddenLayoutRect.height());
        }
    }

    void setTransform(Matrix transform) {
        if (this.hasRotation(transform)) {
            throw new IllegalArgumentException("TransformableSurfaceView does not support rotation transformations.");
        }
        RectF rect = new RectF((float)this.getLeft(), (float)this.getTop(), (float)this.getRight(), (float)this.getBottom());
        transform.mapRect(rect);
        this.overrideLayout(rect);
    }

    private boolean hasRotation(Matrix matrix) {
        float[] values = new float[9];
        matrix.getValues(values);
        double angle = -Math.atan2(values[1], values[0]);
        return Math.round(angle * 57.29577951308232) != 0L;
    }

    private void overrideLayout(RectF overriddenLayoutRect) {
        this.mOverriddenLayoutRect = overriddenLayoutRect;
        this.setX(overriddenLayoutRect.left);
        this.setY(overriddenLayoutRect.top);
        this.requestLayout();
    }
}

