/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.view;

import android.content.Context;
import android.graphics.Matrix;
import android.graphics.SurfaceTexture;
import android.util.Log;
import android.util.Size;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.Preview;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.camera.view.PreviewView;
import androidx.camera.view.ScaleTypeTransform;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.content.ContextCompat;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.Executor;

public class TextureViewImplementation
implements PreviewView.Implementation {
    private static final String TAG = "TextureViewImpl";
    TextureView mTextureView;
    SurfaceTexture mSurfaceTexture;
    private Size mResolution;
    ListenableFuture<Void> mSurfaceReleaseFuture;
    CallbackToFutureAdapter.Completer<Surface> mSurfaceCompleter;

    @Override
    public void init(@NonNull FrameLayout parent) {
        this.mTextureView = new TextureView(parent.getContext());
        this.mTextureView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.mTextureView.setSurfaceTextureListener(new TextureView.SurfaceTextureListener(){

            public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int width, int height) {
                TextureViewImplementation.this.mSurfaceTexture = surfaceTexture;
                TextureViewImplementation.this.tryToProvidePreviewSurface();
            }

            public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int width, int height) {
                Log.d((String)TextureViewImplementation.TAG, (String)("onSurfaceTextureSizeChanged(width:" + width + ", height: " + height + " )"));
            }

            public boolean onSurfaceTextureDestroyed(final SurfaceTexture surfaceTexture) {
                TextureViewImplementation.this.mSurfaceTexture = null;
                if (TextureViewImplementation.this.mSurfaceCompleter == null && TextureViewImplementation.this.mSurfaceReleaseFuture != null) {
                    Futures.addCallback(TextureViewImplementation.this.mSurfaceReleaseFuture, (FutureCallback)new FutureCallback<Void>(){

                        public void onSuccess(@Nullable Void result) {
                            surfaceTexture.release();
                        }

                        public void onFailure(Throwable t) {
                            throw new IllegalStateException("SurfaceReleaseFuture should never fail. Did it get completed by GC?", t);
                        }
                    }, (Executor)ContextCompat.getMainExecutor((Context)TextureViewImplementation.this.mTextureView.getContext()));
                    return false;
                }
                return true;
            }

            public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
            }
        });
        parent.addView((View)this.mTextureView);
    }

    @Override
    @NonNull
    public Preview.PreviewSurfaceProvider getPreviewSurfaceProvider() {
        return (resolution, surfaceReleaseFuture) -> {
            this.mResolution = resolution;
            this.mSurfaceReleaseFuture = surfaceReleaseFuture;
            return CallbackToFutureAdapter.getFuture(completer -> {
                completer.addCancellationListener(() -> {
                    Preconditions.checkState((this.mSurfaceCompleter == completer ? 1 : 0) != 0);
                    this.mSurfaceCompleter = null;
                    this.mSurfaceReleaseFuture = null;
                }, ContextCompat.getMainExecutor((Context)this.mTextureView.getContext()));
                this.mSurfaceCompleter = completer;
                this.tryToProvidePreviewSurface();
                return "provide preview surface";
            });
        };
    }

    void tryToProvidePreviewSurface() {
        if (this.mResolution == null || this.mSurfaceTexture == null || this.mSurfaceCompleter == null) {
            return;
        }
        this.mSurfaceTexture.setDefaultBufferSize(this.mResolution.getWidth(), this.mResolution.getHeight());
        Surface surface = new Surface(this.mSurfaceTexture);
        ListenableFuture<Void> surfaceReleaseFuture = this.mSurfaceReleaseFuture;
        this.mSurfaceReleaseFuture.addListener(() -> {
            surface.release();
            if (this.mSurfaceReleaseFuture == surfaceReleaseFuture) {
                this.mSurfaceReleaseFuture = null;
            }
        }, ContextCompat.getMainExecutor((Context)this.mTextureView.getContext()));
        this.mSurfaceCompleter.set((Object)surface);
        this.mSurfaceCompleter = null;
        this.transformPreview();
    }

    private void transformPreview() {
        WindowManager windowManager = (WindowManager)this.mTextureView.getContext().getSystemService("window");
        if (windowManager == null) {
            return;
        }
        int rotation = windowManager.getDefaultDisplay().getRotation();
        Matrix transformMatrix = ScaleTypeTransform.transformCenterCrop(this.mResolution, (View)this.mTextureView, rotation);
        this.mTextureView.setTransform(transformMatrix);
    }
}

