/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.view;

import android.graphics.SurfaceTexture;
import android.view.TextureView;
import androidx.annotation.NonNull;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

final class SurfaceTextureReleaseBlockingListener
implements TextureView.SurfaceTextureListener {
    private ConcurrentHashMap<SurfaceTexture, CallbackToFutureAdapter.Completer<Void>> mSurfaceTextureCompleterConcurrentHashMap = new ConcurrentHashMap();
    private final TextureView mTextureView;

    SurfaceTextureReleaseBlockingListener(TextureView textureView) {
        this.mTextureView = textureView;
        this.mTextureView.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this);
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        CallbackToFutureAdapter.Completer<Void> completer = this.mSurfaceTextureCompleterConcurrentHashMap.get(surface);
        if (completer == null) {
            return true;
        }
        completer.set(null);
        this.mSurfaceTextureCompleterConcurrentHashMap.remove(surface);
        return false;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
    }

    void setSurfaceTextureSafely(@NonNull SurfaceTexture surfaceTexture, @NonNull ListenableFuture<Void> surfaceReleaseBlockingFuture) {
        if (this.mSurfaceTextureCompleterConcurrentHashMap.containsKey(surfaceTexture)) {
            throw new IllegalArgumentException("SurfaceTexture already registered for destroy future");
        }
        ListenableFuture releasedByTextureViewFuture = CallbackToFutureAdapter.getFuture(completer -> {
            this.mSurfaceTextureCompleterConcurrentHashMap.put(surfaceTexture, (CallbackToFutureAdapter.Completer<Void>)completer);
            return "SurfaceTextureDestroyCompleter";
        });
        List<ListenableFuture> futureList = Arrays.asList(surfaceReleaseBlockingFuture, releasedByTextureViewFuture);
        ListenableFuture future = Futures.successfulAsList(futureList);
        future.addListener(() -> ((SurfaceTexture)surfaceTexture).release(), CameraXExecutors.directExecutor());
        this.mTextureView.setSurfaceTexture(surfaceTexture);
    }
}

