/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.SurfaceTexture;
import android.hardware.display.DisplayManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Size;
import android.view.Display;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.TextureView;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RequiresPermission;
import androidx.annotation.RestrictTo;
import androidx.annotation.UiThread;
import androidx.camera.core.Camera;
import androidx.camera.core.FlashModeHelper;
import androidx.camera.core.FocusMeteringAction;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.LensFacingConverter;
import androidx.camera.core.MeteringPoint;
import androidx.camera.core.VideoCapture;
import androidx.camera.view.CameraXModule;
import androidx.camera.view.TextureViewMeteringPointFactory;
import androidx.lifecycle.LifecycleOwner;
import com.luck.picture.lib.R;
import java.io.File;
import java.util.concurrent.Executor;

public final class CameraView
extends ViewGroup {
    static final String TAG = CameraView.class.getSimpleName();
    static final boolean DEBUG = false;
    static final int INDEFINITE_VIDEO_DURATION = -1;
    static final int INDEFINITE_VIDEO_SIZE = -1;
    private static final String EXTRA_SUPER = "super";
    private static final String EXTRA_ZOOM_RATIO = "zoom_ratio";
    private static final String EXTRA_PINCH_TO_ZOOM_ENABLED = "pinch_to_zoom_enabled";
    private static final String EXTRA_FLASH = "flash";
    private static final String EXTRA_MAX_VIDEO_DURATION = "max_video_duration";
    private static final String EXTRA_MAX_VIDEO_SIZE = "max_video_size";
    private static final String EXTRA_SCALE_TYPE = "scale_type";
    private static final String EXTRA_CAMERA_DIRECTION = "camera_direction";
    private static final String EXTRA_CAPTURE_MODE = "captureMode";
    private static final int LENS_FACING_NONE = 0;
    private static final int LENS_FACING_FRONT = 1;
    private static final int LENS_FACING_BACK = 2;
    private static final int FLASH_MODE_AUTO = 1;
    private static final int FLASH_MODE_ON = 2;
    private static final int FLASH_MODE_OFF = 4;
    private long mDownEventTimestamp;
    private PinchToZoomGestureDetector mPinchToZoomGestureDetector;
    private boolean mIsPinchToZoomEnabled = true;
    CameraXModule mCameraModule;
    private final DisplayManager.DisplayListener mDisplayListener = new DisplayManager.DisplayListener(){

        public void onDisplayAdded(int displayId) {
        }

        public void onDisplayRemoved(int displayId) {
        }

        public void onDisplayChanged(int displayId) {
            CameraView.this.mCameraModule.invalidateView();
        }
    };
    private TextureView mCameraTextureView;
    private Size mPreviewSrcSize = new Size(0, 0);
    private ScaleType mScaleType = ScaleType.CENTER_CROP;
    private MotionEvent mUpEvent;
    @Nullable
    private Paint mLayerPaint;

    public CameraView(@NonNull Context context) {
        this(context, null);
    }

    public CameraView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CameraView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
    }

    @RequiresApi(value=21)
    public CameraView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    private static void log(String msg) {
    }

    private static String displayRotationToString(int displayRotation) {
        if (displayRotation == 0 || displayRotation == 2) {
            return "Portrait-" + displayRotation * 90;
        }
        if (displayRotation == 1 || displayRotation == 3) {
            return "Landscape-" + displayRotation * 90;
        }
        return "Unknown";
    }

    @RequiresPermission(value="android.permission.CAMERA")
    public void bindToLifecycle(@NonNull LifecycleOwner lifecycleOwner) {
        this.mCameraModule.bindToLifecycle(lifecycleOwner);
    }

    private void init(Context context, @Nullable AttributeSet attrs) {
        this.mCameraTextureView = new TextureView(this.getContext());
        this.addView((View)this.mCameraTextureView, 0);
        this.mCameraTextureView.setLayerPaint(this.mLayerPaint);
        this.mCameraModule = new CameraXModule(this);
        if (this.isInEditMode()) {
            this.onPreviewSourceDimensUpdated(640, 480);
        }
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CameraView);
            this.setScaleType(ScaleType.fromId(a.getInteger(R.styleable.CameraView_scaleType, this.getScaleType().getId())));
            this.setPinchToZoomEnabled(a.getBoolean(R.styleable.CameraView_pinchToZoomEnabled, this.isPinchToZoomEnabled()));
            this.setCaptureMode(CaptureMode.fromId(a.getInteger(R.styleable.CameraView_captureMode, this.getCaptureMode().getId())));
            int lensFacing = a.getInt(R.styleable.CameraView_lensFacing, 2);
            switch (lensFacing) {
                case 0: {
                    this.setCameraLensFacing(null);
                    break;
                }
                case 1: {
                    this.setCameraLensFacing(0);
                    break;
                }
                case 2: {
                    this.setCameraLensFacing(1);
                    break;
                }
            }
            int flashMode = a.getInt(R.styleable.CameraView_flash, 0);
            switch (flashMode) {
                case 1: {
                    this.setFlash(0);
                    break;
                }
                case 2: {
                    this.setFlash(1);
                    break;
                }
                case 4: {
                    this.setFlash(2);
                    break;
                }
            }
            a.recycle();
        }
        if (this.getBackground() == null) {
            this.setBackgroundColor(-15658735);
        }
        this.mPinchToZoomGestureDetector = new PinchToZoomGestureDetector(context);
    }

    @NonNull
    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new ViewGroup.LayoutParams(-1, -1);
    }

    @NonNull
    protected Parcelable onSaveInstanceState() {
        Bundle state = new Bundle();
        state.putParcelable(EXTRA_SUPER, super.onSaveInstanceState());
        state.putInt(EXTRA_SCALE_TYPE, this.getScaleType().getId());
        state.putFloat(EXTRA_ZOOM_RATIO, this.getZoomRatio());
        state.putBoolean(EXTRA_PINCH_TO_ZOOM_ENABLED, this.isPinchToZoomEnabled());
        state.putString(EXTRA_FLASH, FlashModeHelper.nameOf((int)this.getFlash()));
        state.putLong(EXTRA_MAX_VIDEO_DURATION, this.getMaxVideoDuration());
        state.putLong(EXTRA_MAX_VIDEO_SIZE, this.getMaxVideoSize());
        if (this.getCameraLensFacing() != null) {
            state.putString(EXTRA_CAMERA_DIRECTION, LensFacingConverter.nameOf((int)this.getCameraLensFacing()));
        }
        state.putInt(EXTRA_CAPTURE_MODE, this.getCaptureMode().getId());
        return state;
    }

    protected void onRestoreInstanceState(@Nullable Parcelable savedState) {
        if (savedState instanceof Bundle) {
            Bundle state = (Bundle)savedState;
            super.onRestoreInstanceState(state.getParcelable(EXTRA_SUPER));
            this.setScaleType(ScaleType.fromId(state.getInt(EXTRA_SCALE_TYPE)));
            this.setZoomRatio(state.getFloat(EXTRA_ZOOM_RATIO));
            this.setPinchToZoomEnabled(state.getBoolean(EXTRA_PINCH_TO_ZOOM_ENABLED));
            this.setFlash(FlashModeHelper.valueOf((String)state.getString(EXTRA_FLASH)));
            this.setMaxVideoDuration(state.getLong(EXTRA_MAX_VIDEO_DURATION));
            this.setMaxVideoSize(state.getLong(EXTRA_MAX_VIDEO_SIZE));
            String lensFacingString = state.getString(EXTRA_CAMERA_DIRECTION);
            this.setCameraLensFacing(TextUtils.isEmpty((CharSequence)lensFacingString) ? null : Integer.valueOf(LensFacingConverter.valueOf((String)lensFacingString)));
            this.setCaptureMode(CaptureMode.fromId(state.getInt(EXTRA_CAPTURE_MODE)));
        } else {
            super.onRestoreInstanceState(savedState);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setLayerPaint(@Nullable Paint paint) {
        super.setLayerPaint(paint);
        this.mLayerPaint = paint;
        this.mCameraTextureView.setLayerPaint(paint);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        DisplayManager dpyMgr = (DisplayManager)this.getContext().getSystemService("display");
        dpyMgr.registerDisplayListener(this.mDisplayListener, new Handler(Looper.getMainLooper()));
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        DisplayManager dpyMgr = (DisplayManager)this.getContext().getSystemService("display");
        dpyMgr.unregisterDisplayListener(this.mDisplayListener);
    }

    @SuppressLint(value={"MissingPermission"})
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int viewWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int viewHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int displayRotation = this.getDisplay().getRotation();
        if (this.mPreviewSrcSize.getHeight() == 0 || this.mPreviewSrcSize.getWidth() == 0) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            this.mCameraTextureView.measure(viewWidth, viewHeight);
        } else {
            Size scaled = this.calculatePreviewViewDimens(this.mPreviewSrcSize, viewWidth, viewHeight, displayRotation, this.mScaleType);
            super.setMeasuredDimension(Math.min(scaled.getWidth(), viewWidth), Math.min(scaled.getHeight(), viewHeight));
            this.mCameraTextureView.measure(scaled.getWidth(), scaled.getHeight());
        }
        if (this.getMeasuredWidth() > 0 && this.getMeasuredHeight() > 0) {
            this.mCameraModule.bindToLifecycleAfterViewMeasured();
        }
    }

    @SuppressLint(value={"MissingPermission"})
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.mCameraModule.bindToLifecycleAfterViewMeasured();
        if (this.mPreviewSrcSize.getWidth() == 0 || this.mPreviewSrcSize.getHeight() == 0) {
            this.mCameraTextureView.layout(left, top, right, bottom);
            return;
        }
        int viewWidth = right - left;
        int viewHeight = bottom - top;
        int displayRotation = this.getDisplay().getRotation();
        Size scaled = this.calculatePreviewViewDimens(this.mPreviewSrcSize, viewWidth, viewHeight, displayRotation, this.mScaleType);
        int centerX = viewWidth / 2;
        int centerY = viewHeight / 2;
        int layoutL = centerX - scaled.getWidth() / 2;
        int layoutT = centerY - scaled.getHeight() / 2;
        int layoutR = layoutL + scaled.getWidth();
        int layoutB = layoutT + scaled.getHeight();
        CameraView.log("layout: viewWidth:  " + viewWidth);
        CameraView.log("layout: viewHeight: " + viewHeight);
        CameraView.log("layout: viewRatio:  " + (float)viewWidth / (float)viewHeight);
        CameraView.log("layout: sizeWidth:  " + this.mPreviewSrcSize.getWidth());
        CameraView.log("layout: sizeHeight: " + this.mPreviewSrcSize.getHeight());
        CameraView.log("layout: sizeRatio:  " + (float)this.mPreviewSrcSize.getWidth() / (float)this.mPreviewSrcSize.getHeight());
        CameraView.log("layout: scaledWidth:  " + scaled.getWidth());
        CameraView.log("layout: scaledHeight: " + scaled.getHeight());
        CameraView.log("layout: scaledRatio:  " + (float)scaled.getWidth() / (float)scaled.getHeight());
        CameraView.log("layout: size:       " + scaled + " (" + (float)scaled.getWidth() / (float)scaled.getHeight() + " - " + (Object)((Object)this.mScaleType) + "-" + CameraView.displayRotationToString(displayRotation) + ")");
        CameraView.log("layout: final       " + layoutL + ", " + layoutT + ", " + layoutR + ", " + layoutB);
        this.mCameraTextureView.layout(layoutL, layoutT, layoutR, layoutB);
        this.mCameraModule.invalidateView();
    }

    @UiThread
    void onPreviewSourceDimensUpdated(int srcWidth, int srcHeight) {
        if (srcWidth != this.mPreviewSrcSize.getWidth() || srcHeight != this.mPreviewSrcSize.getHeight()) {
            this.mPreviewSrcSize = new Size(srcWidth, srcHeight);
            this.requestLayout();
        }
    }

    private Size calculatePreviewViewDimens(Size srcSize, int parentWidth, int parentHeight, int displayRotation, ScaleType scaleType) {
        int inWidth = srcSize.getWidth();
        int inHeight = srcSize.getHeight();
        if (displayRotation == 1 || displayRotation == 3) {
            inWidth = srcSize.getHeight();
            inHeight = srcSize.getWidth();
        }
        int outWidth = parentWidth;
        int outHeight = parentHeight;
        if (inWidth != 0 && inHeight != 0) {
            float vfRatio = (float)inWidth / (float)inHeight;
            float parentRatio = (float)parentWidth / (float)parentHeight;
            switch (scaleType) {
                case CENTER_INSIDE: {
                    if (vfRatio > parentRatio) {
                        outWidth = parentWidth;
                        outHeight = Math.round((float)parentWidth / vfRatio);
                        break;
                    }
                    outWidth = Math.round((float)parentHeight * vfRatio);
                    outHeight = parentHeight;
                    break;
                }
                case CENTER_CROP: {
                    if (vfRatio < parentRatio) {
                        outWidth = parentWidth;
                        outHeight = Math.round((float)parentWidth / vfRatio);
                        break;
                    }
                    outWidth = Math.round((float)parentHeight * vfRatio);
                    outHeight = parentHeight;
                }
            }
        }
        return new Size(outWidth, outHeight);
    }

    int getDisplaySurfaceRotation() {
        Display display = this.getDisplay();
        if (display == null) {
            return 0;
        }
        return display.getRotation();
    }

    @UiThread
    SurfaceTexture getSurfaceTexture() {
        if (this.mCameraTextureView != null) {
            return this.mCameraTextureView.getSurfaceTexture();
        }
        return null;
    }

    @UiThread
    void setSurfaceTexture(SurfaceTexture surfaceTexture) {
        if (this.mCameraTextureView.getSurfaceTexture() != surfaceTexture) {
            if (this.mCameraTextureView.isAvailable()) {
                this.removeView((View)this.mCameraTextureView);
                this.mCameraTextureView = new TextureView(this.getContext());
                this.addView((View)this.mCameraTextureView, 0);
                this.mCameraTextureView.setLayerPaint(this.mLayerPaint);
                this.requestLayout();
            }
            this.mCameraTextureView.setSurfaceTexture(surfaceTexture);
        }
    }

    @UiThread
    Matrix getTransform(Matrix matrix) {
        return this.mCameraTextureView.getTransform(matrix);
    }

    @UiThread
    int getPreviewWidth() {
        return this.mCameraTextureView.getWidth();
    }

    @UiThread
    int getPreviewHeight() {
        return this.mCameraTextureView.getHeight();
    }

    @UiThread
    void setTransform(Matrix matrix) {
        if (this.mCameraTextureView != null) {
            this.mCameraTextureView.setTransform(matrix);
        }
    }

    @NonNull
    public ScaleType getScaleType() {
        return this.mScaleType;
    }

    public void setScaleType(@NonNull ScaleType scaleType) {
        if (scaleType != this.mScaleType) {
            this.mScaleType = scaleType;
            this.requestLayout();
        }
    }

    @NonNull
    public CaptureMode getCaptureMode() {
        return this.mCameraModule.getCaptureMode();
    }

    public void setCaptureMode(@NonNull CaptureMode captureMode) {
        this.mCameraModule.setCaptureMode(captureMode);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public long getMaxVideoDuration() {
        return this.mCameraModule.getMaxVideoDuration();
    }

    private void setMaxVideoDuration(long duration) {
        this.mCameraModule.setMaxVideoDuration(duration);
    }

    private long getMaxVideoSize() {
        return this.mCameraModule.getMaxVideoSize();
    }

    private void setMaxVideoSize(long size) {
        this.mCameraModule.setMaxVideoSize(size);
    }

    @SuppressLint(value={"LambdaLast"})
    public void takePicture(@NonNull Executor executor, @NonNull ImageCapture.OnImageCapturedCallback callback) {
        this.mCameraModule.takePicture(executor, callback);
    }

    @SuppressLint(value={"LambdaLast"})
    public void takePicture(@NonNull File file, @NonNull Executor executor, @NonNull ImageCapture.OnImageSavedCallback callback) {
        this.mCameraModule.takePicture(file, executor, callback);
    }

    @SuppressLint(value={"LambdaLast"})
    public void startRecording(@NonNull File file, @NonNull Executor executor, @NonNull VideoCapture.OnVideoSavedCallback callback) {
        this.mCameraModule.startRecording(file, executor, callback);
    }

    public void stopRecording() {
        this.mCameraModule.stopRecording();
    }

    public boolean isRecording() {
        return this.mCameraModule.isRecording();
    }

    @RequiresPermission(value="android.permission.CAMERA")
    public boolean hasCameraWithLensFacing(int lensFacing) {
        return this.mCameraModule.hasCameraWithLensFacing(lensFacing);
    }

    public void toggleCamera() {
        this.mCameraModule.toggleCamera();
    }

    public void setCameraLensFacing(@Nullable Integer lensFacing) {
        this.mCameraModule.setCameraLensFacing(lensFacing);
    }

    @Nullable
    public Integer getCameraLensFacing() {
        return this.mCameraModule.getLensFacing();
    }

    public int getFlash() {
        return this.mCameraModule.getFlash();
    }

    public void setFlash(int flashMode) {
        this.mCameraModule.setFlash(flashMode);
    }

    private long delta() {
        return System.currentTimeMillis() - this.mDownEventTimestamp;
    }

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        if (this.mCameraModule.isPaused()) {
            return false;
        }
        if (this.isPinchToZoomEnabled()) {
            this.mPinchToZoomGestureDetector.onTouchEvent(event);
        }
        if (event.getPointerCount() == 2 && this.isPinchToZoomEnabled() && this.isZoomSupported()) {
            return true;
        }
        switch (event.getAction()) {
            case 0: {
                this.mDownEventTimestamp = System.currentTimeMillis();
                break;
            }
            case 1: {
                if (this.delta() >= (long)ViewConfiguration.getLongPressTimeout()) break;
                this.mUpEvent = event;
                this.performClick();
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public boolean performClick() {
        super.performClick();
        float x = this.mUpEvent != null ? this.mUpEvent.getX() : this.getX() + (float)this.getWidth() / 2.0f;
        float y = this.mUpEvent != null ? this.mUpEvent.getY() : this.getY() + (float)this.getHeight() / 2.0f;
        this.mUpEvent = null;
        TextureViewMeteringPointFactory pointFactory = new TextureViewMeteringPointFactory(this.mCameraTextureView);
        float afPointWidth = 0.16666667f;
        float aePointWidth = afPointWidth * 1.5f;
        MeteringPoint afPoint = pointFactory.createPoint(x, y, afPointWidth);
        MeteringPoint aePoint = pointFactory.createPoint(x, y, aePointWidth);
        Camera camera = this.mCameraModule.getCamera();
        if (camera != null) {
            camera.getCameraControl().startFocusAndMetering(FocusMeteringAction.Builder.from((MeteringPoint)afPoint, (int)1).addPoint(aePoint, 2).build());
        } else {
            Log.d((String)TAG, (String)"cannot access camera");
        }
        return true;
    }

    float rangeLimit(float val, float max, float min) {
        return Math.min(Math.max(val, min), max);
    }

    public boolean isPinchToZoomEnabled() {
        return this.mIsPinchToZoomEnabled;
    }

    public void setPinchToZoomEnabled(boolean enabled) {
        this.mIsPinchToZoomEnabled = enabled;
    }

    public float getZoomRatio() {
        return this.mCameraModule.getZoomRatio();
    }

    public void setZoomRatio(float zoomRatio) {
        this.mCameraModule.setZoomRatio(zoomRatio);
    }

    public float getMinZoomRatio() {
        return this.mCameraModule.getMinZoomRatio();
    }

    public float getMaxZoomRatio() {
        return this.mCameraModule.getMaxZoomRatio();
    }

    public boolean isZoomSupported() {
        return this.mCameraModule.isZoomSupported();
    }

    public void enableTorch(boolean torch) {
        this.mCameraModule.enableTorch(torch);
    }

    public boolean isTorchOn() {
        return this.mCameraModule.isTorchOn();
    }

    private class PinchToZoomGestureDetector
    extends ScaleGestureDetector
    implements ScaleGestureDetector.OnScaleGestureListener {
        PinchToZoomGestureDetector(Context context) {
            this(context, new S());
        }

        PinchToZoomGestureDetector(Context context, S s) {
            super(context, (ScaleGestureDetector.OnScaleGestureListener)s);
            s.setRealGestureDetector(this);
        }

        public boolean onScale(ScaleGestureDetector detector) {
            float scale = detector.getScaleFactor();
            scale = scale > 1.0f ? 1.0f + (scale - 1.0f) * 2.0f : 1.0f - (1.0f - scale) * 2.0f;
            float newRatio = CameraView.this.getZoomRatio() * scale;
            newRatio = CameraView.this.rangeLimit(newRatio, CameraView.this.getMaxZoomRatio(), CameraView.this.getMinZoomRatio());
            CameraView.this.setZoomRatio(newRatio);
            return true;
        }

        public boolean onScaleBegin(ScaleGestureDetector detector) {
            return true;
        }

        public void onScaleEnd(ScaleGestureDetector detector) {
        }
    }

    static class S
    extends ScaleGestureDetector.SimpleOnScaleGestureListener {
        private ScaleGestureDetector.OnScaleGestureListener mListener;

        S() {
        }

        void setRealGestureDetector(ScaleGestureDetector.OnScaleGestureListener l) {
            this.mListener = l;
        }

        public boolean onScale(ScaleGestureDetector detector) {
            return this.mListener.onScale(detector);
        }
    }

    public static enum CaptureMode {
        IMAGE(0),
        VIDEO(1),
        MIXED(2);

        private int mId;

        int getId() {
            return this.mId;
        }

        private CaptureMode(int id) {
            this.mId = id;
        }

        static CaptureMode fromId(int id) {
            for (CaptureMode f : CaptureMode.values()) {
                if (f.mId != id) continue;
                return f;
            }
            throw new IllegalArgumentException();
        }
    }

    public static enum ScaleType {
        CENTER_CROP(0),
        CENTER_INSIDE(1);

        private int mId;

        int getId() {
            return this.mId;
        }

        private ScaleType(int id) {
            this.mId = id;
        }

        static ScaleType fromId(int id) {
            for (ScaleType st : ScaleType.values()) {
                if (st.mId != id) continue;
                return st;
            }
            throw new IllegalArgumentException();
        }
    }
}

