/*
 * Decompiled with CFR 0.152.
 */
package com.luck.lib.camerax.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Point;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.RelativeLayout;
import androidx.annotation.DrawableRes;
import androidx.appcompat.widget.AppCompatImageView;
import com.luck.lib.camerax.R;

public class FocusImageView
extends AppCompatImageView {
    private static final long DELAY_MILLIS = 1000L;
    private int mFocusImg;
    private int mFocusSucceedImg;
    private int mFocusFailedImg;
    private Animation mAnimation;
    private Handler mHandler;
    private volatile boolean isDisappear;

    public FocusImageView(Context context) {
        super(context);
        this.init();
    }

    public FocusImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.FocusImageView);
        this.mFocusImg = typedArray.getResourceId(R.styleable.FocusImageView_focus_focusing, R.drawable.focus_focusing);
        this.mFocusSucceedImg = typedArray.getResourceId(R.styleable.FocusImageView_focus_success, R.drawable.focus_focused);
        this.mFocusFailedImg = typedArray.getResourceId(R.styleable.FocusImageView_focus_error, R.drawable.focus_failed);
        typedArray.recycle();
    }

    private void init() {
        this.setVisibility(4);
        this.mAnimation = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.focusview_show);
        this.mHandler = new Handler(Looper.getMainLooper());
    }

    public void setDisappear(boolean disappear) {
        this.isDisappear = disappear;
    }

    public void startFocus(Point point) {
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.getLayoutParams();
        params.topMargin = point.y - this.getMeasuredHeight() / 2;
        params.leftMargin = point.x - this.getMeasuredWidth() / 2;
        this.setLayoutParams((ViewGroup.LayoutParams)params);
        this.setVisibility(0);
        this.setFocusResource(this.mFocusImg);
        this.startAnimation(this.mAnimation);
    }

    public void onFocusSuccess() {
        if (this.isDisappear) {
            this.setFocusResource(this.mFocusSucceedImg);
        }
        this.mHandler.removeCallbacks(null, null);
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                FocusImageView.this.setFocusGone();
            }
        }, 1000L);
    }

    public void onFocusFailed() {
        if (this.isDisappear) {
            this.setFocusResource(this.mFocusFailedImg);
        }
        this.mHandler.removeCallbacks(null, null);
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                FocusImageView.this.setFocusGone();
            }
        }, 1000L);
    }

    private void setFocusResource(@DrawableRes int resId) {
        this.setImageResource(resId);
    }

    private void setFocusGone() {
        if (this.isDisappear) {
            this.setVisibility(4);
        }
    }

    public void destroy() {
        this.mHandler.removeCallbacks(null, null);
        this.setVisibility(4);
    }
}

