/*
 * Decompiled with CFR 0.152.
 */
package com.luck.lib.camerax.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import androidx.core.content.FileProvider;
import com.luck.lib.camerax.utils.BitmapUtils;
import com.luck.lib.camerax.utils.DateUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;

public class FileUtils {
    public static final String POSTFIX = ".jpeg";
    public static final String POST_VIDEO = ".mp4";

    public static File createCameraFile(Context context, int chooseMode, String fileName, String format, String outCameraDirectory) {
        return FileUtils.createMediaFile(context, chooseMode, fileName, format, outCameraDirectory);
    }

    private static File createMediaFile(Context context, int chooseMode, String fileName, String format, String outCameraDirectory) {
        return FileUtils.createOutFile(context, chooseMode, fileName, format, outCameraDirectory);
    }

    private static File createOutFile(Context ctx, int chooseMode, String fileName, String format, String outCameraDirectory) {
        File folderDir;
        Context context = ctx.getApplicationContext();
        if (TextUtils.isEmpty((CharSequence)outCameraDirectory)) {
            File rootDir;
            if (TextUtils.equals((CharSequence)"mounted", (CharSequence)Environment.getExternalStorageState())) {
                rootDir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM);
                folderDir = new File(rootDir.getAbsolutePath() + File.separator + "Camera" + File.separator);
            } else {
                rootDir = FileUtils.getRootDirFile(context, chooseMode);
                folderDir = new File(rootDir.getAbsolutePath() + File.separator);
            }
            if (!rootDir.exists()) {
                rootDir.mkdirs();
            }
        } else {
            folderDir = new File(outCameraDirectory);
            if (!Objects.requireNonNull(folderDir.getParentFile()).exists()) {
                folderDir.getParentFile().mkdirs();
            }
        }
        if (!folderDir.exists()) {
            folderDir.mkdirs();
        }
        boolean isOutFileNameEmpty = TextUtils.isEmpty((CharSequence)fileName);
        if (chooseMode == 2) {
            String newFileVideoName = isOutFileNameEmpty ? DateUtils.getCreateFileName("VID_") + POST_VIDEO : fileName;
            return new File(folderDir, newFileVideoName);
        }
        String suffix = TextUtils.isEmpty((CharSequence)format) ? POSTFIX : format;
        String newFileImageName = isOutFileNameEmpty ? DateUtils.getCreateFileName("IMG_") + suffix : fileName;
        return new File(folderDir, newFileImageName);
    }

    private static File getRootDirFile(Context context, int type) {
        if (type == 2) {
            return context.getExternalFilesDir(Environment.DIRECTORY_MOVIES);
        }
        return context.getExternalFilesDir(Environment.DIRECTORY_PICTURES);
    }

    public static File createTempFile(Context context, boolean isVideo) {
        File externalFilesDir = context.getExternalFilesDir("");
        File tempCameraFile = new File(externalFilesDir.getAbsolutePath(), ".TemporaryCamera");
        if (!tempCameraFile.exists()) {
            tempCameraFile.mkdirs();
        }
        String fileName = System.currentTimeMillis() + (isVideo ? POST_VIDEO : POSTFIX);
        return new File(tempCameraFile.getAbsolutePath(), fileName);
    }

    public static Uri parUri(Context context, File cameraFile) {
        String authority = context.getPackageName() + ".luckProvider";
        Uri imageUri = Build.VERSION.SDK_INT > 23 ? FileProvider.getUriForFile((Context)context, (String)authority, (File)cameraFile) : Uri.fromFile((File)cameraFile);
        return imageUri;
    }

    public static boolean isContent(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return false;
        }
        return url.startsWith("content://");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyPath(Context context, String originalPath, String newPath) {
        block5: {
            boolean bl;
            FileOutputStream fos = null;
            ByteArrayOutputStream stream = null;
            try {
                BitmapFactory.Options options = new BitmapFactory.Options();
                options.inJustDecodeBounds = true;
                BitmapFactory.decodeFile((String)originalPath, (BitmapFactory.Options)options);
                options.inSampleSize = BitmapUtils.computeSize(options.outWidth, options.outHeight);
                options.inJustDecodeBounds = false;
                Bitmap newBitmap = BitmapUtils.toHorizontalMirror(BitmapFactory.decodeFile((String)originalPath, (BitmapFactory.Options)options));
                stream = new ByteArrayOutputStream();
                newBitmap.compress(newBitmap.hasAlpha() ? Bitmap.CompressFormat.PNG : Bitmap.CompressFormat.JPEG, 90, (OutputStream)stream);
                newBitmap.recycle();
                fos = new FileOutputStream(newPath);
                fos.write(stream.toByteArray());
                fos.flush();
                FileUtils.deleteFile(context, originalPath);
                bl = true;
                FileUtils.close(fos);
            }
            catch (Exception e) {
                e.printStackTrace();
                break block5;
            }
            finally {
                FileUtils.close(fos);
                FileUtils.close(stream);
            }
            FileUtils.close(stream);
            return bl;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFileFromIS(InputStream is, OutputStream os) {
        boolean bl;
        BufferedOutputStream osBuffer = null;
        BufferedInputStream isBuffer = null;
        try {
            int len;
            isBuffer = new BufferedInputStream(is);
            osBuffer = new BufferedOutputStream(os);
            byte[] data = new byte[1024];
            while ((len = isBuffer.read(data)) != -1) {
                os.write(data, 0, len);
            }
            os.flush();
            bl = true;
        }
        catch (Exception e) {
            boolean bl2;
            try {
                e.printStackTrace();
                bl2 = false;
            }
            catch (Throwable throwable) {
                FileUtils.close(isBuffer);
                FileUtils.close(osBuffer);
                throw throwable;
            }
            FileUtils.close(isBuffer);
            FileUtils.close(osBuffer);
            return bl2;
        }
        FileUtils.close(isBuffer);
        FileUtils.close(osBuffer);
        return bl;
    }

    public static void deleteFile(Context context, String path) {
        try {
            if (FileUtils.isContent(path)) {
                context.getContentResolver().delete(Uri.parse((String)path), null, null);
            } else {
                File file = new File(path);
                if (file.exists()) {
                    file.delete();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void close(@Nullable Closeable c) {
        if (c instanceof Closeable) {
            try {
                c.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

