/*
 * Decompiled with CFR 0.152.
 */
package com.luck.lib.camerax.listener;

import android.content.Context;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;

public class CameraXPreviewViewTouchListener
implements View.OnTouchListener {
    private final GestureDetector mGestureDetector;
    private final ScaleGestureDetector mScaleGestureDetector;
    ScaleGestureDetector.OnScaleGestureListener onScaleGestureListener = new ScaleGestureDetector.SimpleOnScaleGestureListener(){

        public boolean onScale(ScaleGestureDetector detector) {
            float delta = detector.getScaleFactor();
            if (CameraXPreviewViewTouchListener.this.mCustomTouchListener != null) {
                CameraXPreviewViewTouchListener.this.mCustomTouchListener.zoom(delta);
            }
            return true;
        }
    };
    GestureDetector.SimpleOnGestureListener onGestureListener = new GestureDetector.SimpleOnGestureListener(){

        public void onLongPress(MotionEvent e) {
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            return true;
        }

        public boolean onSingleTapConfirmed(MotionEvent e) {
            if (CameraXPreviewViewTouchListener.this.mCustomTouchListener != null) {
                CameraXPreviewViewTouchListener.this.mCustomTouchListener.click(e.getX(), e.getY());
            }
            return true;
        }

        public boolean onDoubleTap(MotionEvent e) {
            if (CameraXPreviewViewTouchListener.this.mCustomTouchListener != null) {
                CameraXPreviewViewTouchListener.this.mCustomTouchListener.doubleClick(e.getX(), e.getY());
            }
            return true;
        }
    };
    private CustomTouchListener mCustomTouchListener;

    public CameraXPreviewViewTouchListener(Context context) {
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)this.onGestureListener);
        this.mScaleGestureDetector = new ScaleGestureDetector(context, this.onScaleGestureListener);
    }

    public boolean onTouch(View v, MotionEvent event) {
        this.mScaleGestureDetector.onTouchEvent(event);
        if (!this.mScaleGestureDetector.isInProgress()) {
            this.mGestureDetector.onTouchEvent(event);
        }
        return true;
    }

    public void setCustomTouchListener(CustomTouchListener customTouchListener) {
        this.mCustomTouchListener = customTouchListener;
    }

    public static interface CustomTouchListener {
        public void zoom(float var1);

        public void click(float var1, float var2);

        public void doubleClick(float var1, float var2);
    }
}

