/*
 * Decompiled with CFR 0.152.
 */
package courgette.runtime.utils;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;

public final class FileUtils {
    private static BiFunction<String, Boolean, String> fileReader = (file, deleteOnExit) -> {
        if (file == null) {
            return null;
        }
        File rerunFile = new File((String)file);
        if (deleteOnExit.booleanValue()) {
            rerunFile.deleteOnExit();
        }
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        try {
            fileReader = new FileReader(rerunFile);
            bufferedReader = new BufferedReader(fileReader);
            String string = bufferedReader.lines().collect(Collectors.joining("\n"));
            return string;
        }
        catch (Exception ignored) {
            String string = null;
            return string;
        }
        finally {
            try {
                if (fileReader != null) {
                    fileReader.close();
                }
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {}
        }
    };
    private static BiConsumer<String, String> fileStringWriter = (file, source) -> {
        if (file == null) {
            return;
        }
        File newFile = new File((String)file);
        try {
            FileWriter fileWriter = new FileWriter(newFile, (boolean)Boolean.FALSE);
            fileWriter.write((String)source);
            fileWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    };
    private static BiConsumer<String, Collection<?>> fileCollectionWriter = (file, source) -> {
        if (file == null) {
            return;
        }
        File newFile = new File((String)file);
        try {
            FileWriter fileWriter = new FileWriter(newFile, (boolean)Boolean.FALSE);
            StringBuilder contents = new StringBuilder();
            source.forEach(data -> contents.append(data).append("\n"));
            fileWriter.write(contents.toString());
            fileWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    };

    public static String readFile(String file, Boolean deleteOnExit) {
        return fileReader.apply(file, deleteOnExit);
    }

    public static void writeFile(String file, Collection<?> contents) {
        fileCollectionWriter.accept(file, contents);
    }

    public static void writeFile(String file, String contents) {
        fileStringWriter.accept(file, contents);
    }

    public static void writeImageFile(String file, String format, String base64Image) {
        try {
            byte[] imageByte = Base64.getDecoder().decode(base64Image);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(imageByte);
            BufferedImage bufferedImage = ImageIO.read(byteArrayInputStream);
            ImageIO.write((RenderedImage)bufferedImage, format, new File(file + "." + format));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void readAndWriteFile(InputStream inputStream, String writePath) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder lines = new StringBuilder();
        reader.lines().forEach(line -> lines.append((String)line).append("\n"));
        FileUtils.writeFile(writePath, lines.toString());
    }

    public static List<File> getParentFiles(String path) {
        return Arrays.asList(new File(path).getParentFile().listFiles());
    }
}

