/*
 * Decompiled with CFR 0.152.
 */
package courgette.runtime.report.model;

import courgette.runtime.report.model.Hook;
import courgette.runtime.report.model.Step;
import java.util.List;
import java.util.UUID;

public class Scenario {
    private String courgetteScenarioId = UUID.randomUUID().toString();
    private String featureUri;
    private String name;
    private int line;
    private String keyword;
    private List<Hook> before;
    private List<Hook> after;
    private List<Step> steps;

    public Scenario(String featureUri, String name, String keyword, int line, List<Hook> before, List<Hook> after, List<Step> steps) {
        this.featureUri = featureUri;
        this.name = name;
        this.keyword = keyword;
        this.line = line;
        this.before = before;
        this.after = after;
        this.steps = steps;
    }

    public String getCourgetteScenarioId() {
        return this.courgetteScenarioId;
    }

    public String getFeatureUri() {
        return this.featureUri;
    }

    public String getName() {
        return this.name;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public int getLine() {
        return this.line;
    }

    public List<Hook> getBefore() {
        return this.before;
    }

    public List<Hook> getAfter() {
        return this.after;
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public boolean passed(boolean isStrict) {
        return this.before.stream().allMatch(before -> before.passed(isStrict)) && this.after.stream().allMatch(after -> after.passed(isStrict)) && this.steps.stream().allMatch(step -> step.passed(isStrict));
    }
}

