/*
 * Decompiled with CFR 0.152.
 */
package courgette.runtime;

import courgette.runtime.CourgetteProperties;
import cucumber.api.CucumberOptions;
import cucumber.runtime.model.CucumberFeature;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;

public class CourgetteRuntimeOptions {
    private final CourgetteProperties courgetteProperties;
    private final CucumberFeature cucumberFeature;
    private final CucumberOptions cucumberOptions;
    private final String reportTargetDir;
    private List<String> runtimeOptions = new ArrayList<String>();
    private String rerunFile;
    private String cucumberResourcePath;
    private final int instanceId = UUID.randomUUID().hashCode();
    private BiFunction<String, String[], String[]> envCucumberOptionParser = (systemPropertyName, cucumberOptions) -> {
        String cucumberOption = System.getProperty("cucumber." + systemPropertyName);
        if (cucumberOption != null && cucumberOption.trim().length() > 0) {
            ArrayList options = new ArrayList();
            Arrays.stream(cucumberOption.split(",")).forEach(t -> options.add(t.trim()));
            String[] cucumberOptionArray = new String[options.size()];
            return options.toArray(cucumberOptionArray);
        }
        return cucumberOptions;
    };
    private Function<CourgetteProperties, String> cucumberRerunPlugin = courgetteProperties -> {
        String rerunPlugin = Arrays.stream(courgetteProperties.getCourgetteOptions().cucumberOptions().plugin()).filter(p -> p.startsWith("rerun")).findFirst().orElse(null);
        if (rerunPlugin != null) {
            return rerunPlugin.substring(rerunPlugin.indexOf(":") + 1);
        }
        return null;
    };
    private final Predicate<String> isReportPlugin = plugin -> plugin.startsWith("html:") || plugin.startsWith("json:") || plugin.startsWith("junit:");
    private BiFunction<String, Object, List<String>> optionParser = (name, options) -> {
        ArrayList<String> runOptions = new ArrayList<String>();
        Boolean isStringArray = options instanceof String[];
        if (options == null || isStringArray.booleanValue() && ((String[])options).length == 0) {
            return runOptions;
        }
        if (isStringArray.booleanValue()) {
            String[] optionArray = (String[])options;
            Arrays.asList(Arrays.asList(optionArray).toString().split(",")).forEach(value -> {
                runOptions.add((String)name);
                runOptions.add(value.trim().replace("[", "").replace("]", ""));
            });
        } else {
            if (name != null) {
                runOptions.add((String)name);
            }
            runOptions.add(options.toString());
        }
        return runOptions;
    };
    private BiFunction<String, String, String> resourceFinder = (resourcePath, featurePath) -> {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String[] resourceFolders = resourcePath.split("/");
        if (resourcePath.equals(featurePath)) {
            return resourcePath;
        }
        Integer startIndex = featurePath.indexOf(resourceFolders[resourceFolders.length - 1]);
        startIndex = startIndex > -1 ? Integer.valueOf(startIndex + (resourceFolders[resourceFolders.length - 1].length() + 1)) : Integer.valueOf(0);
        String resourceName = featurePath.substring(startIndex);
        if (resourceFolders.length > 0) {
            StringBuilder resourcePathBuilder = new StringBuilder();
            for (int i = resourceFolders.length - 1; i >= 0; --i) {
                resourcePathBuilder.insert(0, String.format("%s/", resourceFolders[i]));
                URL resource = classLoader.getResource(String.format("%s%s", resourcePathBuilder.toString(), resourceName));
                if (resource == null) continue;
                return resourcePathBuilder.toString();
            }
        }
        return null;
    };
    private BiFunction<String[], String, List<String>> featureParser = (resourceFeaturePaths, featurePath) -> {
        ArrayList<String> featurePaths = new ArrayList<String>();
        if (featurePath != null) {
            for (String resourceFeaturePath : resourceFeaturePaths) {
                String resource = this.resourceFinder.apply(resourceFeaturePath, (String)featurePath);
                if (resource == null) continue;
                if (featurePath.startsWith(resourceFeaturePath)) {
                    featurePaths.add((String)featurePath);
                } else {
                    featurePaths.add(String.format("%s/%s", resourceFeaturePath, featurePath));
                }
                return featurePaths;
            }
        }
        featurePaths.addAll(Arrays.asList(resourceFeaturePaths));
        return featurePaths;
    };

    public CourgetteRuntimeOptions(CourgetteProperties courgetteProperties2, CucumberFeature cucumberFeature) {
        this.courgetteProperties = courgetteProperties2;
        this.cucumberFeature = cucumberFeature;
        this.cucumberOptions = courgetteProperties2.getCourgetteOptions().cucumberOptions();
        this.cucumberResourcePath = cucumberFeature.getUri().getSchemeSpecificPart();
        this.reportTargetDir = courgetteProperties2.getCourgetteOptions().reportTargetDir();
        this.createRuntimeOptions(this.cucumberOptions, this.cucumberResourcePath).forEach((key, value) -> this.runtimeOptions.addAll((Collection<String>)value));
    }

    public CourgetteRuntimeOptions(CourgetteProperties courgetteProperties2) {
        this.courgetteProperties = courgetteProperties2;
        this.cucumberOptions = courgetteProperties2.getCourgetteOptions().cucumberOptions();
        this.cucumberFeature = null;
        this.reportTargetDir = courgetteProperties2.getCourgetteOptions().reportTargetDir();
        this.createRuntimeOptions(this.cucumberOptions, null).forEach((key, value) -> this.runtimeOptions.addAll((Collection<String>)value));
    }

    public String[] getRuntimeOptions() {
        return (String[])Arrays.copyOf(this.runtimeOptions.toArray(), this.runtimeOptions.size(), String[].class);
    }

    public Map<String, List<String>> mapRuntimeOptions() {
        return this.createRuntimeOptions(this.cucumberOptions, this.cucumberResourcePath);
    }

    public String getRerunFile() {
        return this.rerunFile;
    }

    public String getCucumberRerunFile() {
        String cucumberRerunFile = this.cucumberRerunPlugin.apply(this.courgetteProperties);
        if (cucumberRerunFile == null) {
            return this.getRerunFile();
        }
        return cucumberRerunFile;
    }

    public List<String> getReportJsFiles() {
        ArrayList<String> reportFiles = new ArrayList<String>();
        this.runtimeOptions.forEach(option -> {
            if (option != null && this.isReportPlugin.test((String)option)) {
                String reportFile = option.substring(option.indexOf(":") + 1);
                if (option.startsWith("html:")) {
                    reportFile = reportFile + "/report.js";
                }
                reportFiles.add(reportFile);
            }
        });
        return reportFiles;
    }

    public String getCourgetteReportJson() {
        return String.format("%s/courgette-report/data/report.json", this.reportTargetDir);
    }

    private Map<String, List<String>> createRuntimeOptions(CucumberOptions cucumberOptions, String path) {
        HashMap<String, List<String>> runtimeOptions = new HashMap<String, List<String>>();
        runtimeOptions.put("--glue", this.optionParser.apply("--glue", this.envCucumberOptionParser.apply("glue", cucumberOptions.glue())));
        runtimeOptions.put("--tags", this.optionParser.apply("--tags", this.envCucumberOptionParser.apply("tags", cucumberOptions.tags())));
        runtimeOptions.put("--plugin", this.optionParser.apply("--plugin", this.parsePlugins(this.envCucumberOptionParser.apply("plugin", cucumberOptions.plugin()))));
        runtimeOptions.put("--name", this.optionParser.apply("--name", this.envCucumberOptionParser.apply("name", cucumberOptions.name())));
        runtimeOptions.put("--junit", this.optionParser.apply("--junit", this.envCucumberOptionParser.apply("junit", cucumberOptions.junit())));
        runtimeOptions.put("--snippets", this.optionParser.apply("--snippets", cucumberOptions.snippets()));
        runtimeOptions.put("--dryRun", Collections.singletonList(cucumberOptions.dryRun() ? "--dry-run" : "--no-dry-run"));
        runtimeOptions.put("--strict", Collections.singletonList(cucumberOptions.strict() ? "--strict" : "--no-strict"));
        runtimeOptions.put("--monochrome", Collections.singletonList(cucumberOptions.monochrome() ? "--monochrome" : "--no-monochrome"));
        if (path == null) {
            runtimeOptions.put("runningPath", this.featureParser.apply(this.envCucumberOptionParser.apply("features", cucumberOptions.features()), path));
        } else {
            runtimeOptions.put("runningPath", Collections.singletonList(path));
        }
        return runtimeOptions;
    }

    private String getMultiThreadRerunFile() {
        return this.getTempDirectory() + this.courgetteProperties.getSessionId() + "_rerun_" + this.getFeatureId(this.cucumberFeature) + ".txt";
    }

    private String getMultiThreadReportFile() {
        return this.getTempDirectory() + this.courgetteProperties.getSessionId() + "_thread_report_" + this.getFeatureId(this.cucumberFeature);
    }

    private String getFeatureId(CucumberFeature cucumberFeature) {
        return String.format("%s_%s", cucumberFeature.getGherkinFeature().getFeature().hashCode(), this.instanceId);
    }

    private String[] parsePlugins(String[] plugins) {
        ArrayList<String> pluginList = new ArrayList<String>();
        if (plugins.length == 0) {
            plugins = new String[]{"json:" + this.getCourgetteReportJson()};
        }
        Arrays.asList(plugins).forEach(plugin -> {
            if (this.isReportPlugin.test((String)plugin)) {
                if (this.cucumberFeature != null) {
                    pluginList.add((String)plugin);
                    String extension = plugin.substring(0, plugin.indexOf(":"));
                    if (extension.equalsIgnoreCase("junit")) {
                        pluginList.remove(plugin);
                        String reportPath = String.format("junit:%s.xml", this.getMultiThreadReportFile());
                        pluginList.add(reportPath);
                    } else if (!extension.equals("")) {
                        String reportPath = String.format("%s:%s.%s", extension, this.getMultiThreadReportFile(), extension);
                        pluginList.add(reportPath);
                    }
                } else {
                    pluginList.add((String)plugin);
                }
            } else {
                pluginList.add((String)plugin);
            }
        });
        Predicate<List> alreadyAddedRerunPlugin = addedPlugins -> addedPlugins.stream().anyMatch(p -> p.startsWith("rerun:"));
        if (!alreadyAddedRerunPlugin.test(pluginList)) {
            String cucumberRerunFile;
            this.rerunFile = this.cucumberFeature != null ? this.getMultiThreadRerunFile() : ((cucumberRerunFile = this.cucumberRerunPlugin.apply(this.courgetteProperties)) != null ? cucumberRerunFile : String.format("%s/courgette-rerun.txt", this.reportTargetDir));
            pluginList.add("rerun:" + this.rerunFile);
        }
        if (pluginList.stream().noneMatch(plugin -> plugin.contains(this.getCourgetteReportJson()))) {
            pluginList.add("json:" + this.getCourgetteReportJson());
        }
        return (String[])Arrays.copyOf(pluginList.toArray(), pluginList.size(), String[].class);
    }

    private String getTempDirectory() {
        String fileSeparator = File.separator;
        String tmpDir = System.getProperty("java.io.tmpdir");
        if (!tmpDir.endsWith(fileSeparator)) {
            return tmpDir + fileSeparator;
        }
        return tmpDir;
    }
}

