/*
 * Decompiled with CFR 0.152.
 */
package courgette.runtime;

import courgette.api.CourgetteRunLevel;
import courgette.runtime.CourgetteProperties;
import courgette.runtime.CourgetteRuntimeOptions;
import cucumber.runtime.model.CucumberFeature;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CourgetteRunnerInfo {
    private final CourgetteRuntimeOptions courgetteRuntimeOptions;
    private final Integer lineId;
    private final CourgetteRunLevel courgetteRunLevel;
    private static Logger Log = Logger.getLogger((String)CourgetteRunnerInfo.class.getName());

    public CourgetteRunnerInfo(CourgetteProperties courgetteProperties, CucumberFeature cucumberFeature, Integer lineId) {
        this.courgetteRuntimeOptions = new CourgetteRuntimeOptions(courgetteProperties, cucumberFeature);
        this.lineId = lineId;
        this.courgetteRunLevel = courgetteProperties.getCourgetteOptions().runLevel();
    }

    public Map<String, List<String>> getRuntimeOptions() {
        Map<String, List<String>> runtimeOptions = this.courgetteRuntimeOptions.mapRuntimeOptions();
        if (this.courgetteRunLevel.equals((Object)CourgetteRunLevel.SCENARIO) && this.lineId != null) {
            String featurePath = runtimeOptions.get("runningPath").get(0);
            ArrayList<String> scenarioPath = new ArrayList<String>();
            scenarioPath.add(String.format("%s:%s", featurePath, this.lineId));
            Log.debug((Object)("Scenario Path found for running: " + scenarioPath));
            runtimeOptions.put("runningPath", scenarioPath);
            runtimeOptions.remove("--tags");
        }
        return runtimeOptions;
    }

    public Map<String, List<String>> getRerunRuntimeOptions(String rerun) {
        Map<String, List<String>> rerunRuntimeOptions = this.getRuntimeOptions();
        rerunRuntimeOptions.remove("--tags");
        ArrayList<String> scenarioPath = new ArrayList<String>();
        scenarioPath.add(rerun);
        rerunRuntimeOptions.put("runningPath", scenarioPath);
        return rerunRuntimeOptions;
    }

    public String getRerunFile() {
        return this.courgetteRuntimeOptions.getRerunFile();
    }

    public List<String> getReportFiles() {
        return this.courgetteRuntimeOptions.getReportJsFiles();
    }
}

