/*
 * Decompiled with CFR 0.152.
 */
package courgette.runtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import courgette.runtime.CourgetteFeatureRunner;
import courgette.runtime.CourgetteHtmlReporter;
import courgette.runtime.CourgetteProperties;
import courgette.runtime.CourgetteReporter;
import courgette.runtime.CourgetteRunResult;
import courgette.runtime.CourgetteRunnerInfo;
import courgette.runtime.CourgetteRuntimeOptions;
import courgette.runtime.utils.FileUtils;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;

public class CourgetteRunner {
    private final List<Callable<Boolean>> runners = new ArrayList<Callable<Boolean>>();
    private final CopyOnWriteArrayList<String> reruns = new CopyOnWriteArrayList();
    private final Map<String, CopyOnWriteArrayList<String>> reports = new HashMap<String, CopyOnWriteArrayList<String>>();
    private final List<CourgetteRunnerInfo> runnerInfoList;
    private final CourgetteProperties courgetteProperties;
    private final CourgetteRuntimeOptions defaultRuntimeOptions;
    private final boolean rerunFailedScenarios;
    private final List<CourgetteRunResult> runResults = new ArrayList<CourgetteRunResult>();
    private final boolean canRunFeatures;
    private static Logger Log = Logger.getLogger((String)CourgetteRunner.class.getName());

    public CourgetteRunner(List<CourgetteRunnerInfo> runnerInfoList, CourgetteProperties courgetteProperties) {
        this.runnerInfoList = runnerInfoList;
        this.canRunFeatures = runnerInfoList.size() > 0;
        this.courgetteProperties = courgetteProperties;
        this.rerunFailedScenarios = courgetteProperties.getCourgetteOptions().rerunFailedScenarios();
        this.defaultRuntimeOptions = new CourgetteRuntimeOptions(courgetteProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ExecutorService executor = Executors.newFixedThreadPool(this.optimizedThreadCount());
        Log.debug((Object)("Executor running: " + executor));
        ArrayDeque<CourgetteRunnerInfo> runnerQueue = new ArrayDeque<CourgetteRunnerInfo>(this.runnerInfoList);
        while (!runnerQueue.isEmpty()) {
            CourgetteRunnerInfo runnerInfo = (CourgetteRunnerInfo)runnerQueue.poll();
            Map<String, List<String>> cucumberArgs = runnerInfo.getRuntimeOptions();
            String featureUri = cucumberArgs.get("runningPath").get(0);
            this.runners.add(() -> {
                try {
                    boolean isPassed = this.runFeature(cucumberArgs);
                    if (isPassed) {
                        this.runResults.add(new CourgetteRunResult(featureUri, CourgetteRunResult.Status.PASSED));
                        Boolean bl = true;
                        return bl;
                    }
                    String rerunFile = runnerInfo.getRerunFile();
                    String rerun = FileUtils.readFile(rerunFile, false);
                    if (this.rerunFailedScenarios && rerun != null) {
                        Map<String, List<String>> rerunCucumberArgs = runnerInfo.getRerunRuntimeOptions(rerun);
                        String rerunFeatureUri = rerunCucumberArgs.get("runningPath").get(0);
                        this.runResults.add(new CourgetteRunResult(rerunFeatureUri, CourgetteRunResult.Status.RERUN));
                        int rerunAttempts = this.courgetteProperties.getCourgetteOptions().rerunAttempts();
                        int n = rerunAttempts = rerunAttempts < 1 ? 1 : rerunAttempts;
                        while (rerunAttempts-- > 0) {
                            isPassed = this.runFeature(rerunCucumberArgs);
                            if (!isPassed) continue;
                            this.runResults.add(new CourgetteRunResult(rerunFeatureUri, CourgetteRunResult.Status.PASSED_AFTER_RERUN));
                            Boolean bl = true;
                            return bl;
                        }
                        this.runResults.add(new CourgetteRunResult(rerunFeatureUri, CourgetteRunResult.Status.FAILED));
                    } else {
                        this.runResults.add(new CourgetteRunResult(featureUri, CourgetteRunResult.Status.FAILED));
                    }
                    if (rerun != null) {
                        this.reruns.add(rerun);
                    }
                }
                finally {
                    runnerInfo.getReportFiles().forEach(reportFile -> {
                        if (reportFile.contains(this.courgetteProperties.getSessionId())) {
                            boolean isJson = reportFile.endsWith(".json");
                            String report = isJson ? this.prettyJson(FileUtils.readFile(reportFile, true)) : FileUtils.readFile(reportFile, true);
                            CopyOnWriteArrayList<String> reportDetails = new CopyOnWriteArrayList<String>();
                            reportDetails.add(report);
                            this.reports.put((String)reportFile, reportDetails);
                        }
                    });
                }
                return false;
            });
        }
        try {
            executor.invokeAll(this.runners);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            executor.shutdownNow();
        }
    }

    public void createReport() {
        List<String> reportFiles = this.defaultRuntimeOptions.getReportJsFiles();
        reportFiles.forEach(reportFile -> {
            CourgetteReporter reporter = new CourgetteReporter((String)reportFile, this.reports);
            reporter.createReport();
        });
    }

    public void createRerunFile() {
        ArrayList rerun = new ArrayList();
        this.reruns.sort(String::compareTo);
        this.reruns.forEach(rerun::add);
        String rerunFile = this.defaultRuntimeOptions.getCucumberRerunFile();
        if (rerunFile != null) {
            FileUtils.writeFile(rerunFile, rerun);
        }
    }

    public void createCourgetteReport() {
        CourgetteHtmlReporter courgetteReport = new CourgetteHtmlReporter(this.courgetteProperties, this.runResults, this.defaultRuntimeOptions.getCourgetteReportJson());
        courgetteReport.create();
    }

    public boolean hasFailures() {
        return this.runResults.stream().anyMatch(result -> result.getStatus() == CourgetteRunResult.Status.FAILED);
    }

    public boolean canRunFeatures() {
        return this.canRunFeatures;
    }

    private boolean runFeature(Map<String, List<String>> args) {
        try {
            boolean showTestOutput = this.courgetteProperties.getCourgetteOptions().showTestOutput();
            return 0 == new CourgetteFeatureRunner(args, showTestOutput).run();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    private String prettyJson(String json) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            Object jsonObject = mapper.readValue(json, Object.class);
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(jsonObject);
        }
        catch (IOException e) {
            return json;
        }
    }

    private Integer optimizedThreadCount() {
        return this.courgetteProperties.getMaxThreads() > this.runnerInfoList.size() ? this.runnerInfoList.size() : (this.courgetteProperties.getMaxThreads() < 1 ? 1 : this.courgetteProperties.getMaxThreads());
    }
}

