/*
 * Decompiled with CFR 0.152.
 */
package courgette.runtime;

import courgette.api.CourgetteOptions;
import courgette.api.CourgetteRunLevel;
import courgette.runtime.CourgetteException;
import courgette.runtime.utils.SystemPropertyUtils;
import cucumber.api.CucumberOptions;
import java.lang.annotation.Annotation;
import java.util.Arrays;

public class CourgetteRunOptions
implements CourgetteOptions {
    private CourgetteOptions courgetteOptions;

    public CourgetteRunOptions(Class clazz) {
        this.validate(clazz);
    }

    @Override
    public int threads() {
        return SystemPropertyUtils.getIntProperty("courgette.threads", this.courgetteOptions.threads());
    }

    @Override
    public CourgetteRunLevel runLevel() {
        return SystemPropertyUtils.getEnumProperty("courgette.runLevel", CourgetteRunLevel.class, this.courgetteOptions.runLevel());
    }

    @Override
    public boolean rerunFailedScenarios() {
        return SystemPropertyUtils.getBoolProperty("courgette.rerunFailedScenarios", this.courgetteOptions.rerunFailedScenarios());
    }

    @Override
    public int rerunAttempts() {
        return SystemPropertyUtils.getIntProperty("courgette.rerunAttempts", this.courgetteOptions.rerunAttempts());
    }

    @Override
    public boolean showTestOutput() {
        return SystemPropertyUtils.getBoolProperty("courgette.showTestOutput", this.courgetteOptions.showTestOutput());
    }

    @Override
    public String reportTargetDir() {
        return SystemPropertyUtils.getNonEmptyStringProperty("courgette.reportTargetDir", this.courgetteOptions.reportTargetDir(), "target");
    }

    @Override
    public CucumberOptions cucumberOptions() {
        return this.courgetteOptions.cucumberOptions();
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return null;
    }

    private void validate(Class clazz) {
        this.courgetteOptions = (CourgetteOptions)Arrays.stream(clazz.getDeclaredAnnotations()).filter(annotation -> annotation.annotationType().equals(CourgetteOptions.class)).findFirst().orElseThrow(() -> new CourgetteException("Runner class is not annotated with @CourgetteOptions"));
    }
}

