/*
 * Decompiled with CFR 0.152.
 */
package courgette.runtime;

import cucumber.runtime.filter.Filters;
import cucumber.runtime.model.CucumberFeature;
import gherkin.events.PickleEvent;
import gherkin.pickles.Compiler;
import gherkin.pickles.PickleLocation;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class CourgettePickleMatcher {
    private final Compiler compiler = new Compiler();
    private final CucumberFeature cucumberFeature;
    private final Filters filters;

    public CourgettePickleMatcher(CucumberFeature cucumberFeature, Filters filters) {
        this.cucumberFeature = cucumberFeature;
        this.filters = filters;
    }

    public boolean matches() {
        AtomicBoolean matched = new AtomicBoolean();
        try {
            this.compiler.compile(this.cucumberFeature.getGherkinFeature()).forEach(pickle -> {
                matched.set(this.filters.matchesFilters(new PickleEvent(this.cucumberFeature.getUri().getSchemeSpecificPart(), pickle)));
                if (matched.get()) {
                    throw new ConditionSatisfiedException();
                }
            });
        }
        catch (ConditionSatisfiedException conditionSatisfiedException) {
            // empty catch block
        }
        return matched.get();
    }

    public PickleLocation matchLocation(int pickleLocationLine) {
        PickleLocation[] location = new PickleLocation[]{null};
        List pickles = this.compiler.compile(this.cucumberFeature.getGherkinFeature());
        try {
            pickles.forEach(pickle -> {
                PickleLocation pickleLocation = pickle.getLocations().stream().filter(l -> l.getLine() == pickleLocationLine).findFirst().orElse(null);
                if (pickleLocation != null && this.filters.matchesFilters(new PickleEvent(this.cucumberFeature.getUri().getSchemeSpecificPart(), pickle))) {
                    location[0] = pickleLocation;
                    throw new ConditionSatisfiedException();
                }
            });
        }
        catch (ConditionSatisfiedException conditionSatisfiedException) {
            // empty catch block
        }
        return location[0];
    }

    private class ConditionSatisfiedException
    extends RuntimeException {
        private ConditionSatisfiedException() {
        }
    }
}

