/*
 * Decompiled with CFR 0.152.
 */
package courgette.runtime;

import courgette.runtime.CourgettePickleMatcher;
import courgette.runtime.CourgetteProperties;
import courgette.runtime.CourgetteRuntimeOptions;
import cucumber.runner.EventBus;
import cucumber.runner.TimeService;
import cucumber.runner.TimeServiceEventBus;
import cucumber.runtime.ClassFinder;
import cucumber.runtime.FeaturePathFeatureSupplier;
import cucumber.runtime.RuntimeOptions;
import cucumber.runtime.filter.Filters;
import cucumber.runtime.io.MultiLoader;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.io.ResourceLoaderClassFinder;
import cucumber.runtime.model.CucumberFeature;
import cucumber.runtime.model.FeatureLoader;
import gherkin.ast.ScenarioOutline;
import gherkin.pickles.PickleLocation;
import io.cucumber.core.options.FeatureOptions;
import io.cucumber.core.options.FilterOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CourgetteLoader {
    private final CourgetteProperties courgetteProperties;
    private final ResourceLoader resourceLoader;
    private final FeaturePathFeatureSupplier featureSupplier;
    private final RuntimeOptions runtimeOptions;
    private final EventBus eventBus;
    private final Filters filters;
    private final ClassFinder classFinder;
    private List<CucumberFeature> cucumberFeatures;

    public CourgetteLoader(CourgetteProperties courgetteProperties, ClassLoader classLoader) {
        this.courgetteProperties = courgetteProperties;
        this.resourceLoader = new MultiLoader(classLoader);
        FeatureLoader featureLoader = new FeatureLoader(this.resourceLoader);
        this.runtimeOptions = this.createRuntimeOptions();
        this.featureSupplier = new FeaturePathFeatureSupplier(featureLoader, (FeatureOptions)this.runtimeOptions);
        this.eventBus = new TimeServiceEventBus(TimeService.SYSTEM);
        this.filters = new Filters((FilterOptions)this.runtimeOptions);
        this.classFinder = new ResourceLoaderClassFinder(this.resourceLoader, classLoader);
    }

    public List<CucumberFeature> getCucumberFeatures() {
        this.cucumberFeatures = this.cucumberFeatures();
        return this.cucumberFeatures;
    }

    public Map<PickleLocation, CucumberFeature> getCucumberScenarios() {
        return this.cucumberScenarios(this.cucumberFeatures);
    }

    public RuntimeOptions getRuntimeOptions() {
        return this.runtimeOptions;
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public ClassFinder getClassFinder() {
        return this.classFinder;
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public Filters getFilters() {
        return this.filters;
    }

    private RuntimeOptions createRuntimeOptions() {
        CourgetteRuntimeOptions courgetteRuntimeOptions = new CourgetteRuntimeOptions(this.courgetteProperties);
        List<String> argv = Arrays.asList(courgetteRuntimeOptions.getRuntimeOptions());
        return new RuntimeOptions(argv);
    }

    private List<CucumberFeature> cucumberFeatures() {
        List loadedCucumberFeatures = this.featureSupplier.get();
        ArrayList<CucumberFeature> matchedCucumberFeatures = new ArrayList<CucumberFeature>();
        loadedCucumberFeatures.forEach(cucumberFeature -> {
            CourgettePickleMatcher pickleMatcher = new CourgettePickleMatcher((CucumberFeature)cucumberFeature, this.filters);
            if (pickleMatcher.matches()) {
                matchedCucumberFeatures.add((CucumberFeature)cucumberFeature);
            }
        });
        return matchedCucumberFeatures;
    }

    private Map<PickleLocation, CucumberFeature> cucumberScenarios(List<CucumberFeature> cucumberFeatures) {
        HashMap<PickleLocation, CucumberFeature> scenarios = new HashMap<PickleLocation, CucumberFeature>();
        if (cucumberFeatures != null) {
            cucumberFeatures.forEach(cucumberFeature -> cucumberFeature.getGherkinFeature().getFeature().getChildren().forEach(scenario -> {
                ArrayList<Integer> lines = new ArrayList<Integer>();
                if (scenario instanceof ScenarioOutline) {
                    List examples = ((ScenarioOutline)scenario).getExamples();
                    examples.forEach(example -> example.getTableBody().forEach(tr -> lines.add(tr.getLocation().getLine())));
                } else {
                    lines.add(scenario.getLocation().getLine());
                }
                lines.forEach(line -> {
                    CourgettePickleMatcher pickleMatcher = new CourgettePickleMatcher((CucumberFeature)cucumberFeature, this.filters);
                    PickleLocation pickleLocation = pickleMatcher.matchLocation((int)line);
                    if (pickleLocation != null) {
                        scenarios.put(pickleLocation, (CucumberFeature)cucumberFeature);
                    }
                });
            }));
        }
        return scenarios;
    }
}

